/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.print.multipage;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.ui.actions.PageAction;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.print.PrintClient;
import org.xmind.ui.internal.print.multipage.MultipagePrintClient;
import org.xmind.ui.internal.print.multipage.MultipageSetupDialog;
import org.xmind.ui.mindmap.IMindMap;

public class PrintMapAction2
extends PageAction {
    private String logMessage = "";

    public PrintMapAction2(IGraphicalEditorPage page) {
        super(ActionFactory.PRINT.getId(), page);
        this.setActionDefinitionId(ActionFactory.PRINT.getCommandId());
    }

    public void run() {
        block26: {
            try {
                this.appendLog("[print] start...");
                final IGraphicalEditor editor = this.getEditor();
                if (editor == null) {
                    this.appendLog("[print] editor is null...over...");
                    return;
                }
                Shell parentShell = editor.getSite().getShell();
                if (parentShell == null || parentShell.isDisposed()) {
                    this.appendLog("[print] parent shell is null...over...");
                    return;
                }
                IGraphicalEditorPage page = editor.getActivePageInstance();
                if (page == null) {
                    this.appendLog("[print] editor page is null...over...");
                    return;
                }
                final IMindMap mindMap = this.findMindMap(page);
                if (mindMap == null) {
                    this.appendLog("[print] mind map is null...over...");
                    return;
                }
                MultipageSetupDialog pageSetupDialog = new MultipageSetupDialog(parentShell, page, mindMap);
                int open = pageSetupDialog.open();
                this.appendLog("[print] page setup dialog shown...");
                if (open == 1) {
                    return;
                }
                final IDialogSettings settings = pageSetupDialog.getSettings();
                PrinterData printerData = new PrinterData();
                try {
                    printerData.orientation = settings.getInt("orientation");
                }
                catch (NumberFormatException numberFormatException) {
                    printerData.orientation = 2;
                }
                PrintDialog printDialog = new PrintDialog(parentShell);
                printDialog.setPrinterData(printerData);
                printerData = printDialog.open();
                this.appendLog("[print] print dialog shown...");
                if (printerData != null) {
                    if (settings.getBoolean("multiPages")) {
                        this.appendLog("[print] multiple page print start...");
                        MultipagePrintClient client = new MultipagePrintClient(this.getJobName(mindMap), parentShell, printerData, settings);
                        try {
                            if (settings.getBoolean("contentWholeWorkbook") && !settings.getBoolean("multiPages")) {
                                IGraphicalEditorPage[] pages = editor.getPages();
                                int i = 0;
                                while (i < pages.length) {
                                    client.print(this.findMindMap(pages[i]));
                                    this.appendLog(NLS.bind((String)"[print] print sheet [{0}]...", (Object)i));
                                    ++i;
                                }
                            } else {
                                client.print(mindMap);
                                this.appendLog("[print] print sheet...");
                            }
                            this.appendLog("[print] print success...");
                            break block26;
                        }
                        finally {
                            client.dispose();
                        }
                    }
                    this.appendLog("[print] single page print start...");
                    final PrintClient client = new PrintClient(this.getJobName(mindMap), parentShell, printerData, settings);
                    Display display = parentShell.getDisplay();
                    try {
                        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (settings.getBoolean("contentWholeWorkbook")) {
                                    IGraphicalEditorPage[] pages = editor.getPages();
                                    int i = 0;
                                    while (i < pages.length) {
                                        client.print(PrintMapAction2.this.findMindMap(pages[i]));
                                        PrintMapAction2.this.appendLog(NLS.bind((String)"[print] print sheet [{0}]...", (Object)i));
                                        ++i;
                                    }
                                } else {
                                    client.print(mindMap);
                                    PrintMapAction2.this.appendLog("[print] print sheet...");
                                }
                                PrintMapAction2.this.appendLog("[print] print success...");
                            }
                        });
                        break block26;
                    }
                    finally {
                        client.dispose();
                    }
                }
                this.appendLog("[print] printer data is null...over...");
            }
            finally {
                this.log(this.logMessage);
                this.logMessage = "";
            }
        }
    }

    private IMindMap findMindMap(IGraphicalEditorPage page) {
        IMindMap map = (IMindMap)page.getAdapter(IMindMap.class);
        if (map != null) {
            return map;
        }
        if (page.getInput() instanceof IMindMap) {
            return (IMindMap)page.getInput();
        }
        IGraphicalViewer viewer = page.getViewer();
        if (viewer != null) {
            map = (IMindMap)viewer.getAdapter(IMindMap.class);
            if (map != null) {
                return map;
            }
            if (viewer.getInput() instanceof IMindMap) {
                return (IMindMap)viewer.getInput();
            }
        }
        return null;
    }

    private String getJobName(IMindMap map) {
        return map.getCentralTopic().getTitleText().replaceAll("\r\n|\r|\n", " ");
    }

    private void appendLog(String message) {
        this.logMessage = String.valueOf(this.logMessage) + message;
    }

    private void log(String message) {
        if (Util.isMac()) {
            MindMapUIPlugin.log(null, message);
        }
    }
}

