/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.Graphics;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Element;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.ui.internal.svgsupport.LinearGradient;
import org.xmind.ui.internal.svgsupport.PatternResourceDescriptor;
import org.xmind.ui.internal.svgsupport.SVGColor;
import org.xmind.ui.internal.svgsupport.SVGDefinition;
import org.xmind.ui.internal.svgsupport.SVGShapeFactory;
import org.xmind.ui.internal.svgsupport.SVGShapeInfoMap;
import org.xmind.ui.internal.svgsupport.SVGTransform;
import org.xmind.ui.internal.svgsupport.TransformElement;

abstract class SVGShape
implements SVGDefinition,
Cloneable {
    public static final PrecisionRectangle INVALID_RECT = new PrecisionRectangle(0.0, 0.0, -1.0, -1.0);
    private static final int RATIO = 255;
    static Map<String, SVGDefinition> idRefs = new HashMap<String, SVGDefinition>();
    private SVGShapeInfoMap info = new SVGShapeInfoMap();
    private PrecisionRectangle rect;
    private PathData pathData;
    private ResourceManager resourceManager;

    SVGShape() {
    }

    abstract org.xmind.gef.draw2d.graphics.Path generatePath(Display var1);

    abstract PrecisionRectangle generateRectangle();

    void parse(Element implementation, SVGShape parent) {
        this.info.parse(implementation, parent == null ? null : parent.info);
    }

    static SVGShape parseShape(Element ele, SVGShape parent) {
        String type = ele.getTagName();
        if (type == null) {
            return null;
        }
        SVGShape shape = SVGShapeFactory.createSVGShape(type);
        if (shape != null) {
            shape.parse(ele, parent);
        }
        return shape;
    }

    float getFloatAttribute(Element ele, String name) {
        if (ele.hasAttribute(name)) {
            return Float.valueOf(ele.getAttribute(name)).floatValue();
        }
        return 0.0f;
    }

    void paintImage(Graphics graphics, Display device) {
        org.xmind.gef.draw2d.graphics.Path path = null;
        if (this.pathData == null) {
            path = this.generatePath(device);
            this.pathData = path.getPathData();
        } else {
            path = new org.xmind.gef.draw2d.graphics.Path((Device)device, this.pathData);
        }
        if (this.rect == null || this.rect == INVALID_RECT) {
            this.rect = this.generateRectangle();
        }
        this.paint(graphics, this.rect, path);
        path.dispose();
    }

    private void paint(Graphics graphics, PrecisionRectangle rect, org.xmind.gef.draw2d.graphics.Path path) {
        boolean statePushed = this.prePaint(graphics);
        Color background = null;
        Color foreground = null;
        Pattern pattern = null;
        PrecisionRectangle correctRect = null;
        if (rect == INVALID_RECT) {
            float[] rectNums = new float[4];
            path.getBounds(rectNums);
            if (Util.isWindows()) {
                float[] autoScaleDown = DPIUtil.autoScaleDown((float[])rectNums);
                rectNums[0] = autoScaleDown[0];
                rectNums[1] = autoScaleDown[1];
                rectNums[2] = autoScaleDown[2];
                rectNums[3] = autoScaleDown[3];
            }
            correctRect = new PrecisionRectangle((double)rectNums[0], (double)rectNums[1], (double)rectNums[2], (double)rectNums[3]);
        } else {
            correctRect = rect;
        }
        SVGColor co = this.info.getFillColor();
        if (co != null) {
            float alpha = 255.0f * this.info.getFillOpacity();
            graphics.setFillRule(this.info.getFillRule().equals("nonzero") ? 2 : 1);
            if (co.getLinearGradient() != null) {
                pattern = this.getLinearGradientPattern(co, alpha, correctRect);
                graphics.setBackgroundPattern(pattern);
            } else {
                background = this.resourceManager.createColor(co.getRGB());
                graphics.setBackgroundColor(background);
            }
            graphics.fillPath((Path)path);
        }
        if ((co = this.info.getStrokeColor()) != null) {
            float alpha = 255.0f * this.info.getStrokeOpacity();
            if (co.getLinearGradient() != null) {
                PrecisionRectangle rectExpand = new PrecisionRectangle(correctRect);
                rectExpand.expand((double)this.info.getLineWidth(), (double)this.info.getLineWidth());
                pattern = this.getLinearGradientPattern(co, alpha, rectExpand);
                graphics.setForegroundPattern(pattern);
            } else {
                foreground = this.resourceManager.createColor(co.getRGB());
                graphics.setAlpha((int)alpha);
                graphics.setForegroundColor(foreground);
            }
            this.setApplyLineStyle(graphics);
            graphics.drawPath((Path)path);
        }
        this.postPaint(graphics, statePushed);
    }

    private Pattern getLinearGradientPattern(SVGColor co, float alpha, PrecisionRectangle rect) {
        LinearGradient linearGradient = co.getLinearGradient();
        SVGColor back = linearGradient.getBackGroundColor();
        SVGColor fore = linearGradient.getForeGroundColor();
        Color foreground = this.resourceManager.createColor(fore.getRGB());
        Color background = this.resourceManager.createColor(back.getRGB());
        Pattern pattern = (Pattern)this.resourceManager.create((DeviceResourceDescriptor)new PatternResourceDescriptor((float)(rect.x + (double)linearGradient.getX1() * rect.width), (float)(rect.y + (double)linearGradient.getY1() * rect.height), (float)(rect.x + (double)linearGradient.getX2() * rect.width), (float)(rect.y + (double)linearGradient.getY2() * rect.height), (int)(alpha * linearGradient.getForeOpacity()), foreground, (int)(alpha * linearGradient.getBackOpacity()), background));
        return pattern;
    }

    boolean prePaint(Graphics graphics) {
        boolean statePushed = false;
        try {
            graphics.pushState();
            statePushed = true;
        }
        catch (Exception exception) {
            statePushed = false;
        }
        if (this.haveTransformProperty()) {
            for (TransformElement element : this.info.getTransform().getList()) {
                element.transform(graphics);
            }
        }
        return statePushed;
    }

    private boolean haveTransformProperty() {
        SVGTransform transform;
        return this.info != null && this.info.getTransform() != null && (transform = this.info.getTransform()).getList() != null;
    }

    private void setApplyLineStyle(Graphics graphics) {
        LineAttributes lineAttribute = new LineAttributes(this.info.getLineWidth());
        lineAttribute.style = this.info.getLineStyle();
        lineAttribute.dash = this.info.getLineDash();
        lineAttribute.dashOffset = this.info.getLineDashOffset();
        lineAttribute.join = this.info.getLineJoin();
        lineAttribute.miterLimit = this.info.getLineMiterLimit();
        graphics.setLineAttributes(lineAttribute);
    }

    void postPaint(Graphics graphics, boolean statePushed) {
        if (statePushed) {
            try {
                graphics.restoreState();
                graphics.popState();
            }
            catch (Throwable throwable) {}
        }
    }

    protected SVGShape clone() {
        return this.clone();
    }

    void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public SVGShapeInfoMap getInfo() {
        return this.info;
    }

    public void setInfo(SVGShapeInfoMap info) {
        this.info = info;
    }
}

