/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.signin.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import net.xmind.signin.internal.Activator;
import net.xmind.signin.internal.Messages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.xmind.core.net.FieldSet;
import org.xmind.core.net.http.FileEntity;
import org.xmind.core.net.http.HttpEntity;
import org.xmind.core.net.http.HttpException;
import org.xmind.core.net.http.HttpRequest;
import org.xmind.core.net.http.MultipartEntity;
import org.xmind.core.net.util.LinkUtils;
import org.xmind.ui.internal.statushandlers.IErrorReporter;
import org.xmind.ui.internal.statushandlers.StatusDetails;

public class XMindNetErrorReporter
implements IErrorReporter {
    private static final String API_PATH = "/_api/error-report";
    private static final String USER_NAME_REPLACEMENT = "USERNAME";
    private static final String PREF_REPORTER_EMAIL = "net.xmind.signin.errorReporter.reporterEmail";

    public boolean report(StatusDetails error) throws InterruptedException {
        Display display = Display.getCurrent();
        String reporterEmail = Activator.getDefault().getPreferenceStore().getString(PREF_REPORTER_EMAIL);
        if (display != null) {
            InputDialog inputDialog = new InputDialog(display.getActiveShell(), Messages.XMindNetErrorReporter_ReporterEmailInputDialog_windowTitle, Messages.XMindNetErrorReporter_ReporterEmailInputDialog_message, reporterEmail, null);
            if (inputDialog.open() != 0) {
                throw new InterruptedException();
            }
            reporterEmail = inputDialog.getValue();
            Activator.getDefault().getPreferenceStore().putValue(PREF_REPORTER_EMAIL, reporterEmail);
        }
        ReportErrorJob job = new ReportErrorJob(error, reporterEmail);
        job.setUser(true);
        job.schedule(0L);
        return true;
    }

    private static File copyTempLogFile() {
        IPath logFilePath = Platform.getLogFileLocation();
        if (logFilePath == null) {
            return null;
        }
        File logFile = logFilePath.toFile();
        if (logFile == null) {
            return null;
        }
        IPath tempDirPath = Platform.getStateLocation((Bundle)Activator.getDefault().getBundle());
        if (tempDirPath == null) {
            return null;
        }
        File tempDir = tempDirPath.toFile();
        if (tempDir == null) {
            return null;
        }
        File tempFile = new File(new File(tempDir, "temp-log"), System.currentTimeMillis() + ".log");
        if (!tempFile.getParentFile().isDirectory()) {
            tempFile.getParentFile().mkdirs();
        }
        if (!tempFile.getParentFile().isDirectory()) {
            return null;
        }
        String userName = System.getProperty("user.name");
        if ("".equals(userName.trim())) {
            userName = null;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(logFile));
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(tempFile));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (userName != null) {
                            line = line.replace(userName, USER_NAME_REPLACEMENT);
                        }
                        writer.write(line);
                        writer.newLine();
                    }
                }
                finally {
                    writer.close();
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException iOException) {
            tempFile.delete();
            return null;
        }
        return tempFile;
    }

    private static class ReportErrorJob
    extends Job {
        private final StatusDetails error;
        private final String reporterEmail;

        public ReportErrorJob(StatusDetails error, String reporterEmail) {
            super(Messages.ReportErrorJob_jobName);
            this.error = error;
            this.reporterEmail = reporterEmail;
        }

        /*
         * Loose catch block
         */
        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            File tempLogFile = null;
            try {
                tempLogFile = XMindNetErrorReporter.copyTempLogFile();
                if (subMonitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                FieldSet params = new FieldSet().add("details", (Object)this.error.getFullText());
                if (this.reporterEmail != null) {
                    params.add("reporter", (Object)this.reporterEmail);
                }
                if (tempLogFile != null) {
                    params.add("log", (Object)new FileEntity(tempLogFile));
                }
                HttpRequest request = new HttpRequest(true, LinkUtils.getHostByLanguage((boolean)false, (boolean)false), -1, XMindNetErrorReporter.API_PATH, null, null, "POST", null, (HttpEntity)new MultipartEntity(params), null, null);
                subMonitor.subTask(Messages.ReportErrorJob_SendingErrorReport_taskTitle);
                try {
                    request.execute((IProgressMonitor)subMonitor);
                }
                catch (InterruptedException interruptedException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    if (tempLogFile != null) {
                        tempLogFile.delete();
                    }
                    return iStatus;
                }
                catch (HttpException e) {
                    Status status;
                    block14: {
                        status = new Status(4, "net.xmind.signin", e.getMessage(), (Throwable)e);
                        if (tempLogFile == null) break block14;
                        tempLogFile.delete();
                    }
                    return status;
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (tempLogFile != null) {
                    tempLogFile.delete();
                }
            }
        }
    }
}

