/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.ui.outline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.xmind.gef.tree.ITreeViewer;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;

public abstract class GraphicalOutlinePage
extends Page
implements ISelectionProvider,
ISelectionChangedListener,
IPageChangedListener,
IPropertyListener {
    private List<ISelectionChangedListener> selectionChangedListeners = null;
    private IGraphicalEditor editor;
    private PageBook pageBook;
    private ITreeViewer editorTreeViewer;
    private Map<Object, ITreeViewer> pageViewers = new HashMap<Object, ITreeViewer>();
    private boolean showCurrentPageViewer = false;

    public GraphicalOutlinePage(IGraphicalEditor editor) {
        this.editor = editor;
        this.hookEditor(editor);
    }

    protected void hookEditor(IGraphicalEditor editor) {
        editor.addPageChangedListener(this);
        editor.addPropertyListener(this);
    }

    protected void unhookEditor(IGraphicalEditor editor) {
        editor.removePropertyListener(this);
        editor.removePageChangedListener(this);
    }

    public void pageChanged(PageChangedEvent event) {
        if (this.pageBook == null || this.pageBook.isDisposed() || !this.showCurrentPageViewer) {
            return;
        }
        this.updatePageBook();
    }

    protected IGraphicalEditor getParentEditor() {
        return this.editor;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public void createControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.updatePageBook();
    }

    public boolean isShowCurrentPageViewer() {
        return this.showCurrentPageViewer;
    }

    public void setShowCurrentPageViewer(boolean showCurrentPageViewer) {
        if (showCurrentPageViewer == this.showCurrentPageViewer) {
            return;
        }
        this.showCurrentPageViewer = showCurrentPageViewer;
        this.updatePageBook();
    }

    protected void updatePageBook() {
        if (this.isShowCurrentPageViewer()) {
            this.showCurrentPageViewer(false);
        } else {
            this.showEditorTreeViewer(false);
        }
    }

    protected void refresh() {
        if (this.isShowCurrentPageViewer()) {
            this.showCurrentPageViewer(true);
        } else {
            this.showEditorTreeViewer(true);
        }
    }

    protected void showEditorTreeViewer(boolean refresh) {
        if (this.editorTreeViewer == null || this.editorTreeViewer.getControl() == null || this.editorTreeViewer.getControl().isDisposed()) {
            this.editorTreeViewer = this.createEditorTreeViewer();
            if (this.editorTreeViewer != null) {
                this.configureEditorTreeViewer(this.editorTreeViewer);
                this.createEditorTreeViewerControl(this.editorTreeViewer, (Composite)this.pageBook);
                if (!refresh) {
                    this.editorTreeViewer.setInput(this.createEditorTreeViewerInput(this.editor));
                }
            }
        }
        if (this.editorTreeViewer != null) {
            Object newInput;
            if (refresh && (newInput = this.createEditorTreeViewerInput(this.editor)) != this.editorTreeViewer.getInput()) {
                this.editorTreeViewer.setInput(newInput);
            }
            this.pageBook.showPage(this.editorTreeViewer.getControl());
        }
    }

    protected void showCurrentPageViewer(boolean refresh) {
        IGraphicalEditorPage page = this.editor.getActivePageInstance();
        if (page == null) {
            return;
        }
        Object pageInput = page.getInput();
        ITreeViewer pageTreeViewer = this.pageViewers.get(pageInput);
        if ((pageTreeViewer == null || pageTreeViewer.getControl() == null || pageTreeViewer.getControl().isDisposed()) && (pageTreeViewer = this.createPageTreeViewer()) != null) {
            this.configurePageTreeViewer(pageTreeViewer);
            this.createPageTreeViewerControl(pageTreeViewer, (Composite)this.pageBook);
            if (!refresh) {
                pageTreeViewer.setInput(this.createPageTreeViewerInput(pageInput));
            }
        }
        if (pageTreeViewer != null) {
            Object newInput;
            if (refresh && (newInput = this.createPageTreeViewerInput(pageInput)) != pageTreeViewer.getInput()) {
                pageTreeViewer.setInput(newInput);
            }
            this.pageBook.showPage(pageTreeViewer.getControl());
        }
    }

    protected abstract ITreeViewer createEditorTreeViewer();

    protected abstract ITreeViewer createPageTreeViewer();

    protected abstract Control createEditorTreeViewerControl(ITreeViewer var1, Composite var2);

    protected abstract Control createPageTreeViewerControl(ITreeViewer var1, Composite var2);

    protected abstract Object createEditorTreeViewerInput(IGraphicalEditor var1);

    protected abstract Object createPageTreeViewerInput(Object var1);

    protected void configureEditorTreeViewer(ITreeViewer viewer) {
        this.configureTreeViewer(viewer);
    }

    protected void configurePageTreeViewer(ITreeViewer viewer) {
        this.configureTreeViewer(viewer);
    }

    protected void configureTreeViewer(ITreeViewer viewer) {
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public Control getControl() {
        return this.pageBook;
    }

    public void setFocus() {
        this.pageBook.setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.selectionChangedListeners == null) {
            this.selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
        }
        this.selectionChangedListeners.add(listener);
    }

    public ISelection getSelection() {
        if (this.editorTreeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.editorTreeViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.selectionChangedListeners == null) {
            return;
        }
        this.selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        if (this.editorTreeViewer != null) {
            this.editorTreeViewer.setSelection(selection);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireSelectionChanged(event.getSelection());
    }

    protected void fireSelectionChanged(ISelection selection) {
        if (this.selectionChangedListeners == null) {
            return;
        }
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listeners = this.selectionChangedListeners.toArray();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 258) {
            this.editorInputChanged();
        }
    }

    protected void editorInputChanged() {
        this.refresh();
    }

    public void dispose() {
        this.unhookEditor(this.editor);
        super.dispose();
    }
}

