//
//  CLDateElement.m
//  DateLine
//
//  Created by Alex Clarke on 8/05/05.
//  Copyright 2005 CocoaLab. All rights reserved.
//

#import "CLDateElement.h"
#import "CLDateElement+Graphics.h"


@implementation CLDateElement

//==============// Graphic methods //==============//

-(void)drawInView:(NSView *)aView //called by our custom view for each element
{
	//pass the drawing to the graphics category

	[self drawElementInView:aView];
}

- (BOOL)hitTest:(NSPoint)point isSelected:(BOOL)isSelected
{
    float hypotenuse2 = pow((xLoc-point.x), 2.0) + pow((yLoc-point.y), 2.0);
    return (hypotenuse2 < ((height) * (width-15)));
}


//==============// Accessors //==============//


- (NSCalendarDate *)date 
{
    NSCalendarDate * tmpValue;
    
    [self willAccessValueForKey: @"date"];
    tmpValue = [self primitiveValueForKey: @"date"];
    [self didAccessValueForKey: @"date"];
    
    return tmpValue;
}

- (void)setDate:(NSCalendarDate *)value 
{
    [self willChangeValueForKey: @"date"];
    [self setPrimitiveValue: value forKey: @"date"];
    [self didChangeValueForKey: @"date"];
}

@end
