/*
 * Decompiled with CFR 0.152.
 */
package images;

import shared.IBytedeque;
import shared.IBytestream;
import shared.b;
import shared.e;
import shared.m;
import shared.readexception;
import shared.uncaughtexception;

public class Image {

    public static class Agrb {
        public byte[][][][] image;
        public int levels;
        public int texwidth;
        public int texheight;

        public Agrb(byte[] data, int levels, int texwidth, int texheight) throws readexception {
            this.levels = levels;
            this.texwidth = texwidth;
            this.texheight = texheight;
            this.image = new byte[levels][][][];
            int pos = 0;
            for (int level = 0; level < levels; ++level) {
                int width = texwidth >>> level;
                int height = texheight >>> level;
                int bytesPerRow = width * 4;
                this.image[level] = new byte[height][width][4];
                for (int row = 0; row < height; ++row) {
                    for (int col = 0; col < width; ++col) {
                        for (int i = 0; i < 4; ++i) {
                            this.image[level][row][col][i] = data[pos];
                            ++pos;
                        }
                    }
                }
            }
            throw new readexception("Argb is untested: throwing error.");
        }

        public void invert() {
            for (int level = 0; level < this.levels; ++level) {
                int width = this.texwidth >>> level;
                int height = this.texheight >>> level;
                int bytesPerRow = width * 4;
                byte[][][] newimage = new byte[height][][];
                for (int row = 0; row < height; ++row) {
                    newimage[row] = this.image[level][height - row - 1];
                }
                this.image[level] = newimage;
            }
        }

        public byte[][] save() {
            byte[][] result = new byte[this.levels][];
            for (int level = 0; level < this.levels; ++level) {
                int width = this.texwidth >>> level;
                int height = this.texheight >>> level;
                int bytesPerRow = width * 4;
                result[level] = new byte[bytesPerRow * height];
                int pos = 0;
                for (int row = 0; row < height; ++row) {
                    for (int col = 0; col < width; ++col) {
                        for (int i = 0; i < 4; ++i) {
                            result[level][pos] = this.image[level][row][col][i];
                            ++pos;
                        }
                    }
                }
            }
            return result;
        }
    }

    public static class Dxt {
        public Level[] levels;
        public int numLevels;
        public int texwidth;
        public int texheight;
        public byte texelsize;

        public Dxt(IBytestream data, int numLevels, int texwidth, int texheight, byte texelsize) throws readexception {
            e.ensure((texwidth & 3) == 0);
            e.ensure((texheight & 3) == 0);
            this.numLevels = numLevels;
            this.texwidth = texwidth;
            this.texheight = texheight;
            this.texelsize = texelsize;
            this.levels = new Level[numLevels];
            for (int curLevel = 0; curLevel < numLevels; ++curLevel) {
                int levelwidth = texwidth >>> curLevel;
                int levelheight = texheight >>> curLevel;
                this.levels[curLevel] = new Level(data, levelwidth, levelheight, texelsize);
            }
        }

        public void invert() {
            if (this.texelsize != 8 && this.texelsize != 16) {
                m.err("Inversion of non-DXT1/DXT5 not currently supported.");
                return;
            }
            for (int i = 0; i < this.numLevels; ++i) {
                this.levels[i].invert();
            }
        }

        public void rotate90clockwise() {
            if (this.texelsize != 8 && this.texelsize != 16) {
                m.err("Rotation of non-DXT1/DXT5 not currently supported.");
                return;
            }
            for (int i = 0; i < this.numLevels; ++i) {
                this.levels[i].rotate90clockwise();
            }
        }

        public void compile(IBytedeque c) {
            for (int curLevel = 0; curLevel < this.numLevels; ++curLevel) {
                this.levels[curLevel].compile(c);
            }
        }

        public int getDxtType() {
            if (this.texelsize == 16) {
                return 5;
            }
            if (this.texelsize == 8) {
                return 1;
            }
            throw new uncaughtexception("unhandled.");
        }

        public static class Texel {
            byte[] rawdata;

            public Texel(IBytestream data, int texelsize) {
                this.rawdata = data.readBytes(texelsize);
            }

            public void movebits(int count, byte[] from, byte[] to, int fromoffset, int tooffset) {
                for (int i = 0; i < count; ++i) {
                    int frombytenum = (fromoffset + i) / 8;
                    int posInByte = (fromoffset + i) % 8;
                    if ((from[frombytenum] & 1 << posInByte) == 0) continue;
                    int tobytenum = (tooffset + i) / 8;
                    int pos2InByte = (tooffset + i) % 8;
                    to[tobytenum] = b.or(to[tobytenum], 1 << pos2InByte);
                }
            }

            public void invert() {
                if (this.rawdata.length == 8) {
                    int a = b.BytesToInt32(this.rawdata, 4);
                    int a2 = (a & 0xFF) << 24 | (a & 0xFF000000) >>> 24 | (a & 0xFF0000) >>> 8 | (a & 0xFF00) << 8;
                    b.Int32IntoBytes(a2, this.rawdata, 4);
                } else if (this.rawdata.length == 16) {
                    int a = b.BytesToInt32(this.rawdata, 12);
                    int a2 = (a & 0xFF) << 24 | (a & 0xFF000000) >>> 24 | (a & 0xFF0000) >>> 8 | (a & 0xFF00) << 8;
                    b.Int32IntoBytes(a2, this.rawdata, 12);
                    byte[] newrawdata = new byte[16];
                    this.movebits(16, this.rawdata, newrawdata, 0, 0);
                    this.movebits(64, this.rawdata, newrawdata, 64, 64);
                    this.movebits(12, this.rawdata, newrawdata, 16, 52);
                    this.movebits(12, this.rawdata, newrawdata, 52, 16);
                    this.movebits(12, this.rawdata, newrawdata, 28, 40);
                    this.movebits(12, this.rawdata, newrawdata, 40, 28);
                    this.rawdata = newrawdata;
                }
            }

            public void rotate90clockwise() {
                if (this.rawdata.length == 8) {
                    int a = b.BytesToInt32(this.rawdata, 4);
                    int a2 = (a & 3) << 6 | (a & 0xC) << 12 | (a & 0x30) << 18 | (a & 0xC0) << 24 | (a & 0x300) >>> 4 | (a & 0xC00) << 2 | (a & 0x3000) << 8 | (a & 0xC000) << 14 | (a & 0x30000) >>> 14 | (a & 0xC0000) >>> 8 | (a & 0x300000) >>> 2 | (a & 0xC00000) << 4 | (a & 0x3000000) >>> 24 | (a & 0xC000000) >>> 18 | (a & 0x30000000) >>> 12 | (a & 0xC0000000) >>> 6;
                    b.Int32IntoBytes(a2, this.rawdata, 4);
                } else if (this.rawdata.length == 16) {
                    int a = b.BytesToInt32(this.rawdata, 12);
                    int a2 = (a & 3) << 6 | (a & 0xC) << 12 | (a & 0x30) << 18 | (a & 0xC0) << 24 | (a & 0x300) >>> 4 | (a & 0xC00) << 2 | (a & 0x3000) << 8 | (a & 0xC000) << 14 | (a & 0x30000) >>> 14 | (a & 0xC0000) >>> 8 | (a & 0x300000) >>> 2 | (a & 0xC00000) << 4 | (a & 0x3000000) >>> 24 | (a & 0xC000000) >>> 18 | (a & 0x30000000) >>> 12 | (a & 0xC0000000) >>> 6;
                    b.Int32IntoBytes(a2, this.rawdata, 12);
                    byte[] newrawdata = new byte[16];
                    this.movebits(16, this.rawdata, newrawdata, 0, 0);
                    this.movebits(64, this.rawdata, newrawdata, 64, 64);
                    this.movebits(3, this.rawdata, newrawdata, 16, 25);
                    this.movebits(3, this.rawdata, newrawdata, 28, 22);
                    this.movebits(3, this.rawdata, newrawdata, 40, 19);
                    this.movebits(3, this.rawdata, newrawdata, 52, 16);
                    this.movebits(3, this.rawdata, newrawdata, 19, 37);
                    this.movebits(3, this.rawdata, newrawdata, 31, 34);
                    this.movebits(3, this.rawdata, newrawdata, 43, 31);
                    this.movebits(3, this.rawdata, newrawdata, 55, 28);
                    this.movebits(3, this.rawdata, newrawdata, 22, 49);
                    this.movebits(3, this.rawdata, newrawdata, 34, 46);
                    this.movebits(3, this.rawdata, newrawdata, 46, 43);
                    this.movebits(3, this.rawdata, newrawdata, 58, 40);
                    this.movebits(3, this.rawdata, newrawdata, 25, 61);
                    this.movebits(3, this.rawdata, newrawdata, 37, 58);
                    this.movebits(3, this.rawdata, newrawdata, 49, 55);
                    this.movebits(3, this.rawdata, newrawdata, 61, 52);
                    this.rawdata = newrawdata;
                }
            }

            public void compile(IBytedeque c) {
                c.writeBytes(this.rawdata);
            }
        }

        public static class Level {
            public Texel[][] texels;
            public int numTexelsWide;
            public int numTexelsHigh;
            public int width;
            public int height;
            public int[][] extraPixels;

            public Level(IBytestream data, int width, int height, int texelsize) throws readexception {
                this.width = width;
                this.height = height;
                this.numTexelsWide = width / 4;
                this.numTexelsHigh = height / 4;
                if (this.numTexelsWide == 0 || this.numTexelsHigh == 0) {
                    if (width == 0 || height == 0) {
                        throw new readexception("Dxt: Unhandled case.");
                    }
                    this.extraPixels = data.readMultiDimensionInts(width, height);
                } else {
                    this.texels = new Texel[this.numTexelsHigh][this.numTexelsWide];
                    for (int i = 0; i < this.numTexelsHigh; ++i) {
                        for (int j = 0; j < this.numTexelsWide; ++j) {
                            this.texels[i][j] = new Texel(data, texelsize);
                        }
                    }
                }
            }

            public void invert() {
                if (this.texels == null) {
                    int[][] tempPixels = new int[this.height][];
                    for (int i = 0; i < this.height; ++i) {
                        tempPixels[i] = this.extraPixels[this.height - i - 1];
                    }
                    this.extraPixels = tempPixels;
                } else {
                    for (int i = 0; i < this.numTexelsHigh; ++i) {
                        for (int j = 0; j < this.numTexelsWide; ++j) {
                            this.texels[i][j].invert();
                        }
                    }
                    Texel[][] newtexels = new Texel[this.numTexelsHigh][];
                    for (int i = 0; i < this.numTexelsHigh; ++i) {
                        newtexels[i] = this.texels[this.numTexelsHigh - i - 1];
                    }
                    this.texels = newtexels;
                }
            }

            public void rotate90clockwise() {
                if (this.texels == null) {
                    int[][] tempPixels = b.rotateIntGridClockwise(this.extraPixels);
                    this.extraPixels = tempPixels;
                } else {
                    for (int i = 0; i < this.numTexelsHigh; ++i) {
                        for (int j = 0; j < this.numTexelsWide; ++j) {
                            this.texels[i][j].rotate90clockwise();
                        }
                    }
                    Texel[][] tempTexels = new Texel[this.texels.length][this.texels[0].length];
                    b.rotateGridClockwise(this.texels, tempTexels);
                    this.texels = tempTexels;
                }
            }

            public void compile(IBytedeque c) {
                if (this.texels == null) {
                    c.writeMultiDimensionInts(this.extraPixels);
                } else {
                    for (int i = 0; i < this.numTexelsHigh; ++i) {
                        for (int j = 0; j < this.numTexelsWide; ++j) {
                            this.texels[i][j].compile(c);
                        }
                    }
                }
            }
        }
    }
}

