/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import java.util.Arrays;
import java.util.Random;
import shared.IBytedeque;
import shared.IBytestream;
import shared.b;
import shared.m;
import uru.context;

public class Guid {
    public byte[] guid;
    private static int player = 1;
    private static int ageinstance = 2;

    public Guid(context c) {
        this(c.in);
    }

    public Guid(IBytestream c) {
        this.guid = c.readBytes(16);
    }

    public Guid(byte[] bytes) {
        if (bytes.length != 16) {
            m.throwUncaughtException("Guid is the wrong size.");
        }
        this.guid = bytes;
    }

    public void write(IBytedeque c) {
        c.writeBytes(this.guid);
    }

    public static Guid newAgeInstanceGuid(int prefix, int playerId) {
        byte[] guid = new byte[16];
        b.Int32IntoBytes(ageinstance, guid, 0);
        b.Int32IntoBytes(playerId, guid, 4);
        b.Int32IntoBytes(prefix, guid, 8);
        return new Guid(guid);
    }

    public static byte[] newRandomPlayer() {
        Random rng = new Random();
        byte[] guid = new byte[16];
        rng.nextBytes(guid);
        b.Int32IntoBytes(player, guid, 0);
        return guid;
    }

    public static Guid fullyRandom() {
        Random rng = new Random();
        byte[] guid = new byte[16];
        rng.nextBytes(guid);
        return new Guid(guid);
    }

    public static byte[] none() {
        byte[] guid = new byte[16];
        return guid;
    }

    public static Guid none2() {
        return new Guid(new byte[16]);
    }

    public static String GuidBytesToString(byte[] guid) {
        int i;
        StringBuilder r = new StringBuilder();
        for (i = 0; i < 4; ++i) {
            b.ByteToHexString(r, guid[i]);
        }
        r.append("-");
        for (i = 4; i < 6; ++i) {
            b.ByteToHexString(r, guid[i]);
        }
        r.append("-");
        for (i = 6; i < 8; ++i) {
            b.ByteToHexString(r, guid[i]);
        }
        r.append("-");
        for (i = 8; i < 10; ++i) {
            b.ByteToHexString(r, guid[i]);
        }
        r.append("-");
        for (i = 10; i < 16; ++i) {
            b.ByteToHexString(r, guid[i]);
        }
        return r.toString();
    }

    public static byte[] GuidStringToBytes(String guid) {
        guid.replace("-", "");
        byte[] r = b.HexStringToBytes(guid);
        return r;
    }

    public String toString() {
        return b.BytesToHexString(this.guid);
    }

    public byte[] toBytes() {
        return this.guid;
    }

    public int hashCode() {
        int hashcode = Arrays.hashCode(this.guid);
        return hashcode;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof Guid)) {
            return false;
        }
        Guid g2 = (Guid)o2;
        return b.isEqual(this.guid, g2.guid);
    }
}

