/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;

public abstract class ThreadLocalBuffers
implements Buffers {
    private int _bufferSize = 12288;
    private int _headerSize = 6144;
    private final ThreadLocal<ThreadBuffers> _buffers = new ThreadLocal<ThreadBuffers>(){

        @Override
        protected ThreadBuffers initialValue() {
            return new ThreadBuffers();
        }
    };

    public Buffer getBuffer() {
        ThreadBuffers buffers = this._buffers.get();
        if (buffers._buffer != null) {
            Buffer b2 = buffers._buffer;
            buffers._buffer = null;
            return b2;
        }
        if (buffers._other != null && buffers._other.capacity() == this._bufferSize) {
            Buffer b3 = buffers._other;
            buffers._other = null;
            return b3;
        }
        return this.newBuffer(this._bufferSize);
    }

    public Buffer getHeader() {
        ThreadBuffers buffers = this._buffers.get();
        if (buffers._header != null) {
            Buffer b2 = buffers._header;
            buffers._header = null;
            return b2;
        }
        if (buffers._other != null && buffers._other.capacity() == this._headerSize && this.isHeader(buffers._other)) {
            Buffer b3 = buffers._other;
            buffers._other = null;
            return b3;
        }
        return this.newHeader(this._headerSize);
    }

    public Buffer getBuffer(int size) {
        ThreadBuffers buffers = this._buffers.get();
        if (buffers._other != null && buffers._other.capacity() == size) {
            Buffer b2 = buffers._other;
            buffers._other = null;
            return b2;
        }
        return this.newBuffer(size);
    }

    public void returnBuffer(Buffer buffer) {
        buffer.clear();
        if (buffer.isVolatile() || buffer.isImmutable()) {
            return;
        }
        int size = buffer.capacity();
        ThreadBuffers buffers = this._buffers.get();
        if (buffers._header == null && size == this._headerSize && this.isHeader(buffer)) {
            buffers._header = buffer;
        } else if (size == this._bufferSize && buffers._buffer == null) {
            buffers._buffer = buffer;
        } else {
            buffers._other = buffer;
        }
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public int getHeaderSize() {
        return this._headerSize;
    }

    protected abstract Buffer newBuffer(int var1);

    protected abstract Buffer newHeader(int var1);

    protected abstract boolean isHeader(Buffer var1);

    public void setBufferSize(int size) {
        this._bufferSize = size;
    }

    public void setHeaderSize(int size) {
        this._headerSize = size;
    }

    public String toString() {
        return "{{" + this.getHeaderSize() + "," + this.getBufferSize() + "}}";
    }

    protected static class ThreadBuffers {
        Buffer _buffer;
        Buffer _header;
        Buffer _other;

        protected ThreadBuffers() {
        }
    }
}

