/*
 * Decompiled with CFR 0.152.
 */
package pythondec;

import java.math.BigInteger;
import pythondec.PyObject;
import shared.IBytedeque;
import shared.IBytestream;
import shared.b;

public class PyLong
extends PyObject {
    int length;
    short[] datas;
    BigInteger num;

    public PyLong(IBytestream c) {
        this.length = c.readInt();
        int truelength = this.length < 0 ? -this.length : this.length;
        this.datas = c.readShorts(truelength);
        int numbits = 15 * this.datas.length;
        int numbytes = numbits / 8 + 1;
        byte[] data2 = new byte[numbytes];
        for (int i = 0; i < numbits; ++i) {
            int inbyte = i / 15;
            int inpos = i % 15;
            int curbit = this.datas[inbyte] >>> inpos & 1;
            int outbyte = i / 8;
            int outpos = i % 8;
            int n = data2.length - outbyte - 1;
            data2[n] = (byte)(data2[n] | curbit << outpos);
        }
        this.num = new BigInteger(data2);
        if (this.length < 0) {
            this.num = this.num.negate();
        }
    }

    @Override
    public void marshal(IBytedeque c) {
        c.writeByte((byte)108);
        c.writeInt(this.length);
        c.writeShorts(this.datas);
    }

    private PyLong() {
    }

    public String toString() {
        return "PyLong: " + this.num.toString();
    }

    public String toJavaString() {
        return this.num.toString() + "L";
    }

    @Override
    public int hashCode() {
        return this.num.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof PyLong)) {
            return false;
        }
        PyLong o2 = (PyLong)o;
        if (o2.length != this.length) {
            return false;
        }
        return b.isEqualShorts(this.datas, o2.datas);
    }

    @Override
    public boolean compare(PyObject o2) {
        return this.equals(o2);
    }
}

