/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.File;
import java.net.URI;
import java.util.Vector;
import shared.FileUtils;
import shared.m;
import shared.zip;

public class JarUtils {
    public static String GetThisJarPath() {
        try {
            return JarUtils.GetJarPath(JarUtils.class);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static String GetJarPath(Class klass) {
        try {
            URI uri = klass.getProtectionDomain().getCodeSource().getLocation().toURI();
            String r = uri.getPath();
            return r;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static void MergeThisJarWithLibs() {
        String jarfile = JarUtils.GetThisJarPath();
        JarUtils.MergeJarWithLibs(jarfile);
    }

    public static void MergeJarWithLibs(String jarfilename) {
        File jarfile = new File(jarfilename);
        Vector<File> jars = new Vector<File>();
        m.msg("Main jarfile: ", jarfile.getAbsolutePath());
        File libsdir = new File(jarfile.getParent() + "/lib/");
        m.msg("Libs dir: ", libsdir.getAbsolutePath());
        for (File libfile : libsdir.listFiles()) {
            if (!libfile.isFile() || !libfile.getName().endsWith(".jar")) continue;
            m.msg("Lib jarfile: ", libfile.getAbsolutePath());
            jars.add(libfile);
        }
        jars.add(jarfile);
        JarUtils.MergeJars(jars, jarfile.getParentFile());
    }

    public static void MergeJars(Vector<File> jars, File outputdir) {
        File tempdir = new File(outputdir + "/tempmerge/");
        FileUtils.DeleteTree(tempdir, true);
        String curfilename = null;
        for (File file : jars) {
            zip.extractZipFile(file.getAbsolutePath(), tempdir);
            curfilename = file.getName();
        }
        File manifestdir = new File(outputdir + "/tempmerge/META-INF/");
        for (File child : manifestdir.listFiles()) {
            String filename;
            if (!child.exists() || !child.isFile() || !(filename = child.getName().toLowerCase()).endsWith(".rsa") && !filename.endsWith(".dsa") && !filename.endsWith(".sf") && !filename.startsWith("sig-")) continue;
            FileUtils.DeleteFile(child.getAbsolutePath(), true);
        }
        File file = new File(outputdir + "/" + curfilename + "-Merged.jar");
        zip.createZipFile(tempdir, file);
    }
}

