/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.tools.Pair;

public class DividedScale<T> {
    private final List<Range> ranges;
    private final List<T> data;

    protected DividedScale() {
        this.ranges = new ArrayList<Range>();
        this.ranges.add(Range.ZERO_TO_INFINITY);
        this.data = new ArrayList<T>();
        this.data.add(null);
    }

    protected DividedScale(DividedScale<T> s) {
        this.ranges = new ArrayList<Range>(s.ranges);
        this.data = new ArrayList<T>(s.data);
    }

    public T get(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("scale must be <= 0 but is " + scale);
        }
        for (int i = 0; i < this.data.size(); ++i) {
            Range range = this.ranges.get(i);
            if (!range.contains(scale)) continue;
            return this.data.get(i);
        }
        throw new AssertionError();
    }

    public Pair<T, Range> getWithRange(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("scale must be <= 0 but is " + scale);
        }
        for (int i = 0; i < this.data.size(); ++i) {
            Range range = this.ranges.get(i);
            if (!range.contains(scale)) continue;
            return new Pair<T, Range>(this.data.get(i), range);
        }
        throw new AssertionError();
    }

    public DividedScale<T> put(T o, Range r) {
        DividedScale<T> s = new DividedScale<T>(this);
        super.putImpl(o, r.getLower(), r.getUpper());
        s.consistencyTest();
        return s;
    }

    private void putImpl(T o, double lower, double upper) {
        int i = 0;
        while (this.ranges.get(i).getUpper() <= lower) {
            ++i;
        }
        Range split = this.ranges.get(i);
        if (split.getUpper() < upper) {
            throw new RangeViolatedError("the new range must be within a single subrange");
        }
        if (this.data.get(i) != null) {
            throw new RangeViolatedError("the new range must be within a subrange that has no data");
        }
        if (split.getLower() == lower && split.getUpper() == upper) {
            this.data.set(i, o);
        } else if (split.getLower() == lower) {
            this.ranges.set(i, new Range(split.getLower(), upper));
            this.ranges.add(i + 1, new Range(upper, split.getUpper()));
            this.data.add(i, o);
        } else if (split.getUpper() == upper) {
            this.ranges.set(i, new Range(split.getLower(), lower));
            this.ranges.add(i + 1, new Range(lower, split.getUpper()));
            this.data.add(i + 1, o);
        } else {
            this.ranges.set(i, new Range(split.getLower(), lower));
            this.ranges.add(i + 1, new Range(lower, upper));
            this.ranges.add(i + 2, new Range(upper, split.getUpper()));
            this.data.add(i + 1, o);
            this.data.add(i + 2, null);
        }
    }

    public void consistencyTest() {
        if (this.ranges.size() < 1) {
            throw new AssertionError(this.ranges);
        }
        if (this.data.isEmpty()) {
            throw new AssertionError(this.data);
        }
        if (this.ranges.size() != this.data.size()) {
            throw new AssertionError();
        }
        if (this.ranges.get(0).getLower() != 0.0) {
            throw new AssertionError();
        }
        if (this.ranges.get(this.ranges.size() - 1).getUpper() != Double.POSITIVE_INFINITY) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.data.size() - 1; ++i) {
            if (this.ranges.get(i).getUpper() != this.ranges.get(i + 1).getLower()) {
                throw new AssertionError();
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DividedScale that = (DividedScale)obj;
        return Objects.equals(this.ranges, that.ranges) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.ranges, this.data);
    }

    public String toString() {
        return "DS{" + this.ranges + ' ' + this.data + '}';
    }

    public static class RangeViolatedError
    extends RuntimeException {
        public RangeViolatedError(String message) {
            super(message);
        }
    }
}

