/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery.vectortile.mapbox.style;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.InvalidMapboxVectorTileException;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.style.Layers;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.style.Source;
import org.openstreetmap.josm.data.preferences.JosmBaseDirectories;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class MapboxVectorStyle {
    private static final ConcurrentHashMap<String, MapboxVectorStyle> STYLE_MAPPING = new ConcurrentHashMap();
    private final int version;
    private final String name;
    private final String spriteUrl;
    private final String glyphUrl;
    private final Map<Source, ElemStyles> sources;

    public static MapboxVectorStyle getMapboxVectorStyle(String url) {
        return STYLE_MAPPING.computeIfAbsent(url, key -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public MapboxVectorStyle(JsonObject jsonObject) {
        this.version = jsonObject.getInt("version");
        if (this.version == 8) {
            List layers;
            List sourceList;
            this.name = jsonObject.getString("name", null);
            String id = jsonObject.getString("id", this.name);
            this.spriteUrl = jsonObject.getString("sprite", null);
            this.glyphUrl = jsonObject.getString("glyphs", null);
            if (jsonObject.containsKey("sources") && ((JsonValue)jsonObject.get("sources")).getValueType() == JsonValue.ValueType.OBJECT) {
                JsonObject sourceObj = jsonObject.getJsonObject("sources");
                sourceList = sourceObj.entrySet().stream().filter(entry -> ((JsonValue)entry.getValue()).getValueType() == JsonValue.ValueType.OBJECT).map(entry -> {
                    try {
                        return new Source((String)entry.getKey(), ((JsonValue)entry.getValue()).asJsonObject());
                    }
                    catch (InvalidMapboxVectorTileException e) {
                        Logging.error(e);
                        if (!"TileJson not yet supported".equals(e.getMessage())) {
                            throw e;
                        }
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toList());
            } else {
                sourceList = Collections.emptyList();
            }
            if (jsonObject.containsKey("layers") && ((JsonValue)jsonObject.get("layers")).getValueType() == JsonValue.ValueType.ARRAY) {
                JsonArray lArray = jsonObject.getJsonArray("layers");
                layers = lArray.stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).map(obj -> new Layers(id, (JsonObject)obj)).collect(Collectors.toList());
            } else {
                layers = Collections.emptyList();
            }
            Map sourceLayer = layers.stream().collect(Collectors.groupingBy(layer -> sourceList.stream().filter(source -> source.getName().equals(layer.getSource())).findFirst(), LinkedHashMap::new, Collectors.toList()));
            this.sources = new LinkedHashMap<Source, ElemStyles>();
            for (Map.Entry entry2 : sourceLayer.entrySet()) {
                Source source = ((Optional)entry2.getKey()).orElse(null);
                String data = ((List)entry2.getValue()).stream().map(Layers::toString).collect(Collectors.joining());
                String metaData = "meta{title:" + (source == null ? "Generated Style" : source.getName()) + ";version:\"autogenerated\";description:\"auto generated style\";}";
                String canvas = "canvas{default-points:false;default-lines:false;}";
                MapCSSStyleSource style = new MapCSSStyleSource(metaData + "canvas{default-points:false;default-lines:false;}" + data);
                MainApplication.worker.execute(() -> this.save((source == null ? Integer.valueOf(data.hashCode()) : source.getName()) + ".mapcss", style));
                this.sources.put(source, new ElemStyles(Collections.singleton(style)));
            }
            if (this.spriteUrl != null && !this.spriteUrl.trim().isEmpty()) {
                MainApplication.worker.execute(this::fetchSprites);
            }
        } else {
            throw new IllegalArgumentException(I18n.tr("Vector Tile Style Version not understood: version {0} (json: {1})", this.version, jsonObject));
        }
    }

    private void fetchSprites() {
        CachedFile spritePng;
        try (CachedFile spriteJson = new CachedFile(this.spriteUrl + "@2x.json");){
            spritePng = new CachedFile(this.spriteUrl + "@2x.png");
            try {
                if (this.parseSprites(spriteJson, spritePng)) {
                    return;
                }
            }
            finally {
                spritePng.close();
            }
        }
        spriteJson = new CachedFile(this.spriteUrl + ".json");
        try {
            spritePng = new CachedFile(this.spriteUrl + ".png");
            try {
                this.parseSprites(spriteJson, spritePng);
            }
            finally {
                spritePng.close();
            }
        }
        finally {
            spriteJson.close();
        }
    }

    private boolean parseSprites(CachedFile spriteJson, CachedFile spritePng) {
        BufferedImage spritePngImage;
        JsonObject spriteObject;
        try (BufferedReader spriteJsonBufferedReader = spriteJson.getContentReader();
             JsonReader spriteJsonReader = Json.createReader(spriteJsonBufferedReader);
             InputStream spritePngBufferedReader = spritePng.getInputStream();){
            spriteObject = spriteJsonReader.read().asJsonObject();
            spritePngImage = ImageIO.read(spritePngBufferedReader);
        }
        catch (IOException e) {
            Logging.error(e);
            return false;
        }
        for (Map.Entry entry : spriteObject.entrySet()) {
            JsonObject info = ((JsonValue)entry.getValue()).asJsonObject();
            int width = info.getInt("width");
            int height = info.getInt("height");
            int x = info.getInt("x");
            int y = info.getInt("y");
            this.save((String)entry.getKey() + ".png", spritePngImage.getSubimage(x, y, width, height));
        }
        return true;
    }

    private void save(String name, Object object) {
        block20: {
            File cache = object instanceof Image ? new File(Config.getDirs().getUserDataDirectory(true), "images") : JosmBaseDirectories.getInstance().getCacheDirectory(true);
            File location = new File(cache, this.name != null ? this.name : Integer.toString(this.hashCode()));
            if (!location.exists() && !location.mkdirs() || location.exists() && !location.isDirectory()) {
                return;
            }
            File toSave = new File(location, name);
            try (OutputStream fileOutputStream = Files.newOutputStream(toSave.toPath(), new OpenOption[0]);){
                if (object instanceof String) {
                    fileOutputStream.write(((String)object).getBytes(StandardCharsets.UTF_8));
                    break block20;
                }
                if (object instanceof MapCSSStyleSource) {
                    MapCSSStyleSource source = (MapCSSStyleSource)object;
                    try (InputStream inputStream = source.getSourceInputStream();){
                        int byteVal = inputStream.read();
                        do {
                            fileOutputStream.write(byteVal);
                        } while ((byteVal = inputStream.read()) > -1);
                        source.url = "file:/" + toSave.getAbsolutePath().replace('\\', '/');
                        if (source.isLoaded()) {
                            source.loadStyleSource();
                        }
                        break block20;
                    }
                }
                if (object instanceof BufferedImage) {
                    ImageIO.write((RenderedImage)((BufferedImage)object), "png", toSave);
                }
            }
            catch (IOException e) {
                Logging.info(e);
            }
        }
    }

    public Map<Source, ElemStyles> getSources() {
        return this.sources;
    }

    public String getSpriteUrl() {
        return this.spriteUrl;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            MapboxVectorStyle o = (MapboxVectorStyle)other;
            return this.version == o.version && Objects.equals(this.name, o.name) && Objects.equals(this.glyphUrl, o.glyphUrl) && Objects.equals(this.spriteUrl, o.spriteUrl) && Objects.equals(this.sources, o.sources);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.glyphUrl, this.spriteUrl, this.sources);
    }
}

