/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.KeyValueVisitor;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.ConditionFactory;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.tools.Utils;

public class MapCSSRuleIndex {
    private final List<MapCSSRule> rules = new ArrayList<MapCSSRule>();
    private final Map<String, MapCSSKeyRules> index = new HashMap<String, MapCSSKeyRules>();
    private final BitSet remaining = new BitSet();

    public void add(MapCSSRule rule) {
        this.rules.add(rule);
    }

    public void initIndex() {
        Collections.sort(this.rules);
        for (int ruleIndex = 0; ruleIndex < this.rules.size(); ++ruleIndex) {
            MapCSSRule r = this.rules.get(ruleIndex);
            Iterator<Selector> iterator = r.selectors.iterator();
            while (iterator.hasNext()) {
                Selector selector;
                Selector selRightmost = selector = iterator.next();
                while (selRightmost instanceof Selector.ChildOrParentSelector) {
                    selRightmost = ((Selector.ChildOrParentSelector)selRightmost).right;
                }
                List<Condition> conditions = selRightmost.getConditions();
                if (conditions == null || conditions.isEmpty()) {
                    this.remaining.set(ruleIndex);
                    continue;
                }
                Optional lastCondition = Utils.filteredCollection(conditions, ConditionFactory.SimpleKeyValueCondition.class).stream().reduce((first, last) -> last);
                if (lastCondition.isPresent()) {
                    this.getEntryInIndex(((ConditionFactory.SimpleKeyValueCondition)lastCondition.get()).k).addForKeyAndValue(((ConditionFactory.SimpleKeyValueCondition)lastCondition.get()).v, ruleIndex);
                    continue;
                }
                String key = MapCSSRuleIndex.findAnyRequiredKey(conditions);
                if (key != null) {
                    this.getEntryInIndex(key).addForKey(ruleIndex);
                    continue;
                }
                this.remaining.set(ruleIndex);
            }
        }
    }

    private static String findAnyRequiredKey(List<Condition> conds) {
        String key = null;
        for (Condition c : conds) {
            ConditionFactory.KeyValueCondition keyValueCondition;
            if (c instanceof ConditionFactory.KeyCondition) {
                ConditionFactory.KeyCondition keyCondition = (ConditionFactory.KeyCondition)c;
                if (keyCondition.negateResult) continue;
                key = keyCondition.label;
                continue;
            }
            if (!(c instanceof ConditionFactory.KeyValueCondition) || !(keyValueCondition = (ConditionFactory.KeyValueCondition)c).requiresExactKeyMatch()) continue;
            key = keyValueCondition.k;
        }
        return key;
    }

    private MapCSSKeyRules getEntryInIndex(String key) {
        MapCSSKeyRules rulesWithMatchingKey = this.index.get(key);
        if (rulesWithMatchingKey == null) {
            rulesWithMatchingKey = new MapCSSKeyRules();
            this.index.put(key.intern(), rulesWithMatchingKey);
        }
        return rulesWithMatchingKey;
    }

    public Iterator<MapCSSRule> getRuleCandidates(IPrimitive osm) {
        BitSet ruleCandidates = new BitSet(this.rules.size());
        ruleCandidates.or(this.remaining);
        RuleCandidatesIterator candidatesIterator = new RuleCandidatesIterator(ruleCandidates);
        osm.visitKeys(candidatesIterator);
        candidatesIterator.prepare();
        return candidatesIterator;
    }

    public void clear() {
        this.rules.clear();
        this.index.clear();
        this.remaining.clear();
    }

    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    private static final class MapCSSKeyRules {
        BitSet generalRules = new BitSet();
        Map<String, BitSet> specialRules = new HashMap<String, BitSet>();

        private MapCSSKeyRules() {
        }

        public void addForKey(int ruleIndex) {
            this.generalRules.set(ruleIndex);
            for (BitSet r : this.specialRules.values()) {
                r.set(ruleIndex);
            }
        }

        public void addForKeyAndValue(String value, int ruleIndex) {
            BitSet forValue = this.specialRules.get(value);
            if (forValue == null) {
                forValue = new BitSet();
                forValue.or(this.generalRules);
                this.specialRules.put(value.intern(), forValue);
            }
            forValue.set(ruleIndex);
        }

        public BitSet get(String value) {
            return this.specialRules.getOrDefault(value, this.generalRules);
        }
    }

    private final class RuleCandidatesIterator
    implements Iterator<MapCSSRule>,
    KeyValueVisitor {
        private final BitSet ruleCandidates;
        private int next;

        private RuleCandidatesIterator(BitSet ruleCandidates) {
            this.ruleCandidates = ruleCandidates;
        }

        @Override
        public boolean hasNext() {
            return this.next >= 0 && this.next < MapCSSRuleIndex.this.rules.size();
        }

        @Override
        public MapCSSRule next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            MapCSSRule rule = (MapCSSRule)MapCSSRuleIndex.this.rules.get(this.next);
            this.next = this.ruleCandidates.nextSetBit(this.next + 1);
            return rule;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitKeyValue(Tagged p, String key, String value) {
            MapCSSKeyRules v = (MapCSSKeyRules)MapCSSRuleIndex.this.index.get(key);
            if (v != null) {
                BitSet rs = v.get(value);
                this.ruleCandidates.or(rs);
            }
        }

        public void prepare() {
            this.next = this.ruleCandidates.nextSetBit(0);
        }
    }
}

