/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.io.importexport.ImageImporter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.geoimage.CorrelateGpxWithImages;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

final class ImagesLoader
extends PleaseWaitRunnable {
    private boolean canceled;
    private GeoImageLayer layer;
    private final Collection<File> selection;
    private final Set<String> loadedDirectories = new HashSet<String>();
    private final Set<String> errorMessages;
    private final GpxLayer gpxLayer;

    ImagesLoader(Collection<File> selection, GpxLayer gpxLayer) {
        super(I18n.tr("Extracting GPS locations from EXIF", new Object[0]));
        this.selection = selection;
        this.gpxLayer = gpxLayer;
        this.errorMessages = new LinkedHashSet<String>();
    }

    private void rememberError(String message) {
        this.errorMessages.add(message);
    }

    @Override
    protected void realRun() throws IOException {
        this.progressMonitor.subTask(I18n.tr("Starting directory scan", new Object[0]));
        ArrayList<File> files = new ArrayList<File>();
        try {
            this.addRecursiveFiles(files, this.selection);
        }
        catch (IllegalStateException e) {
            Logging.debug(e);
            this.rememberError(e.getMessage());
        }
        if (this.canceled) {
            return;
        }
        this.progressMonitor.subTask(I18n.tr("Read photos...", new Object[0]));
        this.progressMonitor.setTicksCount(files.size());
        ArrayList<ImageEntry> entries = new ArrayList<ImageEntry>(files.size());
        for (File f : files) {
            if (this.canceled) break;
            this.progressMonitor.subTask(I18n.tr("Reading {0}...", f.getName()));
            this.progressMonitor.worked(1);
            ImageEntry e = new ImageEntry(f);
            e.extractExif();
            entries.add(e);
        }
        this.layer = new GeoImageLayer(entries, this.gpxLayer);
        files.clear();
    }

    private void addRecursiveFiles(Collection<File> files, Collection<File> sel) {
        boolean nullFile = false;
        for (File f : sel) {
            if (this.canceled) break;
            if (f == null) {
                nullFile = true;
                continue;
            }
            if (f.isDirectory()) {
                String canonical = null;
                try {
                    canonical = f.getCanonicalPath();
                }
                catch (IOException e) {
                    Logging.error(e);
                    this.rememberError(I18n.tr("Unable to get canonical path for directory {0}\n", f.getAbsolutePath()));
                }
                if (canonical == null || this.loadedDirectories.contains(canonical)) continue;
                this.loadedDirectories.add(canonical);
                File[] children = f.listFiles(ImageImporter.FILE_FILTER_WITH_FOLDERS);
                if (children != null) {
                    this.progressMonitor.subTask(I18n.tr("Scanning directory {0}", f.getPath()));
                    this.addRecursiveFiles(files, Arrays.asList(children));
                    continue;
                }
                this.rememberError(I18n.tr("Error while getting files from directory {0}\n", f.getPath()));
                continue;
            }
            files.add(f);
        }
        if (nullFile) {
            throw new IllegalStateException(I18n.tr("One of the selected files was null", new Object[0]));
        }
    }

    private String formatErrorMessages() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        if (this.errorMessages.size() == 1) {
            sb.append(Utils.escapeReservedCharactersHTML(this.errorMessages.iterator().next()));
        } else {
            sb.append(Utils.joinAsHtmlUnorderedList(this.errorMessages));
        }
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    protected void finish() {
        if (!this.errorMessages.isEmpty()) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), this.formatErrorMessages(), I18n.tr("Error", new Object[0]), 0);
        }
        if (this.layer != null) {
            MainApplication.getLayerManager().addLayer(this.layer);
            if (!this.canceled && !this.layer.getImageData().getImages().isEmpty()) {
                boolean noGeotagFound = true;
                for (ImageEntry e : this.layer.getImageData().getImages()) {
                    if (e.getPos() == null) continue;
                    noGeotagFound = false;
                }
                if (noGeotagFound) {
                    new CorrelateGpxWithImages(this.layer).actionPerformed(null);
                }
            }
        }
    }

    @Override
    protected void cancel() {
        this.canceled = true;
    }
}

