/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery.vectortile.mapbox;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.CommandInteger;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.Geometry;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.GeometryTypes;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.Layer;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.protobuf.ProtobufPacked;
import org.openstreetmap.josm.data.protobuf.ProtobufParser;
import org.openstreetmap.josm.data.protobuf.ProtobufRecord;
import org.openstreetmap.josm.tools.Utils;

public class Feature {
    private static final byte ID_FIELD = 1;
    private static final byte TAG_FIELD = 2;
    private static final byte GEOMETRY_TYPE_FIELD = 3;
    private static final byte GEOMETRY_FIELD = 4;
    private final List<CommandInteger> geometry = new ArrayList<CommandInteger>();
    private final GeometryTypes geometryType;
    private final long id;
    private TagMap tags;
    private Geometry geometryObject;

    /*
     * Unable to fully structure code
     */
    public Feature(Layer layer, ProtobufRecord record) throws IOException {
        super();
        tId = 0L;
        geometryTypeTemp = GeometryTypes.UNKNOWN;
        key = null;
        parser = new ProtobufParser(record.getBytes());
lbl7:
        // 4 sources

        try {
            while (parser.hasNext()) {
                next = new ProtobufRecord(parser);
                try {
                    block19: {
                        block18: {
                            if (next.getField() != 2) break block18;
                            if (this.tags == null) {
                                this.tags = new TagMap();
                            }
                            packed = new ProtobufPacked(next.getBytes());
                            for (Number number : packed.getArray()) {
                                key = this.parseTagValue(key, layer, number);
                            }
                            ** GOTO lbl7
                        }
                        if (next.getField() != 4) break block19;
                        packed = new ProtobufPacked(next.getBytes());
                        currentCommand = null;
                        for (Number number : packed.getArray()) {
                            if (currentCommand != null && currentCommand.hasAllExpectedParameters()) {
                                currentCommand = null;
                            }
                            if (currentCommand == null) {
                                currentCommand = new CommandInteger(number.intValue());
                                this.geometry.add(currentCommand);
                                continue;
                            }
                            currentCommand.addParameter(ProtobufParser.decodeZigZag(number));
                        }
                        ** GOTO lbl7
                    }
                    if (next.getField() == 3) {
                        geometryTypeTemp = GeometryTypes.values()[next.asUnsignedVarInt().intValue()];
                        continue;
                    }
                    if (next.getField() != 1) continue;
                    tId = next.asUnsignedVarInt().longValue();
                    ** GOTO lbl7
                }
                finally {
                    next.close();
                }
            }
        }
        finally {
            parser.close();
        }
        this.id = tId;
        this.geometryType = geometryTypeTemp;
        record.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseTagValue(String key, Layer layer, Number number) {
        if (key == null) {
            key = layer.getKey(number.intValue());
        } else {
            Object value = layer.getValue(number.intValue());
            if (value instanceof Double || value instanceof Float) {
                NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ROOT);
                boolean grouping = numberFormat.isGroupingUsed();
                try {
                    numberFormat.setGroupingUsed(false);
                    this.tags.put(key, numberFormat.format(value));
                }
                finally {
                    numberFormat.setGroupingUsed(grouping);
                }
            } else {
                this.tags.put(key, Utils.intern(value.toString()));
            }
            key = null;
        }
        return key;
    }

    public List<CommandInteger> getGeometry() {
        return this.geometry;
    }

    public GeometryTypes getGeometryType() {
        return this.geometryType;
    }

    public long getId() {
        return this.id;
    }

    public TagMap getTags() {
        return this.tags;
    }

    public Geometry getGeometryObject() {
        if (this.geometryObject == null) {
            this.geometryObject = new Geometry(this.getGeometryType(), this.getGeometry());
        }
        return this.geometryObject;
    }

    public String toString() {
        return "Feature [geometry=" + this.geometry + ", geometryType=" + (Object)((Object)this.geometryType) + ", id=" + this.id + ", " + (this.tags != null ? "tags=" + this.tags + ", " : "") + (this.geometryObject != null ? "geometryObject=" + this.geometryObject : "") + ']';
    }
}

