/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.OlympusRawDevelopmentMakernoteDirectory;

public class OlympusRawDevelopmentMakernoteDescriptor
extends TagDescriptor<OlympusRawDevelopmentMakernoteDirectory> {
    public OlympusRawDevelopmentMakernoteDescriptor(@NotNull OlympusRawDevelopmentMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 0: {
                return this.getRawDevVersionDescription();
            }
            case 264: {
                return this.getRawDevColorSpaceDescription();
            }
            case 265: {
                return this.getRawDevEngineDescription();
            }
            case 266: {
                return this.getRawDevNoiseReductionDescription();
            }
            case 267: {
                return this.getRawDevEditStatusDescription();
            }
            case 268: {
                return this.getRawDevSettingsDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getRawDevVersionDescription() {
        return this.getVersionBytesDescription(0, 4);
    }

    @Nullable
    public String getRawDevColorSpaceDescription() {
        return this.getIndexedDescription(264, "sRGB", "Adobe RGB", "Pro Photo RGB");
    }

    @Nullable
    public String getRawDevEngineDescription() {
        return this.getIndexedDescription(265, "High Speed", "High Function", "Advanced High Speed", "Advanced High Function");
    }

    @Nullable
    public String getRawDevNoiseReductionDescription() {
        Integer value = ((OlympusRawDevelopmentMakernoteDirectory)this._directory).getInteger(266);
        if (value == null) {
            return null;
        }
        if (value == 0) {
            return "(none)";
        }
        StringBuilder sb = new StringBuilder();
        int v = value;
        if ((v & 1) != 0) {
            sb.append("Noise Reduction, ");
        }
        if ((v >> 1 & 1) != 0) {
            sb.append("Noise Filter, ");
        }
        if ((v >> 2 & 1) != 0) {
            sb.append("Noise Filter (ISO Boost), ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    @Nullable
    public String getRawDevEditStatusDescription() {
        Integer value = ((OlympusRawDevelopmentMakernoteDirectory)this._directory).getInteger(267);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Original";
            }
            case 1: {
                return "Edited (Landscape)";
            }
            case 6: 
            case 8: {
                return "Edited (Portrait)";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getRawDevSettingsDescription() {
        Integer value = ((OlympusRawDevelopmentMakernoteDirectory)this._directory).getInteger(268);
        if (value == null) {
            return null;
        }
        if (value == 0) {
            return "(none)";
        }
        StringBuilder sb = new StringBuilder();
        int v = value;
        if ((v & 1) != 0) {
            sb.append("WB Color Temp, ");
        }
        if ((v >> 1 & 1) != 0) {
            sb.append("WB Gray Point, ");
        }
        if ((v >> 2 & 1) != 0) {
            sb.append("Saturation, ");
        }
        if ((v >> 3 & 1) != 0) {
            sb.append("Contrast, ");
        }
        if ((v >> 4 & 1) != 0) {
            sb.append("Sharpness, ");
        }
        if ((v >> 5 & 1) != 0) {
            sb.append("Color Space, ");
        }
        if ((v >> 6 & 1) != 0) {
            sb.append("High Function, ");
        }
        if ((v >> 7 & 1) != 0) {
            sb.append("Noise Reduction, ");
        }
        return sb.substring(0, sb.length() - 2);
    }
}

