/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Locale;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MoveAction
extends JosmAction {
    private final Direction myDirection;

    public MoveAction(Direction dir) {
        super(I18n.tr("Move {0}", dir.getLocalizedName()), dir.getIcon(), I18n.tr("Moves Objects {0}", dir.getLocalizedName()), dir.getShortcut(), true, dir.getToolbarName(), true);
        this.myDirection = dir;
        this.setHelpId(HelpUtil.ht("/Action/Move"));
    }

    private EastNorth getOffset(MapView mapView) {
        EastNorth en1 = mapView.getEastNorth(100, 100);
        EastNorth en2 = mapView.getEastNorth(101, 101);
        double distx = en2.east() - en1.east();
        double disty = en2.north() - en1.north();
        switch (this.myDirection) {
            case UP: {
                distx = 0.0;
                disty = -disty;
                break;
            }
            case DOWN: {
                distx = 0.0;
                break;
            }
            case LEFT: {
                disty = 0.0;
                distx = -distx;
                break;
            }
            default: {
                disty = 0.0;
            }
        }
        return new EastNorth(distx, disty);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (!MainApplication.isDisplayingMapView() || ds == null) {
            return;
        }
        MapView mapView = MainApplication.getMap().mapView;
        EastNorth dist = this.getOffset(mapView);
        Collection selection = ds.getSelected();
        Collection<Node> affectedNodes = AllNodesVisitor.getAllNodes(selection);
        MoveCommand cmd = ds.update(c -> {
            MoveCommand moveCmd;
            if (c instanceof MoveCommand && ds.equals(c.getAffectedDataSet()) && affectedNodes.equals(((MoveCommand)c).getParticipatingPrimitives())) {
                moveCmd = (MoveCommand)c;
                moveCmd.moveAgain(dist.east(), dist.north());
            } else {
                moveCmd = new MoveCommand(ds, (Collection<OsmPrimitive>)selection, dist.east(), dist.north());
                UndoRedoHandler.getInstance().add(moveCmd);
            }
            return moveCmd;
        }, UndoRedoHandler.getInstance().getLastCommand());
        for (Node n : affectedNodes) {
            if (!n.isLatLonKnown() || !n.isOutSideWorld()) continue;
            cmd.moveAgain(-dist.east(), -dist.north());
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Cannot move objects outside of the world.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        mapView.repaint();
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledStateOnModifiableSelection(selection);
    }

    public static enum Direction {
        UP(I18n.tr("up", new Object[0]), "up", 38),
        LEFT(I18n.tr("left", new Object[0]), "previous", 37),
        RIGHT(I18n.tr("right", new Object[0]), "next", 39),
        DOWN(I18n.tr("down", new Object[0]), "down", 40);

        private final String localizedName;
        private final String icon;
        private final int shortcutKey;

        private Direction(String localizedName, String icon, int shortcutKey) {
            this.localizedName = localizedName;
            this.icon = icon;
            this.shortcutKey = shortcutKey;
        }

        String getId() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        String getLocalizedName() {
            return this.localizedName;
        }

        String getIcon() {
            return "dialogs/" + this.icon;
        }

        String getToolbarName() {
            return "action/move/" + this.getId();
        }

        int getShortcutKey() {
            return this.shortcutKey;
        }

        Shortcut getShortcut() {
            return Shortcut.registerShortcut("core:move" + this.getId(), I18n.tr("Move objects {0}", this.getLocalizedName()), this.getShortcutKey(), 5005);
        }
    }
}

