/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class TimeValidator
extends AbstractTextComponentValidator {
    public TimeValidator(JTextComponent tc) {
        super(tc);
    }

    public static TimeValidator decorate(JTextComponent tc) {
        return new TimeValidator(tc);
    }

    @Override
    public boolean isValid() {
        if (this.getComponent().getText().trim().isEmpty()) {
            return true;
        }
        return this.getTime() != null;
    }

    public String getStandardTooltipTextAsHtml() {
        return "<html>" + this.getStandardTooltipText() + "</html>";
    }

    public String getStandardTooltipText() {
        ZonedDateTime now = ZonedDateTime.now(ZoneId.systemDefault());
        return I18n.tr("Please enter a valid time in the usual format for your locale.<br>Example: {0}<br>Example: {1}<br>Example: {2}<br>Example: {3}<br>", DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).format(now), DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).format(now), DateTimeFormatter.ofLocalizedTime(FormatStyle.LONG).format(now), DateTimeFormatter.ofLocalizedTime(FormatStyle.FULL).format(now));
    }

    @Override
    public void validate() {
        if (!this.isValid()) {
            String msg = "<html>The current value isn't a valid time.<br>" + this.getStandardTooltipText() + "</html>";
            this.feedbackInvalid(msg);
        } else {
            String msg = "<html>" + this.getStandardTooltipText() + "</html>";
            this.feedbackValid(msg);
        }
    }

    public LocalTime getTime() {
        if (this.getComponent().getText().trim().isEmpty()) {
            return LocalTime.MIDNIGHT;
        }
        for (FormatStyle format : FormatStyle.values()) {
            DateTimeFormatter df = DateTimeFormatter.ofLocalizedTime(format);
            try {
                return LocalTime.parse(this.getComponent().getText(), df);
            }
            catch (DateTimeParseException e) {
                Logging.trace(e);
            }
        }
        return LocalTime.MIDNIGHT;
    }
}

