/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.io.File;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Data;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.gpx.GpxExtension;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.IGpxLayerPrefs;
import org.openstreetmap.josm.data.gpx.IGpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.Line;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.gpx.WithAttributes;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.ListeningCollection;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.Interval;

public class GpxData
extends WithAttributes
implements Data,
IGpxLayerPrefs {
    public File storageFile;
    public boolean fromServer;
    public boolean fromSession;
    public String creator;
    private final ArrayList<IGpxTrack> privateTracks = new ArrayList();
    private final ArrayList<GpxRoute> privateRoutes = new ArrayList();
    private final ArrayList<WayPoint> privateWaypoints = new ArrayList();
    private final List<XMLNamespace> namespaces = new ArrayList<XMLNamespace>();
    private final Map<String, String> layerPrefs = new HashMap<String, String>();
    private final IGpxTrack.GpxTrackChangeListener proxy = e -> this.invalidate();
    private boolean modified;
    private boolean updating;
    private boolean initializing;
    private boolean suppressedInvalidate;
    public final Collection<IGpxTrack> tracks = new ListeningCollection<IGpxTrack>(this.privateTracks, this::invalidate){

        @Override
        protected void removed(IGpxTrack cursor) {
            cursor.removeListener(GpxData.this.proxy);
            super.removed(cursor);
        }

        @Override
        protected void added(IGpxTrack cursor) {
            super.added(cursor);
            cursor.addListener(GpxData.this.proxy);
        }
    };
    public final Collection<GpxRoute> routes = new ListeningCollection<GpxRoute>(this.privateRoutes, this::invalidate);
    public final Collection<WayPoint> waypoints = new ListeningCollection<WayPoint>(this.privateWaypoints, this::invalidate);
    public final Set<DataSource> dataSources = new HashSet<DataSource>();
    private final ListenerList<GpxDataChangeListener> listeners = ListenerList.create();
    private List<GpxTrackSegmentSpan> segSpans;

    public GpxData() {
    }

    public GpxData(boolean initializing) {
        this.initializing = initializing;
    }

    public synchronized void mergeFrom(GpxData other) {
        this.mergeFrom(other, false, false);
    }

    public synchronized void mergeFrom(GpxData other, boolean cutOverlapping, boolean connect) {
        if (this.storageFile == null && other.storageFile != null) {
            this.storageFile = other.storageFile;
        }
        this.fromServer = this.fromServer && other.fromServer;
        for (Map.Entry ent : other.attr.entrySet()) {
            String k = (String)ent.getKey();
            if ("meta.links".equals(k) && this.attr.containsKey("meta.links")) {
                Collection my = super.getCollection("meta.links");
                Collection their = (Collection)ent.getValue();
                my.addAll(their);
                continue;
            }
            this.put(k, ent.getValue());
        }
        if (cutOverlapping) {
            for (IGpxTrack trk : other.privateTracks) {
                this.cutOverlapping(trk, connect);
            }
        } else {
            other.privateTracks.forEach(this::addTrack);
        }
        other.privateRoutes.forEach(this::addRoute);
        other.privateWaypoints.forEach(this::addWaypoint);
        this.dataSources.addAll(other.dataSources);
        this.invalidate();
    }

    private void cutOverlapping(IGpxTrack trk, boolean connect) {
        ArrayList<IGpxTrackSegment> segsOld = new ArrayList<IGpxTrackSegment>(trk.getSegments());
        ArrayList<IGpxTrackSegment> segsNew = new ArrayList<IGpxTrackSegment>();
        for (IGpxTrackSegment seg : segsOld) {
            GpxTrackSegmentSpan s = GpxTrackSegmentSpan.tryGetFromSegment(seg);
            if (s != null && this.anySegmentOverlapsWith(s)) {
                ArrayList<WayPoint> wpsNew = new ArrayList<WayPoint>();
                ArrayList<WayPoint> wpsOld = new ArrayList<WayPoint>(seg.getWayPoints());
                if (s.isInverted()) {
                    Collections.reverse(wpsOld);
                }
                boolean split = false;
                WayPoint prevLastOwnWp = null;
                Instant prevWpTime = null;
                for (WayPoint wp : wpsOld) {
                    Instant wpTime = wp.getInstant();
                    boolean overlap = false;
                    if (wpTime != null) {
                        for (GpxTrackSegmentSpan ownspan : this.getSegmentSpans()) {
                            if (wpTime.isAfter(ownspan.firstTime) && wpTime.isBefore(ownspan.lastTime)) {
                                overlap = true;
                                if (connect) {
                                    if (!split) {
                                        wpsNew.add(ownspan.getFirstWp());
                                    } else {
                                        this.connectTracks(prevLastOwnWp, ownspan, trk.getAttributes());
                                    }
                                    prevLastOwnWp = ownspan.getLastWp();
                                }
                                split = true;
                                break;
                            }
                            if (!connect || prevWpTime == null || !prevWpTime.isBefore(ownspan.firstTime) || !wpTime.isAfter(ownspan.lastTime)) continue;
                            if (split) {
                                this.connectTracks(prevLastOwnWp, ownspan, trk.getAttributes());
                                prevLastOwnWp = ownspan.getLastWp();
                                continue;
                            }
                            wpsNew.add(ownspan.getFirstWp());
                            if (!wpsNew.isEmpty()) {
                                segsNew.add(new GpxTrackSegment(wpsNew));
                            }
                            if (!segsNew.isEmpty()) {
                                this.privateTracks.add(new GpxTrack((List<IGpxTrackSegment>)segsNew, trk.getAttributes()));
                            }
                            segsNew = new ArrayList();
                            wpsNew = new ArrayList();
                            wpsNew.add(ownspan.getLastWp());
                        }
                        prevWpTime = wpTime;
                    }
                    if (overlap) continue;
                    if (split) {
                        if (!wpsNew.isEmpty()) {
                            segsNew.add(new GpxTrackSegment(wpsNew));
                        }
                        if (!segsNew.isEmpty()) {
                            this.privateTracks.add(new GpxTrack((List<IGpxTrackSegment>)segsNew, trk.getAttributes()));
                        }
                        segsNew = new ArrayList();
                        wpsNew = new ArrayList();
                        if (connect && prevLastOwnWp != null) {
                            wpsNew.add(new WayPoint(prevLastOwnWp));
                        }
                        prevLastOwnWp = null;
                        split = false;
                    }
                    wpsNew.add(new WayPoint(wp));
                }
                if (wpsNew.isEmpty()) continue;
                segsNew.add(new GpxTrackSegment(wpsNew));
                continue;
            }
            segsNew.add(seg);
        }
        if (segsNew.equals(segsOld)) {
            this.privateTracks.add(trk);
        } else if (!segsNew.isEmpty()) {
            this.privateTracks.add(new GpxTrack((List<IGpxTrackSegment>)segsNew, trk.getAttributes()));
        }
    }

    private void connectTracks(WayPoint prevWp, GpxTrackSegmentSpan span, Map<String, Object> attr) {
        if (prevWp != null && !span.lastEquals(prevWp)) {
            this.privateTracks.add(new GpxTrack((Collection<Collection<WayPoint>>)Arrays.asList(Arrays.asList(new WayPoint(prevWp), span.getFirstWp())), attr));
        }
    }

    public synchronized List<GpxTrackSegmentSpan> getSegmentSpans() {
        if (this.segSpans == null) {
            this.segSpans = new ArrayList<GpxTrackSegmentSpan>();
            for (IGpxTrack trk : this.privateTracks) {
                for (IGpxTrackSegment seg : trk.getSegments()) {
                    GpxTrackSegmentSpan s = GpxTrackSegmentSpan.tryGetFromSegment(seg);
                    if (s == null) continue;
                    this.segSpans.add(s);
                }
            }
            this.segSpans.sort(Comparator.comparing(o -> o.firstTime));
        }
        return this.segSpans;
    }

    private boolean anySegmentOverlapsWith(GpxTrackSegmentSpan other) {
        return this.getSegmentSpans().stream().anyMatch(s -> s.overlapsWith(other));
    }

    public synchronized Collection<IGpxTrack> getTracks() {
        return Collections.unmodifiableCollection(this.privateTracks);
    }

    public synchronized List<IGpxTrack> getOrderedTracks() {
        return this.privateTracks.stream().sorted((t1, t2) -> {
            boolean i2absent;
            boolean t1empty = Utils.isEmpty(t1.getSegments());
            boolean t2empty = Utils.isEmpty(t2.getSegments());
            if (t1empty && t2empty) {
                return 0;
            }
            if (t1empty && !t2empty) {
                return -1;
            }
            if (!t1empty && t2empty) {
                return 1;
            }
            OptionalLong i1 = GpxData.getTrackFirstWaypointMin(t1);
            OptionalLong i2 = GpxData.getTrackFirstWaypointMin(t2);
            boolean i1absent = !i1.isPresent();
            boolean bl = i2absent = !i2.isPresent();
            if (i1absent && i2absent) {
                return 0;
            }
            if (i1absent && !i2absent) {
                return 1;
            }
            if (!i1absent && i2absent) {
                return -1;
            }
            return Long.compare(i1.getAsLong(), i2.getAsLong());
        }).collect(Collectors.toList());
    }

    private static OptionalLong getTrackFirstWaypointMin(IGpxTrack track) {
        return track.getSegments().stream().map(IGpxTrackSegment::getWayPoints).filter(Objects::nonNull).flatMap(Collection::stream).mapToLong(WayPoint::getTimeInMillis).min();
    }

    public synchronized Stream<IGpxTrackSegment> getTrackSegmentsStream() {
        return this.getTracks().stream().flatMap(trk -> trk.getSegments().stream());
    }

    private synchronized void clearTracks() {
        this.privateTracks.forEach(t -> t.removeListener(this.proxy));
        this.privateTracks.clear();
    }

    public synchronized void addTrack(IGpxTrack track) {
        if (this.privateTracks.stream().anyMatch(t -> t == track)) {
            throw new IllegalArgumentException(MessageFormat.format("The track was already added to this data: {0}", track));
        }
        this.privateTracks.add(track);
        track.addListener(this.proxy);
        this.invalidate();
    }

    public synchronized void removeTrack(IGpxTrack track) {
        if (!this.privateTracks.removeIf(t -> t == track)) {
            throw new IllegalArgumentException(MessageFormat.format("The track was not in this data: {0}", track));
        }
        track.removeListener(this.proxy);
        this.invalidate();
    }

    public synchronized void combineTracksToSegmentedTrack() {
        List segs = this.getTrackSegmentsStream().collect(Collectors.toCollection(ArrayList::new));
        HashMap<String, Object> attrs = new HashMap<String, Object>(this.privateTracks.get(0).getAttributes());
        Object name = attrs.get("name");
        if (name != null) {
            attrs.put("name", name.toString().replaceFirst(" #\\d+$", ""));
        }
        this.clearTracks();
        this.addTrack(new GpxTrack(segs, (Map<String, Object>)attrs));
    }

    public static String ensureUniqueName(Map<String, Object> attrs, Map<String, Integer> counts, String srcLayerName) {
        String name = attrs.getOrDefault("name", srcLayerName).toString().replaceFirst(" #\\d+$", "");
        Integer count = counts.getOrDefault(name, 0) + 1;
        counts.put(name, count);
        attrs.put("name", MessageFormat.format("{0}{1}", name, " #" + count));
        return attrs.get("name").toString();
    }

    public synchronized void splitTrackSegmentsToTracks(String srcLayerName) {
        HashMap counts = new HashMap();
        List trks = this.getTracks().stream().flatMap(trk -> trk.getSegments().stream().map(seg -> {
            HashMap<String, Object> attrs = new HashMap<String, Object>(trk.getAttributes());
            GpxData.ensureUniqueName(attrs, counts, srcLayerName);
            return new GpxTrack(Arrays.asList(seg), (Map<String, Object>)attrs);
        })).collect(Collectors.toCollection(ArrayList::new));
        this.clearTracks();
        trks.stream().forEachOrdered(this::addTrack);
    }

    public synchronized void splitTracksToLayers(String srcLayerName) {
        HashMap counts = new HashMap();
        this.getTracks().stream().filter(trk -> this.privateTracks.size() > 1).map(trk -> {
            HashMap<String, Object> attrs = new HashMap<String, Object>(trk.getAttributes());
            GpxData d = new GpxData();
            d.addTrack((IGpxTrack)trk);
            return new GpxLayer(d, GpxData.ensureUniqueName(attrs, counts, srcLayerName));
        }).forEachOrdered(layer -> MainApplication.getLayerManager().addLayer((Layer)layer));
    }

    public synchronized int getTrackCount() {
        return this.privateTracks.size();
    }

    public synchronized int getTrackSegsCount() {
        return this.privateTracks.stream().mapToInt(t -> t.getSegments().size()).sum();
    }

    public synchronized Collection<GpxRoute> getRoutes() {
        return Collections.unmodifiableCollection(this.privateRoutes);
    }

    public synchronized void addRoute(GpxRoute route) {
        if (this.privateRoutes.stream().anyMatch(r -> r == route)) {
            throw new IllegalArgumentException(MessageFormat.format("The route was already added to this data: {0}", route));
        }
        this.privateRoutes.add(route);
        this.invalidate();
    }

    public synchronized void removeRoute(GpxRoute route) {
        if (!this.privateRoutes.removeIf(r -> r == route)) {
            throw new IllegalArgumentException(MessageFormat.format("The route was not in this data: {0}", route));
        }
        this.invalidate();
    }

    public synchronized Collection<WayPoint> getWaypoints() {
        return Collections.unmodifiableCollection(this.privateWaypoints);
    }

    public synchronized void addWaypoint(WayPoint waypoint) {
        if (this.privateWaypoints.stream().anyMatch(w -> w == waypoint)) {
            throw new IllegalArgumentException(MessageFormat.format("The waypoint was already added to this data: {0}", waypoint));
        }
        this.privateWaypoints.add(waypoint);
        this.invalidate();
    }

    public synchronized void removeWaypoint(WayPoint waypoint) {
        if (!this.privateWaypoints.removeIf(w -> w == waypoint)) {
            throw new IllegalArgumentException(MessageFormat.format("The waypoint was not in this data: {0}", waypoint));
        }
        this.invalidate();
    }

    public synchronized boolean hasTrackPoints() {
        return this.getTrackPoints().findAny().isPresent();
    }

    public synchronized Stream<WayPoint> getTrackPoints() {
        return this.getTracks().stream().flatMap(trk -> trk.getSegments().stream()).flatMap(trkseg -> trkseg.getWayPoints().stream());
    }

    public synchronized boolean hasRoutePoints() {
        return this.privateRoutes.stream().anyMatch(rte -> !rte.routePoints.isEmpty());
    }

    public synchronized boolean isEmpty() {
        return !this.hasRoutePoints() && !this.hasTrackPoints() && this.waypoints.isEmpty();
    }

    public Bounds getMetaBounds() {
        Object value = this.get("meta.bounds");
        if (value instanceof Bounds) {
            return (Bounds)value;
        }
        return null;
    }

    public synchronized Bounds recalculateBounds() {
        Bounds bounds = null;
        for (WayPoint wpt : this.privateWaypoints) {
            if (bounds == null) {
                bounds = new Bounds(wpt.getCoor());
                continue;
            }
            bounds.extend(wpt.getCoor());
        }
        for (GpxRoute rte : this.privateRoutes) {
            for (WayPoint wpt : rte.routePoints) {
                if (bounds == null) {
                    bounds = new Bounds(wpt.getCoor());
                    continue;
                }
                bounds.extend(wpt.getCoor());
            }
        }
        for (IGpxTrack trk : this.privateTracks) {
            Bounds trkBounds = trk.getBounds();
            if (trkBounds == null) continue;
            if (bounds == null) {
                bounds = new Bounds(trkBounds);
                continue;
            }
            bounds.extend(trkBounds);
        }
        return bounds;
    }

    public synchronized double length() {
        return this.privateTracks.stream().mapToDouble(IGpxTrack::length).sum();
    }

    public static Optional<Interval> getMinMaxTimeForTrack(IGpxTrack trk) {
        LongSummaryStatistics statistics = trk.getSegments().stream().flatMap(seg -> seg.getWayPoints().stream()).mapToLong(WayPoint::getTimeInMillis).summaryStatistics();
        return statistics.getCount() == 0L || statistics.getMin() == 0L && statistics.getMax() == 0L ? Optional.empty() : Optional.of(new Interval(Instant.ofEpochMilli(statistics.getMin()), Instant.ofEpochMilli(statistics.getMax())));
    }

    public synchronized Optional<Interval> getMinMaxTimeForAllTracks() {
        long now = System.currentTimeMillis();
        LongSummaryStatistics statistics = this.tracks.stream().flatMap(trk -> trk.getSegments().stream()).flatMap(seg -> seg.getWayPoints().stream()).mapToLong(WayPoint::getTimeInMillis).filter(t -> t > 0L && t <= now).summaryStatistics();
        return statistics.getCount() == 0L ? Optional.empty() : Optional.of(new Interval(Instant.ofEpochMilli(statistics.getMin()), Instant.ofEpochMilli(statistics.getMax())));
    }

    public synchronized WayPoint nearestPointOnTrack(EastNorth p, double tolerance) {
        double pnminsq = tolerance * tolerance;
        EastNorth bestEN = null;
        double bestTime = Double.NaN;
        double px = p.east();
        double py = p.north();
        double rx = 0.0;
        double ry = 0.0;
        for (IGpxTrack track : this.privateTracks) {
            for (IGpxTrackSegment seg : track.getSegments()) {
                EastNorth c;
                double prsq;
                double y;
                double x;
                WayPoint r = null;
                for (WayPoint wpSeg : seg.getWayPoints()) {
                    EastNorth en = wpSeg.getEastNorth(ProjectionRegistry.getProjection());
                    if (r == null) {
                        r = wpSeg;
                        rx = en.east();
                        x = px - rx;
                        double pRsq = x * x + (y = py - (ry = en.north())) * y;
                        if (!(pRsq < pnminsq)) continue;
                        pnminsq = pRsq;
                        bestEN = en;
                        if (!r.hasDate()) continue;
                        bestTime = r.getTime();
                        continue;
                    }
                    double sx = en.east();
                    double sy = en.north();
                    double a = sy - ry;
                    double b = rx - sx;
                    double c2 = -a * rx - b * ry;
                    double rssq = a * a + b * b;
                    if (rssq == 0.0) continue;
                    double pnsq = a * px + b * py + c2;
                    if ((pnsq = pnsq * pnsq / rssq) < pnminsq) {
                        x = px - rx;
                        y = py - ry;
                        double prsq2 = x * x + y * y;
                        x = px - sx;
                        y = py - sy;
                        double pssq = x * x + y * y;
                        if (prsq2 - pnsq <= rssq && pssq - pnsq <= rssq) {
                            double rnoverRS = Math.sqrt((prsq2 - pnsq) / rssq);
                            double nx = rx - rnoverRS * b;
                            double ny = ry + rnoverRS * a;
                            bestEN = new EastNorth(nx, ny);
                            if (r.hasDate() && wpSeg.hasDate()) {
                                bestTime = r.getTime() + rnoverRS * (wpSeg.getTime() - r.getTime());
                            }
                            pnminsq = pnsq;
                        }
                    }
                    r = wpSeg;
                    rx = sx;
                    ry = sy;
                }
                if (r == null || !((prsq = (x = px - (rx = (c = r.getEastNorth(ProjectionRegistry.getProjection())).east())) * x + (y = py - (ry = c.north())) * y) < pnminsq)) continue;
                pnminsq = prsq;
                bestEN = c;
                if (!r.hasDate()) continue;
                bestTime = r.getTime();
            }
        }
        if (bestEN == null) {
            return null;
        }
        WayPoint best = new WayPoint(ProjectionRegistry.getProjection().eastNorth2latlon(bestEN));
        if (!Double.isNaN(bestTime)) {
            best.setTimeInMillis((long)(bestTime * 1000.0));
        }
        return best;
    }

    public Iterable<Line> getLinesIterable(boolean ... trackVisibility) {
        return () -> new LinesIterator(this, trackVisibility);
    }

    public synchronized void resetEastNorthCache() {
        this.privateWaypoints.forEach(WayPoint::invalidateEastNorthCache);
        this.getTrackPoints().forEach(WayPoint::invalidateEastNorthCache);
        for (GpxRoute route : this.getRoutes()) {
            if (route.routePoints == null) continue;
            for (WayPoint wp : route.routePoints) {
                wp.invalidateEastNorthCache();
            }
        }
    }

    @Override
    public Collection<DataSource> getDataSources() {
        return Collections.unmodifiableCollection(this.dataSources);
    }

    @Override
    public Map<String, String> getLayerPrefs() {
        return this.layerPrefs;
    }

    public List<XMLNamespace> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public synchronized int hashCode() {
        return Objects.hash(super.hashCode(), this.namespaces, this.layerPrefs, this.dataSources, this.privateRoutes, this.privateTracks, this.privateWaypoints);
    }

    @Override
    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GpxData other = (GpxData)obj;
        if (this.dataSources == null ? other.dataSources != null : !this.dataSources.equals(other.dataSources)) {
            return false;
        }
        if (this.layerPrefs == null ? other.layerPrefs != null : !this.layerPrefs.equals(other.layerPrefs)) {
            return false;
        }
        if (this.privateRoutes == null ? other.privateRoutes != null : !this.privateRoutes.equals(other.privateRoutes)) {
            return false;
        }
        if (this.privateTracks == null ? other.privateTracks != null : !this.privateTracks.equals(other.privateTracks)) {
            return false;
        }
        if (this.privateWaypoints == null ? other.privateWaypoints != null : !this.privateWaypoints.equals(other.privateWaypoints)) {
            return false;
        }
        return !(this.namespaces == null ? other.namespaces != null : !this.namespaces.equals(other.namespaces));
    }

    @Override
    public void put(String key, Object value) {
        this.put(key, value, true);
    }

    public void put(String key, Object value, boolean setModified) {
        super.put(key, value);
        this.fireInvalidate(setModified);
    }

    public void addChangeListener(GpxDataChangeListener listener) {
        this.listeners.addListener(listener);
    }

    public void addWeakChangeListener(GpxDataChangeListener listener) {
        this.listeners.addWeakListener(listener);
    }

    public void removeChangeListener(GpxDataChangeListener listener) {
        this.listeners.removeListener(listener);
    }

    public void invalidate() {
        this.fireInvalidate(true);
    }

    private void fireInvalidate(boolean setModified) {
        if (setModified) {
            this.setModified(true);
        }
        if (this.updating || this.initializing) {
            this.suppressedInvalidate = true;
        } else if (this.listeners.hasListeners()) {
            GpxDataChangeEvent e = new GpxDataChangeEvent(this);
            this.listeners.fireEvent(l -> l.gpxDataChanged(e));
        }
    }

    public void beginUpdate() {
        this.updating = true;
    }

    public void endUpdate() {
        this.initializing = false;
        this.updating = false;
        if (this.suppressedInvalidate) {
            this.fireInvalidate(false);
            this.suppressedInvalidate = false;
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean value) {
        if (!this.initializing && this.modified != value) {
            this.modified = value;
            if (this.listeners.hasListeners()) {
                this.listeners.fireEvent(l -> l.modifiedStateChanged(this.modified));
            }
        }
    }

    public void clear() {
        this.dataSources.clear();
        this.layerPrefs.clear();
        this.privateRoutes.clear();
        this.privateTracks.clear();
        this.privateWaypoints.clear();
        this.attr.clear();
    }

    static class GpxTrackSegmentSpan {
        final Instant firstTime;
        final Instant lastTime;
        private final boolean inv;
        private final WayPoint firstWp;
        private final WayPoint lastWp;

        GpxTrackSegmentSpan(WayPoint a, WayPoint b) {
            Instant at = a.getInstant();
            Instant bt = b.getInstant();
            boolean bl = this.inv = at != null && bt != null && bt.isBefore(at);
            if (this.inv) {
                this.firstWp = b;
                this.firstTime = bt;
                this.lastWp = a;
                this.lastTime = at;
            } else {
                this.firstWp = a;
                this.firstTime = at;
                this.lastWp = b;
                this.lastTime = bt;
            }
        }

        WayPoint getFirstWp() {
            return new WayPoint(this.firstWp);
        }

        WayPoint getLastWp() {
            return new WayPoint(this.lastWp);
        }

        boolean firstEquals(Object other) {
            return this.firstWp.equals(other);
        }

        boolean lastEquals(Object other) {
            return this.lastWp.equals(other);
        }

        public boolean isInverted() {
            return this.inv;
        }

        boolean overlapsWith(GpxTrackSegmentSpan other) {
            return this.firstTime.isBefore(other.lastTime) && other.firstTime.isBefore(this.lastTime) || other.firstTime.isBefore(this.lastTime) && this.firstTime.isBefore(other.lastTime);
        }

        static GpxTrackSegmentSpan tryGetFromSegment(IGpxTrackSegment seg) {
            WayPoint e;
            WayPoint b = GpxTrackSegmentSpan.getNextWpWithTime(seg, true);
            if (b != null && (e = GpxTrackSegmentSpan.getNextWpWithTime(seg, false)) != null) {
                return new GpxTrackSegmentSpan(b, e);
            }
            return null;
        }

        private static WayPoint getNextWpWithTime(IGpxTrackSegment seg, boolean forward) {
            int i;
            ArrayList<WayPoint> wps = new ArrayList<WayPoint>(seg.getWayPoints());
            int n = i = forward ? 0 : wps.size() - 1;
            while (i >= 0 && i < wps.size()) {
                if (((WayPoint)wps.get(i)).hasDate()) {
                    return (WayPoint)wps.get(i);
                }
                i += forward ? 1 : -1;
            }
            return null;
        }
    }

    public static class GpxDataChangeEvent {
        private final GpxData source;

        GpxDataChangeEvent(GpxData source) {
            this.source = source;
        }

        public GpxData getSource() {
            return this.source;
        }
    }

    @FunctionalInterface
    public static interface GpxDataChangeListener {
        public void gpxDataChanged(GpxDataChangeEvent var1);

        default public void modifiedStateChanged(boolean modified) {
        }
    }

    public static class LinesIterator
    implements Iterator<Line> {
        private Iterator<IGpxTrack> itTracks;
        private int idxTracks;
        private Iterator<IGpxTrackSegment> itTrackSegments;
        private Line next;
        private final boolean[] trackVisibility;
        private Map<String, Object> trackAttributes;
        private IGpxTrack curTrack;

        public LinesIterator(GpxData data, boolean ... trackVisibility) {
            this.itTracks = data.tracks.iterator();
            this.idxTracks = -1;
            this.trackVisibility = trackVisibility;
            this.next = this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Line next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Line current = this.next;
            this.next = this.getNext();
            return current;
        }

        private Line getNext() {
            if (this.itTracks != null) {
                if (this.itTrackSegments != null && this.itTrackSegments.hasNext()) {
                    return new Line(this.itTrackSegments.next(), this.trackAttributes, this.curTrack.getColor());
                }
                while (this.itTracks.hasNext()) {
                    this.curTrack = this.itTracks.next();
                    this.trackAttributes = this.curTrack.getAttributes();
                    ++this.idxTracks;
                    if (this.trackVisibility != null && !this.trackVisibility[this.idxTracks]) continue;
                    this.itTrackSegments = this.curTrack.getSegments().iterator();
                    if (!this.itTrackSegments.hasNext()) continue;
                    return new Line(this.itTrackSegments.next(), this.trackAttributes, this.curTrack.getColor());
                }
                this.trackAttributes = null;
                this.itTracks = null;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class XMLNamespace {
        private final String uri;
        private final String prefix;
        private String location;

        public XMLNamespace(String fallbackPrefix, String uri) {
            this.prefix = Optional.ofNullable(GpxExtension.findPrefix(uri)).orElse(fallbackPrefix);
            this.uri = uri;
        }

        public XMLNamespace(String prefix, String uri, String location) {
            this.prefix = prefix;
            this.uri = uri;
            this.location = location;
        }

        public String getURI() {
            return this.uri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public int hashCode() {
            return Objects.hash(this.prefix, this.uri, this.location);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            XMLNamespace other = (XMLNamespace)obj;
            if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
                return false;
            }
            if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
                return false;
            }
            return !(this.location == null ? other.location != null : !this.location.equals(other.location));
        }
    }
}

