/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.awt.Color;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.Functions;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public final class ExpressionFactory {
    static final Map<String, Factory> FACTORY_MAP = new HashMap<String, Factory>();

    private static void initFactories() {
        FACTORY_MAP.put("CRC32_checksum", Factory.of(String.class, Functions::CRC32_checksum));
        FACTORY_MAP.put("JOSM_pref", Factory.ofEnv(String.class, String.class, null, Functions::JOSM_pref));
        FACTORY_MAP.put("JOSM_search", Factory.ofEnv(String.class, Functions::JOSM_search));
        FACTORY_MAP.put("URL_decode", Factory.of(String.class, Functions::URL_decode));
        FACTORY_MAP.put("URL_encode", Factory.of(String.class, Functions::URL_encode));
        FACTORY_MAP.put("XML_encode", Factory.of(String.class, Functions::XML_encode));
        FACTORY_MAP.put("abs", Factory.of(Math::acos));
        FACTORY_MAP.put("acos", Factory.of(Math::acos));
        FACTORY_MAP.put("alpha", Factory.of(Color.class, Functions::alpha));
        FACTORY_MAP.put("any", Factory.ofObjectVarargs(Functions::any));
        FACTORY_MAP.put("areasize", Factory.ofEnv(Functions::areasize));
        FACTORY_MAP.put("asin", Factory.of(Math::asin));
        FACTORY_MAP.put("at", Factory.ofEnv(Double.TYPE, Double.TYPE, null, Functions::at));
        FACTORY_MAP.put("atan", Factory.of(Math::atan));
        FACTORY_MAP.put("atan2", Factory.of(Double.class, Double.class, Math::atan2));
        FACTORY_MAP.put("blue", Factory.of(Color.class, Functions::blue));
        FACTORY_MAP.put("cardinal_to_radians", Factory.of(String.class, Functions::cardinal_to_radians));
        FACTORY_MAP.put("ceil", Factory.of(Math::ceil));
        FACTORY_MAP.put("center", Factory.ofEnv(Functions::center));
        FACTORY_MAP.put("child_tag", Factory.ofEnv(String.class, Functions::child_tag));
        FACTORY_MAP.put("color2html", Factory.of(Color.class, Functions::color2html));
        FACTORY_MAP.put("concat", Factory.ofObjectVarargs(Functions::concat));
        FACTORY_MAP.put("cos", Factory.of(Math::cos));
        FACTORY_MAP.put("cosh", Factory.of(Math::cosh));
        FACTORY_MAP.put("count", Factory.of(List.class, Functions::count));
        FACTORY_MAP.put("count_roles", Factory.ofStringVarargs(Functions::count_roles));
        FACTORY_MAP.put("degree_to_radians", Factory.of(Functions::degree_to_radians));
        FACTORY_MAP.put("divided_by", Factory.ofNumberVarArgs(1.0, DoubleUnaryOperator.identity(), Functions::divided_by));
        FACTORY_MAP.put("equal", Factory.of(Object.class, Object.class, Functions::equal));
        FACTORY_MAP.put("eval", Factory.of(Object.class, Functions::eval));
        FACTORY_MAP.put("exp", Factory.of(Math::exp));
        FACTORY_MAP.put("floor", Factory.of(Math::floor));
        FACTORY_MAP.put("get", Factory.of(List.class, Float.TYPE, Functions::get));
        FACTORY_MAP.put("gpx_distance", Factory.ofEnv(Functions::gpx_distance));
        FACTORY_MAP.put("greater", Factory.of(Float.TYPE, Float.TYPE, Functions::greater));
        FACTORY_MAP.put("greater_equal", Factory.of(Float.TYPE, Float.TYPE, Functions::greater_equal));
        FACTORY_MAP.put("green", Factory.of(Color.class, Functions::green));
        FACTORY_MAP.put("has_tag_key", Factory.ofEnv(String.class, Functions::has_tag_key));
        FACTORY_MAP.put("hsb_color", Factory.of(Float.TYPE, Float.TYPE, Float.TYPE, null, Functions::hsb_color));
        FACTORY_MAP.put("html2color", Factory.of(String.class, Functions::html2color));
        FACTORY_MAP.put("index", Factory.ofEnv(Functions::index));
        FACTORY_MAP.put("inside", Factory.ofEnv(String.class, Functions::inside));
        FACTORY_MAP.put("is_anticlockwise", Factory.ofEnv(Functions::is_anticlockwise));
        FACTORY_MAP.put("is_clockwise", Factory.ofEnv(Functions::is_clockwise));
        FACTORY_MAP.put("is_prop_set", Factory.ofEnv(String.class, String.class, Functions::is_prop_set, Functions::is_prop_set));
        FACTORY_MAP.put("is_right_hand_traffic", Factory.ofEnv(Functions::is_right_hand_traffic));
        FACTORY_MAP.put("is_similar", Factory.of(String.class, String.class, Functions::is_similar));
        FACTORY_MAP.put("join", Factory.ofStringVarargs(Functions::join));
        FACTORY_MAP.put("join_list", Factory.of(String.class, List.class, Functions::join_list));
        FACTORY_MAP.put("less", Factory.of(Float.TYPE, Float.TYPE, Functions::less));
        FACTORY_MAP.put("less_equal", Factory.of(Float.TYPE, Float.TYPE, Functions::less_equal));
        FACTORY_MAP.put("list", Factory.ofObjectVarargs(Functions::list));
        FACTORY_MAP.put("log", Factory.of(Math::log));
        FACTORY_MAP.put("lower", Factory.of(String.class, Functions::lower));
        FACTORY_MAP.put("minus", Factory.ofNumberVarArgs(0.0, v -> -v, Functions::minus));
        FACTORY_MAP.put("mod", Factory.of(Float.TYPE, Float.TYPE, Functions::mod));
        FACTORY_MAP.put("not", Factory.of(Boolean.TYPE, Functions::not));
        FACTORY_MAP.put("not_equal", Factory.of(Object.class, Object.class, Functions::not_equal));
        FACTORY_MAP.put("number_of_tags", Factory.ofEnv(Functions::number_of_tags));
        FACTORY_MAP.put("osm_changeset_id", Factory.ofEnv(Functions::osm_changeset_id));
        FACTORY_MAP.put("osm_id", Factory.ofEnv(Functions::osm_id));
        FACTORY_MAP.put("osm_timestamp", Factory.ofEnv(Functions::osm_timestamp));
        FACTORY_MAP.put("osm_user_id", Factory.ofEnv(Functions::osm_user_id));
        FACTORY_MAP.put("osm_user_name", Factory.ofEnv(Functions::osm_user_name));
        FACTORY_MAP.put("osm_version", Factory.ofEnv(Functions::osm_version));
        FACTORY_MAP.put("outside", Factory.ofEnv(String.class, Functions::outside));
        FACTORY_MAP.put("parent_osm_id", Factory.ofEnv(Functions::parent_osm_id));
        FACTORY_MAP.put("parent_tag", Factory.ofEnv(String.class, Functions::parent_tag));
        FACTORY_MAP.put("parent_tags", Factory.ofEnv(String.class, Functions::parent_tags));
        FACTORY_MAP.put("parent_way_angle", Factory.ofEnv(Functions::parent_way_angle));
        FACTORY_MAP.put("plus", Factory.ofNumberVarArgs(0.0, DoubleUnaryOperator.identity(), Functions::plus));
        FACTORY_MAP.put("print", Factory.of(Object.class, Functions::print));
        FACTORY_MAP.put("println", Factory.of(Object.class, Functions::println));
        FACTORY_MAP.put("prop", Factory.ofEnv(String.class, String.class, Functions::prop, Functions::prop));
        FACTORY_MAP.put("red", Factory.of(Color.class, Functions::red));
        FACTORY_MAP.put("regexp_match", Factory.of(String.class, String.class, String.class, Functions::regexp_match, Functions::regexp_match));
        FACTORY_MAP.put("regexp_test", Factory.of(String.class, String.class, String.class, Functions::regexp_test, Functions::regexp_test));
        FACTORY_MAP.put("replace", Factory.of(String.class, String.class, String.class, null, Functions::replace));
        FACTORY_MAP.put("rgb", Factory.of(Float.TYPE, Float.TYPE, Float.TYPE, null, Functions::rgb));
        FACTORY_MAP.put("rgba", Factory.of(Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Functions::rgba));
        FACTORY_MAP.put("role", Factory.ofEnv(Functions::role));
        FACTORY_MAP.put("round", Factory.of(Math::round));
        FACTORY_MAP.put("setting", Factory.ofEnv(String.class, Functions::setting));
        FACTORY_MAP.put("signum", Factory.of(Math::signum));
        FACTORY_MAP.put("sin", Factory.of(Math::sin));
        FACTORY_MAP.put("sinh", Factory.of(Math::sinh));
        FACTORY_MAP.put("sort", Factory.ofStringVarargs(Functions::sort));
        FACTORY_MAP.put("sort_list", Factory.of(List.class, Functions::sort_list));
        FACTORY_MAP.put("split", Factory.of(String.class, String.class, Functions::split));
        FACTORY_MAP.put("sqrt", Factory.of(Math::sqrt));
        FACTORY_MAP.put("substring", Factory.of(String.class, Float.TYPE, Float.TYPE, Functions::substring, Functions::substring));
        FACTORY_MAP.put("tag", Factory.ofEnv(String.class, Functions::tag));
        FACTORY_MAP.put("tag_regex", Factory.ofEnv(String.class, String.class, Functions::tag_regex, Functions::tag_regex));
        FACTORY_MAP.put("tan", Factory.of(Math::tan));
        FACTORY_MAP.put("tanh", Factory.of(Math::tanh));
        FACTORY_MAP.put("times", Factory.ofNumberVarArgs(1.0, DoubleUnaryOperator.identity(), Functions::times));
        FACTORY_MAP.put("title", Factory.of(String.class, Functions::title));
        FACTORY_MAP.put("to_boolean", Factory.of(String.class, Functions::to_boolean));
        FACTORY_MAP.put("to_byte", Factory.of(String.class, Functions::to_byte));
        FACTORY_MAP.put("to_double", Factory.of(String.class, Functions::to_double));
        FACTORY_MAP.put("to_float", Factory.of(String.class, Functions::to_float));
        FACTORY_MAP.put("to_int", Factory.of(String.class, Functions::to_int));
        FACTORY_MAP.put("to_long", Factory.of(String.class, Functions::to_long));
        FACTORY_MAP.put("to_short", Factory.of(String.class, Functions::to_short));
        FACTORY_MAP.put("tr", Factory.ofStringVarargs(Functions::tr));
        FACTORY_MAP.put("trim", Factory.of(String.class, Functions::trim));
        FACTORY_MAP.put("trim_list", Factory.of(List.class, Functions::trim_list));
        FACTORY_MAP.put("uniq", Factory.ofStringVarargs(Functions::uniq));
        FACTORY_MAP.put("uniq_list", Factory.of(List.class, Functions::uniq_list));
        FACTORY_MAP.put("upper", Factory.of(String.class, Functions::upper));
        FACTORY_MAP.put("waylength", Factory.ofEnv(Functions::waylength));
    }

    private ExpressionFactory() {
    }

    public static Expression createFunctionExpression(String name, List<Expression> args) {
        if ("cond".equals(name) && args.size() == 3) {
            return new CondOperator(args.get(0), args.get(1), args.get(2));
        }
        if ("and".equals(name)) {
            return new AndOperator(args);
        }
        if ("or".equals(name)) {
            return new OrOperator(args);
        }
        if ("length".equals(name) && args.size() == 1) {
            return new LengthFunction(args.get(0));
        }
        if ("max".equals(name) && !args.isEmpty()) {
            return new MinMaxFunction(args, true);
        }
        if ("min".equals(name) && !args.isEmpty()) {
            return new MinMaxFunction(args, false);
        }
        if ("inside".equals(name) && args.size() == 1) {
            return new IsInsideFunction(args.get(0));
        }
        if ("random".equals(name)) {
            return env -> Math.random();
        }
        Factory factory = FACTORY_MAP.get(name);
        if (factory != null) {
            return factory.createExpression(args);
        }
        return NullExpression.INSTANCE;
    }

    static {
        ExpressionFactory.initFactories();
    }

    @FunctionalInterface
    static interface Factory {
        public Expression createExpression(List<Expression> var1);

        public static Factory of(DoubleUnaryOperator operator) {
            return Factory.of(Double.class, operator::applyAsDouble);
        }

        public static Factory ofNumberVarArgs(double identity, DoubleUnaryOperator unaryOperator, DoubleBinaryOperator operator) {
            return args -> env -> {
                if (args.isEmpty()) {
                    return identity;
                }
                if (args.size() == 1) {
                    Double arg2 = Cascade.convertTo(((Expression)args.get(0)).evaluate(env), Double.class);
                    return arg2 == null ? null : Double.valueOf(unaryOperator.applyAsDouble(arg2));
                }
                return args.stream().map(arg -> Cascade.convertTo(arg.evaluate(env), Double.class)).filter(Objects::nonNull).reduce(operator::applyAsDouble).orElse(null);
            };
        }

        public static Factory ofStringVarargs(BiFunction<Environment, String[], ?> function) {
            return args -> env -> function.apply(env, (String[])args.stream().map(arg -> Cascade.convertTo(arg.evaluate(env), String.class)).toArray(String[]::new));
        }

        public static Factory ofObjectVarargs(BiFunction<Environment, Object[], ?> function) {
            return args -> env -> function.apply(env, args.stream().map(arg -> arg.evaluate(env)).toArray(Object[]::new));
        }

        public static <T> Factory of(Class<T> type, Function<T, ?> function) {
            return args -> env -> {
                Object v = Cascade.convertTo(((Expression)args.get(0)).evaluate(env), type);
                return v == null ? null : function.apply(v);
            };
        }

        public static <T, U> Factory of(Class<T> type1, Class<U> type2, BiFunction<T, U, ?> function) {
            return args -> env -> {
                Object v1 = Cascade.convertTo(((Expression)args.get(0)).evaluate(env), type1);
                Object v2 = Cascade.convertTo(((Expression)args.get(1)).evaluate(env), type2);
                return v1 == null || v2 == null ? null : function.apply(v1, v2);
            };
        }

        public static <T, U, V> Factory of(Class<T> type1, Class<U> type2, Class<V> type3, BiFunction<T, U, ?> biFunction, TriFunction<T, U, V, ?> triFunction) {
            return args -> env -> {
                Object v3;
                Object v1 = args.size() >= 1 ? (Object)Cascade.convertTo(((Expression)args.get(0)).evaluate(env), type1) : null;
                Object v2 = args.size() >= 2 ? (Object)Cascade.convertTo(((Expression)args.get(1)).evaluate(env), type2) : null;
                Object v = v3 = args.size() >= 3 ? (Object)Cascade.convertTo(((Expression)args.get(2)).evaluate(env), type3) : null;
                return v1 == null || v2 == null ? null : (v3 == null ? biFunction.apply(v1, v2) : triFunction.apply(v1, v2, v3));
            };
        }

        public static <T, U, V, W> Factory of(Class<T> type1, Class<U> type2, Class<V> type3, Class<W> type4, QuadFunction<T, U, V, W, ?> function) {
            return args -> env -> {
                Object v1 = args.size() >= 1 ? (Object)Cascade.convertTo(((Expression)args.get(0)).evaluate(env), type1) : null;
                Object v2 = args.size() >= 2 ? (Object)Cascade.convertTo(((Expression)args.get(1)).evaluate(env), type2) : null;
                Object v3 = args.size() >= 3 ? (Object)Cascade.convertTo(((Expression)args.get(2)).evaluate(env), type3) : null;
                Object v4 = args.size() >= 4 ? (Object)Cascade.convertTo(((Expression)args.get(3)).evaluate(env), type4) : null;
                return v1 == null || v2 == null || v3 == null || v4 == null ? null : function.apply(v1, v2, v3, v4);
            };
        }

        public static <T> Factory ofEnv(Function<Environment, ?> function) {
            return args -> function::apply;
        }

        public static <T> Factory ofEnv(Class<T> type, BiFunction<Environment, T, ?> function) {
            return args -> env -> {
                Object v = Cascade.convertTo(((Expression)args.get(0)).evaluate(env), type);
                return v == null ? null : function.apply(env, v);
            };
        }

        public static <T, U> Factory ofEnv(Class<T> type1, Class<U> type2, BiFunction<Environment, T, ?> biFunction, TriFunction<Environment, T, U, ?> triFunction) {
            return args -> env -> {
                Object v2;
                Object v1 = args.size() >= 1 ? (Object)Cascade.convertTo(((Expression)args.get(0)).evaluate(env), type1) : null;
                Object v = v2 = args.size() >= 2 ? (Object)Cascade.convertTo(((Expression)args.get(1)).evaluate(env), type2) : null;
                return v1 == null ? null : (v2 == null ? biFunction.apply(env, v1) : triFunction.apply(env, v1, v2));
            };
        }
    }

    @FunctionalInterface
    public static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }

    @FunctionalInterface
    public static interface QuadFunction<T, U, V, W, R> {
        public R apply(T var1, U var2, V var3, W var4);
    }

    public static class CondOperator
    implements Expression {
        private final Expression condition;
        private final Expression firstOption;
        private final Expression secondOption;

        public CondOperator(Expression condition, Expression firstOption, Expression secondOption) {
            this.condition = condition;
            this.firstOption = firstOption;
            this.secondOption = secondOption;
        }

        @Override
        public Object evaluate(Environment env) {
            Boolean b = Cascade.convertTo(this.condition.evaluate(env), Boolean.TYPE);
            if (b != null && b.booleanValue()) {
                return this.firstOption.evaluate(env);
            }
            return this.secondOption.evaluate(env);
        }
    }

    public static class AndOperator
    implements Expression {
        private final List<Expression> args;

        public AndOperator(List<Expression> args) {
            this.args = args;
        }

        @Override
        public Object evaluate(Environment env) {
            return this.args.stream().map(arg -> Cascade.convertTo(arg.evaluate(env), Boolean.TYPE)).allMatch(Boolean.TRUE::equals);
        }
    }

    public static class OrOperator
    implements Expression {
        private final List<Expression> args;

        public OrOperator(List<Expression> args) {
            this.args = args;
        }

        @Override
        public Object evaluate(Environment env) {
            return this.args.stream().map(arg -> Cascade.convertTo(arg.evaluate(env), Boolean.TYPE)).anyMatch(Boolean.TRUE::equals);
        }
    }

    public static class LengthFunction
    implements Expression {
        private final Expression arg;

        public LengthFunction(Expression args) {
            this.arg = args;
        }

        @Override
        public Object evaluate(Environment env) {
            List l = Cascade.convertTo(this.arg.evaluate(env), List.class);
            if (l != null) {
                return l.size();
            }
            String s = Cascade.convertTo(this.arg.evaluate(env), String.class);
            if (s != null) {
                return s.length();
            }
            return null;
        }
    }

    public static class MinMaxFunction
    implements Expression {
        private final List<Expression> args;
        private final boolean computeMax;

        public MinMaxFunction(List<Expression> args, boolean computeMax) {
            this.args = args;
            this.computeMax = computeMax;
        }

        public Float aggregateList(List<?> lst) {
            List<Float> floats = Utils.transform(lst, x -> Cascade.convertTo(x, Float.TYPE));
            SubclassFilteredCollection<Float, Float> nonNullList = SubclassFilteredCollection.filter(floats, Objects::nonNull);
            return nonNullList.isEmpty() ? Float.valueOf(Float.NaN) : (this.computeMax ? (Float)Collections.max(nonNullList) : (Float)Collections.min(nonNullList));
        }

        @Override
        public Object evaluate(Environment env) {
            List<Object> l = Cascade.convertTo(this.args.get(0).evaluate(env), List.class);
            if (this.args.size() != 1 || l == null) {
                l = Utils.transform(this.args, x -> x.evaluate(env));
            }
            return this.aggregateList(l);
        }
    }

    public static class IsInsideFunction
    implements Expression {
        private final Expression arg;

        public IsInsideFunction(Expression arg) {
            this.arg = arg;
        }

        public Expression getArg() {
            return this.arg;
        }

        @Override
        public Object evaluate(Environment env) {
            String codes = Cascade.convertTo(this.arg.evaluate(env), String.class);
            return Functions.inside(env, codes);
        }
    }

    public static class NullExpression
    implements Expression {
        public static final NullExpression INSTANCE = new NullExpression();

        @Override
        public Object evaluate(Environment env) {
            return null;
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface NullableArguments {
    }
}

