/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public class QuadBucketPrimitiveStore<N extends INode, W extends IWay<N>, R extends IRelation<?>> {
    private final QuadBuckets<N> nodes = new QuadBuckets();
    private final QuadBuckets<W> ways = new QuadBuckets();
    private final Collection<R> relations = new ArrayList<R>();

    public List<N> searchNodes(BBox bbox) {
        return this.nodes.search(bbox);
    }

    public boolean containsNode(N n) {
        return this.nodes.contains(n);
    }

    public List<W> searchWays(BBox bbox) {
        return this.ways.search(bbox);
    }

    public boolean containsWay(W w) {
        return this.ways.contains(w);
    }

    public List<R> searchRelations(BBox bbox) {
        return this.relations.stream().filter(r -> r.getBBox().intersects(bbox)).collect(Collectors.toList());
    }

    public boolean containsRelation(R r) {
        return this.relations.contains(r);
    }

    public void addPrimitive(IPrimitive primitive) {
        boolean success = false;
        if (primitive instanceof INode) {
            success = this.nodes.add((N)((INode)primitive));
        } else if (primitive instanceof IWay) {
            success = this.ways.add((W)((IWay)primitive));
        } else if (primitive instanceof IRelation) {
            success = this.relations.add((IRelation)primitive);
        }
        if (!success) {
            throw new JosmRuntimeException("failed to add primitive: " + primitive);
        }
    }

    protected void removePrimitive(IPrimitive primitive) {
        boolean success = false;
        if (primitive instanceof INode) {
            success = this.nodes.remove(primitive);
        } else if (primitive instanceof IWay) {
            success = this.ways.remove(primitive);
        } else if (primitive instanceof IRelation) {
            success = this.relations.remove(primitive);
        }
        if (!success) {
            throw new JosmRuntimeException("failed to remove primitive: " + primitive);
        }
    }

    protected void reindexNode(N node, Consumer<N> nUpdater, Consumer<W> wUpdater, Consumer<R> rUpdater) {
        if (!this.nodes.remove(node)) {
            throw new JosmRuntimeException("Reindexing node failed to remove");
        }
        nUpdater.accept(node);
        if (!this.nodes.add(node)) {
            throw new JosmRuntimeException("Reindexing node failed to add");
        }
        for (IPrimitive iPrimitive : node.getReferrers()) {
            if (iPrimitive instanceof IWay) {
                this.reindexWay((IWay)iPrimitive, wUpdater, rUpdater);
                continue;
            }
            this.reindexRelation((IRelation)iPrimitive, rUpdater);
        }
    }

    protected void reindexWay(W way, Consumer<W> wUpdater, Consumer<R> rUpdater) {
        BBox before = way.getBBox();
        if (!this.ways.remove(way)) {
            throw new JosmRuntimeException("Reindexing way failed to remove");
        }
        wUpdater.accept(way);
        if (!this.ways.add(way)) {
            throw new JosmRuntimeException("Reindexing way failed to add");
        }
        if (!way.getBBox().equals(before)) {
            for (IPrimitive iPrimitive : way.getReferrers()) {
                this.reindexRelation((IRelation)iPrimitive, rUpdater);
            }
        }
    }

    protected void reindexRelation(R relation, Consumer<R> rUpdater) {
        BBox before = relation.getBBox();
        rUpdater.accept(relation);
        if (!before.equals(relation.getBBox())) {
            for (IPrimitive iPrimitive : relation.getReferrers()) {
                this.reindexRelation((IRelation)iPrimitive, rUpdater);
            }
        }
    }

    public void clear() {
        this.nodes.clear();
        this.ways.clear();
        this.relations.clear();
    }
}

