/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.util.Objects;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.presets.items.ComboMultiSelect;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class PresetListEntry
implements Comparable<PresetListEntry> {
    protected static final PresetListEntry ENTRY_DIFFERENT = new PresetListEntry("<different>", null);
    protected static final PresetListEntry ENTRY_EMPTY = new PresetListEntry("", null);
    public String value;
    public ComboMultiSelect cms;
    public String display_value;
    public String short_description;
    public String icon;
    public short icon_size;
    public String locale_display_value;
    public String locale_short_description;
    private String cachedDisplayValue;
    private String cachedShortDescription;
    private ImageIcon cachedIcon;

    public PresetListEntry() {
    }

    public PresetListEntry(String value, ComboMultiSelect cms) {
        this.value = value;
        this.cms = cms;
    }

    public String getListDisplay(int width) {
        String displayValue = this.getDisplayValue();
        Integer count = this.getCount();
        if (count > 0 && this.cms.usage.getSelectedCount() > 1) {
            displayValue = I18n.tr("{0} ({1})", displayValue, count);
        }
        if (this.equals(ENTRY_DIFFERENT)) {
            return "<html><b>" + Utils.escapeReservedCharactersHTML(displayValue) + "</b></html>";
        }
        String shortDescription = this.getShortDescription();
        if (shortDescription.isEmpty()) {
            if (displayValue.isEmpty()) {
                return " ";
            }
            return displayValue;
        }
        return String.format("<html><div style=\"width: %d\"><b>%s</b><p style=\"padding-left: 10\">%s</p></div></html>", width, displayValue, Utils.escapeReservedCharactersHTML(shortDescription));
    }

    public ImageIcon getIcon() {
        if (this.icon != null && this.cachedIcon == null) {
            this.cachedIcon = TaggingPresetItem.loadImageIcon(this.icon, TaggingPresetReader.getZipIcons(), Integer.valueOf(this.icon_size));
        }
        return this.cachedIcon;
    }

    public String getDisplayValue() {
        if (this.cachedDisplayValue == null) {
            if (this.cms != null && this.cms.values_no_i18n) {
                this.cachedDisplayValue = Utils.firstNonNull(this.value, " ");
            } else {
                String context = this.cms == null ? null : this.cms.values_context;
                this.cachedDisplayValue = Utils.firstNonNull(this.locale_display_value, I18n.trc(context, this.display_value), I18n.trc(context, this.value), " ");
            }
        }
        return this.cachedDisplayValue;
    }

    public String getShortDescription() {
        if (this.cachedShortDescription == null) {
            this.cachedShortDescription = Utils.firstNonNull(this.locale_short_description, I18n.tr(this.short_description, new Object[0]), "");
        }
        return this.cachedShortDescription;
    }

    public String getToolTipText(String key) {
        if (this.equals(ENTRY_DIFFERENT)) {
            return I18n.tr("Keeps the original values of the selected objects unchanged.", new Object[0]);
        }
        if (this.value != null && !this.value.isEmpty()) {
            return I18n.tr("Sets the key ''{0}'' to the value ''{1}''.", key, this.value);
        }
        return I18n.tr("Clears the key ''{0}''.", key);
    }

    public String toString() {
        if (this.equals(ENTRY_DIFFERENT)) {
            return this.getDisplayValue();
        }
        return this.getDisplayValue().replaceAll("\\s*<.*>\\s*", " ");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PresetListEntry that = (PresetListEntry)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public int getCount() {
        Integer count = this.cms == null || this.cms.usage == null ? null : (Integer)this.cms.usage.map.get(this.value);
        return count == null ? 0 : count;
    }

    @Override
    public int compareTo(PresetListEntry o) {
        return AlphanumComparator.getInstance().compare(this.value, o.value);
    }
}

