/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.CloseChangesetDialog;
import org.openstreetmap.josm.gui.io.CloseChangesetTask;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.ChangesetUpdater;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmServerUserInfoReader;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class CloseChangesetAction
extends JosmAction {
    public CloseChangesetAction() {
        super(I18n.tr("Close open changesets...", new Object[0]), "closechangeset", I18n.tr("Close open changesets", new Object[0]), Shortcut.registerShortcut("system:closechangeset", I18n.tr("File: {0}", I18n.tr("Close open changesets", new Object[0])), 81, 5008), true, false);
        this.setHelpId(HelpUtil.ht("/Action/CloseChangeset"));
        this.setEnabled(!NetworkManager.isOffline(OnlineResource.OSM_API));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MainApplication.worker.submit(new DownloadOpenChangesetsTask());
    }

    protected void onPostDownloadOpenChangesets() {
        ChangesetUpdater.check();
        List<Changeset> openChangesets = ChangesetCache.getInstance().getOpenChangesetsForCurrentUser();
        if (openChangesets.isEmpty()) {
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("There are no open changesets", new Object[0]), I18n.tr("No open changesets", new Object[0]), 1);
            return;
        }
        CloseChangesetDialog dialog = new CloseChangesetDialog();
        dialog.setChangesets(openChangesets);
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        Collection<Changeset> changesetsToClose = dialog.getSelectedChangesets();
        CloseChangesetTask closeChangesetTask = new CloseChangesetTask(changesetsToClose);
        MainApplication.worker.submit(closeChangesetTask);
    }

    private final class DownloadOpenChangesetsTask
    extends PleaseWaitRunnable {
        private boolean canceled;
        private OsmServerChangesetReader reader;
        private List<Changeset> changesets;
        private Exception lastException;

        private DownloadOpenChangesetsTask() {
            super(I18n.tr("Downloading open changesets ...", new Object[0]), false);
        }

        @Override
        protected void cancel() {
            this.canceled = true;
            if (this.reader != null) {
                this.reader.cancel();
            }
        }

        @Override
        protected void finish() {
            SwingUtilities.invokeLater(() -> {
                if (this.lastException != null) {
                    ExceptionDialogUtil.explainException(this.lastException);
                }
                ChangesetCache.getInstance().update(this.changesets);
                if (!this.canceled && this.lastException == null) {
                    CloseChangesetAction.this.onPostDownloadOpenChangesets();
                }
            });
        }

        private UserInfo fetchUserInfo() throws OsmTransferException {
            return new OsmServerUserInfoReader().fetchUserInfo(this.getProgressMonitor().createSubTaskMonitor(1, false));
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                UserInfo userInfo = this.fetchUserInfo();
                if (this.canceled) {
                    return;
                }
                this.reader = new OsmServerChangesetReader();
                ChangesetQuery query = new ChangesetQuery().forUser(userInfo.getId()).beingOpen(true);
                this.changesets = this.reader.queryChangesets(query, this.getProgressMonitor().createSubTaskMonitor(1, false));
            }
            catch (OsmTransferCanceledException e) {
                Logging.trace(e);
                this.cancel();
            }
            catch (IllegalArgumentException | OsmTransferException e) {
                if (this.canceled) {
                    return;
                }
                this.lastException = e;
            }
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public Exception getLastException() {
            return this.lastException;
        }
    }
}

