/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.ValidatorLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class ValidationTask
extends PleaseWaitRunnable {
    private final Consumer<List<TestError>> onFinish;
    private Collection<Test> tests;
    private final Collection<OsmPrimitive> validatedPrimitives;
    private final Collection<OsmPrimitive> formerValidatedPrimitives;
    private final boolean beforeUpload;
    private boolean canceled;
    private List<TestError> errors;
    private BiConsumer<ValidationTask, Test> testConsumer;

    public ValidationTask(Collection<Test> tests, Collection<OsmPrimitive> validatedPrimitives, Collection<OsmPrimitive> formerValidatedPrimitives) {
        this(new PleaseWaitProgressMonitor(I18n.tr("Validating", new Object[0])), tests, validatedPrimitives, formerValidatedPrimitives);
    }

    public ValidationTask(Consumer<List<TestError>> onFinish, ProgressMonitor progressMonitor, Collection<Test> tests, Collection<OsmPrimitive> validatedPrimitives, Collection<OsmPrimitive> formerValidatedPrimitives, boolean beforeUpload) {
        super(I18n.tr("Validating", new Object[0]), progressMonitor != null ? progressMonitor : new PleaseWaitProgressMonitor(I18n.tr("Validating", new Object[0])), false);
        this.onFinish = onFinish;
        this.validatedPrimitives = validatedPrimitives;
        this.formerValidatedPrimitives = formerValidatedPrimitives;
        this.tests = tests;
        this.beforeUpload = beforeUpload;
    }

    protected ValidationTask(ProgressMonitor progressMonitor, Collection<Test> tests, Collection<OsmPrimitive> validatedPrimitives, Collection<OsmPrimitive> formerValidatedPrimitives) {
        this(null, progressMonitor, tests, validatedPrimitives, formerValidatedPrimitives, false);
    }

    @Override
    protected void cancel() {
        this.canceled = true;
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (!GraphicsEnvironment.isHeadless() && MainApplication.getMap() != null) {
            GuiHelper.runInEDT(() -> {
                MapFrame map = MainApplication.getMap();
                map.validatorDialog.unfurlDialog();
                map.validatorDialog.tree.setErrors(this.errors);
                MainApplication.getLayerManager().getLayersOfType(ValidatorLayer.class).forEach(AbstractMapViewPaintable::invalidate);
                if (!this.errors.isEmpty()) {
                    OsmValidator.initializeErrorLayer();
                }
            });
        }
        if (this.onFinish != null) {
            this.onFinish.accept(this.errors);
        }
    }

    @Override
    protected void realRun() {
        if (Utils.isEmpty(this.tests)) {
            return;
        }
        this.errors = new ArrayList<TestError>();
        this.getProgressMonitor().setTicksCount(this.tests.size() * this.validatedPrimitives.size());
        int testCounter = 0;
        for (Test test : this.tests) {
            if (this.canceled) {
                return;
            }
            this.getProgressMonitor().setCustomText(I18n.tr("Test {0}/{1}: Starting {2}", ++testCounter, this.tests.size(), test.getName()));
            test.setBeforeUpload(this.beforeUpload);
            test.setPartialSelection(this.formerValidatedPrimitives != null);
            test.startTest(this.getProgressMonitor().createSubTaskMonitor(this.validatedPrimitives.size(), false));
            test.visit(this.validatedPrimitives);
            test.endTest();
            this.errors.addAll(test.getErrors());
            if (this.testConsumer != null) {
                this.testConsumer.accept(this, test);
            }
            test.clear();
            test.setBeforeUpload(false);
        }
        this.tests = null;
        if (Boolean.TRUE.equals(ValidatorPrefHelper.PREF_USE_IGNORE.get())) {
            this.getProgressMonitor().setCustomText("");
            this.getProgressMonitor().subTask(I18n.tr("Updating ignored errors ...", new Object[0]));
            for (TestError error : this.errors) {
                if (this.canceled) {
                    return;
                }
                error.updateIgnored();
            }
        }
        if (this.errors.stream().anyMatch(e -> e.getPrimitives().stream().anyMatch(OsmPrimitive::isDisabledAndHidden))) {
            String msg = "<b>" + I18n.tr("Validation results contain elements hidden by a filter.", new Object[0]) + "</b><br/>" + I18n.tr("Please review active filters to see the hidden results.", new Object[0]);
            GuiHelper.runInEDT(() -> new Notification(msg).setDuration(Notification.TIME_LONG).setIcon(2).setHelpTopic("Dialog/Validator").show());
        }
    }

    public List<TestError> getErrors() {
        return this.errors;
    }

    public void setTestConsumer(BiConsumer<ValidationTask, Test> testConsumer) {
        this.testConsumer = testConsumer;
    }
}

