/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.MainApplication;

public class HighlightHelper {
    private final Set<OsmPrimitive> highlightedPrimitives = new HashSet<OsmPrimitive>();

    public boolean highlight(Collection<? extends OsmPrimitive> prims) {
        return this.highlight(prims, false);
    }

    public boolean highlight(Collection<? extends OsmPrimitive> prims, boolean only) {
        boolean needsRepaint = false;
        if (only) {
            Iterator<OsmPrimitive> it = this.highlightedPrimitives.iterator();
            while (it.hasNext()) {
                OsmPrimitive osmPrimitive = it.next();
                if (prims.contains(osmPrimitive)) continue;
                osmPrimitive.setHighlighted(false);
                it.remove();
                needsRepaint = true;
            }
        }
        for (OsmPrimitive osmPrimitive : prims) {
            needsRepaint |= this.setHighlight(osmPrimitive, true);
        }
        return needsRepaint;
    }

    public boolean highlightOnly(Collection<? extends OsmPrimitive> prims) {
        return this.highlight(prims, true);
    }

    public boolean highlightOnly(OsmPrimitive p) {
        return this.highlight(Collections.singleton(p), true);
    }

    public boolean setHighlight(OsmPrimitive p, boolean flag) {
        return this.setHighlight(p, flag, new HashSet<Relation>());
    }

    private boolean setHighlight(OsmPrimitive p, boolean flag, Set<Relation> seenRelations) {
        if (p instanceof Relation) {
            Relation r = (Relation)p;
            seenRelations.add(r);
            boolean needRepaint = false;
            for (OsmPrimitive m : r.getMemberPrimitivesList()) {
                if (m instanceof Relation && seenRelations.contains(m)) continue;
                needRepaint |= this.setHighlight(m, flag, seenRelations);
            }
            return needRepaint;
        }
        if (flag) {
            if (this.highlightedPrimitives.add(p)) {
                p.setHighlighted(true);
                return true;
            }
        } else if (this.highlightedPrimitives.remove(p)) {
            p.setHighlighted(false);
            return true;
        }
        return false;
    }

    public Set<OsmPrimitive> getHighlighted() {
        return Collections.unmodifiableSet(this.highlightedPrimitives);
    }

    public void clear() {
        for (OsmPrimitive p : this.highlightedPrimitives) {
            p.setHighlighted(false);
        }
        this.highlightedPrimitives.clear();
    }

    public boolean anyHighlighted() {
        return !this.highlightedPrimitives.isEmpty();
    }

    public void findAllHighlighted() {
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        if (ds != null) {
            this.highlightedPrimitives.addAll(ds.allNonDeletedPrimitives());
        }
    }

    public static void clearAllHighlighted() {
        DataSet ds = MainApplication.getLayerManager().getActiveDataSet();
        if (ds != null) {
            for (OsmPrimitive p : ds.allNonDeletedPrimitives()) {
                p.setHighlighted(false);
            }
        }
    }
}

