/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.importers;

import java.awt.Component;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmDataManager;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.conflict.tags.PasteTagsConflictResolverDialog;
import org.openstreetmap.josm.gui.datatransfer.data.PrimitiveTagTransferData;
import org.openstreetmap.josm.gui.datatransfer.importers.AbstractTagPaster;
import org.openstreetmap.josm.tools.StreamUtils;

public class PrimitiveTagTransferPaster
extends AbstractTagPaster {
    public PrimitiveTagTransferPaster() {
        super(PrimitiveTagTransferData.FLAVOR);
    }

    @Override
    public boolean importTagsOn(TransferHandler.TransferSupport support, Collection<? extends OsmPrimitive> selection) throws UnsupportedFlavorException, IOException {
        Object o = support.getTransferable().getTransferData(this.df);
        if (!(o instanceof PrimitiveTagTransferData)) {
            return false;
        }
        PrimitiveTagTransferData data = (PrimitiveTagTransferData)o;
        TagPasteSupport tagPaster = new TagPasteSupport(data, selection);
        List<Command> commands = tagPaster.execute().stream().map(tag -> Collections.singletonMap(tag.getKey(), "".equals(tag.getValue()) ? null : tag.getValue())).map(tags -> new ChangePropertyCommand(OsmDataManager.getInstance().getEditDataSet(), selection, (Map<String, String>)tags)).filter(cmd -> cmd.getObjectsNumber() > 0).collect(StreamUtils.toUnmodifiableList());
        PrimitiveTagTransferPaster.commitCommands(selection, commands);
        return true;
    }

    @Override
    protected Map<String, String> getTags(TransferHandler.TransferSupport support) throws UnsupportedFlavorException, IOException {
        PrimitiveTagTransferData data = (PrimitiveTagTransferData)support.getTransferable().getTransferData(this.df);
        TagPasteSupport tagPaster = new TagPasteSupport(data, Arrays.asList(new Node()));
        return new TagMap(tagPaster.execute());
    }

    private static class TagPasteSupport {
        private final PrimitiveTagTransferData data;
        private final Collection<? extends IPrimitive> selection;
        private final List<Tag> tags = new ArrayList<Tag>();

        TagPasteSupport(PrimitiveTagTransferData data, Collection<? extends IPrimitive> selection) {
            this.data = data;
            this.selection = selection;
        }

        protected void pasteFromHomogeneousSource() {
            TagCollection tc = null;
            for (OsmPrimitiveType type : OsmPrimitiveType.dataValues()) {
                TagCollection tc1 = this.data.getForPrimitives(type);
                if (tc1.isEmpty()) continue;
                tc = tc1;
            }
            if (tc == null) {
                return;
            }
            if (!tc.isApplicableToPrimitive()) {
                PasteTagsConflictResolverDialog dialog = new PasteTagsConflictResolverDialog((Component)MainApplication.getMainFrame());
                dialog.populate(tc, this.data.getStatistics(), this.getTargetStatistics());
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    return;
                }
                this.buildTags(dialog.getResolution());
            } else {
                this.buildTags(tc);
            }
        }

        protected boolean canPasteFromHeterogeneousSourceWithoutConflict() {
            return OsmPrimitiveType.dataValues().stream().filter(this::hasTargetPrimitives).map(this.data::getForPrimitives).allMatch(tc -> tc.isEmpty() || tc.isApplicableToPrimitive());
        }

        protected void pasteFromHeterogeneousSource() {
            if (this.canPasteFromHeterogeneousSourceWithoutConflict()) {
                for (OsmPrimitiveType type : OsmPrimitiveType.dataValues()) {
                    if (this.data.getForPrimitives(type).isEmpty() || !this.hasTargetPrimitives(type)) continue;
                    this.buildTags(this.data.getForPrimitives(type));
                }
            } else {
                PasteTagsConflictResolverDialog dialog = new PasteTagsConflictResolverDialog((Component)MainApplication.getMainFrame());
                dialog.populate(this.data.getForPrimitives(OsmPrimitiveType.NODE), this.data.getForPrimitives(OsmPrimitiveType.WAY), this.data.getForPrimitives(OsmPrimitiveType.RELATION), this.data.getStatistics(), this.getTargetStatistics());
                dialog.setVisible(true);
                if (dialog.isCanceled()) {
                    return;
                }
                for (OsmPrimitiveType type : OsmPrimitiveType.dataValues()) {
                    if (this.data.getForPrimitives(type).isEmpty() || !this.hasTargetPrimitives(type)) continue;
                    this.buildTags(dialog.getResolution(type));
                }
            }
        }

        protected Map<OsmPrimitiveType, Integer> getTargetStatistics() {
            EnumMap<OsmPrimitiveType, Integer> ret = new EnumMap<OsmPrimitiveType, Integer>(OsmPrimitiveType.class);
            for (OsmPrimitiveType type : OsmPrimitiveType.dataValues()) {
                int count = (int)this.selection.stream().filter(p -> type == p.getType()).count();
                if (count <= 0) continue;
                ret.put(type, count);
            }
            return ret;
        }

        protected boolean hasTargetPrimitives(OsmPrimitiveType type) {
            return this.selection.stream().anyMatch(p -> type == p.getType());
        }

        protected void buildTags(TagCollection tc) {
            for (String key : tc.getKeys()) {
                this.tags.add(new Tag(key, tc.getValues(key).iterator().next()));
            }
        }

        public List<Tag> execute() {
            this.tags.clear();
            if (this.data.isHeterogeneousSource()) {
                this.pasteFromHeterogeneousSource();
            } else {
                this.pasteFromHomogeneousSource();
            }
            return this.tags;
        }

        public String toString() {
            return "PasteSupport [data=" + this.data + ", selection=" + this.selection + ']';
        }
    }
}

