/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.oauth.OAuth20Exception;
import org.openstreetmap.josm.data.oauth.OAuth20Token;
import org.openstreetmap.josm.data.oauth.OAuthAccessTokenHolder;
import org.openstreetmap.josm.data.oauth.OAuthVersion;
import org.openstreetmap.josm.gui.oauth.AbstractAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.TestAccessTokenTask;
import org.openstreetmap.josm.gui.widgets.DefaultTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public class ManualAuthorizationUI
extends AbstractAuthorizationUI {
    private final JosmTextField tfAccessTokenKey = new JosmTextField();
    private transient AccessTokenKeyValidator valAccessTokenKey;
    private final JCheckBox cbSaveToPreferences = new JCheckBox(I18n.tr("Save Access Token in preferences", new Object[0]));
    private final HtmlPanel pnlMessage = new HtmlPanel();
    private final transient Executor executor;

    @Deprecated
    public ManualAuthorizationUI(String apiUrl, Executor executor) {
        this(apiUrl, executor, OAuthVersion.OAuth10a);
    }

    public ManualAuthorizationUI(String apiUrl, Executor executor, OAuthVersion oAuthVersion) {
        super(null, oAuthVersion);
        this.setApiUrl(apiUrl);
        this.executor = executor;
        this.build();
    }

    protected JPanel buildAccessTokenPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gc = new GridBagConstraints();
        AccessTokenBuilder accessTokenBuilder = new AccessTokenBuilder();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.gridwidth = 2;
        gc.insets = new Insets(0, 0, 5, 0);
        this.pnlMessage.setText("<html><body>" + I18n.tr("Please enter an OAuth Access Token which is authorized to access the OSM server ''{0}''.", this.getApiUrl()) + "</body></html>");
        pnl.add((Component)this.pnlMessage, gc);
        gc.gridy = 1;
        gc.weightx = 0.0;
        gc.gridwidth = 1;
        gc.insets = new Insets(0, 0, 0, 3);
        pnl.add((Component)new JLabel(I18n.tr("Access Token Key:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)this.tfAccessTokenKey, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfAccessTokenKey);
        this.valAccessTokenKey = new AccessTokenKeyValidator(this.tfAccessTokenKey);
        this.valAccessTokenKey.validate();
        this.tfAccessTokenKey.getDocument().addDocumentListener(accessTokenBuilder);
        gc.gridy = 3;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        pnl.add((Component)this.cbSaveToPreferences, gc);
        this.cbSaveToPreferences.setSelected(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
        gc.gridy = 3;
        gc.gridx = 0;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        pnl.add((Component)new JPanel(), gc);
        return pnl;
    }

    protected JPanel buildTabbedPreferencesPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        JTabbedPane tp = new JTabbedPane();
        tp.add(this.buildAccessTokenPanel());
        tp.add(this.getAdvancedPropertiesPanel());
        tp.setTitleAt(0, I18n.tr("Access Token", new Object[0]));
        tp.setTitleAt(1, I18n.tr("Advanced OAuth parameters", new Object[0]));
        tp.setToolTipTextAt(0, I18n.tr("Enter the OAuth Access Token", new Object[0]));
        tp.setToolTipTextAt(1, I18n.tr("Enter advanced OAuth properties", new Object[0]));
        pnl.add((Component)tp, "Center");
        return pnl;
    }

    protected JPanel buildActionsPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        TestAccessTokenAction actTestAccessToken = new TestAccessTokenAction();
        pnl.add(new JButton(actTestAccessToken));
        this.addPropertyChangeListener(actTestAccessToken);
        return pnl;
    }

    @Override
    public void setApiUrl(String apiUrl) {
        super.setApiUrl(apiUrl);
        if (this.pnlMessage != null) {
            this.pnlMessage.setText(I18n.tr("<html><body>Please enter an OAuth Access Token which is authorized to access the OSM server ''{0}''.</body></html>", this.getApiUrl()));
        }
    }

    protected final void build() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.buildTabbedPreferencesPanel(), "Center");
        this.add((Component)this.buildActionsPanel(), "South");
    }

    @Override
    public boolean isSaveAccessTokenToPreferences() {
        return this.cbSaveToPreferences.isSelected();
    }

    private static class AccessTokenKeyValidator
    extends DefaultTextComponentValidator {
        AccessTokenKeyValidator(JTextComponent tc) {
            super(tc, I18n.tr("Please enter an Access Token Key", new Object[0]), I18n.tr("The Access Token Key must not be empty. Please enter an Access Token Key", new Object[0]));
        }
    }

    class AccessTokenBuilder
    implements DocumentListener {
        AccessTokenBuilder() {
        }

        public void build() {
            if (!ManualAuthorizationUI.this.valAccessTokenKey.isValid()) {
                ManualAuthorizationUI.this.setAccessToken(null);
            } else {
                try {
                    ManualAuthorizationUI.this.setAccessToken(new OAuth20Token(ManualAuthorizationUI.this.getOAuthParameters(), "{\"token_type\":\"bearer\", \"access_token\"" + ManualAuthorizationUI.this.tfAccessTokenKey.getText().trim() + "\"}"));
                }
                catch (OAuth20Exception e) {
                    throw new JosmRuntimeException(e);
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.build();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.build();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.build();
        }
    }

    class TestAccessTokenAction
    extends AbstractAction
    implements PropertyChangeListener {
        TestAccessTokenAction() {
            this.putValue("Name", I18n.tr("Test Access Token", new Object[0]));
            new ImageProvider("oauth", "oauth-small").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Click to test the Access Token", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TestAccessTokenTask task = new TestAccessTokenTask((Component)ManualAuthorizationUI.this, ManualAuthorizationUI.this.getApiUrl(), ManualAuthorizationUI.this.getAccessToken());
            ManualAuthorizationUI.this.executor.execute(task);
        }

        protected final void updateEnabledState() {
            this.setEnabled(ManualAuthorizationUI.this.hasAccessToken());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals(AbstractAuthorizationUI.ACCESS_TOKEN_PROP)) {
                return;
            }
            this.updateEnabledState();
        }
    }
}

