/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.time.DateTimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.function.Consumer;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DownloadPolicy;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.UploadPolicy;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.LruCache;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmServerReadPostprocessor;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public abstract class AbstractReader {
    private static volatile List<OsmServerReadPostprocessor> postprocessors;
    protected boolean cancel;
    protected DataSet ds = new DataSet();
    protected Changeset uploadChangeset;
    protected final Map<PrimitiveId, OsmPrimitive> externalIdMap = new HashMap<PrimitiveId, OsmPrimitive>();
    protected final Map<Long, Collection<Long>> ways = new HashMap<Long, Collection<Long>>();
    protected final Map<Long, Collection<RelationMemberData>> relations = new HashMap<Long, Collection<RelationMemberData>>();
    private final Map<String, Integer> timestampCache = new LruCache<String, Integer>(30);

    public static void registerPostprocessor(OsmServerReadPostprocessor pp) {
        if (postprocessors == null) {
            postprocessors = new ArrayList<OsmServerReadPostprocessor>();
        }
        postprocessors.add(pp);
    }

    public static void deregisterPostprocessor(OsmServerReadPostprocessor pp) {
        if (postprocessors != null) {
            postprocessors.remove(pp);
        }
    }

    public DataSet getDataSet() {
        return this.ds;
    }

    protected void callPostProcessors(ProgressMonitor progressMonitor) {
        if (postprocessors != null) {
            for (OsmServerReadPostprocessor pp : postprocessors) {
                pp.postprocessDataSet(this.getDataSet(), progressMonitor);
            }
        }
    }

    protected void processNodesAfterParsing() {
        for (OsmPrimitive primitive : this.externalIdMap.values()) {
            if (!(primitive instanceof Node)) continue;
            this.ds.addPrimitive(primitive);
        }
    }

    protected void processWaysAfterParsing() throws IllegalDataException {
        for (Map.Entry<Long, Collection<Long>> entry : this.ways.entrySet()) {
            Long externalWayId = entry.getKey();
            Way w = (Way)this.externalIdMap.get(new SimplePrimitiveId(externalWayId, OsmPrimitiveType.WAY));
            ArrayList<Node> wayNodes = new ArrayList<Node>();
            for (long id : entry.getValue()) {
                Node n = (Node)this.externalIdMap.get(new SimplePrimitiveId(id, OsmPrimitiveType.NODE));
                if (n == null) {
                    if (id <= 0L) {
                        throw new IllegalDataException(I18n.tr("Way with external ID ''{0}'' includes missing node with external ID ''{1}''.", Long.toString(externalWayId), Long.toString(id)));
                    }
                    n = (Node)this.ds.getPrimitiveById(id, OsmPrimitiveType.NODE);
                    if (n == null) {
                        n = new Node(id);
                        this.ds.addPrimitive(n);
                    }
                }
                if (n.isDeleted()) {
                    Logging.info(I18n.tr("Deleted node {0} is part of way {1}", Long.toString(id), Long.toString(w.getId())));
                    continue;
                }
                wayNodes.add(n);
            }
            w.setNodes((List<Node>)wayNodes);
            if (w.hasIncompleteNodes()) {
                Logging.info(I18n.tr("Way {0} with {1} nodes is incomplete because at least one node was missing in the loaded data.", Long.toString(externalWayId), w.getNodesCount()));
            }
            this.ds.addPrimitive(w);
        }
    }

    protected void processRelationsAfterParsing() throws IllegalDataException {
        for (Long l : this.relations.keySet()) {
            Relation relation = (Relation)this.externalIdMap.get(new SimplePrimitiveId(l, OsmPrimitiveType.RELATION));
            this.ds.addPrimitive(relation);
        }
        for (Map.Entry entry : this.relations.entrySet()) {
            Long externalRelationId = (Long)entry.getKey();
            Relation relation = (Relation)this.externalIdMap.get(new SimplePrimitiveId(externalRelationId, OsmPrimitiveType.RELATION));
            ArrayList<RelationMember> relationMembers = new ArrayList<RelationMember>();
            for (RelationMemberData rm : (Collection)entry.getValue()) {
                OsmPrimitive primitive = this.externalIdMap.get(new SimplePrimitiveId(rm.getMemberId(), rm.getMemberType()));
                if (primitive == null) {
                    if (rm.getMemberId() <= 0L) {
                        throw new IllegalDataException(I18n.tr("Relation with external id ''{0}'' refers to a missing primitive with external id ''{1}''.", Long.toString(externalRelationId), Long.toString(rm.getMemberId())));
                    }
                    primitive = (OsmPrimitive)this.ds.getPrimitiveById(rm.getMemberId(), rm.getMemberType());
                    if (primitive == null) {
                        switch (rm.getMemberType()) {
                            case NODE: {
                                primitive = new Node(rm.getMemberId());
                                break;
                            }
                            case WAY: {
                                primitive = new Way(rm.getMemberId());
                                break;
                            }
                            case RELATION: {
                                primitive = new Relation(rm.getMemberId());
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        this.ds.addPrimitive(primitive);
                        this.externalIdMap.put(new SimplePrimitiveId(rm.getMemberId(), rm.getMemberType()), primitive);
                    }
                }
                if (primitive.isDeleted()) {
                    Logging.info(I18n.tr("Deleted member {0} is used by relation {1}", Long.toString(primitive.getId()), Long.toString(relation.getId())));
                    continue;
                }
                relationMembers.add(new RelationMember(rm.getRole(), primitive));
            }
            relation.setMembers((List<RelationMember>)relationMembers);
        }
    }

    protected void processChangesetAfterParsing() {
        if (this.uploadChangeset != null) {
            for (Map.Entry<String, String> e : this.uploadChangeset.getKeys().entrySet()) {
                this.ds.addChangeSetTag(e.getKey(), e.getValue());
            }
        }
    }

    protected final void prepareDataSet() throws IllegalDataException {
        this.ds.beginUpdate();
        try {
            this.processNodesAfterParsing();
            this.processWaysAfterParsing();
            this.processRelationsAfterParsing();
            this.processChangesetAfterParsing();
        }
        finally {
            this.ds.endUpdate();
        }
    }

    protected abstract DataSet doParseDataSet(InputStream var1, ProgressMonitor var2) throws IllegalDataException;

    protected final DataSet doParseDataSet(InputStream source, ProgressMonitor progressMonitor, BinaryParserWorker parserWorker) throws IllegalDataException {
        return this.doParseDataSet(source, progressMonitor, (Object)parserWorker);
    }

    protected final DataSet doParseDataSet(InputStream source, ProgressMonitor progressMonitor, ParserWorker parserWorker) throws IllegalDataException {
        return this.doParseDataSet(source, progressMonitor, (Object)parserWorker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet doParseDataSet(InputStream source, ProgressMonitor progressMonitor, Object parserWorker) throws IllegalDataException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        ProgressMonitor.CancelListener cancelListener = () -> {
            this.cancel = true;
        };
        progressMonitor.addCancelListener(cancelListener);
        CheckParameterUtil.ensureParameterNotNull(source, "source");
        try {
            progressMonitor.beginTask(I18n.tr("Prepare OSM data...", new Object[0]), 4);
            progressMonitor.indeterminateSubTask(I18n.tr("Parsing OSM data...", new Object[0]));
            if (parserWorker instanceof ParserWorker) {
                try (UTFInputStreamReader ir = UTFInputStreamReader.create(source);){
                    ((ParserWorker)parserWorker).accept(ir);
                }
            } else if (parserWorker instanceof BinaryParserWorker) {
                ((BinaryParserWorker)parserWorker).accept(source);
            } else {
                throw new IllegalArgumentException("Unknown parser worker type: " + String.valueOf(parserWorker.getClass()));
            }
            progressMonitor.worked(1);
            boolean readOnly = this.getDataSet().isLocked();
            progressMonitor.indeterminateSubTask(I18n.tr("Preparing data set...", new Object[0]));
            if (readOnly) {
                this.getDataSet().unlock();
            }
            this.prepareDataSet();
            if (readOnly) {
                this.getDataSet().lock();
            }
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr("Post-processing data set...", new Object[0]));
            this.callPostProcessors(progressMonitor);
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr("Rendering data set...", new Object[0]));
            if (readOnly && !this.getDataSet().isLocked()) {
                this.getDataSet().lock();
            }
            DataSet dataSet = this.getDataSet();
            return dataSet;
        }
        catch (IllegalDataException e2) {
            throw e2;
        }
        catch (IOException e3) {
            throw new IllegalDataException(e3);
        }
        finally {
            for (OsmPrimitiveType dataType : OsmPrimitiveType.dataValues()) {
                OptionalLong minId = this.externalIdMap.entrySet().parallelStream().filter(e -> ((PrimitiveId)e.getKey()).getType() == dataType).mapToLong(e -> ((OsmPrimitive)e.getValue()).getUniqueId()).min();
                Class<? extends PrimitiveData> clazz = dataType.getDataClass();
                synchronized (clazz) {
                    if (minId.isPresent() && minId.getAsLong() < dataType.getIdGenerator().currentUniqueId()) {
                        dataType.getIdGenerator().advanceUniqueId(minId.getAsLong());
                    }
                }
            }
            progressMonitor.finishTask();
            progressMonitor.removeCancelListener(cancelListener);
        }
    }

    protected final long getLong(String name, String value) throws IllegalDataException {
        if (value == null) {
            throw new IllegalDataException(I18n.tr("Missing required attribute ''{0}''.", name));
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalDataException(I18n.tr("Illegal long value for attribute ''{0}''. Got ''{1}''.", name, value), e);
        }
    }

    protected final void parseVersion(String version) throws IllegalDataException {
        AbstractReader.validateVersion(version);
        this.ds.setVersion(version);
    }

    private static void validateVersion(String version) throws IllegalDataException {
        if (version == null) {
            throw new IllegalDataException(I18n.tr("Missing mandatory attribute ''{0}''.", "version"));
        }
        if (!"0.6".equals(version)) {
            throw new IllegalDataException(I18n.tr("Unsupported version: {0}", version));
        }
    }

    protected final void parseDownloadPolicy(String key, String downloadPolicy) throws IllegalDataException {
        AbstractReader.parsePolicy(key, downloadPolicy, policy -> this.ds.setDownloadPolicy(DownloadPolicy.of(policy)));
    }

    protected final void parseUploadPolicy(String key, String uploadPolicy) throws IllegalDataException {
        AbstractReader.parsePolicy(key, uploadPolicy, policy -> this.ds.setUploadPolicy(UploadPolicy.of(policy)));
    }

    private static void parsePolicy(String key, String policy, Consumer<String> consumer) throws IllegalDataException {
        if (policy != null) {
            try {
                consumer.accept(policy);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalDataException(MessageFormat.format("Illegal value for attribute ''{0}''. Got ''{1}''.", key, policy), e);
            }
        }
    }

    protected final void parseLocked(String locked) {
        if ("true".equalsIgnoreCase(locked)) {
            this.ds.lock();
        }
    }

    protected final void parseBounds(String generator, String minlon, String minlat, String maxlon, String maxlat, String origin) throws IllegalDataException {
        Bounds bounds;
        if (minlon != null && maxlon != null && minlat != null && maxlat != null) {
            if (origin == null) {
                origin = generator;
            }
            if ((bounds = new Bounds(Double.parseDouble(minlat), Double.parseDouble(minlon), Double.parseDouble(maxlat), Double.parseDouble(maxlon))).isOutOfTheWorld()) {
                Bounds copy = new Bounds(bounds);
                bounds.normalize();
                Logging.info("Bbox " + String.valueOf(copy) + " is out of the world, normalized to " + String.valueOf(bounds));
            }
        } else {
            throw new IllegalDataException(I18n.tr("Missing mandatory attributes on element ''bounds''. Got minlon=''{0}'',minlat=''{1}'',maxlon=''{2}'',maxlat=''{3}'', origin=''{4}''.", minlon, minlat, maxlon, maxlat, origin));
        }
        this.ds.addDataSource(new DataSource(bounds, origin));
    }

    protected final void parseId(PrimitiveData current, long id) throws IllegalDataException {
        current.setId(id);
        if (current.getUniqueId() == 0L) {
            throw new IllegalDataException(I18n.tr("Illegal object with ID=0.", new Object[0]));
        }
    }

    protected final void parseTimestamp(PrimitiveData current, String time) {
        if (Utils.isEmpty(time)) {
            return;
        }
        try {
            int timestamp = this.timestampCache.computeIfAbsent(time, t -> (int)DateUtils.parseInstant(t).getEpochSecond());
            current.setRawTimestamp(timestamp);
        }
        catch (DateTimeException | UncheckedParseException e) {
            Logging.error(e);
        }
    }

    private static User createUser(String uid, String name) throws IllegalDataException {
        if (uid == null) {
            if (name == null) {
                return null;
            }
            return User.createLocalUser(name);
        }
        try {
            return User.createOsmUser(Long.parseLong(uid), name);
        }
        catch (NumberFormatException e) {
            throw new IllegalDataException(MessageFormat.format("Illegal value for attribute ''uid''. Got ''{0}''.", uid), e);
        }
    }

    protected final void parseUser(PrimitiveData current, String user, long uid) {
        current.setUser(User.createOsmUser(uid, user));
    }

    protected final void parseUser(PrimitiveData current, String user, String uid) throws IllegalDataException {
        current.setUser(AbstractReader.createUser(uid, user));
    }

    protected final void parseVisible(PrimitiveData current, String visible) {
        if (visible != null) {
            current.setVisible(Boolean.parseBoolean(visible));
        }
    }

    protected final void parseVersion(PrimitiveData current, String versionString) throws IllegalDataException {
        int version = 0;
        if (versionString != null) {
            try {
                version = Integer.parseInt(versionString);
            }
            catch (NumberFormatException e) {
                throw new IllegalDataException(I18n.tr("Illegal value for attribute ''version'' on OSM primitive with ID {0}. Got {1}.", Long.toString(current.getUniqueId()), versionString), e);
            }
            this.parseVersion(current, version);
        } else if (!current.isNew() && this.ds.getVersion() != null && "0.6".equals(this.ds.getVersion())) {
            throw new IllegalDataException(I18n.tr("Missing attribute ''version'' on OSM primitive with ID {0}.", Long.toString(current.getUniqueId())));
        }
    }

    protected final void parseVersion(PrimitiveData current, int version) throws IllegalDataException {
        switch (this.ds.getVersion()) {
            case "0.6": {
                if (version <= 0 && !current.isNew()) {
                    throw new IllegalDataException(I18n.tr("Illegal value for attribute ''version'' on OSM primitive with ID {0}. Got {1}.", Long.toString(current.getUniqueId()), version));
                }
                if (version >= 0 || !current.isNew()) break;
                Logging.warn(I18n.tr("Normalizing value of attribute ''version'' of element {0} to {2}, API version is ''{3}''. Got {1}.", current.getUniqueId(), version, 0, "0.6"));
                version = 0;
                break;
            }
            default: {
                throw new IllegalDataException(I18n.tr("Unknown or unsupported API version. Got {0}.", this.ds.getVersion()));
            }
        }
        current.setVersion(version);
    }

    protected final void parseAction(PrimitiveData current, String action) {
        if (action != null) {
            if ("delete".equals(action)) {
                current.setDeleted(true);
                current.setModified(current.isVisible());
            } else if ("modify".equals(action)) {
                current.setModified(true);
            }
        }
    }

    private static void handleIllegalChangeset(PrimitiveData current, IllegalArgumentException e, Object v) throws IllegalDataException {
        Logging.debug(e.getMessage());
        if (!current.isNew()) {
            throw new IllegalDataException(I18n.tr("Illegal value for attribute ''changeset''. Got {0}.", v), e);
        }
        Logging.info(I18n.tr("Illegal value for attribute ''changeset'' on new object {1}. Got {0}. Resetting to 0.", v, current.getUniqueId()));
        current.setChangesetId(0);
    }

    protected final void parseChangeset(PrimitiveData current, String v) throws IllegalDataException {
        if (v == null) {
            current.setChangesetId(0);
        } else {
            try {
                this.parseChangeset(current, Integer.parseInt(v));
            }
            catch (NumberFormatException e) {
                AbstractReader.handleIllegalChangeset(current, e, v);
            }
        }
    }

    protected final void parseChangeset(PrimitiveData current, int v) throws IllegalDataException {
        try {
            current.setChangesetId(v);
        }
        catch (IllegalArgumentException e) {
            AbstractReader.handleIllegalChangeset(current, e, v);
        }
        catch (IllegalStateException e) {
            Logging.debug(e);
            Logging.info(e.getMessage());
            current.setChangesetId(0);
        }
        if (current.getChangesetId() <= 0) {
            if (current.isNew()) {
                Logging.info(I18n.tr("Illegal value for attribute ''changeset'' on new object {1}. Got {0}. Resetting to 0.", v, current.getUniqueId()));
                current.setChangesetId(0);
            } else if (current.getChangesetId() < 0) {
                throw new IllegalDataException(I18n.tr("Illegal value for attribute ''changeset''. Got {0}.", v));
            }
        }
    }

    protected final void parseTag(Tagged t, String key, String value) throws IllegalDataException {
        if (key == null || value == null) {
            throw new IllegalDataException(I18n.tr("Missing key or value attribute in tag.", new Object[0]));
        }
        if (Utils.isStripEmpty(key) && t instanceof AbstractPrimitive) {
            ((AbstractPrimitive)t).setModified(true);
        } else {
            t.put(key.intern(), value.intern());
        }
    }

    private static boolean areLatLonDefined(String lat, String lon) {
        return lat != null && lon != null;
    }

    private static boolean areLatLonDefined(double lat, double lon) {
        return !Double.isNaN(lat) && !Double.isNaN(lon);
    }

    protected OsmPrimitive buildPrimitive(PrimitiveData pd) {
        OsmPrimitive p;
        if (pd.getUniqueId() < pd.getIdGenerator().currentUniqueId()) {
            p = pd.getType().newInstance(pd.getUniqueId(), true);
            pd.getIdGenerator().advanceUniqueId(pd.getUniqueId());
        } else {
            p = pd.getType().newVersionedInstance(pd.getId(), pd.getVersion());
        }
        p.setVisible(pd.isVisible());
        p.load(pd);
        this.externalIdMap.put(pd.getPrimitiveId(), p);
        return p;
    }

    private Node addNode(NodeData nd, NodeReader nodeReader) throws IllegalDataException {
        nodeReader.accept(nd);
        return (Node)this.buildPrimitive(nd);
    }

    protected final Node parseNode(double lat, double lon, CommonReader commonReader, NodeReader nodeReader) throws IllegalDataException {
        NodeData nd = new NodeData(0L);
        LatLon ll = null;
        if (AbstractReader.areLatLonDefined(lat, lon)) {
            try {
                ll = new LatLon(lat, lon);
                nd.setCoor(ll);
            }
            catch (NumberFormatException e) {
                Logging.trace(e);
            }
        }
        commonReader.accept(nd);
        if (AbstractReader.areLatLonDefined(lat, lon) && (ll == null || !ll.isValid())) {
            throw new IllegalDataException(I18n.tr("Illegal value for attributes ''lat'', ''lon'' on node with ID {0}. Got ''{1}'', ''{2}''.", Long.toString(nd.getId()), lat, lon));
        }
        return this.addNode(nd, nodeReader);
    }

    protected final Node parseNode(String lat, String lon, CommonReader commonReader, NodeReader nodeReader) throws IllegalDataException {
        NodeData nd = new NodeData(0L);
        LatLon ll = null;
        if (AbstractReader.areLatLonDefined(lat, lon)) {
            try {
                ll = new LatLon(Double.parseDouble(lat), Double.parseDouble(lon));
                nd.setCoor(ll);
            }
            catch (NumberFormatException e) {
                Logging.trace(e);
            }
        }
        commonReader.accept(nd);
        if (AbstractReader.areLatLonDefined(lat, lon) && (ll == null || !ll.isValid())) {
            throw new IllegalDataException(I18n.tr("Illegal value for attributes ''lat'', ''lon'' on node with ID {0}. Got ''{1}'', ''{2}''.", Long.toString(nd.getId()), lat, lon));
        }
        return this.addNode(nd, nodeReader);
    }

    protected final Way parseWay(CommonReader commonReader, WayReader wayReader) throws IllegalDataException {
        WayData wd = new WayData(0L);
        commonReader.accept(wd);
        ArrayList<Long> nodeIds = new ArrayList<Long>();
        wayReader.accept(wd, nodeIds);
        if (wd.isDeleted() && !nodeIds.isEmpty()) {
            Logging.info(I18n.tr("Deleted way {0} contains nodes", Long.toString(wd.getUniqueId())));
            nodeIds = new ArrayList();
        }
        this.ways.put(wd.getUniqueId(), nodeIds);
        return (Way)this.buildPrimitive(wd);
    }

    protected final Relation parseRelation(CommonReader commonReader, RelationReader relationReader) throws IllegalDataException {
        RelationData rd = new RelationData(0L);
        commonReader.accept(rd);
        ArrayList<RelationMemberData> members = new ArrayList<RelationMemberData>();
        relationReader.accept(rd, members);
        if (rd.isDeleted() && !members.isEmpty()) {
            Logging.info(I18n.tr("Deleted relation {0} contains members", Long.toString(rd.getUniqueId())));
            members = new ArrayList();
        }
        this.relations.put(rd.getUniqueId(), members);
        return (Relation)this.buildPrimitive(rd);
    }

    protected final RelationMemberData parseRelationMember(RelationData r, String ref, String type, String role) throws IllegalDataException {
        if (ref == null) {
            throw new IllegalDataException(I18n.tr("Missing attribute ''ref'' on member in relation {0}.", Long.toString(r.getUniqueId())));
        }
        try {
            return this.parseRelationMember(r, Long.parseLong(ref), type, role);
        }
        catch (NumberFormatException e) {
            throw new IllegalDataException(I18n.tr("Illegal value for attribute ''ref'' on member in relation {0}. Got {1}", Long.toString(r.getUniqueId()), ref), e);
        }
    }

    protected final RelationMemberData parseRelationMember(RelationData r, long id, String type, String role) throws IllegalDataException {
        if (id == 0L) {
            throw new IllegalDataException(I18n.tr("Incomplete <member> specification with ref=0", new Object[0]));
        }
        if (type == null) {
            throw new IllegalDataException(I18n.tr("Missing attribute ''type'' on member {0} in relation {1}.", Long.toString(id), Long.toString(r.getUniqueId())));
        }
        try {
            return new RelationMemberData(role, OsmPrimitiveType.fromApiTypeName(type), id);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalDataException(I18n.tr("Illegal value for attribute ''type'' on member {0} in relation {1}. Got {2}.", Long.toString(id), Long.toString(r.getUniqueId()), type), e);
        }
    }

    @FunctionalInterface
    protected static interface ParserWorker {
        public void accept(InputStreamReader var1) throws IllegalDataException, IOException;
    }

    @FunctionalInterface
    protected static interface BinaryParserWorker {
        public void accept(InputStream var1) throws IllegalDataException, IOException;
    }

    @FunctionalInterface
    protected static interface NodeReader {
        public void accept(NodeData var1) throws IllegalDataException;
    }

    @FunctionalInterface
    protected static interface CommonReader {
        public void accept(PrimitiveData var1) throws IllegalDataException;
    }

    @FunctionalInterface
    protected static interface WayReader {
        public void accept(WayData var1, Collection<Long> var2) throws IllegalDataException;
    }

    @FunctionalInterface
    protected static interface RelationReader {
        public void accept(RelationData var1, Collection<RelationMemberData> var2) throws IllegalDataException;
    }
}

