/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openstreetmap.josm.spi.preferences.Config;

public interface GpxConstants {
    public static final String GPX_PREFIX = "gpx:";
    public static final String GPX_NAME = "name";
    public static final String GPX_CMT = "cmt";
    public static final String GPX_DESC = "desc";
    public static final String GPX_SRC = "src";
    public static final String META_PREFIX = "meta.";
    public static final String META_AUTHOR_NAME = "meta.author.name";
    public static final String META_AUTHOR_EMAIL = "meta.author.email";
    public static final String META_AUTHOR_LINK = "meta.author.link";
    public static final String META_COPYRIGHT_AUTHOR = "meta.copyright.author";
    public static final String META_COPYRIGHT_LICENSE = "meta.copyright.license";
    public static final String META_COPYRIGHT_YEAR = "meta.copyright.year";
    public static final String META_DESC = "meta.desc";
    public static final String META_KEYWORDS = "meta.keywords";
    public static final String META_LINKS = "meta.links";
    public static final String META_NAME = "meta.name";
    public static final String META_TIME = "meta.time";
    public static final String META_BOUNDS = "meta.bounds";
    public static final String JOSM_CREATOR_NAME = "JOSM GPX export";
    public static final String XML_URI_XSD = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XML_URI_EXTENSIONS_JOSM = Config.getUrls().getXMLBase() + "/gpx-extensions-1.1";
    public static final String XML_XSD_EXTENSIONS_JOSM = Config.getUrls().getXMLBase() + "/gpx-extensions-1.1.xsd";
    public static final String XML_URI_EXTENSIONS_DRAWING = Config.getUrls().getXMLBase() + "/gpx-drawing-extensions-1.0";
    public static final String XML_XSD_EXTENSIONS_DRAWING = Config.getUrls().getXMLBase() + "/gpx-drawing-extensions-1.0.xsd";
    public static final String XML_URI_EXTENSIONS_GARMIN = "http://www.garmin.com/xmlschemas/GpxExtensions/v3";
    public static final String XML_XSD_EXTENSIONS_GARMIN = "http://www.garmin.com/xmlschemas/GpxExtensionsv3.xsd";
    public static final String PT_ELE = "ele";
    public static final String PT_TIME = "time";
    public static final String PT_MAGVAR = "magvar";
    public static final String PT_GEOIDHEIGHT = "geoidheight";
    public static final String PT_SYM = "sym";
    public static final String PT_TYPE = "type";
    public static final String PT_FIX = "fix";
    public static final String PT_SAT = "sat";
    public static final String PT_HDOP = "hdop";
    public static final String PT_VDOP = "vdop";
    public static final String PT_PDOP = "pdop";
    public static final String PT_AGEOFDGPSDATA = "ageofdgpsdata";
    public static final String PT_DGPSID = "dgpsid";
    public static final String PT_STD_HDEV = "stdhdev";
    public static final String PT_STD_VDEV = "stdvdev";
    public static final List<String> WPT_KEYS = Collections.unmodifiableList(Arrays.asList("ele", "time", "magvar", "geoidheight", "name", "cmt", "desc", "src", "meta.links", "sym", "type", "fix", "sat", "hdop", "vdop", "pdop", "ageofdgpsdata", "dgpsid", "stdhdev", "stdvdev"));
    public static final List<String> RTE_TRK_KEYS = Collections.unmodifiableList(Arrays.asList("name", "cmt", "desc", "src", "meta.links", "number", "type"));
    public static final Map<String, Color> GARMIN_COLORS = GpxConstants.getGarminColors();
    public static final Map<String, String> EXTENSION_ABBREVIATIONS = GpxConstants.getExtensionAbbreviations();
    public static final List<String> FIX_VALUES = Collections.unmodifiableList(Arrays.asList("none", "2d", "3d", "dgps", "pps", "rtk", "float rtk", "estimated", "manual", "simulated"));
    public static final String RTKLIB_Q = "Q";
    public static final String RTKLIB_SDN = "sdn";
    public static final String RTKLIB_SDE = "sde";
    public static final String RTKLIB_SDU = "sdu";
    public static final String RTKLIB_SDNE = "sdne";
    public static final String RTKLIB_SDEU = "sdeu";
    public static final String RTKLIB_SDUN = "sdun";
    public static final String RTKLIB_AGE = "age";
    public static final String RTKLIB_RATIO = "ratio";

    public static Map<String, Color> getGarminColors() {
        TreeMap<String, Color> m = new TreeMap<String, Color>(String.CASE_INSENSITIVE_ORDER);
        m.put("Black", Color.BLACK);
        m.put("DarkRed", new Color(139, 0, 0));
        m.put("DarkGreen", new Color(0, 100, 0));
        m.put("DarkYellow", new Color(255, 170, 0));
        m.put("DarkBlue", new Color(0, 0, 139));
        m.put("DarkMagenta", new Color(139, 0, 139));
        m.put("DarkCyan", new Color(0, 139, 139));
        m.put("LightGray", Color.LIGHT_GRAY);
        m.put("DarkGray", Color.DARK_GRAY);
        m.put("Red", Color.RED);
        m.put("Green", Color.GREEN);
        m.put("Yellow", Color.YELLOW);
        m.put("Blue", Color.BLUE);
        m.put("Magenta", Color.MAGENTA);
        m.put("Cyan", Color.CYAN);
        m.put("White", Color.WHITE);
        m.put("Transparent", new Color(0, 0, 0, 255));
        return Collections.unmodifiableMap(m);
    }

    public static Map<String, String> getExtensionAbbreviations() {
        TreeMap<String, String> m = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        m.put("gpx:extension:gpxx:TrackExtension:DisplayColor", "gpxx:DisplayColor");
        m.put("gpx:extension:gpxd:color", "gpxd:color");
        return m;
    }

    public static enum ColorFormat {
        GPXD,
        GPXX;

    }
}

