/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jrtfs;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import jdk.internal.jrtfs.JrtDirectoryStream;
import jdk.internal.jrtfs.JrtFileAttributeView;
import jdk.internal.jrtfs.JrtFileAttributes;
import jdk.internal.jrtfs.JrtFileSystem;

final class JrtPath
implements Path {
    final JrtFileSystem jrtfs;
    private final String path;
    private volatile int[] offsets;
    private volatile String resolved;
    private static final long L_DIGIT = JrtPath.lowMask('0', '9');
    private static final long H_DIGIT = 0L;
    private static final long L_UPALPHA = 0L;
    private static final long H_UPALPHA = JrtPath.highMask('A', 'Z');
    private static final long L_LOWALPHA = 0L;
    private static final long H_LOWALPHA = JrtPath.highMask('a', 'z');
    private static final long L_ALPHA = 0L;
    private static final long H_ALPHA = H_LOWALPHA | H_UPALPHA;
    private static final long L_ALPHANUM = L_DIGIT | 0L;
    private static final long H_ALPHANUM = 0L | H_ALPHA;
    private static final long L_MARK = JrtPath.lowMask("-_.!~*'()");
    private static final long H_MARK = JrtPath.highMask("-_.!~*'()");
    private static final long L_UNRESERVED = L_ALPHANUM | L_MARK;
    private static final long H_UNRESERVED = H_ALPHANUM | H_MARK;
    private static final long L_PCHAR = L_UNRESERVED | JrtPath.lowMask(":@&=+$,");
    private static final long H_PCHAR = H_UNRESERVED | JrtPath.highMask(":@&=+$,");
    private static final long L_PATH = L_PCHAR | JrtPath.lowMask(";/");
    private static final long H_PATH = H_PCHAR | JrtPath.highMask(";/");
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    JrtPath(JrtFileSystem jrtfs, String path) {
        this.jrtfs = jrtfs;
        this.path = JrtPath.normalize(path);
        this.resolved = null;
    }

    JrtPath(JrtFileSystem jrtfs, String path, boolean normalized) {
        this.jrtfs = jrtfs;
        this.path = normalized ? path : JrtPath.normalize(path);
        this.resolved = null;
    }

    final String getName() {
        return this.path;
    }

    @Override
    public final JrtPath getRoot() {
        if (this.isAbsolute()) {
            return this.jrtfs.getRootPath();
        }
        return null;
    }

    @Override
    public final JrtPath getFileName() {
        if (this.path.isEmpty()) {
            return this;
        }
        if (this.path.length() == 1 && this.path.charAt(0) == '/') {
            return null;
        }
        int off = this.path.lastIndexOf(47);
        if (off == -1) {
            return this;
        }
        return new JrtPath(this.jrtfs, this.path.substring(off + 1), true);
    }

    @Override
    public final JrtPath getParent() {
        this.initOffsets();
        int count = this.offsets.length;
        if (count == 0) {
            return null;
        }
        int off = this.offsets[count - 1] - 1;
        if (off <= 0) {
            return this.getRoot();
        }
        return new JrtPath(this.jrtfs, this.path.substring(0, off));
    }

    @Override
    public final int getNameCount() {
        this.initOffsets();
        return this.offsets.length;
    }

    @Override
    public final JrtPath getName(int index) {
        this.initOffsets();
        if (index < 0 || index >= this.offsets.length) {
            throw new IllegalArgumentException("index: " + index + ", offsets length: " + this.offsets.length);
        }
        int begin = this.offsets[index];
        int end = index == this.offsets.length - 1 ? this.path.length() : this.offsets[index + 1];
        return new JrtPath(this.jrtfs, this.path.substring(begin, end));
    }

    @Override
    public final JrtPath subpath(int beginIndex, int endIndex) {
        this.initOffsets();
        if (beginIndex < 0 || endIndex > this.offsets.length || beginIndex >= endIndex) {
            throw new IllegalArgumentException("beginIndex: " + beginIndex + ", endIndex: " + endIndex + ", offsets length: " + this.offsets.length);
        }
        int begin = this.offsets[beginIndex];
        int end = endIndex == this.offsets.length ? this.path.length() : this.offsets[endIndex];
        return new JrtPath(this.jrtfs, this.path.substring(begin, end));
    }

    @Override
    public final JrtPath toRealPath(LinkOption ... options) throws IOException {
        return this.jrtfs.toRealPath(this, options);
    }

    @Override
    public final JrtPath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return new JrtPath(this.jrtfs, "/" + this.path, true);
    }

    @Override
    public final URI toUri() {
        String p = this.toAbsolutePath().path;
        if (!p.startsWith("/modules") || p.contains("..")) {
            throw new IOError(new RuntimeException(p + " cannot be represented as URI"));
        }
        if ((p = p.substring("/modules".length())).isEmpty()) {
            p = "/";
        }
        return JrtPath.toUri(p);
    }

    private boolean equalsNameAt(JrtPath other, int index) {
        int mbegin = this.offsets[index];
        int mlen = index == this.offsets.length - 1 ? this.path.length() - mbegin : this.offsets[index + 1] - mbegin - 1;
        int obegin = other.offsets[index];
        int olen = index == other.offsets.length - 1 ? other.path.length() - obegin : other.offsets[index + 1] - obegin - 1;
        if (mlen != olen) {
            return false;
        }
        for (int n = 0; n < mlen; ++n) {
            if (this.path.charAt(mbegin + n) == other.path.charAt(obegin + n)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final JrtPath relativize(Path other) {
        int i;
        JrtPath o = this.checkPath(other);
        if (o.equals(this)) {
            return new JrtPath(this.jrtfs, "", true);
        }
        if (this.path.isEmpty()) {
            return o;
        }
        if (this.jrtfs != o.jrtfs || this.isAbsolute() != o.isAbsolute()) {
            throw new IllegalArgumentException("Incorrect filesystem or path: " + other);
        }
        String op = o.path;
        String tp = this.path;
        if (op.startsWith(tp)) {
            int off = tp.length();
            if (op.charAt(off - 1) == '/') {
                return new JrtPath(this.jrtfs, op.substring(off), true);
            }
            if (op.charAt(off) == '/') {
                return new JrtPath(this.jrtfs, op.substring(off + 1), true);
            }
        }
        int mc = this.getNameCount();
        int oc = o.getNameCount();
        int n = Math.min(mc, oc);
        for (i = 0; i < n && this.equalsNameAt(o, i); ++i) {
        }
        int dotdots = mc - i;
        int len = dotdots * 3 - 1;
        if (i < oc) {
            len += o.path.length() - o.offsets[i] + 1;
        }
        StringBuilder sb = new StringBuilder(len);
        while (dotdots > 0) {
            sb.append("..");
            if (sb.length() < len) {
                sb.append('/');
            }
            --dotdots;
        }
        if (i < oc) {
            sb.append(o.path, o.offsets[i], o.path.length());
        }
        return new JrtPath(this.jrtfs, sb.toString(), true);
    }

    @Override
    public JrtFileSystem getFileSystem() {
        return this.jrtfs;
    }

    @Override
    public final boolean isAbsolute() {
        return !this.path.isEmpty() && this.path.charAt(0) == '/';
    }

    @Override
    public final JrtPath resolve(Path other) {
        JrtPath o = this.checkPath(other);
        if (this.path.isEmpty() || o.isAbsolute()) {
            return o;
        }
        if (o.path.isEmpty()) {
            return this;
        }
        StringBuilder sb = new StringBuilder(this.path.length() + o.path.length() + 1);
        sb.append(this.path);
        if (this.path.charAt(this.path.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append(o.path);
        return new JrtPath(this.jrtfs, sb.toString(), true);
    }

    @Override
    public final Path resolveSibling(Path other) {
        Objects.requireNonNull(other, "other");
        JrtPath parent = this.getParent();
        return parent == null ? other : parent.resolve(other);
    }

    @Override
    public final boolean startsWith(Path other) {
        if (!(Objects.requireNonNull(other) instanceof JrtPath)) {
            return false;
        }
        JrtPath o = (JrtPath)other;
        String tp = this.path;
        String op = o.path;
        if (this.isAbsolute() != o.isAbsolute() || !tp.startsWith(op)) {
            return false;
        }
        int off = op.length();
        if (off == 0) {
            return tp.isEmpty();
        }
        return tp.length() == off || tp.charAt(off) == '/' || off == 0 || op.charAt(off - 1) == '/';
    }

    @Override
    public final boolean endsWith(Path other) {
        int last;
        if (!(Objects.requireNonNull(other) instanceof JrtPath)) {
            return false;
        }
        JrtPath o = (JrtPath)other;
        JrtPath t = this;
        int olast = o.path.length() - 1;
        if (olast > 0 && o.path.charAt(olast) == '/') {
            --olast;
        }
        if ((last = t.path.length() - 1) > 0 && t.path.charAt(last) == '/') {
            --last;
        }
        if (olast == -1) {
            return last == -1;
        }
        if (o.isAbsolute() && (!t.isAbsolute() || olast != last) || last < olast) {
            return false;
        }
        while (olast >= 0) {
            if (o.path.charAt(olast) != t.path.charAt(last)) {
                return false;
            }
            --olast;
            --last;
        }
        return o.path.charAt(olast + 1) == '/' || last == -1 || t.path.charAt(last) == '/';
    }

    @Override
    public final JrtPath resolve(String other) {
        return this.resolve(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public final Path resolveSibling(String other) {
        return this.resolveSibling(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public final boolean startsWith(String other) {
        return this.startsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public final boolean endsWith(String other) {
        return this.endsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public final JrtPath normalize() {
        String res = this.getResolved();
        if (res == this.path) {
            return this;
        }
        return new JrtPath(this.jrtfs, res, true);
    }

    private JrtPath checkPath(Path path) {
        Objects.requireNonNull(path);
        if (!(path instanceof JrtPath)) {
            throw new ProviderMismatchException("path class: " + path.getClass());
        }
        return (JrtPath)path;
    }

    private void initOffsets() {
        if (this.offsets == null) {
            int len = this.path.length();
            int count = 0;
            int off = 0;
            while (off < len) {
                char c;
                if ((c = this.path.charAt(off++)) == '/') continue;
                ++count;
                if ((off = this.path.indexOf(47, off)) != -1) continue;
                break;
            }
            int[] offsets = new int[count];
            count = 0;
            off = 0;
            while (off < len) {
                char c = this.path.charAt(off);
                if (c == '/') {
                    ++off;
                    continue;
                }
                offsets[count++] = off++;
                if ((off = this.path.indexOf(47, off)) != -1) continue;
                break;
            }
            this.offsets = offsets;
        }
    }

    final String getResolvedPath() {
        String r = this.resolved;
        if (r == null) {
            r = this.isAbsolute() ? this.getResolved() : this.toAbsolutePath().getResolvedPath();
            this.resolved = r;
        }
        return r;
    }

    private static String normalize(String path) {
        int len = path.length();
        if (len == 0) {
            return path;
        }
        int prevC = 0;
        for (int i = 0; i < len; ++i) {
            char c = path.charAt(i);
            if (c == '\\' || c == '\u0000') {
                return JrtPath.normalize(path, i);
            }
            if (c == '/' && prevC == 47) {
                return JrtPath.normalize(path, i - 1);
            }
            prevC = c;
        }
        if (prevC == 47 && len > 1) {
            return path.substring(0, len - 1);
        }
        return path;
    }

    private static String normalize(String path, int off) {
        int len = path.length();
        StringBuilder to = new StringBuilder(len);
        to.append(path, 0, off);
        int prevC = 0;
        while (off < len) {
            int c;
            if ((c = path.charAt(off++)) == 92) {
                c = 47;
            }
            if (c == 47 && prevC == 47) continue;
            if (c == 0) {
                throw new InvalidPathException(path, "Path: NUL character not allowed");
            }
            to.append((char)c);
            prevC = c;
        }
        len = to.length();
        if (len > 1 && to.charAt(len - 1) == '/') {
            to.deleteCharAt(len - 1);
        }
        return to.toString();
    }

    private String getResolved() {
        int length = this.path.length();
        if (length == 0 || !this.path.contains("./") && this.path.charAt(length - 1) != '.') {
            return this.path;
        }
        return this.resolvePath();
    }

    private String resolvePath() {
        int length = this.path.length();
        char[] to = new char[length];
        int nc = this.getNameCount();
        int[] lastM = new int[nc];
        int lastMOff = -1;
        int m = 0;
        for (int i = 0; i < nc; ++i) {
            int len;
            int n = this.offsets[i];
            int n2 = len = i == this.offsets.length - 1 ? length - n : this.offsets[i + 1] - n - 1;
            if (len == 1 && this.path.charAt(n) == '.') {
                if (m != 0 || this.path.charAt(0) != '/') continue;
                to[m++] = 47;
                continue;
            }
            if (len == 2 && this.path.charAt(n) == '.' && this.path.charAt(n + 1) == '.') {
                if (lastMOff >= 0) {
                    m = lastM[lastMOff--];
                    continue;
                }
                if (this.path.charAt(0) == '/') {
                    if (m != 0) continue;
                    to[m++] = 47;
                    continue;
                }
                if (m != 0 && to[m - 1] != '/') {
                    to[m++] = 47;
                }
                while (len-- > 0) {
                    to[m++] = this.path.charAt(n++);
                }
                continue;
            }
            if (m == 0 && this.path.charAt(0) == '/' || m != 0 && to[m - 1] != '/') {
                to[m++] = 47;
            }
            lastM[++lastMOff] = m;
            while (len-- > 0) {
                to[m++] = this.path.charAt(n++);
            }
        }
        if (m > 1 && to[m - 1] == '/') {
            --m;
        }
        return m == to.length ? new String(to) : new String(to, 0, m);
    }

    @Override
    public final String toString() {
        return this.path;
    }

    @Override
    public final int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        return obj instanceof JrtPath && this.path.equals(((JrtPath)obj).path);
    }

    @Override
    public final int compareTo(Path other) {
        JrtPath o = this.checkPath(other);
        return this.path.compareTo(o.path);
    }

    @Override
    public final WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) {
        Objects.requireNonNull(watcher, "watcher");
        Objects.requireNonNull(events, "events");
        Objects.requireNonNull(modifiers, "modifiers");
        throw new UnsupportedOperationException();
    }

    @Override
    public final WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) {
        return this.register(watcher, events, new WatchEvent.Modifier[0]);
    }

    @Override
    public final File toFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Iterator<Path> iterator() {
        return new Iterator<Path>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < JrtPath.this.getNameCount();
            }

            @Override
            public Path next() {
                if (this.i < JrtPath.this.getNameCount()) {
                    JrtPath result = JrtPath.this.getName(this.i);
                    ++this.i;
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new ReadOnlyFileSystemException();
            }
        };
    }

    final JrtPath readSymbolicLink() throws IOException {
        if (!this.jrtfs.isLink(this)) {
            throw new IOException("not a symbolic link");
        }
        return this.jrtfs.resolveLink(this);
    }

    final boolean isHidden() {
        return false;
    }

    final void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        this.jrtfs.createDirectory(this, attrs);
    }

    final InputStream newInputStream(OpenOption ... options) throws IOException {
        for (OpenOption opt : options) {
            if (opt == StandardOpenOption.READ) continue;
            throw new UnsupportedOperationException("'" + opt + "' not allowed");
        }
        return this.jrtfs.newInputStream(this);
    }

    final DirectoryStream<Path> newDirectoryStream(DirectoryStream.Filter<? super Path> filter) throws IOException {
        return new JrtDirectoryStream(this, filter);
    }

    final void delete() throws IOException {
        this.jrtfs.deleteFile(this, true);
    }

    final void deleteIfExists() throws IOException {
        this.jrtfs.deleteFile(this, false);
    }

    final JrtFileAttributes getAttributes(LinkOption ... options) throws IOException {
        return this.jrtfs.getFileAttributes(this, options);
    }

    final void setAttribute(String attribute, Object value, LinkOption ... options) throws IOException {
        JrtFileAttributeView.setAttribute(this, attribute, value);
    }

    final Map<String, Object> readAttributes(String attributes, LinkOption ... options) throws IOException {
        return JrtFileAttributeView.readAttributes(this, attributes, options);
    }

    final void setTimes(FileTime mtime, FileTime atime, FileTime ctime) throws IOException {
        this.jrtfs.setTimes(this, mtime, atime, ctime);
    }

    final FileStore getFileStore() throws IOException {
        if (this.exists()) {
            return this.jrtfs.getFileStore(this);
        }
        throw new NoSuchFileException(this.path);
    }

    final boolean isSameFile(Path other) throws IOException {
        if (this == other || this.equals(other)) {
            return true;
        }
        if (other == null || this.getFileSystem() != other.getFileSystem()) {
            return false;
        }
        this.checkAccess(new AccessMode[0]);
        JrtPath o = (JrtPath)other;
        o.checkAccess(new AccessMode[0]);
        return this.getResolvedPath().equals(o.getResolvedPath()) || this.jrtfs.isSameFile(this, o);
    }

    final SeekableByteChannel newByteChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.jrtfs.newByteChannel(this, options, attrs);
    }

    final FileChannel newFileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.jrtfs.newFileChannel(this, options, attrs);
    }

    final void checkAccess(AccessMode ... modes) throws IOException {
        if (modes.length == 0) {
            this.jrtfs.checkNode(this);
        } else {
            boolean w = false;
            block5: for (AccessMode mode : modes) {
                switch (mode) {
                    case READ: {
                        continue block5;
                    }
                    case WRITE: {
                        w = true;
                        continue block5;
                    }
                    case EXECUTE: {
                        throw new AccessDeniedException(this.toString());
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            this.jrtfs.checkNode(this);
            if (w && this.jrtfs.isReadOnly()) {
                throw new AccessDeniedException(this.toString());
            }
        }
    }

    final boolean exists() {
        try {
            return this.jrtfs.exists(this);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    final OutputStream newOutputStream(OpenOption ... options) throws IOException {
        if (options.length == 0) {
            return this.jrtfs.newOutputStream(this, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        return this.jrtfs.newOutputStream(this, options);
    }

    final void move(JrtPath target, CopyOption ... options) throws IOException {
        if (this.jrtfs == target.jrtfs) {
            this.jrtfs.copyFile(true, this, target, options);
        } else {
            this.copyToTarget(target, options);
            this.delete();
        }
    }

    final void copy(JrtPath target, CopyOption ... options) throws IOException {
        if (this.jrtfs == target.jrtfs) {
            this.jrtfs.copyFile(false, this, target, options);
        } else {
            this.copyToTarget(target, options);
        }
    }

    private void copyToTarget(JrtPath target, CopyOption ... options) throws IOException {
        boolean exists;
        boolean replaceExisting = false;
        boolean copyAttrs = false;
        for (CopyOption opt : options) {
            if (opt == StandardCopyOption.REPLACE_EXISTING) {
                replaceExisting = true;
                continue;
            }
            if (opt != StandardCopyOption.COPY_ATTRIBUTES) continue;
            copyAttrs = true;
        }
        JrtFileAttributes jrtfas = this.getAttributes(new LinkOption[0]);
        if (replaceExisting) {
            try {
                target.deleteIfExists();
                exists = false;
            }
            catch (DirectoryNotEmptyException x) {
                exists = true;
            }
        } else {
            exists = target.exists();
        }
        if (exists) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (jrtfas.isDirectory()) {
            target.createDirectory(new FileAttribute[0]);
        } else {
            try (InputStream is = this.jrtfs.newInputStream(this);
                 OutputStream os = target.newOutputStream(new OpenOption[0]);){
                int n;
                byte[] buf = new byte[8192];
                while ((n = is.read(buf)) != -1) {
                    os.write(buf, 0, n);
                }
            }
        }
        if (copyAttrs) {
            BasicFileAttributeView view = Files.getFileAttributeView(target, BasicFileAttributeView.class, new LinkOption[0]);
            try {
                view.setTimes(jrtfas.lastModifiedTime(), jrtfas.lastAccessTime(), jrtfas.creationTime());
            }
            catch (IOException x) {
                try {
                    target.delete();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw x;
            }
        }
    }

    private static URI toUri(String str) {
        char[] path = str.toCharArray();
        assert (path[0] == '/');
        StringBuilder sb = new StringBuilder();
        sb.append(path[0]);
        for (int i = 1; i < path.length; ++i) {
            char c = (char)(path[i] & 0xFF);
            if (JrtPath.match(c, L_PATH, H_PATH)) {
                sb.append(c);
                continue;
            }
            sb.append('%');
            sb.append(hexDigits[c >> 4 & 0xF]);
            sb.append(hexDigits[c & 0xF]);
        }
        try {
            return new URI("jrt:" + sb.toString());
        }
        catch (URISyntaxException x) {
            throw new AssertionError((Object)x);
        }
    }

    private static long lowMask(String chars) {
        int n = chars.length();
        long m = 0L;
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c >= '@') continue;
            m |= 1L << c;
        }
        return m;
    }

    private static long highMask(String chars) {
        int n = chars.length();
        long m = 0L;
        for (int i = 0; i < n; ++i) {
            char c = chars.charAt(i);
            if (c < '@' || c >= '\u0080') continue;
            m |= 1L << c - 64;
        }
        return m;
    }

    private static long lowMask(char first, char last) {
        long m = 0L;
        int f = Math.max(Math.min(first, 63), 0);
        int l = Math.max(Math.min(last, 63), 0);
        for (int i = f; i <= l; ++i) {
            m |= 1L << i;
        }
        return m;
    }

    private static long highMask(char first, char last) {
        long m = 0L;
        int f = Math.max(Math.min(first, 127), 64) - 64;
        int l = Math.max(Math.min(last, 127), 64) - 64;
        for (int i = f; i <= l; ++i) {
            m |= 1L << i;
        }
        return m;
    }

    private static boolean match(char c, long lowMask, long highMask) {
        if (c < '@') {
            return (1L << c & lowMask) != 0L;
        }
        if (c < '\u0080') {
            return (1L << c - 64 & highMask) != 0L;
        }
        return false;
    }
}

