/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.languagetool.server.TooManyRequestsException;

class RequestLimiter {
    static final int REQUEST_QUEUE_SIZE = 1000;
    final List<RequestEvent> requestEvents = new CopyOnWriteArrayList<RequestEvent>();
    private final int requestLimit;
    private final int requestLimitInBytes;
    private final int requestLimitPeriodInSeconds;

    RequestLimiter(int requestLimit, int requestLimitInBytes, int requestLimitPeriodInSeconds) {
        this.requestLimit = requestLimit;
        this.requestLimitInBytes = requestLimitInBytes;
        this.requestLimitPeriodInSeconds = requestLimitPeriodInSeconds;
    }

    int getRequestLimit() {
        return this.requestLimit;
    }

    int getRequestLimitInBytes() {
        return this.requestLimitInBytes;
    }

    int getRequestLimitPeriodInSeconds() {
        return this.requestLimitPeriodInSeconds;
    }

    void checkAccess(String ipAddress, Map<String, String> parameters) {
        int reqSize = this.getRequestSize(parameters);
        while (this.requestEvents.size() > 1000) {
            this.requestEvents.remove(0);
        }
        this.requestEvents.add(new RequestEvent(ipAddress, new Date(), reqSize));
        this.checkLimit(ipAddress);
    }

    private int getRequestSize(Map<String, String> params) {
        String text = params.get("text");
        if (text != null) {
            return text.length();
        }
        String data = params.get("data");
        if (data != null) {
            return data.length();
        }
        return 0;
    }

    void checkLimit(String ipAddress) {
        int requestsByIp = 0;
        int requestSizeByIp = 0;
        Date thresholdDate = new Date(System.currentTimeMillis() - (long)(this.requestLimitPeriodInSeconds * 1000));
        for (RequestEvent requestEvent : this.requestEvents) {
            if (!requestEvent.ip.equals(ipAddress) || !requestEvent.date.after(thresholdDate)) continue;
            if (this.requestLimit > 0 && ++requestsByIp > this.requestLimit) {
                throw new TooManyRequestsException("Request limit of " + this.requestLimit + " requests per " + this.requestLimitPeriodInSeconds + " seconds exceeded");
            }
            if (this.requestLimitInBytes <= 0 || (requestSizeByIp += requestEvent.getSizeInBytes()) <= this.requestLimitInBytes) continue;
            throw new TooManyRequestsException("Request size limit of " + this.requestLimitInBytes + " bytes per " + this.requestLimitPeriodInSeconds + " seconds exceeded");
        }
    }

    protected static class RequestEvent {
        private final String ip;
        private final Date date;
        private final int sizeInBytes;

        RequestEvent(String ip, Date date, int sizeInBytes) {
            this.ip = ip;
            this.date = new Date(date.getTime());
            this.sizeInBytes = sizeInBytes;
        }

        protected Date getDate() {
            return this.date;
        }

        int getSizeInBytes() {
            return this.sizeInBytes;
        }
    }
}

