/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.markup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.TextPart;

public class AnnotatedTextBuilder {
    private final List<TextPart> parts = new ArrayList<TextPart>();
    private final Map<AnnotatedText.MetaDataKey, String> metaData = new HashMap<AnnotatedText.MetaDataKey, String>();
    private final Map<String, String> customMetaData = new HashMap<String, String>();

    public AnnotatedTextBuilder addGlobalMetaData(AnnotatedText.MetaDataKey key, String value) {
        this.metaData.put(key, value);
        return this;
    }

    public AnnotatedTextBuilder addGlobalMetaData(String key, String value) {
        this.customMetaData.put(key, value);
        return this;
    }

    public AnnotatedTextBuilder addText(String text) {
        this.parts.add(new TextPart(text, TextPart.Type.TEXT));
        return this;
    }

    public AnnotatedTextBuilder addMarkup(String markup) {
        this.parts.add(new TextPart(markup, TextPart.Type.MARKUP));
        return this;
    }

    public AnnotatedTextBuilder addMarkup(String markup, String interpretAs) {
        this.parts.add(new TextPart(markup, TextPart.Type.MARKUP));
        this.parts.add(new TextPart(interpretAs, TextPart.Type.FAKE_CONTENT));
        return this;
    }

    public AnnotatedText build() {
        int plainTextPosition = 0;
        int totalPosition = 0;
        HashMap<Integer, Integer> mapping = new HashMap<Integer, Integer>();
        mapping.put(0, 0);
        for (TextPart part : this.parts) {
            if (part.getType() == TextPart.Type.TEXT) {
                plainTextPosition += part.getPart().length();
                totalPosition += part.getPart().length();
            } else if (part.getType() == TextPart.Type.MARKUP) {
                totalPosition += part.getPart().length();
            } else if (part.getType() == TextPart.Type.FAKE_CONTENT) {
                plainTextPosition += part.getPart().length();
            }
            mapping.put(plainTextPosition, totalPosition);
        }
        return new AnnotatedText(this.parts, mapping, this.metaData, this.customMetaData);
    }
}

