/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.LinguServices;
import org.languagetool.UserConfig;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class ReadabilityRule
extends TextLevelRule {
    private static final int MARK_DISTANCE = 10;
    private static final int MIN_WORDS = 10;
    private final LinguServices linguServices;
    private final Language lang;
    private int level;
    private boolean tooEasyTest;

    public ReadabilityRule(ResourceBundle messages, Language lang, UserConfig userConfig, boolean tooEasyTest) {
        this(messages, lang, userConfig, tooEasyTest, -1, false);
    }

    public ReadabilityRule(ResourceBundle messages, Language lang, UserConfig userConfig, boolean tooEasyTest, int level) {
        this(messages, lang, userConfig, tooEasyTest, level, false);
    }

    public ReadabilityRule(ResourceBundle messages, Language lang, UserConfig userConfig, boolean tooEasyTest, boolean defaultOn) {
        this(messages, lang, userConfig, tooEasyTest, -1, defaultOn);
    }

    public ReadabilityRule(ResourceBundle messages, Language lang, UserConfig userConfig, boolean tooEasyTest, int level, boolean defaultOn) {
        super(messages);
        super.setCategory(new Category(new CategoryId("TEXT_ANALYSIS"), "Text Analysis", Category.Location.INTERNAL, false));
        this.setLocQualityIssueType(ITSIssueType.Style);
        if (!defaultOn) {
            this.setDefaultOff();
        }
        this.lang = lang;
        this.tooEasyTest = tooEasyTest;
        if (userConfig != null) {
            int lv;
            this.linguServices = userConfig.getLinguServices();
            this.level = level >= 0 ? level : ((lv = userConfig.getConfigValueByID(this.getId())) >= 0 ? lv : (tooEasyTest ? 4 : 2));
        } else {
            this.linguServices = null;
        }
    }

    @Override
    public String getId() {
        if (this.tooEasyTest) {
            return "READABILITY_RULE_SIMPLE";
        }
        return "READABILITY_RULE_DIFFICULT";
    }

    @Override
    public String getDescription() {
        if (this.tooEasyTest) {
            return "Readability: Too easy text";
        }
        return "Readability: Too difficult text";
    }

    @Override
    public int getDefaultValue() {
        return this.tooEasyTest ? 4 : 2;
    }

    @Override
    public boolean hasConfigurableValue() {
        return true;
    }

    @Override
    public int getMinConfigurableValue() {
        return 0;
    }

    @Override
    public int getMaxConfigurableValue() {
        return 6;
    }

    @Override
    public String getConfigureText() {
        return "Level of readability 0 (very difficult) to 6 (very easy):";
    }

    private static String printMessageLevel(int level) {
        String sLevel = null;
        if (level == 0) {
            sLevel = "Very difficult";
        } else if (level == 1) {
            sLevel = "Difficult";
        } else if (level == 2) {
            sLevel = "Fairly difficult";
        } else if (level == 3) {
            sLevel = "Medium";
        } else if (level == 4) {
            sLevel = "Fairly easy";
        } else if (level == 5) {
            sLevel = "Easy";
        } else if (level == 6) {
            sLevel = "Very easy";
        }
        if (sLevel != null) {
            return " {Level " + level + ": " + sLevel + "}";
        }
        return "";
    }

    protected String getMessage(int level, int FRE, int ASL, int ASW) {
        String few;
        String simple;
        if (this.tooEasyTest) {
            simple = "simple";
            few = "few";
        } else {
            simple = "difficult";
            few = "many";
        }
        return "Readability: The text of this paragraph is too " + simple + ReadabilityRule.printMessageLevel(level) + ". Too " + few + " words per sentence and too " + few + " syllables per word.";
    }

    private int getReadabilityLevel(double FRE) {
        if (FRE < 30.0) {
            return 0;
        }
        if (FRE < 50.0) {
            return 1;
        }
        if (FRE < 60.0) {
            return 2;
        }
        if (FRE < 70.0) {
            return 3;
        }
        if (FRE < 80.0) {
            return 4;
        }
        if (FRE < 90.0) {
            return 5;
        }
        return 6;
    }

    protected double getFleschReadingEase(double ASL, double ASW) {
        return 206.835 - 1.015 * ASL - 84.6 * ASW;
    }

    private static boolean isVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' || c == 'y' || c == 'A' || c == 'E' || c == 'I' || c == 'O' || c == 'U' || c == 'Y';
    }

    protected int simpleSyllablesCount(String word) {
        if (word.length() == 0) {
            return 0;
        }
        if (word.length() == 1) {
            return 1;
        }
        int nSyllables = 0;
        boolean lastDouble = false;
        for (int i = 0; i < word.length() - 1; ++i) {
            char c = word.charAt(i);
            if (ReadabilityRule.isVowel(c)) {
                char cn = word.charAt(i + 1);
                if (lastDouble) {
                    ++nSyllables;
                    lastDouble = false;
                    continue;
                }
                if (!((c != 'e' && c != 'E' || cn != 'a' && cn != 'o' && cn != 'e' && cn != 'i' && cn != 'y') && (c != 'a' && c != 'A' || cn != 'e' && cn != 'i' && cn != 'u') && (c != 'o' && c != 'O' || cn != 'o' && cn != 'i' && cn != 'u' && cn != 'a') && (c != 'u' && c != 'U' || cn != 'i' && cn != 'a') && (c != 'i' && c != 'I' || cn != 'e' && cn != 'o'))) {
                    lastDouble = true;
                    continue;
                }
                ++nSyllables;
                lastDouble = false;
                continue;
            }
            lastDouble = false;
        }
        char c = word.charAt(word.length() - 1);
        char cl = word.charAt(word.length() - 2);
        if (cl == 'e' && (c == 's' || c == 'd') || cl == 'u' && c == 'e') {
            --nSyllables;
        } else if (ReadabilityRule.isVowel(c) && c != 'e') {
            ++nSyllables;
        }
        return nSyllables <= 0 ? 1 : nSyllables;
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int nSentences = 0;
        int nWords = 0;
        int nSyllables = 0;
        int pos = 0;
        int startPos = 0;
        int endPos = 0;
        for (int n = 0; n < sentences.size(); ++n) {
            AnalyzedSentence sentence = sentences.get(n);
            AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
            if (nSentences == 0) {
                startPos = pos + tokens[1].getStartPos();
            }
            ++nSentences;
            for (AnalyzedTokenReadings token : tokens) {
                String sToken = token.getToken();
                if (token.isWhitespace() || token.isNonWord()) continue;
                ++nWords;
                if (this.linguServices == null) {
                    nSyllables += this.simpleSyllablesCount(sToken);
                    continue;
                }
                nSyllables += this.linguServices.getNumberOfSyllables(sToken, this.lang.getDefaultLanguageVariant());
            }
            if (sentence.hasParagraphEndMark(this.lang) || n == sentences.size() - 1) {
                if (nWords >= 10) {
                    RuleMatch ruleMatch;
                    String msg;
                    endPos = pos + tokens[tokens.length - 1].getEndPos();
                    double ASL = (double)nWords / (double)nSentences;
                    double ASW = (double)nSyllables / (double)nWords;
                    double FRE = this.getFleschReadingEase(ASL, ASW);
                    int rLevel = this.getReadabilityLevel(FRE);
                    endPos = pos + sentence.getText().length();
                    if (this.tooEasyTest && rLevel > this.level) {
                        msg = this.getMessage(rLevel, (int)FRE, (int)ASL, (int)ASW);
                        ruleMatch = new RuleMatch(this, startPos, startPos + 10, msg);
                        ruleMatches.add(ruleMatch);
                        msg = this.getMessage(rLevel, (int)FRE, (int)ASL, (int)ASW);
                        ruleMatch = new RuleMatch(this, endPos - 10, endPos, msg);
                        ruleMatches.add(ruleMatch);
                    } else if (!this.tooEasyTest && rLevel < this.level) {
                        msg = this.getMessage(rLevel, (int)FRE, (int)ASL, (int)ASW);
                        ruleMatch = new RuleMatch(this, startPos, startPos + 10, msg);
                        ruleMatches.add(ruleMatch);
                        msg = this.getMessage(rLevel, (int)FRE, (int)ASL, (int)ASW);
                        ruleMatch = new RuleMatch(this, endPos - 10, endPos, msg);
                        ruleMatches.add(ruleMatch);
                    }
                }
                nSentences = 0;
                nWords = 0;
                nSyllables = 0;
            }
            pos += sentence.getText().length();
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

