/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.morfologik.MorfologikMultiSpeller;
import org.languagetool.rules.spelling.morfologik.suggestions_ordering.SuggestionsOrdererGSoC;
import org.languagetool.rules.spelling.suggestions.SuggestionsChanges;
import org.languagetool.rules.spelling.suggestions.SuggestionsOrderer;
import org.languagetool.rules.spelling.suggestions.SuggestionsOrdererFeatureExtractor;
import org.languagetool.rules.spelling.suggestions.XGBoostSuggestionsOrderer;
import org.languagetool.tools.Tools;

public abstract class MorfologikSpellerRule
extends SpellingCheckRule {
    protected MorfologikMultiSpeller speller1;
    protected MorfologikMultiSpeller speller2;
    protected MorfologikMultiSpeller speller3;
    protected Locale conversionLocale;
    private final SuggestionsOrderer suggestionsOrderer;
    private final boolean runningExperiment;
    private boolean ignoreTaggedWords = false;
    private boolean checkCompound = false;
    private Pattern compoundRegex = Pattern.compile("-");
    private final UserConfig userConfig;

    public abstract String getFileName();

    @Override
    public abstract String getId();

    public MorfologikSpellerRule(ResourceBundle messages, Language language) throws IOException {
        this(messages, language, null);
    }

    public MorfologikSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig) throws IOException {
        this(messages, language, userConfig, Collections.emptyList());
    }

    public MorfologikSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        this(messages, language, userConfig, altLanguages, null);
    }

    public MorfologikSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages, LanguageModel languageModel) throws IOException {
        super(messages, language, userConfig, altLanguages, languageModel);
        this.userConfig = userConfig;
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.conversionLocale = this.conversionLocale != null ? this.conversionLocale : Locale.getDefault();
        this.init();
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        if (SuggestionsChanges.isRunningExperiment("NewSuggestionsOrderer")) {
            this.suggestionsOrderer = new SuggestionsOrdererFeatureExtractor(language, this.languageModel);
            this.runningExperiment = true;
        } else if (SuggestionsChanges.isRunningExperiment("SuggestionsOrdererGSOC")) {
            this.suggestionsOrderer = new SuggestionsOrdererGSoC(language, this.languageModel, this.getId());
            this.runningExperiment = true;
        } else {
            this.runningExperiment = false;
            this.suggestionsOrderer = new XGBoostSuggestionsOrderer(language, languageModel);
        }
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_spelling");
    }

    public void setLocale(Locale locale) {
        this.conversionLocale = locale;
    }

    public void setIgnoreTaggedWords() {
        this.ignoreTaggedWords = true;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        if (this.speller1 == null) {
            String binaryDict = null;
            if (JLanguageTool.getDataBroker().resourceExists(this.getFileName())) {
                binaryDict = this.getFileName();
            } else if (Files.exists(Paths.get(this.getFileName(), new String[0]), new LinkOption[0])) {
                binaryDict = this.getFileName();
            }
            if (binaryDict != null) {
                this.initSpeller(binaryDict);
            } else {
                return this.toRuleMatchArray(ruleMatches);
            }
        }
        int idx = -1;
        for (AnalyzedTokenReadings token : tokens) {
            if (this.canBeIgnored(tokens, ++idx, token)) continue;
            String word = token.getAnalyzedToken(0).getToken();
            int startPos = token.getStartPos();
            if (this.tokenizingPattern() == null) {
                ruleMatches.addAll(this.getRuleMatches(word, startPos, sentence, ruleMatches));
                continue;
            }
            int index = 0;
            Matcher m = this.tokenizingPattern().matcher(word);
            while (m.find()) {
                String match = word.subSequence(index, m.start()).toString();
                ruleMatches.addAll(this.getRuleMatches(match, startPos + index, sentence, ruleMatches));
                index = m.end();
            }
            if (index == 0) {
                ruleMatches.addAll(this.getRuleMatches(word, startPos, sentence, ruleMatches));
                continue;
            }
            ruleMatches.addAll(this.getRuleMatches(word.subSequence(index, word.length()).toString(), startPos + index, sentence, ruleMatches));
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private void initSpeller(String binaryDict) throws IOException {
        String plainTextDict = null;
        String languageVariantPlainTextDict = null;
        if (this.getSpellingFileName() != null && JLanguageTool.getDataBroker().resourceExists(this.getSpellingFileName())) {
            plainTextDict = this.getSpellingFileName();
        }
        if (this.getLanguageVariantSpellingFileName() != null && JLanguageTool.getDataBroker().resourceExists(this.getLanguageVariantSpellingFileName())) {
            languageVariantPlainTextDict = this.getLanguageVariantSpellingFileName();
        }
        this.speller1 = new MorfologikMultiSpeller(binaryDict, plainTextDict, languageVariantPlainTextDict, this.userConfig, 1);
        this.speller2 = new MorfologikMultiSpeller(binaryDict, plainTextDict, languageVariantPlainTextDict, this.userConfig, 2);
        this.speller3 = new MorfologikMultiSpeller(binaryDict, plainTextDict, languageVariantPlainTextDict, this.userConfig, 3);
        this.setConvertsCase(this.speller1.convertsCase());
    }

    private boolean canBeIgnored(AnalyzedTokenReadings[] tokens, int idx, AnalyzedTokenReadings token) throws IOException {
        return token.isSentenceStart() || token.isImmunized() || token.isIgnoredBySpeller() || this.isUrl(token.getToken()) || this.isEMail(token.getToken()) || this.ignoreTaggedWords && token.isTagged() || this.ignoreToken(tokens, idx);
    }

    protected boolean isMisspelled(MorfologikMultiSpeller speller, String word) {
        if (!speller.isMisspelled(word)) {
            return false;
        }
        if (this.checkCompound && this.compoundRegex.matcher(word).find()) {
            String[] words;
            for (String singleWord : words = this.compoundRegex.split(word)) {
                if (!speller.isMisspelled(singleWord)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected List<RuleMatch> getRuleMatches(String word, int startPos, AnalyzedSentence sentence, List<RuleMatch> ruleMatchesSoFar) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (this.isMisspelled(this.speller1, word) || this.isProhibited(word)) {
            boolean fullResults;
            RuleMatch ruleMatch;
            Language acceptingLanguage = this.acceptedInAlternativeLanguage(word);
            if (acceptingLanguage != null) {
                ruleMatch = new RuleMatch(this, sentence, startPos, startPos + word.length(), Tools.i18n(this.messages, "accepted_in_alt_language", word, this.messages.getString(acceptingLanguage.getShortCode())));
                ruleMatch.setType(RuleMatch.Type.Hint);
            } else {
                ruleMatch = new RuleMatch(this, sentence, startPos, startPos + word.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
            }
            boolean bl = fullResults = SuggestionsChanges.getInstance() != null && SuggestionsChanges.getInstance().getCurrentExperiment() != null && (Boolean)SuggestionsChanges.getInstance().getCurrentExperiment().parameters.getOrDefault("fullSuggestionCandidates", Boolean.FALSE) != false;
            if (this.userConfig == null || this.userConfig.getMaxSpellingSuggestions() == 0 || ruleMatchesSoFar.size() <= this.userConfig.getMaxSpellingSuggestions()) {
                List<String> defaultSuggestions = this.speller1.getSuggestionsFromDefaultDicts(word);
                List<String> userSuggestions = this.speller1.getSuggestionsFromUserDicts(word);
                if (word.length() >= 3 && (fullResults || defaultSuggestions.isEmpty())) {
                    defaultSuggestions.addAll(this.speller2.getSuggestionsFromDefaultDicts(word));
                    userSuggestions.addAll(this.speller2.getSuggestionsFromUserDicts(word));
                    if (word.length() >= 5 && (fullResults || defaultSuggestions.isEmpty())) {
                        defaultSuggestions.addAll(this.speller3.getSuggestionsFromDefaultDicts(word));
                        userSuggestions.addAll(this.speller3.getSuggestionsFromUserDicts(word));
                    }
                }
                defaultSuggestions.addAll(0, this.getAdditionalTopSuggestions(defaultSuggestions, word));
                defaultSuggestions.addAll(this.getAdditionalSuggestions(defaultSuggestions, word));
                if (!defaultSuggestions.isEmpty() || !userSuggestions.isEmpty()) {
                    this.filterSuggestions(defaultSuggestions);
                    this.filterDupes(userSuggestions);
                    defaultSuggestions = this.orderSuggestions(defaultSuggestions, word);
                    if (this.runningExperiment) {
                        MorfologikSpellerRule.addSuggestionsToRuleMatch(word, userSuggestions, defaultSuggestions, this.suggestionsOrderer, ruleMatch);
                    } else if (this.userConfig != null && this.userConfig.getAbTest() != null && this.userConfig.getAbTest().equals("SuggestionsRanker") && this.suggestionsOrderer.isMlAvailable() && this.userConfig.getTextSessionId() != null) {
                        boolean testingA;
                        boolean bl2 = testingA = this.userConfig.getTextSessionId() % 2L == 0L;
                        if (testingA) {
                            MorfologikSpellerRule.addSuggestionsToRuleMatch(word, userSuggestions, defaultSuggestions, null, ruleMatch);
                        } else {
                            MorfologikSpellerRule.addSuggestionsToRuleMatch(word, userSuggestions, defaultSuggestions, this.suggestionsOrderer, ruleMatch);
                        }
                    } else {
                        MorfologikSpellerRule.addSuggestionsToRuleMatch(word, userSuggestions, defaultSuggestions, null, ruleMatch);
                    }
                }
            } else {
                ruleMatch.setSuggestedReplacement(this.messages.getString("too_many_errors"));
            }
            ruleMatches.add(ruleMatch);
        }
        return ruleMatches;
    }

    @Nullable
    public Pattern tokenizingPattern() {
        return null;
    }

    protected List<String> orderSuggestions(List<String> suggestions, String word) {
        return suggestions;
    }

    private List<String> orderSuggestions(List<String> suggestions, String word, AnalyzedSentence sentence, int startPos) {
        List<String> orderedSuggestions;
        if (this.userConfig != null && this.userConfig.getAbTest() != null && this.userConfig.getAbTest().equals("SuggestionsOrderer") && this.suggestionsOrderer.isMlAvailable() && this.userConfig.getTextSessionId() != null) {
            boolean logGroup;
            boolean bl = logGroup = Math.random() < 0.01;
            if (logGroup) {
                System.out.print("Running A/B-Test for SuggestionsOrderer ->");
            }
            if (this.userConfig.getTextSessionId() % 2L == 0L) {
                if (logGroup) {
                    System.out.println("in group A (using new ordering)");
                }
                orderedSuggestions = this.suggestionsOrderer.orderSuggestionsUsingModel(suggestions, word, sentence, startPos);
            } else {
                if (logGroup) {
                    System.out.println("in group B (using old ordering)");
                }
                orderedSuggestions = this.orderSuggestions(suggestions, word);
            }
        } else {
            orderedSuggestions = this.suggestionsOrderer.isMlAvailable() ? this.suggestionsOrderer.orderSuggestionsUsingModel(suggestions, word, sentence, startPos) : this.orderSuggestions(suggestions, word);
        }
        return orderedSuggestions;
    }

    protected void setCheckCompound(boolean checkCompound) {
        this.checkCompound = checkCompound;
    }

    protected void setCompoundRegex(String compoundRegex) {
        this.compoundRegex = Pattern.compile(compoundRegex);
    }

    protected boolean isSurrogatePairCombination(String word) {
        if (word.length() > 1 && word.length() % 2 == 0 && word.codePointCount(0, word.length()) != word.length()) {
            boolean isSurrogatePairCombination = true;
            for (int i = 0; i < word.length() && isSurrogatePairCombination; isSurrogatePairCombination &= Character.isSurrogatePair(word.charAt(i), word.charAt(i + 1)), i += 2) {
            }
            return isSurrogatePairCombination;
        }
        return false;
    }

    @Override
    protected boolean ignoreWord(String word) throws IOException {
        return super.ignoreWord(word) || this.isSurrogatePairCombination(word);
    }
}

