/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.NotNull;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.IntArray;
import com.esotericsoftware.kryo.util.ObjectMap;
import com.esotericsoftware.kryo.util.Util;
import com.esotericsoftware.minlog.Log;
import com.esotericsoftware.reflectasm.FieldAccess;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldSerializer<T>
extends Serializer<T>
implements Comparator<CachedField> {
    final Kryo kryo;
    final Class type;
    private CachedField[] fields = new CachedField[0];
    Object access;
    private boolean fieldsCanBeNull = true;
    private boolean setFieldsAsAccessible = true;
    private boolean ignoreSyntheticFields = true;
    private boolean fixedFieldTypes;

    public FieldSerializer(Kryo kryo, Class type) {
        this.kryo = kryo;
        this.type = type;
        this.rebuildCachedFields();
    }

    private void rebuildCachedFields() {
        if (this.type.isInterface()) {
            this.fields = new CachedField[0];
            return;
        }
        ArrayList allFields = new ArrayList();
        for (Class nextClass = this.type; nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            Collections.addAll(allFields, nextClass.getDeclaredFields());
        }
        ObjectMap context = this.kryo.getContext();
        IntArray useAsm = new IntArray();
        ArrayList<Field> validFields = new ArrayList<Field>(allFields.size());
        int n = allFields.size();
        for (int i = 0; i < n; ++i) {
            Optional optional;
            Field field = (Field)allFields.get(i);
            int modifiers = field.getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers) || field.isSynthetic() && this.ignoreSyntheticFields) continue;
            if (!field.isAccessible()) {
                if (!this.setFieldsAsAccessible) continue;
                try {
                    field.setAccessible(true);
                }
                catch (AccessControlException ex) {
                    continue;
                }
            }
            if ((optional = field.getAnnotation(Optional.class)) != null && !context.containsKey(optional.value())) continue;
            validFields.add(field);
            useAsm.add(!Modifier.isFinal(modifiers) && Modifier.isPublic(modifiers) && Modifier.isPublic(field.getType().getModifiers()) ? 1 : 0);
        }
        if (!Util.isAndroid && Modifier.isPublic(this.type.getModifiers()) && useAsm.indexOf(1) != -1) {
            try {
                this.access = FieldAccess.get(this.type);
            }
            catch (RuntimeException ignored) {
                // empty catch block
            }
        }
        ArrayList<CachedField> cachedFields = new ArrayList<CachedField>(validFields.size());
        int n2 = validFields.size();
        for (int i = 0; i < n2; ++i) {
            Field field = (Field)validFields.get(i);
            int accessIndex = -1;
            if (this.access != null && useAsm.get(i) == 1) {
                accessIndex = ((FieldAccess)this.access).getIndex(field.getName());
            }
            cachedFields.add(this.newCachedField(field, cachedFields.size(), accessIndex));
        }
        Collections.sort(cachedFields, this);
        this.fields = cachedFields.toArray(new CachedField[cachedFields.size()]);
        this.initializeCachedFields();
    }

    protected void initializeCachedFields() {
    }

    private CachedField newCachedField(Field field, int fieldIndex, int accessIndex) {
        CachedField cachedField;
        Class<?> fieldClass = field.getType();
        if (accessIndex != -1) {
            cachedField = fieldClass.isPrimitive() ? (fieldClass == Boolean.TYPE ? new BooleanField() : (fieldClass == Byte.TYPE ? new ByteField() : (fieldClass == Character.TYPE ? new CharField() : (fieldClass == Short.TYPE ? new ShortField() : (fieldClass == Integer.TYPE ? new IntField() : (fieldClass == Long.TYPE ? new LongField() : (fieldClass == Float.TYPE ? new FloatField() : (fieldClass == Double.TYPE ? new DoubleField() : new ObjectField())))))))) : (!(fieldClass != String.class || this.kryo.getReferences() && this.kryo.getReferenceResolver().useReferences(String.class)) ? new StringField() : new ObjectField());
        } else {
            cachedField = new ObjectField();
            cachedField.generics = Kryo.getGenerics(field.getGenericType());
        }
        cachedField.field = field;
        cachedField.accessIndex = accessIndex;
        boolean bl = cachedField.canBeNull = this.fieldsCanBeNull && !fieldClass.isPrimitive() && !field.isAnnotationPresent(NotNull.class);
        if (this.kryo.isFinal(fieldClass) || this.fixedFieldTypes) {
            cachedField.valueClass = fieldClass;
        }
        return cachedField;
    }

    @Override
    public int compare(CachedField o1, CachedField o2) {
        return o1.field.getName().compareTo(o2.field.getName());
    }

    public void setFieldsCanBeNull(boolean fieldsCanBeNull) {
        this.fieldsCanBeNull = fieldsCanBeNull;
        this.rebuildCachedFields();
    }

    public void setFieldsAsAccessible(boolean setFieldsAsAccessible) {
        this.setFieldsAsAccessible = setFieldsAsAccessible;
        this.rebuildCachedFields();
    }

    public void setIgnoreSyntheticFields(boolean ignoreSyntheticFields) {
        this.ignoreSyntheticFields = ignoreSyntheticFields;
        this.rebuildCachedFields();
    }

    public void setFixedFieldTypes(boolean fixedFieldTypes) {
        this.fixedFieldTypes = fixedFieldTypes;
        this.rebuildCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        CachedField[] fields = this.fields;
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            fields[i].write(output, object);
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> type) {
        T object = this.create(kryo, input, type);
        kryo.reference(object);
        CachedField[] fields = this.fields;
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            fields[i].read(input, object);
        }
        return object;
    }

    protected T create(Kryo kryo, Input input, Class<T> type) {
        return kryo.newInstance(type);
    }

    public CachedField getField(String fieldName) {
        for (CachedField cachedField : this.fields) {
            if (!cachedField.field.getName().equals(fieldName)) continue;
            return cachedField;
        }
        throw new IllegalArgumentException("Field \"" + fieldName + "\" not found on class: " + this.type.getName());
    }

    public void removeField(String fieldName) {
        for (int i = 0; i < this.fields.length; ++i) {
            CachedField cachedField = this.fields[i];
            if (!cachedField.field.getName().equals(fieldName)) continue;
            CachedField[] newFields = new CachedField[this.fields.length - 1];
            System.arraycopy(this.fields, 0, newFields, 0, i);
            System.arraycopy(this.fields, i + 1, newFields, i, newFields.length - i);
            this.fields = newFields;
            return;
        }
        throw new IllegalArgumentException("Field \"" + fieldName + "\" not found on class: " + this.type.getName());
    }

    public CachedField[] getFields() {
        return this.fields;
    }

    public Class getType() {
        return this.type;
    }

    protected T createCopy(Kryo kryo, T original) {
        return (T)kryo.newInstance(original.getClass());
    }

    @Override
    public T copy(Kryo kryo, T original) {
        T copy = this.createCopy(kryo, original);
        kryo.reference(copy);
        int n = this.fields.length;
        for (int i = 0; i < n; ++i) {
            this.fields[i].copy(original, copy);
        }
        return copy;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Optional {
        public String value();
    }

    class ObjectField
    extends CachedField {
        Class[] generics;

        ObjectField() {
        }

        public void write(Output output, Object object) {
            try {
                if (Log.TRACE) {
                    Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                }
                Object value = this.accessIndex != -1 ? ((FieldAccess)FieldSerializer.this.access).get(object, this.accessIndex) : this.field.get(object);
                Serializer serializer = this.serializer;
                if (this.valueClass == null) {
                    if (value == null) {
                        FieldSerializer.this.kryo.writeClass(output, null);
                        return;
                    }
                    Registration registration = FieldSerializer.this.kryo.writeClass(output, value.getClass());
                    if (serializer == null) {
                        serializer = registration.getSerializer();
                    }
                    if (this.generics != null) {
                        serializer.setGenerics(FieldSerializer.this.kryo, this.generics);
                    }
                    FieldSerializer.this.kryo.writeObject(output, value, serializer);
                } else {
                    if (serializer == null) {
                        this.serializer = serializer = FieldSerializer.this.kryo.getSerializer(this.valueClass);
                    }
                    if (this.generics != null) {
                        serializer.setGenerics(FieldSerializer.this.kryo, this.generics);
                    }
                    if (this.canBeNull) {
                        FieldSerializer.this.kryo.writeObjectOrNull(output, value, serializer);
                    } else {
                        if (value == null) {
                            throw new KryoException("Field value is null but canBeNull is false: " + this + " (" + object.getClass().getName() + ")");
                        }
                        FieldSerializer.this.kryo.writeObject(output, value, serializer);
                    }
                }
            }
            catch (IllegalAccessException ex) {
                throw new KryoException("Error accessing field: " + this + " (" + object.getClass().getName() + ")", ex);
            }
            catch (KryoException ex) {
                ex.addTrace(this + " (" + object.getClass().getName() + ")");
                throw ex;
            }
            catch (RuntimeException runtimeEx) {
                KryoException ex = new KryoException(runtimeEx);
                ex.addTrace(this + " (" + object.getClass().getName() + ")");
                throw ex;
            }
        }

        public void read(Input input, Object object) {
            try {
                Object value;
                if (Log.TRACE) {
                    Log.trace("kryo", "Read field: " + this + " (" + FieldSerializer.this.type.getName() + ")");
                }
                Class concreteType = this.valueClass;
                Serializer serializer = this.serializer;
                if (concreteType == null) {
                    Registration registration = FieldSerializer.this.kryo.readClass(input);
                    if (registration == null) {
                        value = null;
                    } else {
                        if (serializer == null) {
                            serializer = registration.getSerializer();
                        }
                        if (this.generics != null) {
                            serializer.setGenerics(FieldSerializer.this.kryo, this.generics);
                        }
                        value = FieldSerializer.this.kryo.readObject(input, registration.getType(), serializer);
                    }
                } else {
                    if (serializer == null) {
                        this.serializer = serializer = FieldSerializer.this.kryo.getSerializer(this.valueClass);
                    }
                    if (this.generics != null) {
                        serializer.setGenerics(FieldSerializer.this.kryo, this.generics);
                    }
                    value = this.canBeNull ? FieldSerializer.this.kryo.readObjectOrNull(input, concreteType, serializer) : FieldSerializer.this.kryo.readObject(input, concreteType, serializer);
                }
                if (this.accessIndex != -1) {
                    ((FieldAccess)FieldSerializer.this.access).set(object, this.accessIndex, value);
                } else {
                    this.field.set(object, value);
                }
            }
            catch (IllegalAccessException ex) {
                throw new KryoException("Error accessing field: " + this + " (" + FieldSerializer.this.type.getName() + ")", ex);
            }
            catch (KryoException ex) {
                ex.addTrace(this + " (" + FieldSerializer.this.type.getName() + ")");
                throw ex;
            }
            catch (RuntimeException runtimeEx) {
                KryoException ex = new KryoException(runtimeEx);
                ex.addTrace(this + " (" + FieldSerializer.this.type.getName() + ")");
                throw ex;
            }
        }

        public void copy(Object original, Object copy) {
            try {
                if (this.accessIndex != -1) {
                    FieldAccess access = (FieldAccess)FieldSerializer.this.access;
                    access.set(copy, this.accessIndex, FieldSerializer.this.kryo.copy(access.get(original, this.accessIndex)));
                } else {
                    this.field.set(copy, FieldSerializer.this.kryo.copy(this.field.get(original)));
                }
            }
            catch (IllegalAccessException ex) {
                throw new KryoException("Error accessing field: " + this + " (" + FieldSerializer.this.type.getName() + ")", ex);
            }
            catch (KryoException ex) {
                ex.addTrace(this + " (" + FieldSerializer.this.type.getName() + ")");
                throw ex;
            }
            catch (RuntimeException runtimeEx) {
                KryoException ex = new KryoException(runtimeEx);
                ex.addTrace(this + " (" + FieldSerializer.this.type.getName() + ")");
                throw ex;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class StringField
    extends AsmCachedField {
        StringField() {
        }

        @Override
        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write string: " + this.access.getString(object, this.accessIndex));
            }
            output.writeString(this.access.getString(object, this.accessIndex));
        }

        @Override
        public void read(Input input, Object object) {
            if (Log.TRACE) {
                String value = input.readString();
                this.access.set(object, this.accessIndex, (Object)value);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read string: " + value);
            } else {
                this.access.set(object, this.accessIndex, (Object)input.readString());
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.set(copy, this.accessIndex, (Object)this.access.getString(original, this.accessIndex));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DoubleField
    extends AsmCachedField {
        DoubleField() {
        }

        @Override
        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write double: " + this.access.getDouble(object, this.accessIndex));
            }
            output.writeDouble(this.access.getDouble(object, this.accessIndex));
        }

        @Override
        public void read(Input input, Object object) {
            if (Log.TRACE) {
                double value = input.readDouble();
                this.access.setDouble(object, this.accessIndex, value);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read double: " + value);
            } else {
                this.access.setDouble(object, this.accessIndex, input.readDouble());
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.setDouble(copy, this.accessIndex, this.access.getDouble(original, this.accessIndex));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LongField
    extends AsmCachedField {
        LongField() {
        }

        @Override
        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write long: " + this.access.getLong(object, this.accessIndex));
            }
            output.writeLong(this.access.getLong(object, this.accessIndex), false);
        }

        @Override
        public void read(Input input, Object object) {
            if (Log.TRACE) {
                long value = input.readLong(false);
                this.access.setLong(object, this.accessIndex, value);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read long: " + value);
            } else {
                this.access.setLong(object, this.accessIndex, input.readLong(false));
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.setLong(copy, this.accessIndex, this.access.getLong(original, this.accessIndex));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CharField
    extends AsmCachedField {
        CharField() {
        }

        @Override
        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write char: " + this.access.getChar(object, this.accessIndex));
            }
            output.writeChar(this.access.getChar(object, this.accessIndex));
        }

        @Override
        public void read(Input input, Object object) {
            if (Log.TRACE) {
                char value = input.readChar();
                this.access.setChar(object, this.accessIndex, value);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read char: " + value);
            } else {
                this.access.setChar(object, this.accessIndex, input.readChar());
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.setChar(copy, this.accessIndex, this.access.getChar(original, this.accessIndex));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BooleanField
    extends AsmCachedField {
        BooleanField() {
        }

        @Override
        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write boolean: " + this.access.getBoolean(object, this.accessIndex));
            }
            output.writeBoolean(this.access.getBoolean(object, this.accessIndex));
        }

        @Override
        public void read(Input input, Object object) {
            if (Log.TRACE) {
                boolean value = input.readBoolean();
                this.access.setBoolean(object, this.accessIndex, value);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read boolean: " + value);
            } else {
                this.access.setBoolean(object, this.accessIndex, input.readBoolean());
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.setBoolean(copy, this.accessIndex, this.access.getBoolean(original, this.accessIndex));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ByteField
    extends AsmCachedField {
        ByteField() {
        }

        @Override
        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write byte: " + this.access.getByte(object, this.accessIndex));
            }
            output.writeByte(this.access.getByte(object, this.accessIndex));
        }

        @Override
        public void read(Input input, Object object) {
            if (Log.TRACE) {
                byte value = input.readByte();
                this.access.setByte(object, this.accessIndex, value);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read byte: " + value);
            } else {
                this.access.setByte(object, this.accessIndex, input.readByte());
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.setByte(copy, this.accessIndex, this.access.getByte(original, this.accessIndex));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShortField
    extends AsmCachedField {
        ShortField() {
        }

        @Override
        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write short: " + this.access.getShort(object, this.accessIndex));
            }
            output.writeShort(this.access.getShort(object, this.accessIndex));
        }

        @Override
        public void read(Input input, Object object) {
            if (Log.TRACE) {
                short value = input.readShort();
                this.access.setShort(object, this.accessIndex, value);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read short: " + value);
            } else {
                this.access.setShort(object, this.accessIndex, input.readShort());
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.setShort(copy, this.accessIndex, this.access.getShort(original, this.accessIndex));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FloatField
    extends AsmCachedField {
        FloatField() {
        }

        @Override
        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write float: " + this.access.getFloat(object, this.accessIndex));
            }
            output.writeFloat(this.access.getFloat(object, this.accessIndex));
        }

        @Override
        public void read(Input input, Object object) {
            if (Log.TRACE) {
                float value = input.readFloat();
                this.access.setFloat(object, this.accessIndex, value);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read float: " + value);
            } else {
                this.access.setFloat(object, this.accessIndex, input.readFloat());
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.setFloat(copy, this.accessIndex, this.access.getFloat(original, this.accessIndex));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IntField
    extends AsmCachedField {
        IntField() {
        }

        @Override
        public void write(Output output, Object object) {
            if (Log.TRACE) {
                Log.trace("kryo", "Write field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Write int: " + this.access.getInt(object, this.accessIndex));
            }
            output.writeInt(this.access.getInt(object, this.accessIndex), false);
        }

        @Override
        public void read(Input input, Object object) {
            if (Log.TRACE) {
                int value = input.readInt(false);
                this.access.setInt(object, this.accessIndex, value);
                Log.trace("kryo", "Read field: " + this + " (" + object.getClass().getName() + ")");
                Log.trace("kryo", "Read int: " + value);
            } else {
                this.access.setInt(object, this.accessIndex, input.readInt(false));
            }
        }

        @Override
        public void copy(Object original, Object copy) {
            this.access.setInt(copy, this.accessIndex, this.access.getInt(original, this.accessIndex));
        }
    }

    abstract class AsmCachedField
    extends CachedField {
        FieldAccess access;

        AsmCachedField() {
            this.access = (FieldAccess)FieldSerializer.this.access;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class CachedField<X> {
        Field field;
        Class valueClass;
        Serializer serializer;
        boolean canBeNull;
        int accessIndex = -1;

        public void setClass(Class valueClass) {
            this.valueClass = valueClass;
            this.serializer = null;
        }

        public void setClass(Class valueClass, Serializer serializer) {
            this.valueClass = valueClass;
            this.serializer = serializer;
        }

        public void setSerializer(Serializer serializer) {
            this.serializer = serializer;
        }

        public void setCanBeNull(boolean canBeNull) {
            this.canBeNull = canBeNull;
        }

        public Field getField() {
            return this.field;
        }

        public String toString() {
            return this.field.getName();
        }

        public abstract void write(Output var1, Object var2);

        public abstract void read(Input var1, Object var2);

        public abstract void copy(Object var1, Object var2);
    }
}

