/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.ResultCache;
import org.languagetool.UserConfig;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatchFilter;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.xml.sax.SAXException;

class Pipeline
extends JLanguageTool {
    private boolean setup = false;
    private long lastUsedTimestamp = System.currentTimeMillis();

    void setupFinished() {
        this.setup = true;
    }

    void refreshExpireTimer() {
        this.lastUsedTimestamp = System.currentTimeMillis();
    }

    boolean isExpired() {
        long delta = System.currentTimeMillis() - this.lastUsedTimestamp;
        return delta > 900000L;
    }

    Pipeline(Language language, List<Language> altLanguages, Language motherTongue, ResultCache cache, GlobalConfig globalConfig, UserConfig userConfig) {
        super(language, altLanguages, motherTongue, cache, globalConfig, userConfig);
    }

    @Override
    public void setCleanOverlappingMatches(boolean cleanOverlappingMatches) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.setCleanOverlappingMatches(cleanOverlappingMatches);
    }

    @Override
    public void setMaxErrorsPerWordRate(float maxErrorsPerWordRate) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.setMaxErrorsPerWordRate(maxErrorsPerWordRate);
    }

    @Override
    public void setOutput(PrintStream printStream) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.setOutput(printStream);
    }

    @Override
    public List<AbstractPatternRule> loadPatternRules(String filename) throws IOException {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        return super.loadPatternRules(filename);
    }

    @Override
    public List<AbstractPatternRule> loadFalseFriendRules(String filename) throws ParserConfigurationException, SAXException, IOException {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        return super.loadFalseFriendRules(filename);
    }

    @Override
    public void activateLanguageModelRules(File indexDir) throws IOException {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.activateLanguageModelRules(indexDir);
    }

    @Override
    public void activateWord2VecModelRules(File indexDir) throws IOException {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.activateWord2VecModelRules(indexDir);
    }

    @Override
    public void activateRemoteRules(File configFile) throws IOException {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.activateRemoteRules(configFile);
    }

    @Override
    public void addMatchFilter(@NotNull RuleMatchFilter filter) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.addMatchFilter(filter);
    }

    @Override
    public void addRule(Rule rule) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.addRule(rule);
    }

    @Override
    public void disableRule(String ruleId) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.disableRule(ruleId);
    }

    @Override
    public void disableRules(List<String> ruleIds) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.disableRules(ruleIds);
    }

    @Override
    public void disableCategory(CategoryId id) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.disableCategory(id);
    }

    @Override
    public Set<String> getDisabledRules() {
        return Collections.unmodifiableSet(super.getDisabledRules());
    }

    @Override
    public void enableRule(String ruleId) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.enableRule(ruleId);
    }

    @Override
    public void enableRuleCategory(CategoryId id) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.enableRuleCategory(id);
    }

    @Override
    public List<String> getUnknownWords() {
        return Collections.unmodifiableList(super.getUnknownWords());
    }

    @Override
    public Map<CategoryId, Category> getCategories() {
        return Collections.unmodifiableMap(super.getCategories());
    }

    @Override
    public List<Rule> getAllRules() {
        return Collections.unmodifiableList(super.getAllRules());
    }

    @Override
    public List<Rule> getAllActiveRules() {
        return Collections.unmodifiableList(super.getAllActiveRules());
    }

    @Override
    public List<Rule> getAllActiveOfficeRules() {
        return Collections.unmodifiableList(super.getAllActiveOfficeRules());
    }

    @Override
    public List<AbstractPatternRule> getPatternRulesByIdAndSubId(String Id2, String subId) {
        return Collections.unmodifiableList(super.getPatternRulesByIdAndSubId(Id2, subId));
    }

    @Override
    public void setConfigValues(Map<String, Integer> v) {
        if (this.setup) {
            throw new IllegalPipelineMutationException();
        }
        super.setConfigValues(v);
    }

    static class IllegalPipelineMutationException
    extends RuntimeException {
        IllegalPipelineMutationException() {
            super("Pipeline is frozen; mutating shared JLanguageTool instance is forbidden.");
        }
    }
}

