/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import org.languagetool.tools.StringTools;

public class ContextTools {
    private int contextSize = 40;
    private boolean escapeHtml = true;
    private String errorMarkerStart = "<b><font bgcolor=\"#ff8b8b\">";
    private String errorMarkerEnd = "</font></b>";

    public String getContext(int fromPos, int toPos, String contents) {
        int textLength;
        int endContent;
        String text = contents.replace('\n', ' ');
        int startContent = fromPos - this.contextSize;
        String prefix = "...";
        String postfix = "...";
        String markerPrefix = "   ";
        if (startContent < 0) {
            prefix = "";
            markerPrefix = "";
            startContent = 0;
        }
        if ((endContent = toPos + this.contextSize) > (textLength = text.length())) {
            postfix = "";
            endContent = textLength;
        }
        StringBuilder marker = this.getMarker(fromPos, toPos, textLength + prefix.length());
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(text, startContent, endContent);
        String markerStr = markerPrefix + marker.substring(startContent, endContent);
        sb.append(postfix);
        int startMark = markerStr.indexOf(94);
        int endMark = markerStr.lastIndexOf(94);
        String result = sb.toString();
        if (this.escapeHtml) {
            String escapedErrorPart = StringTools.escapeHTML(result.substring(startMark, endMark + 1)).replace(" ", "&nbsp;");
            result = StringTools.escapeHTML(result.substring(0, startMark)) + this.errorMarkerStart + escapedErrorPart + this.errorMarkerEnd + StringTools.escapeHTML(result.substring(endMark + 1));
        } else {
            result = result.substring(0, startMark) + this.errorMarkerStart + result.substring(startMark, endMark + 1) + this.errorMarkerEnd + result.substring(endMark + 1);
        }
        return result;
    }

    public String getPlainTextContext(int fromPos, int toPos, String contents) {
        int endContent;
        String text = contents.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ');
        int startContent = fromPos - this.contextSize;
        String prefix = "...";
        String postfix = "...";
        String markerPrefix = "   ";
        if (startContent < 0) {
            prefix = "";
            markerPrefix = "";
            startContent = 0;
        }
        if ((endContent = toPos + this.contextSize) > text.length()) {
            postfix = "";
            endContent = text.length();
        }
        StringBuilder marker = this.getMarker(fromPos, toPos, text.length() + prefix.length());
        return prefix + text.substring(startContent, endContent) + postfix + '\n' + markerPrefix + marker.substring(startContent, endContent);
    }

    public void setErrorMarkerStart(String errorMarkerStart) {
        this.errorMarkerStart = errorMarkerStart;
    }

    public void setErrorMarkerEnd(String errorMarkerEnd) {
        this.errorMarkerEnd = errorMarkerEnd;
    }

    public void setContextSize(int contextSize) {
        this.contextSize = contextSize;
    }

    public void setEscapeHtml(boolean escapeHtml) {
        this.escapeHtml = escapeHtml;
    }

    private StringBuilder getMarker(int fromPos, int toPos, int textLength) {
        StringBuilder marker = new StringBuilder();
        for (int i = 0; i < textLength; ++i) {
            if (i >= fromPos && i < toPos) {
                marker.append('^');
                continue;
            }
            marker.append(' ');
        }
        return marker;
    }
}

