/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.languagetool.language.LanguageIdentifier;

public class NGramLangIdentifier {
    private static final double EPSILON = 1.0E-8;
    private final Map<String, Integer> vocab;
    private final List<String[]> codes;
    private final List<Map<String, Integer>> bigramCounts;
    private final List<Map<String, Integer>> unigramCounts;
    private final List<Map<String, Integer>> bigramSumsPre;
    private final List<Map<String, Integer>> bigramSumsPost;
    private final List<List<Double>> scales;
    private final int maxLength;
    private final boolean knp;
    private final boolean scaling;

    public NGramLangIdentifier(File sourceFolder, int maxLength, boolean knSmoothing, boolean scaling) throws IOException {
        this.maxLength = maxLength;
        this.knp = knSmoothing;
        this.scaling = scaling;
        String vocabPath = Paths.get(sourceFolder.getAbsolutePath(), "vocab.txt").toString();
        String isoPath = Paths.get(sourceFolder.getAbsolutePath(), "iso_codes.tsv").toString();
        File ugPath = new File(sourceFolder.getAbsolutePath(), "/ug/");
        File sumsPathPre = new File(sourceFolder.getAbsolutePath(), "/sums/pre/");
        File sumsPathPost = new File(sourceFolder.getAbsolutePath(), "/sums/post/");
        String scalesPath = Paths.get(sourceFolder.getAbsolutePath(), "scales.txt").toString();
        this.codes = new ArrayList<String[]>();
        try (Object br = new BufferedReader(new FileReader(isoPath));){
            String line;
            while ((line = ((BufferedReader)br).readLine()) != null) {
                String[] values = line.split("\t");
                if (!values[3].equals("1")) continue;
                this.codes.add(values);
            }
        }
        this.vocab = new HashMap<String, Integer>();
        br = new BufferedReader(new FileReader(vocabPath));
        var12_12 = null;
        try {
            int i = 0;
            while ((line = ((BufferedReader)br).readLine()) != null) {
                this.vocab.put(line.split("\t")[0].trim(), i);
                ++i;
            }
        }
        catch (Throwable line) {
            var12_12 = line;
            throw line;
        }
        finally {
            if (br != null) {
                if (var12_12 != null) {
                    try {
                        ((BufferedReader)br).close();
                    }
                    catch (Throwable line) {
                        var12_12.addSuppressed(line);
                    }
                } else {
                    ((BufferedReader)br).close();
                }
            }
        }
        this.bigramCounts = new ArrayList<Map<String, Integer>>();
        for (String path : this.expectedFiles(sourceFolder)) {
            this.bigramCounts.add(NGramLangIdentifier.loadDict(path));
        }
        this.unigramCounts = new ArrayList<Map<String, Integer>>();
        for (String path : this.expectedFiles(ugPath)) {
            this.unigramCounts.add(NGramLangIdentifier.loadDict(path));
        }
        this.bigramSumsPre = new ArrayList<Map<String, Integer>>();
        for (String path : this.expectedFiles(sumsPathPre)) {
            this.bigramSumsPre.add(NGramLangIdentifier.loadDict(path));
        }
        this.bigramSumsPost = new ArrayList<Map<String, Integer>>();
        for (String path : this.expectedFiles(sumsPathPost)) {
            this.bigramSumsPost.add(NGramLangIdentifier.loadDict(path));
        }
        if (scaling) {
            this.scales = new ArrayList<List<Double>>();
            br = new BufferedReader(new FileReader(scalesPath));
            var12_12 = null;
            try {
                while ((line = ((BufferedReader)br).readLine()) != null) {
                    String[] parts = line.trim().split(" ");
                    this.scales.add(Arrays.stream(parts).map(Double::parseDouble).collect(Collectors.toList()));
                }
            }
            catch (Throwable throwable) {
                var12_12 = throwable;
                throw throwable;
            }
            finally {
                if (br != null) {
                    if (var12_12 != null) {
                        try {
                            ((BufferedReader)br).close();
                        }
                        catch (Throwable throwable) {
                            var12_12.addSuppressed(throwable);
                        }
                    } else {
                        ((BufferedReader)br).close();
                    }
                }
            }
        } else {
            this.scales = null;
        }
    }

    public Map<String, Double> detectLanguages(String text, List<String> additionalLanguageCodes) {
        List<Integer> enc = this.encode(text);
        List<Double> vals = new ArrayList<Double>();
        for (int i = 0; i < this.codes.size(); ++i) {
            double val = 0.0;
            for (int[] key : this.keys(enc)) {
                int ugCnt;
                double prob = this.knp ? this.knp(key[0], key[1], i) : ((ugCnt = this.unigramCounts.get(i).getOrDefault("0_" + key[0], 0).intValue()) == 0 ? 1.0E-8 : (double)this.bigramCounts.get(i).getOrDefault(key[0] + "_" + key[1], 1).intValue() / (double)ugCnt);
                val += StrictMath.log(prob);
            }
            vals.add(StrictMath.exp(val));
        }
        if (this.scaling) {
            ArrayList<Double> l1normed = vals;
            vals = new ArrayList();
            for (int i = 0; i < l1normed.size(); ++i) {
                double val = 0.0;
                for (double d : this.scales.get(i)) {
                    val += d * (Double)l1normed.get(i);
                }
                vals.add(val);
            }
        }
        vals = this.normalize(vals);
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (int i = 0; i < this.codes.size(); ++i) {
            String langCode;
            String string = langCode = this.codes.get(i)[1].equals("NULL") ? this.codes.get(i)[2] : this.codes.get(i)[1];
            if (!LanguageIdentifier.canLanguageBeDetected(langCode, additionalLanguageCodes)) continue;
            result.put(langCode, vals.get(i));
        }
        return result;
    }

    private static Map<String, Integer> loadDict(String path) throws IOException {
        String line;
        HashMap<String, Integer> tm = new HashMap<String, Integer>();
        BufferedReader br = new BufferedReader(new FileReader(path));
        while ((line = br.readLine()) != null) {
            String[] parts = line.trim().split(" ");
            String key = String.join((CharSequence)"_", Arrays.copyOfRange(parts, 0, parts.length - 1));
            tm.put(key, Integer.parseInt(parts[parts.length - 1]));
        }
        return tm;
    }

    private List<String> expectedFiles(File folderPath) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.codes.size(); ++i) {
            String name = String.format("%02d.txt", i);
            String fp = Paths.get(folderPath.getAbsolutePath(), name).toString();
            result.add(fp);
        }
        return result;
    }

    private List<Integer> encode(String text) {
        int ci;
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(1);
        if (text.length() > this.maxLength) {
            text = text.substring(0, this.maxLength);
        }
        if ((text = Normalizer.normalize(text, Normalizer.Form.NFKC).toLowerCase().replaceAll("\\s+", "\u2581")).length() == 0) {
            return result;
        }
        text = "\u2581" + text;
        for (int cur = 0; cur < text.length(); cur += ci) {
            int tok = 0;
            ci = 1;
            for (int i = cur + 1; i <= text.length(); ++i) {
                int maybeTok = this.vocab.getOrDefault(text.substring(cur, i), -1);
                if (maybeTok <= -1) continue;
                tok = maybeTok;
                ci = i - cur;
            }
            result.add(tok);
        }
        return result;
    }

    private List<int[]> keys(List<Integer> enc) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        for (int i = 1; i < enc.size(); ++i) {
            result.add(new int[]{enc.get(i - 1), enc.get(i)});
        }
        return result;
    }

    private Double knp(int a, int b, int tmI) {
        Map<String, Integer> tm = this.bigramCounts.get(tmI);
        Map<String, Integer> tmU = this.unigramCounts.get(tmI);
        Map<String, Integer> tmS = this.bigramSumsPre.get(tmI);
        Map<String, Integer> tmSd = this.bigramSumsPost.get(tmI);
        int xaCnt = tmS.getOrDefault("" + b, 0);
        int axCnt = tmSd.getOrDefault("" + a, 0);
        int bigramsTotal = tm.size();
        int unigramCnt = tmU.getOrDefault("0_" + a, 1);
        int bigramCnt = tm.getOrDefault(a + "_" + b, 1);
        double d = 0.75;
        double bigramProbNormalized = Double.max((double)bigramCnt - d, 0.0) / (double)unigramCnt;
        double pCont = (double)xaCnt / (double)bigramsTotal;
        double lamb = d * (double)axCnt / (double)unigramCnt;
        return bigramProbNormalized + lamb * pCont + 1.0E-8;
    }

    private List<Double> normalize(List<Double> vals) {
        double tot = vals.stream().mapToDouble(f -> f).sum();
        return vals.stream().map(n -> n / tot).collect(Collectors.toList());
    }
}

