/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.sun.net.httpserver.HttpServer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.server.ErrorRequestLimiter;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.LanguageToolHttpHandler;
import org.languagetool.server.RequestLimiter;
import org.languagetool.server.ServerTools;

abstract class Server {
    protected static final Set<String> DEFAULT_ALLOWED_IPS = new HashSet<String>(Arrays.asList("0:0:0:0:0:0:0:1", "0:0:0:0:0:0:0:1%0", "127.0.0.1"));
    protected int port;
    protected String host;
    protected HttpServer server;
    protected LanguageToolHttpHandler httpHandler;
    private boolean isRunning;

    Server() {
    }

    protected abstract String getProtocol();

    public void run() {
        String hostName = this.host != null ? this.host : "localhost";
        ServerTools.print("Starting LanguageTool 5.5 (build date: " + JLanguageTool.BUILD_DATE + ", " + JLanguageTool.GIT_SHORT_ID + ") server on " + this.getProtocol() + "://" + hostName + ":" + this.port + "...");
        this.server.start();
        this.isRunning = true;
        ServerTools.print("Server started");
    }

    public void stop() {
        if (this.httpHandler != null) {
            this.httpHandler.shutdown();
        }
        if (this.server != null) {
            ServerTools.print("Stopping server...");
            this.server.stop(5);
            this.isRunning = false;
            ServerTools.print("Server stopped");
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    @Nullable
    protected RequestLimiter getRequestLimiterOrNull(HTTPServerConfig config) {
        int requestLimit = config.getRequestLimit();
        int requestLimitInBytes = config.getRequestLimitInBytes();
        int requestLimitPeriodInSeconds = config.getRequestLimitPeriodInSeconds();
        int ipFingerprintFactor = config.getIpFingerprintFactor();
        List<String> requestLimitWhitelistUsers = config.getRequestLimitWhitelistUsers();
        int requestLimitWhitelistLimit = config.getRequestLimitWhitelistLimit();
        if ((requestLimit > 0 || requestLimitInBytes > 0) && requestLimitPeriodInSeconds > 0) {
            return new RequestLimiter(requestLimit, requestLimitInBytes, requestLimitPeriodInSeconds, ipFingerprintFactor, requestLimitWhitelistUsers, requestLimitWhitelistLimit);
        }
        return null;
    }

    @Nullable
    protected ErrorRequestLimiter getErrorRequestLimiterOrNull(HTTPServerConfig config) {
        int requestLimit = config.getTimeoutRequestLimit();
        int requestLimitPeriodInSeconds = config.getRequestLimitPeriodInSeconds();
        if (requestLimit > 0 && requestLimitPeriodInSeconds > 0) {
            return new ErrorRequestLimiter(requestLimit, requestLimitPeriodInSeconds);
        }
        return null;
    }

    protected static boolean usageRequested(String[] args) {
        return args.length == 1 && (args[0].equals("-h") || args[0].equals("--help"));
    }

    protected static void printCommonConfigFileOptions() {
        System.out.println("                 'maxTextLength' - maximum text length, longer texts will cause an error (optional)");
        System.out.println("                 'maxTextHardLength' - maximum text length, applies even to users with a special secret 'token' parameter (optional)");
        System.out.println("                 'secretTokenKey' - secret JWT token key, if set by user and valid, maxTextLength can be increased by the user (optional)");
        System.out.println("                 'maxCheckTimeMillis' - maximum time in milliseconds allowed per check (optional)");
        System.out.println("                 'maxErrorsPerWordRate' - checking will stop with error if there are more rules matches per word (optional)");
        System.out.println("                 'maxSpellingSuggestions' - only this many spelling errors will have suggestions for performance reasons (optional,\n                                            affects Hunspell-based languages only)");
        System.out.println("                 'maxCheckThreads' - maximum number of threads working in parallel (optional)");
        System.out.println("                 'cacheSize' - size of internal cache in number of sentences (optional, default: 0)");
        System.out.println("                 'cacheTTLSeconds' - how many seconds sentences are kept in cache (optional, default: 300 if 'cacheSize' is set)");
        System.out.println("                 'requestLimit' - maximum number of requests per requestLimitPeriodInSeconds (optional)");
        System.out.println("                 'requestLimitInBytes' - maximum aggregated size of requests per requestLimitPeriodInSeconds (optional)");
        System.out.println("                 'timeoutRequestLimit' - maximum number of timeout request (optional)");
        System.out.println("                 'requestLimitPeriodInSeconds' - time period to which requestLimit and timeoutRequestLimit applies (optional)");
        System.out.println("                 'languageModel' - a directory with '1grams', '2grams', '3grams' sub directories which contain a Lucene index");
        System.out.println("                  each with ngram occurrence counts; activates the confusion rule if supported (optional)");
        System.out.println("                 'word2vecModel' - a directory with word2vec data (optional), see");
        System.out.println("                  https://github.com/languagetool-org/languagetool/blob/master/languagetool-standalone/CHANGES.md#word2vec");
        System.out.println("                 'fasttextModel' - a model file for better language detection (optional), see");
        System.out.println("                  https://fasttext.cc/docs/en/language-identification.html");
        System.out.println("                 'fasttextBinary' - compiled fasttext executable for language detection (optional), see");
        System.out.println("                  https://fasttext.cc/docs/en/support.html");
        System.out.println("                 'maxWorkQueueSize' - reject request if request queue gets larger than this (optional)");
        System.out.println("                 'rulesFile' - a file containing rules configuration, such as .langugagetool.cfg (optional)");
        System.out.println("                 'warmUp' - set to 'true' to warm up server at start, i.e. run a short check with all languages (optional)");
        System.out.println("                 'blockedReferrers' - a comma-separated list of HTTP referrers (and 'Origin' headers) that are blocked and will not be served (optional)");
        System.out.println("                 'premiumOnly' - activate only the premium rules (optional)");
        System.out.println("                 'disabledRuleIds' - a comma-separated list of rule ids that are turned off for this server (optional)");
        System.out.println("                 Spellcheck-only languages: You can add simple spellcheck-only support for languages that LT doesn't");
        System.out.println("                 support by defining two optional properties:");
        System.out.println("                   'lang-xx' - set name of the language, use language code instead of 'xx', e.g. lang-tr=Turkish");
        System.out.println("                   'lang-xx-dictPath' - absolute path to the hunspell .dic file, use language code instead of 'xx', e.g.");
        System.out.println("                                        lang-tr-dictPath=/path/to/tr.dic. Note that the same directory also needs to");
        System.out.println("                                        contain a common_words.txt file with the most common 10,000 words (used for better language detection)");
    }

    protected static void printCommonOptions() {
        System.out.println("  --port, -p PRT   port to bind to, defaults to 8081 if not specified");
        System.out.println("  --public         allow this server process to be connected from anywhere; if not set,");
        System.out.println("                   it can only be connected from the computer it was started on");
        System.out.println("  --allow-origin   ORIGIN  set the Access-Control-Allow-Origin header in the HTTP response,");
        System.out.println("                         used for direct (non-proxy) JavaScript-based access from browsers;");
        System.out.println("                         example: --allow-origin \"*\"");
        System.out.println("  --verbose, -v    in case of exceptions, log the input text (up to 500 characters)");
        System.out.println("  --languageModel  a directory with '1grams', '2grams', '3grams' sub directories (per language)");
        System.out.println("                         which contain a Lucene index (optional, overwrites 'languageModel'");
        System.out.println("                         parameter in properties files)");
        System.out.println("  --word2vecModel  a directory with word2vec data (optional), see");
        System.out.println("                   https://github.com/languagetool-org/languagetool/blob/master/languagetool-standalone/CHANGES.md#word2vec");
        System.out.println("  --premiumAlways  activate the premium rules even when user has no username/password - useful for API servers");
    }

    protected static void checkForNonRootUser() {
        if ("root".equals(System.getProperty("user.name"))) {
            ServerTools.print("****************************************************************************************************");
            ServerTools.print("*** WARNING: this process is running as root - please do not run it as root for security reasons ***");
            ServerTools.print("****************************************************************************************************");
        }
    }

    protected ThreadPoolExecutor getExecutorService(LinkedBlockingQueue<Runnable> workQueue, HTTPServerConfig config) {
        int threadPoolSize = config.getMaxCheckThreads();
        ServerTools.print("Setting up thread pool with " + threadPoolSize + " threads");
        return new StoppingThreadPoolExecutor(threadPoolSize, workQueue);
    }

    static class StoppingThreadPoolExecutor
    extends ThreadPoolExecutor {
        StoppingThreadPoolExecutor(int threadPoolSize, LinkedBlockingQueue<Runnable> workQueue) {
            super(threadPoolSize, threadPoolSize, 0L, TimeUnit.MILLISECONDS, workQueue, new ThreadFactoryBuilder().setNameFormat("lt-server-thread-%d").build());
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (t != null && t instanceof OutOfMemoryError) {
                t.printStackTrace();
                System.exit(1);
            }
        }
    }
}

