/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.Demo;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.rules.DictionarySpellMatchFilter;
import org.languagetool.rules.FakeRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class DictionarySpellMatchFilterTest {
    @Test
    public void testGetPhrases() throws IOException {
        String text = "This is aa bb and then xx yyy zzzz";
        AnnotatedText aText = new AnnotatedTextBuilder().addText(text).build();
        AnalyzedSentence sentence = new JLanguageTool((Language)new Demo()).getAnalyzedSentence(text);
        SpellingFakeRule rule = new SpellingFakeRule();
        List<RuleMatch> matches = Arrays.asList(new RuleMatch((Rule)rule, sentence, 8, 10, "fake msg"), new RuleMatch((Rule)rule, sentence, 11, 13, "fake msg"), new RuleMatch((Rule)rule, sentence, 23, 25, "fake msg"), new RuleMatch((Rule)rule, sentence, 26, 29, "fake msg"), new RuleMatch((Rule)rule, sentence, 30, 34, "fake msg"));
        DictionarySpellMatchFilter filter = new DictionarySpellMatchFilter(new UserConfig());
        Map result = filter.getPhrases(matches, aText);
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)3));
        TestCase.assertTrue((boolean)result.containsKey("aa bb"));
        TestCase.assertTrue((boolean)result.containsKey("xx yyy"));
        TestCase.assertTrue((boolean)result.containsKey("xx yyy zzzz"));
    }

    static class SpellingFakeRule
    extends FakeRule {
        SpellingFakeRule() {
        }

        public boolean isDictionaryBasedSpellingRule() {
            return true;
        }
    }
}

