/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.perceptron.transition.features;

import com.hankcs.hanlp.dependency.perceptron.structures.Sentence;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.Configuration;
import com.hankcs.hanlp.dependency.perceptron.transition.configuration.State;

public class FeatureExtractor {
    public static Object[] extractAllParseFeatures(Configuration configuration, int length) {
        if (length == 26) {
            return FeatureExtractor.extractBasicFeatures(configuration, length);
        }
        if (length == 72) {
            return FeatureExtractor.extractExtendedFeatures(configuration, length);
        }
        return FeatureExtractor.extractExtendedFeaturesWithBrownClusters(configuration, length);
    }

    private static Object[] extractExtendedFeatures(Configuration configuration, int length) {
        int leftMost;
        Object[] featureMap = new Object[length];
        State state = configuration.state;
        Sentence sentence = configuration.sentence;
        int b0Position = 0;
        int b1Position = 0;
        int b2Position = 0;
        int s0Position = 0;
        long svr = 0L;
        long svl = 0L;
        long bvl = 0L;
        long b0w = 0L;
        long b0p = 0L;
        long b1w = 0L;
        long b1p = 0L;
        long b2w = 0L;
        long b2p = 0L;
        long s0w = 0L;
        long s0p = 0L;
        long s0l = 0L;
        long bl0p = 0L;
        long bl0w = 0L;
        long bl0l = 0L;
        long bl1w = 0L;
        long bl1p = 0L;
        long bl1l = 0L;
        long sr0p = 0L;
        long sr0w = 0L;
        long sr0l = 0L;
        long sh0w = 0L;
        long sh0p = 0L;
        long sh0l = 0L;
        long sl0p = 0L;
        long sl0w = 0L;
        long sl0l = 0L;
        long sr1w = 0L;
        long sr1p = 0L;
        long sr1l = 0L;
        long sh1w = 0L;
        long sh1p = 0L;
        long sl1w = 0L;
        long sl1p = 0L;
        long sl1l = 0L;
        long sdl = 0L;
        long sdr = 0L;
        long bdl = 0L;
        int[] words = sentence.getWords();
        int[] tags = sentence.getTags();
        if (0 < state.bufferSize()) {
            b0Position = state.bufferHead();
            b0w = b0Position == 0 ? 0L : (long)words[b0Position - 1];
            b0w += 2L;
            b0p = b0Position == 0 ? 0L : (long)tags[b0Position - 1];
            b0p += 2L;
            bvl = state.leftValency(b0Position);
            leftMost = state.leftMostModifier(state.getBufferItem(0));
            if (leftMost >= 0) {
                bl0p = leftMost == 0 ? 0L : (long)tags[leftMost - 1];
                bl0p += 2L;
                bl0w = leftMost == 0 ? 0L : (long)words[leftMost - 1];
                bl0w += 2L;
                bl0l = state.getDependent(leftMost);
                bl0l += 2L;
                int l2 = state.leftMostModifier(leftMost);
                if (l2 >= 0) {
                    bl1w = l2 == 0 ? 0L : (long)words[l2 - 1];
                    bl1w += 2L;
                    bl1p = l2 == 0 ? 0L : (long)tags[l2 - 1];
                    bl1p += 2L;
                    bl1l = state.getDependent(l2);
                    bl1l += 2L;
                }
            }
            if (1 < state.bufferSize()) {
                b1Position = state.getBufferItem(1);
                b1w = b1Position == 0 ? 0L : (long)words[b1Position - 1];
                b1w += 2L;
                b1p = b1Position == 0 ? 0L : (long)tags[b1Position - 1];
                b1p += 2L;
                if (2 < state.bufferSize()) {
                    b2Position = state.getBufferItem(2);
                    b2w = b2Position == 0 ? 0L : (long)words[b2Position - 1];
                    b2w += 2L;
                    b2p = b2Position == 0 ? 0L : (long)tags[b2Position - 1];
                    b2p += 2L;
                }
            }
        }
        if (0 < state.stackSize()) {
            int r2;
            int l2;
            int headIndex;
            int rightMost;
            s0Position = state.stackTop();
            s0w = s0Position == 0 ? 0L : (long)words[s0Position - 1];
            s0w += 2L;
            s0p = s0Position == 0 ? 0L : (long)tags[s0Position - 1];
            s0p += 2L;
            s0l = state.getDependent(s0Position);
            s0l += 2L;
            svl = state.leftValency(s0Position);
            svr = state.rightValency(s0Position);
            leftMost = state.leftMostModifier(s0Position);
            if (leftMost >= 0) {
                sl0p = leftMost == 0 ? 0L : (long)tags[leftMost - 1];
                sl0p += 2L;
                sl0w = leftMost == 0 ? 0L : (long)words[leftMost - 1];
                sl0w += 2L;
                sl0l = state.getDependent(leftMost);
                sl0l += 2L;
            }
            if ((rightMost = state.rightMostModifier(s0Position)) >= 0) {
                sr0p = rightMost == 0 ? 0L : (long)tags[rightMost - 1];
                sr0p += 2L;
                sr0w = rightMost == 0 ? 0L : (long)words[rightMost - 1];
                sr0w += 2L;
                sr0l = state.getDependent(rightMost);
                sr0l += 2L;
            }
            if ((headIndex = state.getHead(s0Position)) >= 0) {
                sh0w = headIndex == 0 ? 0L : (long)words[headIndex - 1];
                sh0w += 2L;
                sh0p = headIndex == 0 ? 0L : (long)tags[headIndex - 1];
                sh0p += 2L;
                sh0l = state.getDependent(headIndex);
                sh0l += 2L;
            }
            if (leftMost >= 0 && (l2 = state.leftMostModifier(leftMost)) >= 0) {
                sl1w = l2 == 0 ? 0L : (long)words[l2 - 1];
                sl1w += 2L;
                sl1p = l2 == 0 ? 0L : (long)tags[l2 - 1];
                sl1p += 2L;
                sl1l = state.getDependent(l2);
                sl1l += 2L;
            }
            if (headIndex >= 0 && state.hasHead(headIndex)) {
                int h2 = state.getHead(headIndex);
                sh1w = h2 == 0 ? 0L : (long)words[h2 - 1];
                sh1w += 2L;
                sh1p = h2 == 0 ? 0L : (long)tags[h2 - 1];
                sh1p += 2L;
            }
            if (rightMost >= 0 && (r2 = state.rightMostModifier(rightMost)) >= 0) {
                sr1w = r2 == 0 ? 0L : (long)words[r2 - 1];
                sr1w += 2L;
                sr1p = r2 == 0 ? 0L : (long)tags[r2 - 1];
                sr1p += 2L;
                sr1l = state.getDependent(r2);
                sr1l += 2L;
            }
        }
        int index = 0;
        long b0wp = b0p;
        b0wp |= b0w << 8;
        long b1wp = b1p;
        b1wp |= b1w << 8;
        long s0wp = s0p;
        s0wp |= s0w << 8;
        long b2wp = b2p;
        b2wp |= b2w << 8;
        if (s0w != 1L) {
            featureMap[index++] = s0wp;
            featureMap[index++] = s0w;
        } else {
            featureMap[index++] = null;
            featureMap[index++] = null;
        }
        featureMap[index++] = s0p;
        if (b0w != 1L) {
            featureMap[index++] = b0wp;
            featureMap[index++] = b0w;
        } else {
            featureMap[index++] = null;
            featureMap[index++] = null;
        }
        featureMap[index++] = b0p;
        if (b1w != 1L) {
            featureMap[index++] = b1wp;
            featureMap[index++] = b1w;
        } else {
            featureMap[index++] = null;
            featureMap[index++] = null;
        }
        featureMap[index++] = b1p;
        if (b2w != 1L) {
            featureMap[index++] = b2wp;
            featureMap[index++] = b2w;
        } else {
            featureMap[index++] = null;
            featureMap[index++] = null;
        }
        featureMap[index++] = b2p;
        if (s0w != 1L && b0w != 1L) {
            featureMap[index++] = s0wp << 28 | b0wp;
            featureMap[index++] = s0wp << 20 | b0w;
            featureMap[index++] = s0w << 28 | b0wp;
        } else {
            featureMap[index++] = null;
            featureMap[index++] = null;
            featureMap[index++] = null;
        }
        featureMap[index++] = s0w != 1L ? Long.valueOf(s0wp << 8 | b0p) : null;
        featureMap[index++] = b0w != 1L ? Long.valueOf(s0p << 28 | b0wp) : null;
        featureMap[index++] = s0w != 1L && b0w != 1L ? Long.valueOf(s0w << 20 | b0w) : null;
        featureMap[index++] = s0p << 8 | b0p;
        featureMap[index++] = b0p << 8 | b1p;
        featureMap[index++] = b0p << 16 | b1p << 8 | b2p;
        featureMap[index++] = s0p << 16 | b0p << 8 | b1p;
        featureMap[index++] = sh0p << 16 | s0p << 8 | b0p;
        featureMap[index++] = s0p << 16 | sl0p << 8 | b0p;
        featureMap[index++] = s0p << 16 | sr0p << 8 | b0p;
        featureMap[index++] = s0p << 16 | b0p << 8 | bl0p;
        long distance = 0L;
        if (s0Position > 0 && b0Position > 0) {
            distance = Math.abs(b0Position - s0Position);
        }
        featureMap[index++] = s0w != 1L ? Long.valueOf(s0w | distance << 20) : null;
        featureMap[index++] = s0p | distance << 8;
        featureMap[index++] = b0w != 1L ? Long.valueOf(b0w | distance << 20) : null;
        featureMap[index++] = b0p | distance << 8;
        featureMap[index++] = s0w != 1L && b0w != 1L ? Long.valueOf(s0w | b0w << 20 | distance << 40) : null;
        featureMap[index++] = s0p | b0p << 8 | distance << 28;
        featureMap[index++] = s0w != 1L ? Long.valueOf(s0w | svr << 20) : null;
        featureMap[index++] = s0p | svr << 8;
        featureMap[index++] = s0w != 1L ? Long.valueOf(s0w | svl << 20) : null;
        featureMap[index++] = s0p | svl << 8;
        featureMap[index++] = b0w != 1L ? Long.valueOf(b0w | bvl << 20) : null;
        featureMap[index++] = b0p | bvl << 8;
        featureMap[index++] = sh0w != 1L ? Long.valueOf(sh0w) : null;
        featureMap[index++] = sh0p;
        featureMap[index++] = s0l;
        featureMap[index++] = sl0w != 1L ? Long.valueOf(sl0w) : null;
        featureMap[index++] = sl0p;
        featureMap[index++] = sl0l;
        featureMap[index++] = sr0w != 1L ? Long.valueOf(sr0w) : null;
        featureMap[index++] = sr0p;
        featureMap[index++] = sr0l;
        featureMap[index++] = bl0w != 1L ? Long.valueOf(bl0w) : null;
        featureMap[index++] = bl0p;
        featureMap[index++] = bl0l;
        featureMap[index++] = sh1w != 1L ? Long.valueOf(sh1w) : null;
        featureMap[index++] = sh1p;
        featureMap[index++] = sh0l;
        featureMap[index++] = sl1w != 1L ? Long.valueOf(sl1w) : null;
        featureMap[index++] = sl1p;
        featureMap[index++] = sl1l;
        featureMap[index++] = sr1w != 1L ? Long.valueOf(sr1w) : null;
        featureMap[index++] = sr1p;
        featureMap[index++] = sr1l;
        featureMap[index++] = bl1w != 1L ? Long.valueOf(bl1w) : null;
        featureMap[index++] = bl1p;
        featureMap[index++] = bl1l;
        featureMap[index++] = s0p | sl0p << 8 | sl1p << 16;
        featureMap[index++] = s0p | sr0p << 8 | sr1p << 16;
        featureMap[index++] = s0p | sh0p << 8 | sh1p << 16;
        featureMap[index++] = b0p | bl0p << 8 | bl1p << 16;
        if (s0Position >= 0) {
            sdl = state.leftDependentLabels(s0Position);
            sdr = state.rightDependentLabels(s0Position);
        }
        if (b0Position >= 0) {
            bdl = state.leftDependentLabels(b0Position);
        }
        featureMap[index++] = s0w != 1L ? s0w + "|" + sdr : null;
        featureMap[index++] = s0p + "|" + sdr;
        featureMap[index++] = s0w != 1L ? s0w + "|" + sdl : null;
        featureMap[index++] = s0p + "|" + sdl;
        featureMap[index++] = b0w != 1L ? b0w + "|" + bdl : null;
        featureMap[index++] = b0p + "|" + bdl;
        return featureMap;
    }

    private static Long[] extractBasicFeatures(Configuration configuration, int length) {
        int leftMost;
        Long[] featureMap = new Long[length];
        State state = configuration.state;
        Sentence sentence = configuration.sentence;
        int b0Position = 0;
        int b1Position = 0;
        int b2Position = 0;
        int s0Position = 0;
        long b0w = 0L;
        long b0p = 0L;
        long b1w = 0L;
        long b1p = 0L;
        long b2w = 0L;
        long b2p = 0L;
        long s0w = 0L;
        long s0p = 0L;
        long bl0p = 0L;
        long sr0p = 0L;
        long sh0p = 0L;
        long sl0p = 0L;
        int[] words = sentence.getWords();
        int[] tags = sentence.getTags();
        if (0 < state.bufferSize()) {
            b0Position = state.bufferHead();
            b0w = b0Position == 0 ? 0L : (long)words[b0Position - 1];
            b0w += 2L;
            b0p = b0Position == 0 ? 0L : (long)tags[b0Position - 1];
            b0p += 2L;
            leftMost = state.leftMostModifier(state.getBufferItem(0));
            if (leftMost >= 0) {
                bl0p = leftMost == 0 ? 0L : (long)tags[leftMost - 1];
                bl0p += 2L;
            }
            if (1 < state.bufferSize()) {
                b1Position = state.getBufferItem(1);
                b1w = b1Position == 0 ? 0L : (long)words[b1Position - 1];
                b1w += 2L;
                b1p = b1Position == 0 ? 0L : (long)tags[b1Position - 1];
                b1p += 2L;
                if (2 < state.bufferSize()) {
                    b2Position = state.getBufferItem(2);
                    b2w = b2Position == 0 ? 0L : (long)words[b2Position - 1];
                    b2w += 2L;
                    b2p = b2Position == 0 ? 0L : (long)tags[b2Position - 1];
                    b2p += 2L;
                }
            }
        }
        if (0 < state.stackSize()) {
            int headIndex;
            int rightMost;
            s0Position = state.stackTop();
            s0w = s0Position == 0 ? 0L : (long)words[s0Position - 1];
            s0w += 2L;
            s0p = s0Position == 0 ? 0L : (long)tags[s0Position - 1];
            s0p += 2L;
            leftMost = state.leftMostModifier(s0Position);
            if (leftMost >= 0) {
                sl0p = leftMost == 0 ? 0L : (long)tags[leftMost - 1];
                sl0p += 2L;
            }
            if ((rightMost = state.rightMostModifier(s0Position)) >= 0) {
                sr0p = rightMost == 0 ? 0L : (long)tags[rightMost - 1];
                sr0p += 2L;
            }
            if ((headIndex = state.getHead(s0Position)) >= 0) {
                sh0p = headIndex == 0 ? 0L : (long)tags[headIndex - 1];
                sh0p += 2L;
            }
        }
        int index = 0;
        long b0wp = b0p;
        b0wp |= b0w << 8;
        long b1wp = b1p;
        b1wp |= b1w << 8;
        long s0wp = s0p;
        s0wp |= s0w << 8;
        long b2wp = b2p;
        b2wp |= b2w << 8;
        if (s0w != 1L) {
            featureMap[index++] = s0wp;
            featureMap[index++] = s0w;
        } else {
            featureMap[index++] = null;
            featureMap[index++] = null;
        }
        featureMap[index++] = s0p;
        if (b0w != 1L) {
            featureMap[index++] = b0wp;
            featureMap[index++] = b0w;
        } else {
            featureMap[index++] = null;
            featureMap[index++] = null;
        }
        featureMap[index++] = b0p;
        if (b1w != 1L) {
            featureMap[index++] = b1wp;
            featureMap[index++] = b1w;
        } else {
            featureMap[index++] = null;
            featureMap[index++] = null;
        }
        featureMap[index++] = b1p;
        if (b2w != 1L) {
            featureMap[index++] = b2wp;
            featureMap[index++] = b2w;
        } else {
            featureMap[index++] = null;
            featureMap[index++] = null;
        }
        featureMap[index++] = b2p;
        if (s0w != 1L && b0w != 1L) {
            featureMap[index++] = s0wp << 28 | b0wp;
            featureMap[index++] = s0wp << 20 | b0w;
            featureMap[index++] = s0w << 28 | b0wp;
        } else {
            featureMap[index++] = null;
            featureMap[index++] = null;
            featureMap[index++] = null;
        }
        featureMap[index++] = s0w != 1L ? Long.valueOf(s0wp << 8 | b0p) : null;
        featureMap[index++] = b0w != 1L ? Long.valueOf(s0p << 28 | b0wp) : null;
        featureMap[index++] = s0w != 1L && b0w != 1L ? Long.valueOf(s0w << 20 | b0w) : null;
        featureMap[index++] = s0p << 8 | b0p;
        featureMap[index++] = b0p << 8 | b1p;
        featureMap[index++] = b0p << 16 | b1p << 8 | b2p;
        featureMap[index++] = s0p << 16 | b0p << 8 | b1p;
        featureMap[index++] = sh0p << 16 | s0p << 8 | b0p;
        featureMap[index++] = s0p << 16 | sl0p << 8 | b0p;
        featureMap[index++] = s0p << 16 | sr0p << 8 | b0p;
        featureMap[index++] = s0p << 16 | b0p << 8 | bl0p;
        return featureMap;
    }

    private static Object[] extractExtendedFeaturesWithBrownClusters(Configuration configuration, int length) {
        int leftMost;
        Object[] featureVector = new Object[length];
        State state = configuration.state;
        Sentence sentence = configuration.sentence;
        int b0Position = 0;
        int b1Position = 0;
        int b2Position = 0;
        int s0Position = 0;
        int svr = 0;
        int svl = 0;
        int bvl = 0;
        long b0w = 0L;
        long b0p = 0L;
        long b0bc4 = 0L;
        long b0bc6 = 0L;
        long b0bcf = 0L;
        long b1w = 0L;
        long b1p = 0L;
        long b2w = 0L;
        long b2p = 0L;
        long s0w = 0L;
        long s0p = 0L;
        long s0bc4 = 0L;
        long s0bc6 = 0L;
        long s0bcf = 0L;
        long s0l = 0L;
        long bl0p = 0L;
        long bl0w = 0L;
        long bl0l = 0L;
        long bl1w = 0L;
        long bl1p = 0L;
        long bl1l = 0L;
        long sr0p = 0L;
        long sr0w = 0L;
        long sr0l = 0L;
        long sh0w = 0L;
        long sh0p = 0L;
        long sh0l = 0L;
        long sl0p = 0L;
        long sl0w = 0L;
        long sl0l = 0L;
        long sr1w = 0L;
        long sr1p = 0L;
        long sr1l = 0L;
        long sh1w = 0L;
        long sh1p = 0L;
        long sl1w = 0L;
        long sl1p = 0L;
        long sl1l = 0L;
        long sdl = 0L;
        long sdr = 0L;
        long bdl = 0L;
        int[] words = sentence.getWords();
        int[] tags = sentence.getTags();
        int[] bc4 = sentence.getBrownCluster4thPrefix();
        int[] bc6 = sentence.getBrownCluster6thPrefix();
        int[] bcf = sentence.getBrownClusterFullString();
        if (0 < state.bufferSize()) {
            b0Position = state.bufferHead();
            b0w = b0Position == 0 ? 0L : (long)words[b0Position - 1];
            b0w += 2L;
            b0p = b0Position == 0 ? 0L : (long)tags[b0Position - 1];
            b0p += 2L;
            b0bc4 = b0Position == 0 ? 0L : (long)bc4[b0Position - 1];
            b0bc4 += 2L;
            b0bc6 = b0Position == 0 ? 0L : (long)bc6[b0Position - 1];
            b0bc6 += 2L;
            b0bcf = b0Position == 0 ? 0L : (long)bcf[b0Position - 1];
            b0bcf += 2L;
            bvl = state.leftValency(b0Position);
            leftMost = state.leftMostModifier(state.bufferHead());
            if (leftMost >= 0) {
                bl0p = leftMost == 0 ? 0L : (long)tags[leftMost - 1];
                bl0p += 2L;
                bl0w = leftMost == 0 ? 0L : (long)words[leftMost - 1];
                bl0w += 2L;
                bl0l = state.getDependent(leftMost);
                bl0l += 2L;
                int l2 = state.leftMostModifier(leftMost);
                if (l2 >= 0) {
                    bl1w = l2 == 0 ? 0L : (long)words[l2 - 1];
                    bl1w += 2L;
                    bl1p = l2 == 0 ? 0L : (long)tags[l2 - 1];
                    bl1p += 2L;
                    bl1l = state.getDependent(l2);
                    bl1l += 2L;
                }
            }
            if (1 < state.bufferSize()) {
                b1Position = state.getBufferItem(1);
                b1w = b1Position == 0 ? 0L : (long)words[b1Position - 1];
                b1w += 2L;
                b1p = b1Position == 0 ? 0L : (long)tags[b1Position - 1];
                b1p += 2L;
                if (2 < state.bufferSize()) {
                    b2Position = state.getBufferItem(2);
                    b2w = b2Position == 0 ? 0L : (long)words[b2Position - 1];
                    b2w += 2L;
                    b2p = b2Position == 0 ? 0L : (long)tags[b2Position - 1];
                    b2p += 2L;
                }
            }
        }
        if (0 < state.stackSize()) {
            int r2;
            int l2;
            int headIndex;
            int rightMost;
            s0Position = state.stackTop();
            s0w = s0Position == 0 ? 0L : (long)words[s0Position - 1];
            s0w += 2L;
            s0p = s0Position == 0 ? 0L : (long)tags[s0Position - 1];
            s0p += 2L;
            s0bc4 = s0Position == 0 ? 0L : (long)bc4[s0Position - 1];
            s0bc4 += 2L;
            s0bc6 = s0Position == 0 ? 0L : (long)bc6[s0Position - 1];
            s0bc6 += 2L;
            s0bcf = s0Position == 0 ? 0L : (long)bcf[s0Position - 1];
            s0bcf += 2L;
            s0l = state.getDependent(s0Position);
            s0l += 2L;
            svl = state.leftValency(s0Position);
            svr = state.rightValency(s0Position);
            leftMost = state.leftMostModifier(s0Position);
            if (leftMost >= 0) {
                sl0p = leftMost == 0 ? 0L : (long)tags[leftMost - 1];
                sl0p += 2L;
                sl0w = leftMost == 0 ? 0L : (long)words[leftMost - 1];
                sl0w += 2L;
                sl0l = state.getDependent(leftMost);
                sl0l += 2L;
            }
            if ((rightMost = state.rightMostModifier(s0Position)) >= 0) {
                sr0p = rightMost == 0 ? 0L : (long)tags[rightMost - 1];
                sr0p += 2L;
                sr0w = rightMost == 0 ? 0L : (long)words[rightMost - 1];
                sr0w += 2L;
                sr0l = state.getDependent(rightMost);
                sr0l += 2L;
            }
            if ((headIndex = state.getHead(s0Position)) >= 0) {
                sh0w = headIndex == 0 ? 0L : (long)words[headIndex - 1];
                sh0w += 2L;
                sh0p = headIndex == 0 ? 0L : (long)tags[headIndex - 1];
                sh0p += 2L;
                sh0l = state.getDependent(headIndex);
                sh0l += 2L;
            }
            if (leftMost >= 0 && (l2 = state.leftMostModifier(leftMost)) >= 0) {
                sl1w = l2 == 0 ? 0L : (long)words[l2 - 1];
                sl1w += 2L;
                sl1p = l2 == 0 ? 0L : (long)tags[l2 - 1];
                sl1p += 2L;
                sl1l = state.getDependent(l2);
                sl1l += 2L;
            }
            if (headIndex >= 0 && state.hasHead(headIndex)) {
                int h2 = state.getHead(headIndex);
                sh1w = h2 == 0 ? 0L : (long)words[h2 - 1];
                sh1w += 2L;
                sh1p = h2 == 0 ? 0L : (long)tags[h2 - 1];
                sh1p += 2L;
            }
            if (rightMost >= 0 && (r2 = state.rightMostModifier(rightMost)) >= 0) {
                sr1w = r2 == 0 ? 0L : (long)words[r2 - 1];
                sr1w += 2L;
                sr1p = r2 == 0 ? 0L : (long)tags[r2 - 1];
                sr1p += 2L;
                sr1l = state.getDependent(r2);
                sr1l += 2L;
            }
        }
        int index = 0;
        long b0wp = b0p;
        b0wp |= b0w << 8;
        long b1wp = b1p;
        b1wp |= b1w << 8;
        long s0wp = s0p;
        s0wp |= s0w << 8;
        long b2wp = b2p;
        b2wp |= b2w << 8;
        if (s0w != 1L) {
            featureVector[index++] = s0wp;
            featureVector[index++] = s0w;
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        featureVector[index++] = s0p;
        if (b0w != 1L) {
            featureVector[index++] = b0wp;
            featureVector[index++] = b0w;
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        featureVector[index++] = b0p;
        if (b1w != 1L) {
            featureVector[index++] = b1wp;
            featureVector[index++] = b1w;
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        featureVector[index++] = b1p;
        if (b2w != 1L) {
            featureVector[index++] = b2wp;
            featureVector[index++] = b2w;
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        featureVector[index++] = b2p;
        if (s0w != 1L && b0w != 1L) {
            featureVector[index++] = s0wp << 28 | b0wp;
            featureVector[index++] = s0wp << 20 | b0w;
            featureVector[index++] = s0w << 28 | b0wp;
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        featureVector[index++] = s0w != 1L ? Long.valueOf(s0wp << 8 | b0p) : null;
        featureVector[index++] = b0w != 1L ? Long.valueOf(s0p << 28 | b0wp) : null;
        featureVector[index++] = s0w != 1L && b0w != 1L ? Long.valueOf(s0w << 20 | b0w) : null;
        featureVector[index++] = s0p << 8 | b0p;
        featureVector[index++] = b0p << 8 | b1p;
        featureVector[index++] = b0p << 16 | b1p << 8 | b2p;
        featureVector[index++] = s0p << 16 | b0p << 8 | b1p;
        featureVector[index++] = sh0p << 16 | s0p << 8 | b0p;
        featureVector[index++] = s0p << 16 | sl0p << 8 | b0p;
        featureVector[index++] = s0p << 16 | sr0p << 8 | b0p;
        featureVector[index++] = s0p << 16 | b0p << 8 | bl0p;
        long distance = 0L;
        if (s0Position > 0 && b0Position > 0) {
            distance = Math.abs(b0Position - s0Position);
        }
        featureVector[index++] = s0w != 1L ? Long.valueOf(s0w | distance << 20) : null;
        featureVector[index++] = s0p | distance << 8;
        featureVector[index++] = b0w != 1L ? Long.valueOf(b0w | distance << 20) : null;
        featureVector[index++] = b0p | distance << 8;
        featureVector[index++] = s0w != 1L && b0w != 1L ? Long.valueOf(s0w | b0w << 20 | distance << 40) : null;
        featureVector[index++] = s0p | b0p << 8 | distance << 28;
        featureVector[index++] = s0w != 1L ? Long.valueOf(s0w | (long)(svr << 20)) : null;
        featureVector[index++] = s0p | (long)(svr << 8);
        featureVector[index++] = s0w != 1L ? Long.valueOf(s0w | (long)(svl << 20)) : null;
        featureVector[index++] = s0p | (long)(svl << 8);
        featureVector[index++] = b0w != 1L ? Long.valueOf(b0w | (long)(bvl << 20)) : null;
        featureVector[index++] = b0p | (long)(bvl << 8);
        featureVector[index++] = sh0w != 1L ? Long.valueOf(sh0w) : null;
        featureVector[index++] = sh0p;
        featureVector[index++] = s0l;
        featureVector[index++] = sl0w != 1L ? Long.valueOf(sl0w) : null;
        featureVector[index++] = sl0p;
        featureVector[index++] = sl0l;
        featureVector[index++] = sr0w != 1L ? Long.valueOf(sr0w) : null;
        featureVector[index++] = sr0p;
        featureVector[index++] = sr0l;
        featureVector[index++] = bl0w != 1L ? Long.valueOf(bl0w) : null;
        featureVector[index++] = bl0p;
        featureVector[index++] = bl0l;
        featureVector[index++] = sh1w != 1L ? Long.valueOf(sh1w) : null;
        featureVector[index++] = sh1p;
        featureVector[index++] = sh0l;
        featureVector[index++] = sl1w != 1L ? Long.valueOf(sl1w) : null;
        featureVector[index++] = sl1p;
        featureVector[index++] = sl1l;
        featureVector[index++] = sr1w != 1L ? Long.valueOf(sr1w) : null;
        featureVector[index++] = sr1p;
        featureVector[index++] = sr1l;
        featureVector[index++] = bl1w != 1L ? Long.valueOf(bl1w) : null;
        featureVector[index++] = bl1p;
        featureVector[index++] = bl1l;
        featureVector[index++] = s0p | sl0p << 8 | sl1p << 16;
        featureVector[index++] = s0p | sr0p << 8 | sr1p << 16;
        featureVector[index++] = s0p | sh0p << 8 | sh1p << 16;
        featureVector[index++] = b0p | bl0p << 8 | bl1p << 16;
        if (s0Position >= 0) {
            sdl = state.leftDependentLabels(s0Position);
            sdr = state.rightDependentLabels(s0Position);
        }
        if (b0Position >= 0) {
            bdl = state.leftDependentLabels(b0Position);
        }
        featureVector[index++] = s0w != 1L ? s0w + "|" + sdr : null;
        featureVector[index++] = s0p + "|" + sdr;
        featureVector[index++] = s0w != 1L ? s0w + "|" + sdl : null;
        featureVector[index++] = s0p + "|" + sdl;
        featureVector[index++] = b0w != 1L ? b0w + "|" + bdl : null;
        featureVector[index++] = b0p + "|" + bdl;
        long b0wbc4 = b0bc4;
        b0wbc4 |= b0w << 12;
        if (b0w == 1L) {
            b0wbc4 = 0L;
        }
        long b0wbc6 = b0bc6;
        b0wbc6 |= b0w << 12;
        if (b0w == 1L) {
            b0wbc6 = 0L;
        }
        long b0bcfP = b0p;
        b0bcfP |= b0bcf << 8;
        long s0wbc4 = s0bc4;
        s0wbc4 |= s0w << 12;
        if (s0w == 0L) {
            s0wbc4 = 0L;
        }
        long s0wbc6 = s0bc6;
        s0wbc6 |= s0w << 12;
        if (s0w == 0L) {
            s0wbc6 = 0L;
        }
        long s0bcfP = s0p;
        s0bcfP |= s0bcf << 8;
        if (s0bcf > 0L) {
            if (s0w != 1L) {
                featureVector[index++] = s0wbc4;
                featureVector[index++] = s0wbc6;
            } else {
                featureVector[index++] = null;
                featureVector[index++] = null;
            }
            featureVector[index++] = s0bcfP;
            featureVector[index++] = s0bcf;
            featureVector[index++] = s0bc4;
            featureVector[index++] = s0bc6;
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (b0bcf > 0L) {
            if (b0w != 1L) {
                featureVector[index++] = b0wbc4;
                featureVector[index++] = b0wbc6;
            } else {
                featureVector[index++] = null;
                featureVector[index++] = null;
            }
            featureVector[index++] = b0bcfP;
            featureVector[index++] = b0bcf;
            featureVector[index++] = b0bc4;
            featureVector[index++] = b0bc6;
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (s0bcf > 0L && s0w != 1L) {
            if (b0bcf > 0L && b0w != 1L) {
                featureVector[index++] = s0wbc4 << 32 | b0wbc4;
                featureVector[index++] = s0wbc6 << 32 | b0wbc6;
            } else {
                featureVector[index++] = null;
                featureVector[index++] = null;
            }
            if (b0w != 1L) {
                featureVector[index++] = s0wbc4 << 28 | b0wp;
                featureVector[index++] = s0wbc6 << 28 | b0wp;
            } else {
                featureVector[index++] = null;
                featureVector[index++] = null;
            }
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (b0bcf > 0L && s0w != 1L & b0w != 1L) {
            featureVector[index++] = s0wp << 32 | b0wbc4;
            featureVector[index++] = s0wp << 32 | b0wbc6;
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (s0bcf > 0L && s0w != 1L) {
            if (b0w != 1L) {
                featureVector[index++] = s0wbc4 << 20 | b0w;
                featureVector[index++] = s0wbc6 << 20 | b0w;
            } else {
                featureVector[index++] = null;
                featureVector[index++] = null;
            }
            if (b0bcf > 0L) {
                featureVector[index++] = s0wbc4 << 12 | b0bcf;
                featureVector[index++] = s0wbc6 << 12 | b0bcf;
            } else {
                featureVector[index++] = null;
                featureVector[index++] = null;
            }
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        featureVector[index++] = b0bcf > 0L && s0w != 1L ? Long.valueOf(s0wp << 12 | b0bcf) : null;
        featureVector[index++] = s0bcf > 0L && b0w != 1L ? Long.valueOf(s0bcf << 28 | b0wp) : null;
        if (b0bcf > 0L) {
            if (s0w != 1L && b0w != 1L) {
                featureVector[index++] = s0w << 32 | b0wbc4;
                featureVector[index++] = s0w << 32 | b0wbc6;
            } else {
                featureVector[index++] = null;
                featureVector[index++] = null;
            }
            if (s0bcf > 0L && b0w != 1L) {
                featureVector[index++] = s0bcf << 32 | b0wbc4;
                featureVector[index++] = s0bcf << 32 | b0wbc6;
            } else {
                featureVector[index++] = null;
                featureVector[index++] = null;
            }
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (s0bcf > 0L && s0w != 1L) {
            featureVector[index++] = s0wbc4 << 8 | b0p;
            featureVector[index++] = s0wbc6 << 8 | b0p;
            if (b0bcf > 0L) {
                featureVector[index++] = s0wbc4 << 8 | b0bc4;
                featureVector[index++] = s0wbc6 << 8 | b0bc6;
            } else {
                featureVector[index++] = null;
                featureVector[index++] = null;
            }
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (s0bcf > 0L && b0w != 1L) {
            featureVector[index++] = s0bc4 << 28 | b0wp;
            featureVector[index++] = s0bc6 << 28 | b0wp;
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (b0bcf > 0L && b0w != 1L) {
            featureVector[index++] = s0p << 32 | b0wbc4;
            featureVector[index++] = s0p << 32 | b0wbc6;
            if (s0bcf > 0L) {
                featureVector[index++] = s0bc4 << 32 | b0wbc4;
                featureVector[index++] = s0bc6 << 32 | b0wbc6;
            } else {
                featureVector[index++] = null;
                featureVector[index++] = null;
            }
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        featureVector[index++] = b0bcf > 0L && s0w != 1L ? Long.valueOf(s0w << 12 | b0bcf) : null;
        if (s0bcf > 0L) {
            featureVector[index++] = b0w != 1L ? Long.valueOf(s0bcf << 20 | b0w) : null;
            featureVector[index++] = b0bcf > 0L ? Long.valueOf(s0bcf << 12 | b0bcf) : null;
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (s0bcf > 0L) {
            featureVector[index++] = s0bc4 << 8 | b0p;
            featureVector[index++] = s0bc6 << 8 | b0p;
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (b0bcf > 0L) {
            featureVector[index++] = s0p << 12 | b0bc4;
            featureVector[index++] = s0p << 12 | b0bc6;
            if (s0bcf > 0L) {
                featureVector[index++] = s0bc4 << 12 | b0bc4;
                featureVector[index++] = s0bc6 << 12 | b0bc6;
            } else {
                featureVector[index++] = null;
                featureVector[index++] = null;
            }
            featureVector[index++] = b0bc4 << 8 | b1p;
            featureVector[index++] = b0bc6 << 8 | b1p;
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (b0bcf > 0L) {
            featureVector[index++] = b0bc4 << 16 | b1p << 8 | b2p;
            featureVector[index++] = b0bc6 << 16 | b1p << 8 | b2p;
            featureVector[index++] = s0p << 20 | b0bc4 << 8 | b1p;
            featureVector[index++] = s0p << 20 | b0bc6 << 8 | b1p;
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (s0bcf > 0L) {
            featureVector[index++] = s0bc4 << 16 | b2p << 8 | b1p;
            featureVector[index++] = s0bc6 << 16 | b2p << 8 | b1p;
            if (b0bcf > 0L) {
                featureVector[index++] = s0bc4 << 20 | b0bc4 << 8 | b1p;
                featureVector[index++] = s0bc6 << 20 | b0bc6 << 8 | b1p;
            } else {
                featureVector[index++] = null;
                featureVector[index++] = null;
            }
            featureVector[index++] = sh0p << 20 | s0bc4 << 8 | b0p;
            featureVector[index++] = sh0p << 20 | s0bc6 << 8 | b0p;
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (b0bcf > 0L) {
            featureVector[index++] = sh0p << 20 | s0p << 12 | b0bc4;
            featureVector[index++] = sh0p << 20 | s0p << 12 | b0bc6;
            if (s0bcf > 0L) {
                featureVector[index++] = sh0p << 24 | s0bc4 << 12 | b0bc4;
                featureVector[index++] = sh0p << 24 | s0bc6 << 12 | b0bc6;
            } else {
                featureVector[index++] = null;
                featureVector[index++] = null;
            }
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (b0bcf > 0L) {
            featureVector[index++] = s0p << 20 | sl0p << 12 | b0bc4;
            featureVector[index++] = s0p << 20 | sl0p << 12 | b0bc6;
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (s0bcf > 0L) {
            featureVector[index++] = s0bc4 << 16 | sl0p << 8 | b0p;
            featureVector[index++] = s0bc6 << 16 | sl0p << 8 | b0p;
            if (b0bcf > 0L) {
                featureVector[index++] = s0bc4 << 20 | sl0p << 12 | b0bc4;
                featureVector[index++] = s0bc6 << 20 | sl0p << 12 | b0bc6;
            } else {
                featureVector[index++] = null;
                featureVector[index++] = null;
            }
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (b0bcf > 0L) {
            featureVector[index++] = s0p << 20 | sr0p << 12 | b0bc4;
            featureVector[index++] = s0p << 20 | sr0p << 12 | b0bc6;
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (s0bcf > 0L) {
            featureVector[index++] = s0bc4 << 16 | sr0p << 8 | b0p;
            featureVector[index++] = s0bc6 << 16 | sr0p << 8 | b0p;
            if (b0bcf > 0L) {
                featureVector[index++] = s0bc4 << 20 | sr0p << 12 | b0bc4;
                featureVector[index++] = s0bc6 << 20 | sr0p << 12 | b0bc6;
            } else {
                featureVector[index++] = null;
                featureVector[index++] = null;
            }
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (b0bcf > 0L) {
            featureVector[index++] = s0p << 20 | b0bc4 << 8 | bl0p;
            featureVector[index++] = s0p << 20 | b0bc6 << 8 | bl0p;
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        if (s0bcf > 0L) {
            featureVector[index++] = s0bc4 << 16 | b0p << 8 | bl0p;
            featureVector[index++] = s0bc6 << 16 | b0p << 8 | bl0p;
            if (b0bcf > 0L) {
                featureVector[index++] = s0bc4 << 20 | b0bc4 << 8 | bl0p;
                featureVector[index++] = s0bc6 << 20 | b0bc6 << 8 | bl0p;
            } else {
                featureVector[index++] = null;
                featureVector[index++] = null;
            }
        } else {
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
            featureVector[index++] = null;
        }
        return featureVector;
    }
}

