/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.rules;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRulePerformer;
import org.languagetool.rules.patterns.AbstractTokenBasedRule;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.MatchState;
import org.languagetool.rules.patterns.PatternRuleMatcher;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.rules.patterns.RuleFilterEvaluator;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;

class DisambiguationPatternRuleReplacer
extends AbstractPatternRulePerformer {
    DisambiguationPatternRuleReplacer(DisambiguationPatternRule rule) {
        super(rule, rule.getLanguage().getDisambiguationUnifier());
    }

    AnalyzedSentence replace(AnalyzedSentence sentence) throws IOException {
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        AnalyzedTokenReadings[] preDisambigTokens = sentence.getTokens();
        AnalyzedTokenReadings[][] whTokens = new AnalyzedTokenReadings[][]{sentence.getTokens()};
        boolean[] changed = new boolean[]{false};
        this.doMatch(sentence, tokens, (tokenPositions, firstMatchToken, lastMatchToken, firstMarkerMatchToken, lastMarkerMatchToken) -> {
            int ruleMatchFromPos = -1;
            int ruleMatchToPos = -1;
            int tokenCount = 0;
            for (AnalyzedTokenReadings token : tokens) {
                if (ruleMatchFromPos == -1 && tokenCount == firstMatchToken) {
                    ruleMatchFromPos = token.getStartPos();
                }
                if (ruleMatchToPos == -1 && tokenCount == lastMatchToken) {
                    ruleMatchToPos = token.getEndPos();
                }
                ++tokenCount;
            }
            int matchingTokens = (int)Arrays.stream(tokenPositions).filter(i -> i != 0).count();
            if (this.keepDespiteFilter(tokens, tokenPositions, firstMatchToken, lastMatchToken) && this.keepByDisambig(sentence, ruleMatchFromPos, ruleMatchToPos)) {
                whTokens[0] = this.executeAction(sentence, whTokens[0], this.unifiedTokens, firstMatchToken, lastMarkerMatchToken, matchingTokens, tokenPositions);
                changed[0] = true;
            }
        });
        if (changed[0]) {
            return new AnalyzedSentence(whTokens[0], preDisambigTokens);
        }
        return sentence;
    }

    private boolean keepByDisambig(AnalyzedSentence sentence, int ruleMatchFromPos, int ruleMatchToPos) throws IOException {
        List<DisambiguationPatternRule> antiPatterns = this.rule.getAntiPatterns();
        for (DisambiguationPatternRule antiPattern : antiPatterns) {
            RuleMatch[] matches;
            if (antiPattern.canBeIgnoredFor(sentence)) continue;
            for (RuleMatch disMatch : matches = new PatternRuleMatcher((AbstractTokenBasedRule)antiPattern, false).match(sentence)) {
                if (!(disMatch.getFromPos() <= ruleMatchFromPos && disMatch.getToPos() >= ruleMatchFromPos || disMatch.getFromPos() <= ruleMatchToPos && disMatch.getToPos() >= ruleMatchToPos) && (disMatch.getFromPos() < ruleMatchFromPos || disMatch.getToPos() > ruleMatchToPos)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean keepDespiteFilter(AnalyzedTokenReadings[] tokens, int[] tokenPositions, int firstMatchToken, int lastMatchToken) throws IOException {
        RuleFilter filter = this.rule.getFilter();
        if (filter != null) {
            RuleFilterEvaluator ruleFilterEval = new RuleFilterEvaluator(filter);
            List<Integer> tokensPos = IntStream.of(tokenPositions).boxed().collect(Collectors.toList());
            Map<String, String> resolvedArguments = ruleFilterEval.getResolvedArguments(this.rule.getFilterArguments(), tokens, firstMatchToken, tokensPos);
            AnalyzedTokenReadings[] relevantTokens = Arrays.copyOfRange(tokens, firstMatchToken, lastMatchToken + 1);
            return filter.matches(resolvedArguments, relevantTokens, firstMatchToken);
        }
        return true;
    }

    private AnalyzedTokenReadings[] executeAction(AnalyzedSentence sentence, AnalyzedTokenReadings[] whiteTokens, AnalyzedTokenReadings[] unifiedTokens, int firstMatchToken, int lastMatchToken, int matchingTokens, int[] tokenPositions) {
        AnalyzedTokenReadings[] whTokens = (AnalyzedTokenReadings[])whiteTokens.clone();
        DisambiguationPatternRule rule = (DisambiguationPatternRule)this.rule;
        int correctedStPos = 0;
        int startPositionCorrection = rule.getStartPositionCorrection();
        int endPositionCorrection = rule.getEndPositionCorrection();
        int matchingTokensWithCorrection = matchingTokens;
        if (startPositionCorrection > 0) {
            --correctedStPos;
            for (int l = 0; l <= startPositionCorrection && l < tokenPositions.length; ++l) {
                correctedStPos += tokenPositions[l];
            }
            int w = startPositionCorrection;
            for (int j = 0; j <= w; ++j) {
                if (j >= tokenPositions.length || tokenPositions[j] != 0) continue;
                --startPositionCorrection;
            }
        }
        if (endPositionCorrection < 0) {
            for (int d = startPositionCorrection; d < tokenPositions.length; ++d) {
                if (tokenPositions[d] != 0) continue;
                ++endPositionCorrection;
            }
        }
        if (lastMatchToken != -1) {
            int maxPosCorrection = Math.max(lastMatchToken + 1 - (firstMatchToken + correctedStPos) - matchingTokens, 0);
            matchingTokensWithCorrection += maxPosCorrection;
        }
        int fromPos = sentence.getOriginalPosition(firstMatchToken + correctedStPos);
        DisambiguationPatternRule.DisambiguatorAction disAction = rule.getAction();
        AnalyzedToken[] newTokenReadings = rule.getNewTokenReadings();
        Match matchElement = rule.getMatchElement();
        String disambiguatedPOS = rule.getDisambiguatedPOS();
        switch (disAction) {
            case UNIFY: {
                if (unifiedTokens == null || unifiedTokens.length != matchingTokensWithCorrection - startPositionCorrection + endPositionCorrection) break;
                if (whTokens[sentence.getOriginalPosition(firstMatchToken + correctedStPos + unifiedTokens.length - 1)].isSentenceEnd()) {
                    unifiedTokens[unifiedTokens.length - 1].setSentEnd();
                }
                for (int i = 0; i < unifiedTokens.length; ++i) {
                    int position = sentence.getOriginalPosition(firstMatchToken + correctedStPos + i);
                    whTokens[position] = new AnalyzedTokenReadings(whTokens[position], unifiedTokens[i].getReadings(), rule.getFullId());
                }
                break;
            }
            case REMOVE: {
                if (newTokenReadings != null && newTokenReadings.length > 0) {
                    if (newTokenReadings.length != matchingTokensWithCorrection - startPositionCorrection + endPositionCorrection) break;
                    for (int i = 0; i < newTokenReadings.length; ++i) {
                        int position = sentence.getOriginalPosition(firstMatchToken + correctedStPos + i);
                        whTokens[position].removeReading(newTokenReadings[i], rule.getFullId());
                    }
                } else {
                    if (StringTools.isEmpty(disambiguatedPOS)) break;
                    Pattern p = Pattern.compile(disambiguatedPOS);
                    AnalyzedTokenReadings tmp = new AnalyzedTokenReadings(whTokens[fromPos].getReadings(), whTokens[fromPos].getStartPos());
                    for (AnalyzedToken analyzedToken : tmp) {
                        if (analyzedToken.getPOSTag() == null || !p.matcher(analyzedToken.getPOSTag()).matches()) continue;
                        int position = sentence.getOriginalPosition(firstMatchToken + correctedStPos);
                        whTokens[position].removeReading(analyzedToken, rule.getFullId());
                    }
                }
                break;
            }
            case ADD: {
                if (newTokenReadings == null || newTokenReadings.length != matchingTokensWithCorrection - startPositionCorrection + endPositionCorrection) break;
                for (int i = 0; i < newTokenReadings.length; ++i) {
                    int position = sentence.getOriginalPosition(firstMatchToken + correctedStPos + i);
                    String token = newTokenReadings[i].getToken().isEmpty() ? whTokens[position].getToken() : newTokenReadings[i].getToken();
                    String lemma = newTokenReadings[i].getLemma() == null ? token : newTokenReadings[i].getLemma();
                    AnalyzedToken newTok = new AnalyzedToken(token, newTokenReadings[i].getPOSTag(), lemma);
                    whTokens[position].addReading(newTok, rule.getFullId());
                }
                break;
            }
            case FILTERALL: {
                for (int i = 0; i < matchingTokensWithCorrection - startPositionCorrection + endPositionCorrection; ++i) {
                    PatternToken pToken;
                    int position = sentence.getOriginalPosition(firstMatchToken + correctedStPos + i);
                    if (tokenPositions[i + startPositionCorrection] > 0) {
                        pToken = rule.getPatternTokens().get(i + startPositionCorrection);
                    } else {
                        int k = 1;
                        while (i + startPositionCorrection + k < rule.getPatternTokens().size() + endPositionCorrection && tokenPositions[i + startPositionCorrection + k] == 0) {
                            ++k;
                        }
                        pToken = rule.getPatternTokens().get(i + k + startPositionCorrection);
                    }
                    Match tmpMatchToken = new Match(pToken.getPOStag(), null, true, pToken.getPOStag(), null, Match.CaseConversion.NONE, false, false, Match.IncludeRange.NONE);
                    MatchState matchState = tmpMatchToken.createState(rule.getLanguage().getSynthesizer(), whTokens[position]);
                    whTokens[position] = new AnalyzedTokenReadings(whTokens[position], matchState.filterReadings().getReadings(), rule.getFullId());
                }
                break;
            }
            case IMMUNIZE: {
                for (int i = 0; i < matchingTokensWithCorrection - startPositionCorrection + endPositionCorrection; ++i) {
                    whTokens[sentence.getOriginalPosition(firstMatchToken + correctedStPos + i)].immunize(rule.getXmlLineNumber());
                }
                break;
            }
            case IGNORE_SPELLING: {
                for (int i = 0; i < matchingTokensWithCorrection - startPositionCorrection + endPositionCorrection; ++i) {
                    whTokens[sentence.getOriginalPosition(firstMatchToken + correctedStPos + i)].ignoreSpelling();
                }
                break;
            }
            case FILTER: {
                if (matchElement == null) {
                    Match tmpMatchToken = new Match(disambiguatedPOS, null, true, disambiguatedPOS, null, Match.CaseConversion.NONE, false, false, Match.IncludeRange.NONE);
                    boolean newPOSmatches = false;
                    for (int i = 0; i < whTokens[fromPos].getReadingsLength(); ++i) {
                        if (whTokens[fromPos].getAnalyzedToken(i).hasNoTag() || whTokens[fromPos].getAnalyzedToken(i).getPOSTag() == null || !whTokens[fromPos].getAnalyzedToken(i).getPOSTag().matches(disambiguatedPOS)) continue;
                        newPOSmatches = true;
                        break;
                    }
                    if (!newPOSmatches) break;
                    MatchState matchState = tmpMatchToken.createState(rule.getLanguage().getSynthesizer(), whTokens[fromPos]);
                    whTokens[fromPos] = new AnalyzedTokenReadings(whTokens[fromPos], matchState.filterReadings().getReadings(), rule.getFullId());
                    break;
                }
            }
            default: {
                if (newTokenReadings != null && newTokenReadings.length > 0) {
                    if (newTokenReadings.length != matchingTokensWithCorrection - startPositionCorrection + endPositionCorrection) break;
                    for (int i = 0; i < newTokenReadings.length; ++i) {
                        int position = sentence.getOriginalPosition(firstMatchToken + correctedStPos + i);
                        String token = "".equals(newTokenReadings[i].getToken()) ? whTokens[position].getToken() : newTokenReadings[i].getToken();
                        String lemma = newTokenReadings[i].getLemma() == null ? token : newTokenReadings[i].getLemma();
                        AnalyzedToken analyzedToken = new AnalyzedToken(token, newTokenReadings[i].getPOSTag(), lemma);
                        AnalyzedTokenReadings toReplace = new AnalyzedTokenReadings(analyzedToken, whTokens[fromPos].getStartPos());
                        whTokens[position] = new AnalyzedTokenReadings(whTokens[position], toReplace.getReadings(), rule.getFullId());
                    }
                    break;
                }
                if (matchElement == null) {
                    String lemma = "";
                    for (AnalyzedToken analyzedToken : whTokens[fromPos]) {
                        if (analyzedToken.getPOSTag() == null || !analyzedToken.getPOSTag().equals(disambiguatedPOS) || analyzedToken.getLemma() == null) continue;
                        lemma = analyzedToken.getLemma();
                    }
                    if (StringTools.isEmpty(lemma)) {
                        lemma = whTokens[fromPos].getAnalyzedToken(0).getLemma();
                    }
                    AnalyzedToken analyzedToken = new AnalyzedToken(whTokens[fromPos].getToken(), disambiguatedPOS, lemma);
                    AnalyzedTokenReadings toReplace = new AnalyzedTokenReadings(analyzedToken, whTokens[fromPos].getStartPos());
                    whTokens[fromPos] = new AnalyzedTokenReadings(whTokens[fromPos], toReplace.getReadings(), rule.getFullId());
                    break;
                }
                MatchState matchElementState = matchElement.createState(rule.getLanguage().getSynthesizer(), whTokens[fromPos]);
                whTokens[fromPos] = new AnalyzedTokenReadings(whTokens[fromPos], matchElementState.filterReadings().getReadings(), rule.getFullId());
                matchElementState.filterReadings();
            }
        }
        return whTokens;
    }
}

