/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.dictionary;

import java.util.BitSet;
import java.util.NoSuchElementException;
import net.java.sen.dictionary.Reading;
import net.java.sen.dictionary.SentenceIterator;

public class Sentence {
    private char[] characters;
    private BitSet breakingIgnoreSet;
    private Reading[] constraints;

    public void setBreakingIgnoreSpan(int position, short length) {
        this.breakingIgnoreSet.set(position, position + length);
    }

    public void setReadingConstraint(Reading constraint) {
        if (constraint.start < 0 || constraint.start >= this.characters.length) {
            throw new IllegalArgumentException("Invalid constraint starting position");
        }
        if (constraint.length <= 0 || constraint.start + constraint.length - 1 >= this.characters.length) {
            throw new IllegalArgumentException("Invalid constraint length");
        }
        if (constraint.text == null) {
            throw new IllegalArgumentException("Invalid constraint reading");
        }
        boolean done = false;
        for (int i = constraint.start + constraint.length - 1; i >= 0 && !done; --i) {
            if (this.constraints[i] == null) continue;
            if (i + this.constraints[i].length - 1 >= constraint.start) {
                this.constraints[i] = null;
                continue;
            }
            done = true;
        }
        this.constraints[constraint.start] = constraint;
    }

    public Reading getReadingConstraint(int position) {
        return this.constraints[position];
    }

    public void removeReadingConstraint(int position) {
        this.constraints[position] = null;
    }

    public SentenceIterator iterator() {
        return new ConstrainedIterator();
    }

    public SentenceIterator unconstrainedIterator(int position) {
        return new UnconstrainedIterator(position);
    }

    public char[] getCharacters() {
        return this.characters;
    }

    public Sentence(char[] characters) {
        this.characters = characters;
        this.breakingIgnoreSet = new BitSet(characters.length);
        this.constraints = new Reading[characters.length];
    }

    public Sentence(String text) {
        this(text.toCharArray());
    }

    private class UnconstrainedIterator
    implements SentenceIterator {
        private int origin = -1;
        private int nextIndex = -1;
        private Boolean nextIndexValid = null;

        @Override
        public char current() {
            return Sentence.this.characters[this.nextIndex];
        }

        @Override
        public boolean hasNextOrigin() {
            return false;
        }

        @Override
        public int length() {
            return Sentence.this.characters.length;
        }

        @Override
        public int nextOrigin() {
            throw new IllegalStateException();
        }

        @Override
        public int origin() {
            return this.origin;
        }

        @Override
        public void rewindToOrigin() {
            this.nextIndex = this.origin;
        }

        @Override
        public int skippedCharCount() {
            return 0;
        }

        @Override
        public boolean hasNext() {
            boolean nextIndexValid = this.nextIndex >= Sentence.this.characters.length ? false : (Sentence.this.breakingIgnoreSet.get(this.nextIndex) ? false : Sentence.this.characters[this.nextIndex] != ' ' && Sentence.this.characters[this.nextIndex] != '\t' && Sentence.this.characters[this.nextIndex] != '\r' && Sentence.this.characters[this.nextIndex] != '\n');
            this.nextIndexValid = nextIndexValid;
            return nextIndexValid;
        }

        @Override
        public char next() throws NoSuchElementException {
            if (this.nextIndexValid == null) {
                this.hasNext();
            }
            if (!this.nextIndexValid.booleanValue()) {
                throw new NoSuchElementException();
            }
            char nextCharacter = Sentence.this.characters[this.nextIndex];
            ++this.nextIndex;
            this.nextIndexValid = null;
            return nextCharacter;
        }

        public UnconstrainedIterator(int origin) {
            this.origin = origin;
            this.nextIndex = origin;
        }
    }

    private class ConstrainedIterator
    implements SentenceIterator {
        private int nextIndex = -1;
        private Boolean nextIndexValid = null;
        private int nextSkipped = -1;
        private int nextOrigin = -1;
        private int nextLimit = -1;
        private int skipped = -1;
        private int origin = -1;
        private int limit = -1;

        private ConstrainedIterator() {
        }

        private void findNextOrigin() {
            int nextOrigin = -1;
            int nextSkipped = 0;
            int i = this.origin;
            i = i >= 0 && Sentence.this.constraints[i] != null ? (i += ((Sentence)Sentence.this).constraints[i].length) : ++i;
            int j = i;
            while (j < Sentence.this.characters.length) {
                if (Sentence.this.breakingIgnoreSet.get(j)) {
                    j = Sentence.this.breakingIgnoreSet.nextClearBit(j);
                    continue;
                }
                if (Sentence.this.characters[j] == ' ' || Sentence.this.characters[j] == '\t' || Sentence.this.characters[j] == '\r' || Sentence.this.characters[j] == '\n') {
                    ++j;
                    continue;
                }
                nextOrigin = j;
                nextSkipped = j - i;
                break;
            }
            this.nextOrigin = nextOrigin;
            this.nextSkipped = nextSkipped;
            this.nextLimit = this.nextOrigin >= 0 && this.nextOrigin < Sentence.this.characters.length && Sentence.this.constraints[this.nextOrigin] != null ? this.nextOrigin + ((Sentence)Sentence.this).constraints[this.nextOrigin].length : Sentence.this.characters.length;
        }

        @Override
        public char current() {
            return Sentence.this.characters[this.nextIndex];
        }

        @Override
        public boolean hasNextOrigin() {
            if (this.nextOrigin == -1) {
                this.findNextOrigin();
            }
            return this.nextOrigin != -1;
        }

        @Override
        public int length() {
            return Sentence.this.characters.length;
        }

        @Override
        public int nextOrigin() {
            if (this.nextOrigin == -1) {
                this.findNextOrigin();
            }
            this.skipped = this.nextSkipped;
            this.origin = this.nextOrigin;
            this.limit = this.nextLimit;
            this.nextIndex = this.origin;
            this.findNextOrigin();
            return this.origin;
        }

        @Override
        public int origin() {
            return this.origin;
        }

        @Override
        public void rewindToOrigin() {
            this.nextIndex = this.origin;
        }

        @Override
        public int skippedCharCount() {
            return this.skipped;
        }

        @Override
        public boolean hasNext() {
            boolean nextIndexValid = this.nextIndex >= this.limit ? false : (Sentence.this.breakingIgnoreSet.get(this.nextIndex) ? false : (this.nextIndex > this.origin && Sentence.this.constraints[this.nextIndex] != null ? false : Sentence.this.characters[this.nextIndex] != ' ' && Sentence.this.characters[this.nextIndex] != '\t' && Sentence.this.characters[this.nextIndex] != '\r' && Sentence.this.characters[this.nextIndex] != '\n'));
            this.nextIndexValid = nextIndexValid;
            return nextIndexValid;
        }

        @Override
        public char next() throws NoSuchElementException {
            if (this.nextIndexValid == null) {
                this.hasNext();
            }
            if (!this.nextIndexValid.booleanValue()) {
                throw new NoSuchElementException();
            }
            char nextCharacter = Sentence.this.characters[this.nextIndex];
            ++this.nextIndex;
            this.nextIndexValid = null;
            return nextCharacter;
        }
    }
}

