/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf.crfpp;

import com.hankcs.hanlp.model.crf.crfpp.Node;
import com.hankcs.hanlp.model.crf.crfpp.Path;
import com.hankcs.hanlp.model.crf.crfpp.TaggerImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class FeatureIndex {
    public static String[] BOS = new String[]{"_B-1", "_B-2", "_B-3", "_B-4", "_B-5", "_B-6", "_B-7", "_B-8"};
    public static String[] EOS = new String[]{"_B+1", "_B+2", "_B+3", "_B+4", "_B+5", "_B+6", "_B+7", "_B+8"};
    protected int maxid_ = 0;
    protected double[] alpha_ = null;
    protected float[] alphaFloat_ = null;
    protected double costFactor_ = 1.0;
    protected int xsize_ = 0;
    protected boolean checkMaxXsize_ = false;
    protected int max_xsize_ = 0;
    protected int threadNum_ = 1;
    protected List<String> unigramTempls_ = new ArrayList<String>();
    protected List<String> bigramTempls_ = new ArrayList<String>();
    protected String templs_;
    protected List<String> y_ = new ArrayList<String>();
    protected List<List<Path>> pathList_;
    protected List<List<Node>> nodeList_;

    protected abstract int getID(String var1);

    public void calcCost(Node node) {
        node.cost = 0.0;
        if (this.alphaFloat_ != null) {
            float c = 0.0f;
            int i = 0;
            while (node.fVector.get(i) != -1) {
                c += this.alphaFloat_[node.fVector.get(i) + node.y];
                ++i;
            }
            node.cost = this.costFactor_ * (double)c;
        } else {
            double c = 0.0;
            int i = 0;
            while (node.fVector.get(i) != -1) {
                c += this.alpha_[node.fVector.get(i) + node.y];
                ++i;
            }
            node.cost = this.costFactor_ * c;
        }
    }

    public void calcCost(Path path) {
        path.cost = 0.0;
        if (this.alphaFloat_ != null) {
            float c = 0.0f;
            int i = 0;
            while (path.fvector.get(i) != -1) {
                c += this.alphaFloat_[path.fvector.get(i) + path.lnode.y * this.y_.size() + path.rnode.y];
                ++i;
            }
            path.cost = this.costFactor_ * (double)c;
        } else {
            double c = 0.0;
            int i = 0;
            while (path.fvector.get(i) != -1) {
                c += this.alpha_[path.fvector.get(i) + path.lnode.y * this.y_.size() + path.rnode.y];
                ++i;
            }
            path.cost = this.costFactor_ * c;
        }
    }

    public String makeTempls(List<String> unigramTempls, List<String> bigramTempls) {
        StringBuilder sb = new StringBuilder();
        for (String temp : unigramTempls) {
            sb.append(temp).append("\n");
        }
        for (String temp : bigramTempls) {
            sb.append(temp).append("\n");
        }
        return sb.toString();
    }

    public String getTemplate() {
        return this.templs_;
    }

    public String getIndex(String[] idxStr, int cur, TaggerImpl tagger) {
        int row = Integer.valueOf(idxStr[0]);
        int col = Integer.valueOf(idxStr[1]);
        int pos = row + cur;
        if (row < -EOS.length || row > EOS.length || col < 0 || col >= tagger.xsize()) {
            return null;
        }
        if (this.checkMaxXsize_) {
            this.max_xsize_ = Math.max(this.max_xsize_, col + 1);
        }
        if (pos < 0) {
            return BOS[-pos - 1];
        }
        if (pos >= tagger.size()) {
            return EOS[pos - tagger.size()];
        }
        return tagger.x(pos, col);
    }

    public String applyRule(String str, int cur, TaggerImpl tagger) {
        StringBuilder sb = new StringBuilder();
        for (String tmp : str.split("%x", -1)) {
            if (tmp.startsWith("U") || tmp.startsWith("B")) {
                sb.append(tmp);
                continue;
            }
            if (tmp.length() <= 0) continue;
            String[] tuple = tmp.split("]");
            String[] idx = tuple[0].replace("[", "").split(",");
            String r = this.getIndex(idx, cur, tagger);
            if (r != null) {
                sb.append(r);
            }
            if (tuple.length <= 1) continue;
            sb.append(tuple[1]);
        }
        return sb.toString();
    }

    private boolean buildFeatureFromTempl(List<Integer> feature, List<String> templs, int curPos, TaggerImpl tagger) {
        for (String tmpl : templs) {
            String featureID = this.applyRule(tmpl, curPos, tagger);
            if (featureID == null || featureID.length() == 0) {
                System.err.println("format error");
                return false;
            }
            int id = this.getID(featureID);
            if (id == -1) continue;
            feature.add(id);
        }
        return true;
    }

    public boolean buildFeatures(TaggerImpl tagger) {
        int cur;
        ArrayList<Integer> feature = new ArrayList<Integer>();
        List<List<Integer>> featureCache = tagger.getFeatureCache_();
        tagger.setFeature_id_(featureCache.size());
        for (cur = 0; cur < tagger.size(); ++cur) {
            if (!this.buildFeatureFromTempl(feature, this.unigramTempls_, cur, tagger)) {
                return false;
            }
            feature.add(-1);
            featureCache.add(feature);
            feature = new ArrayList();
        }
        for (cur = 1; cur < tagger.size(); ++cur) {
            if (!this.buildFeatureFromTempl(feature, this.bigramTempls_, cur, tagger)) {
                return false;
            }
            feature.add(-1);
            featureCache.add(feature);
            feature = new ArrayList();
        }
        return true;
    }

    public void rebuildFeatures(TaggerImpl tagger) {
        List<Integer> f;
        int cur;
        int fid = tagger.getFeature_id_();
        List<List<Integer>> featureCache = tagger.getFeatureCache_();
        for (cur = 0; cur < tagger.size(); ++cur) {
            f = featureCache.get(fid++);
            for (int i = 0; i < this.y_.size(); ++i) {
                Node n = new Node();
                n.clear();
                n.x = cur;
                n.y = i;
                n.fVector = f;
                tagger.set_node(n, cur, i);
            }
        }
        for (cur = 1; cur < tagger.size(); ++cur) {
            f = featureCache.get(fid++);
            for (int j = 0; j < this.y_.size(); ++j) {
                for (int i = 0; i < this.y_.size(); ++i) {
                    Path p = new Path();
                    p.clear();
                    p.add(tagger.node(cur - 1, j), tagger.node(cur, i));
                    p.fvector = f;
                }
            }
        }
    }

    public boolean open(String file) {
        return true;
    }

    public boolean open(InputStream stream) {
        return true;
    }

    public void clear() {
    }

    public int size() {
        return this.getMaxid_();
    }

    public int ysize() {
        return this.y_.size();
    }

    public int getMaxid_() {
        return this.maxid_;
    }

    public void setMaxid_(int maxid_) {
        this.maxid_ = maxid_;
    }

    public double[] getAlpha_() {
        return this.alpha_;
    }

    public void setAlpha_(double[] alpha_) {
        this.alpha_ = alpha_;
    }

    public float[] getAlphaFloat_() {
        return this.alphaFloat_;
    }

    public void setAlphaFloat_(float[] alphaFloat_) {
        this.alphaFloat_ = alphaFloat_;
    }

    public double getCostFactor_() {
        return this.costFactor_;
    }

    public void setCostFactor_(double costFactor_) {
        this.costFactor_ = costFactor_;
    }

    public int getXsize_() {
        return this.xsize_;
    }

    public void setXsize_(int xsize_) {
        this.xsize_ = xsize_;
    }

    public int getMax_xsize_() {
        return this.max_xsize_;
    }

    public void setMax_xsize_(int max_xsize_) {
        this.max_xsize_ = max_xsize_;
    }

    public int getThreadNum_() {
        return this.threadNum_;
    }

    public void setThreadNum_(int threadNum_) {
        this.threadNum_ = threadNum_;
    }

    public List<String> getUnigramTempls_() {
        return this.unigramTempls_;
    }

    public void setUnigramTempls_(List<String> unigramTempls_) {
        this.unigramTempls_ = unigramTempls_;
    }

    public List<String> getBigramTempls_() {
        return this.bigramTempls_;
    }

    public void setBigramTempls_(List<String> bigramTempls_) {
        this.bigramTempls_ = bigramTempls_;
    }

    public List<String> getY_() {
        return this.y_;
    }

    public void setY_(List<String> y_) {
        this.y_ = y_;
    }

    public List<List<Path>> getPathList_() {
        return this.pathList_;
    }

    public void setPathList_(List<List<Path>> pathList_) {
        this.pathList_ = pathList_;
    }

    public List<List<Node>> getNodeList_() {
        return this.nodeList_;
    }

    public void setNodeList_(List<List<Node>> nodeList_) {
        this.nodeList_ = nodeList_;
    }
}

