/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.android;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cordova.platforms.android.AndroidActionProvider;
import org.netbeans.modules.cordova.platforms.android.AndroidConfigurationPanel;
import org.netbeans.modules.cordova.platforms.android.AndroidDebugTransport;
import org.netbeans.modules.cordova.platforms.android.AndroidPlatform;
import org.netbeans.modules.cordova.platforms.api.ProcessUtilities;
import org.netbeans.modules.cordova.platforms.spi.Device;
import org.netbeans.modules.cordova.platforms.spi.MobileDebugTransport;
import org.netbeans.modules.cordova.platforms.spi.MobilePlatform;
import org.netbeans.modules.cordova.platforms.spi.PropertyProvider;
import org.netbeans.modules.web.clientproject.spi.platform.ProjectConfigurationCustomizer;
import org.netbeans.spi.project.ActionProvider;
import org.openide.util.Exceptions;

public class AVD
implements Device {
    private String name;
    private HashMap<String, String> props = new HashMap();

    private AVD() {
    }

    public static Collection<Device> parse(String output) throws IOException {
        BufferedReader r = new BufferedReader(new StringReader(output));
        Pattern pattern = Pattern.compile(" *([\\w]*): (.*)");
        ArrayList<Device> result = new ArrayList<Device>();
        String line = r.readLine();
        line = r.readLine();
        AVD current = new AVD();
        String lastProp = null;
        while (line != null) {
            Matcher m = pattern.matcher(line);
            if (m.matches()) {
                if ("Name".equals(m.group(1))) {
                    current.name = m.group(2);
                } else {
                    current.props.put(m.group(1), m.group(2));
                    lastProp = m.group(1);
                }
            } else if (line.contains("---------")) {
                result.add(current);
                current = new AVD();
            } else {
                current.props.put(lastProp, current.props.get(lastProp) + line);
            }
            if ((line = r.readLine()) != null || current.name == null) continue;
            result.add(current);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "AVD{name=" + this.name + ", props=" + this.props + '}';
    }

    public boolean isEmulator() {
        return true;
    }

    public MobilePlatform getPlatform() {
        return AndroidPlatform.getDefault();
    }

    public void addProperties(Properties props) {
        MobilePlatform android = this.getPlatform();
        props.put("android.build.target", android.getPrefferedTarget().getName());
        props.put("android.sdk.home", android.getSdkLocation());
        props.put("android.target.device.arg", this.isEmulator() ? "emulate" : "run");
    }

    public ActionProvider getActionProvider(Project p) {
        return new AndroidActionProvider(p);
    }

    public ProjectConfigurationCustomizer getProjectConfigurationCustomizer(Project project, PropertyProvider aThis) {
        return new AndroidConfigurationPanel.AndroidConfigurationCustomizer(project, aThis);
    }

    public void openUrl(String url) {
        try {
            String string = ProcessUtilities.callProcess((String)((AndroidPlatform)this.getPlatform()).getAdbCommand(), (boolean)false, (int)AndroidPlatform.DEFAULT_TIMEOUT, (String[])new String[]{this.isEmulator() ? "-d" : "-e", "wait-for-device", "shell", "am", "start", "-a", "android.intent.action.VIEW", "-n", "com.android.browser/.BrowserActivity", url});
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public MobileDebugTransport getDebugTransport() {
        return new AndroidDebugTransport();
    }

    public boolean isWebViewDebugSupported() {
        return AndroidPlatform.getDefault().isWebViewDebugSupported(this.isEmulator());
    }
}

