/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.RenamePropertyRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.ui.JavaRenameProperties;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.spi.gototest.TestLocator;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class RenameTestClassRefactoringPlugin
extends JavaRefactoringPlugin {
    public static final EnumSet<ElementKind> SUPPORTED = EnumSet.of(ElementKind.CLASS, ElementKind.ENUM, ElementKind.INTERFACE, ElementKind.ANNOTATION_TYPE, ElementKind.METHOD);
    private RenameRefactoring refactoring;
    private TreePathHandle treePathHandle;
    private RenameRefactoring[] renameDelegates;
    private boolean inited = false;

    public RenameTestClassRefactoringPlugin(RenameRefactoring rename) {
        this.refactoring = rename;
        this.treePathHandle = (TreePathHandle)rename.getRefactoringSource().lookup(TreePathHandle.class);
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase phase) {
        return JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject());
    }

    @Override
    public Problem checkParameters() {
        if (!this.isRenameTestClass() && !this.isRenameTestClassMethod()) {
            return null;
        }
        this.initDelegates();
        Problem p = null;
        for (RenameRefactoring delegate : this.renameDelegates) {
            if ((p = JavaPluginUtils.chainProblems(p, delegate.checkParameters())) == null || !p.isFatal()) continue;
            return p;
        }
        return JavaPluginUtils.chainProblems(p, super.checkParameters());
    }

    @Override
    public Problem fastCheckParameters() {
        if (!this.isRenameTestClass() && !this.isRenameTestClassMethod()) {
            return null;
        }
        this.initDelegates();
        Problem p = null;
        for (RenameRefactoring delegate : this.renameDelegates) {
            FileObject delegateFile = (FileObject)delegate.getRefactoringSource().lookup(FileObject.class);
            if (!this.isRenameTestClassMethod()) {
                delegate.setNewName(RenameTestClassRefactoringPlugin.newName(this.treePathHandle.getFileObject(), delegateFile, this.refactoring.getNewName()));
            }
            if ((p = JavaPluginUtils.chainProblems(p, delegate.fastCheckParameters())) == null || !p.isFatal()) continue;
            return p;
        }
        return JavaPluginUtils.chainProblems(p, super.fastCheckParameters());
    }

    @Override
    protected Problem preCheck(CompilationController javac) throws IOException {
        if (!this.isRenameTestClass() && !this.isRenameTestClassMethod()) {
            return null;
        }
        this.initDelegates();
        Problem p = null;
        for (RenameRefactoring delegate : this.renameDelegates) {
            if ((p = JavaPluginUtils.chainProblems(p, delegate.preCheck())) == null || !p.isFatal()) continue;
            return p;
        }
        return JavaPluginUtils.chainProblems(p, super.preCheck(javac));
    }

    public Problem prepare(RefactoringElementsBag reb) {
        if (!this.isRenameTestClass() && !this.isRenameTestClassMethod()) {
            return null;
        }
        this.initDelegates();
        this.fireProgressListenerStart(1, this.renameDelegates.length);
        Problem p = null;
        for (RenameRefactoring delegate : this.renameDelegates) {
            if ((p = JavaPluginUtils.chainProblems(p, delegate.prepare(reb.getSession()))) != null && p.isFatal()) {
                return p;
            }
            this.fireProgressListenerStep();
        }
        this.fireProgressListenerStop();
        return p;
    }

    private boolean isRenameTestClass() {
        JavaRenameProperties renameProps = (JavaRenameProperties)this.refactoring.getContext().lookup(JavaRenameProperties.class);
        return renameProps != null && renameProps.isIsRenameTestClass();
    }

    private boolean isRenameTestClassMethod() {
        JavaRenameProperties renameProps = (JavaRenameProperties)this.refactoring.getContext().lookup(JavaRenameProperties.class);
        return renameProps != null && renameProps.isIsRenameTestClassMethod();
    }

    private void initDelegates() {
        if (this.inited) {
            return;
        }
        final List<RenameRefactoring> renameRefactoringsList = Collections.synchronizedList(new LinkedList());
        final ElementKind elementKind = this.treePathHandle.getElementHandle().getKind();
        if (SUPPORTED.contains((Object)elementKind)) {
            FileObject fileObject = this.treePathHandle.getFileObject();
            Collection testLocators = Lookup.getDefault().lookupAll(TestLocator.class);
            for (final TestLocator testLocator : testLocators) {
                if (!testLocator.appliesTo(fileObject)) continue;
                if (testLocator.asynchronous()) {
                    final CountDownLatch latch = new CountDownLatch(1);
                    testLocator.findOpposite(fileObject, -1, new TestLocator.LocationListener(){

                        public void foundLocation(FileObject fo, TestLocator.LocationResult location) {
                            try {
                                if (elementKind == ElementKind.CLASS) {
                                    RenameTestClassRefactoringPlugin.this.addIfMatch(location, testLocator, fo, renameRefactoringsList);
                                } else if (elementKind == ElementKind.METHOD) {
                                    RenameTestClassRefactoringPlugin.this.addIfMatchMethod(location, testLocator, renameRefactoringsList);
                                }
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    });
                    try {
                        latch.await(10000000000L, TimeUnit.NANOSECONDS);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(RenamePropertyRefactoringPlugin.class.getName()).fine("Finding test class took too long, or it was interupted");
                    }
                    continue;
                }
                TestLocator.LocationResult location = testLocator.findOpposite(fileObject, -1);
                if (elementKind == ElementKind.METHOD) {
                    this.addIfMatchMethod(location, testLocator, renameRefactoringsList);
                    continue;
                }
                this.addIfMatch(location, testLocator, fileObject, renameRefactoringsList);
            }
        }
        this.renameDelegates = renameRefactoringsList.toArray(new RenameRefactoring[0]);
        this.inited = true;
    }

    private static String newName(FileObject testedFile, FileObject testFile, String newName) {
        String testedName = testedFile.getName();
        String testName = testFile.getName();
        return testName.replace(testedName, newName);
    }

    private void addIfMatch(TestLocator.LocationResult location, TestLocator testLocator, FileObject fileObject, List<RenameRefactoring> renameRefactoringsList) {
        if (location.getFileObject() != null && testLocator.getFileType(location.getFileObject()).equals((Object)TestLocator.FileType.TEST)) {
            RenameRefactoring renameRefactoring = new RenameRefactoring(Lookups.singleton((Object)location.getFileObject()));
            renameRefactoring.setNewName(RenameTestClassRefactoringPlugin.newName(fileObject, location.getFileObject(), this.refactoring.getNewName()));
            renameRefactoring.setSearchInComments(true);
            renameRefactoringsList.add(renameRefactoring);
        }
    }

    private void addIfMatchMethod(TestLocator.LocationResult location, TestLocator testLocator, final List<RenameRefactoring> renameRefactoringsList) {
        if (location.getFileObject() != null && testLocator.getFileType(location.getFileObject()).equals((Object)TestLocator.FileType.TEST)) {
            try {
                JavaSource.forFileObject((FileObject)location.getFileObject()).runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController javac) throws Exception {
                        Element methodElement = RenameTestClassRefactoringPlugin.this.treePathHandle.resolveElement((CompilationInfo)javac);
                        String methodName = methodElement.getSimpleName().toString();
                        String testMethodName = RefactoringUtils.getTestMethodName(methodName);
                        javac.toPhase(JavaSource.Phase.RESOLVED);
                        CompilationUnitTree cut = javac.getCompilationUnit();
                        Tree classTree = cut.getTypeDecls().get(0);
                        List<? extends Tree> members = ((ClassTree)classTree).getMembers();
                        for (int i = 0; i < members.size(); ++i) {
                            MethodTree methodTree;
                            Tree member = members.get(i);
                            if (member.getKind() != Tree.Kind.METHOD || !(methodTree = (MethodTree)member).getName().contentEquals(testMethodName) || methodTree.getReturnType().getKind() != Tree.Kind.PRIMITIVE_TYPE || ((PrimitiveTypeTree)methodTree.getReturnType()).getPrimitiveTypeKind() != TypeKind.VOID) continue;
                            classTree = ((ClassTree)classTree).getMembers().get(i);
                            TreePath tp = TreePath.getPath(cut, classTree);
                            RenameRefactoring renameRefactoring = new RenameRefactoring(Lookups.singleton((Object)TreePathHandle.create((TreePath)tp, (CompilationInfo)javac)));
                            renameRefactoring.setNewName(RefactoringUtils.getTestMethodName(RenameTestClassRefactoringPlugin.this.refactoring.getNewName()));
                            renameRefactoring.setSearchInComments(true);
                            renameRefactoringsList.add(renameRefactoring);
                            break;
                        }
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

