/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phing.exec;

import java.awt.EventQueue;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.phing.exec.Bundle;
import org.netbeans.modules.php.phing.options.PhingOptions;
import org.netbeans.modules.php.phing.options.PhingOptionsValidator;
import org.netbeans.modules.php.phing.util.PhingUtils;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public class PhingExecutable {
    static final Logger LOGGER = Logger.getLogger(PhingExecutable.class.getName());
    public static final String PHING_NAME = "phing";
    @SuppressWarnings(value={"MS_MUTABLE_ARRAY"}, justification="No need to worry, noone will change it")
    public static final String[] PHING_NAMES = new String[]{Utilities.isWindows() ? "phing.bat" : "phing", "phing.php", "phing-latest.phar"};
    private static final String LOGGER_PARAM = "-logger";
    private static final String LOGGER_COLOR_VALUE = "phing.listener.AnsiColorLogger";
    private static final String LIST_PARAM = "-list";
    private static final String QUIET_PARAM = "-quiet";
    private final Project project;
    private final String phingPath;
    @NullAllowed
    private final File workDir;

    PhingExecutable(String phingPath, Project project, @NullAllowed File workDir) {
        assert (phingPath != null);
        assert (project != null);
        this.phingPath = phingPath;
        this.project = project;
        this.workDir = workDir;
    }

    @CheckForNull
    public static PhingExecutable getDefault(Project project, boolean showOptions) {
        return PhingExecutable.createExecutable(project, null, showOptions);
    }

    @CheckForNull
    public static PhingExecutable getDefault(Project project, File workDir, boolean showOptions) {
        assert (workDir != null);
        assert (workDir.exists()) : workDir;
        return PhingExecutable.createExecutable(project, workDir, showOptions);
    }

    @CheckForNull
    private static PhingExecutable createExecutable(Project project, @NullAllowed File workDir, boolean showOptions) {
        assert (project != null);
        ValidationResult result = new PhingOptionsValidator().validatePhing().getResult();
        if (PhingExecutable.validateResult(result) != null) {
            if (showOptions) {
                UiUtils.showOptions((String)"FrameworksAndTools/Phing");
            }
            return null;
        }
        return new PhingExecutable(PhingOptions.getInstance().getPhing(), project, workDir);
    }

    private String getCommand() {
        return this.phingPath;
    }

    public Future<Integer> run(String ... args) {
        assert (!EventQueue.isDispatchThread());
        assert (this.project != null);
        String projectName = PhingUtils.getProjectDisplayName(this.project);
        Future task = this.getExecutable(Bundle.PhingExecutable_run(projectName)).additionalParameters(this.getRunParams(args)).run(this.getDescriptor());
        assert (task != null) : this.phingPath;
        return task;
    }

    public Future<List<String>> listTargets() {
        final PhingTargetsLineProcessor phingTargetsLineProcessor = new PhingTargetsLineProcessor();
        Future task = this.getExecutable("list phing targets").noInfo(true).additionalParameters(PhingExecutable.getListTargetsParams()).redirectErrorStream(false).run(PhingExecutable.getSilentDescriptor(), new ExecutionDescriptor.InputProcessorFactory2(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.bridge((LineProcessor)phingTargetsLineProcessor);
            }
        });
        assert (task != null) : this.phingPath;
        return new TargetList(this, task, phingTargetsLineProcessor);
    }

    private PhpExecutable getExecutable(String title) {
        assert (title != null);
        return new PhpExecutable(this.getCommand()).workDir(this.getWorkDir()).displayName(title).optionsSubcategory("FrameworksAndTools/Phing");
    }

    private List<String> getRunParams(String[] args) {
        ArrayList<String> params = new ArrayList<String>(args.length + 2);
        params.add(LOGGER_PARAM);
        params.add(LOGGER_COLOR_VALUE);
        params.addAll(Arrays.asList(args));
        return params;
    }

    private ExecutionDescriptor getDescriptor() {
        assert (this.project != null);
        return PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.showSuspended(true).optionsPath("org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/Phing").outLineBased(true).errLineBased(true).postExecution(new Runnable(){

            @Override
            public void run() {
                FileUtil.refreshFor((File[])new File[]{PhingExecutable.this.getWorkDir()});
            }
        });
    }

    private static ExecutionDescriptor getSilentDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL).inputVisible(false).frontWindow(false).showProgress(false).charset(StandardCharsets.UTF_8).outLineBased(true);
    }

    private File getWorkDir() {
        if (this.workDir != null && this.workDir.exists()) {
            return this.workDir;
        }
        File dir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        assert (dir != null) : this.project.getProjectDirectory();
        return dir;
    }

    @CheckForNull
    private static String validateResult(ValidationResult result) {
        if (result.isFaultless()) {
            return null;
        }
        if (result.hasErrors()) {
            return result.getFirstErrorMessage();
        }
        return result.getFirstWarningMessage();
    }

    static List<String> getListTargetsParams() {
        return Arrays.asList(QUIET_PARAM, LIST_PARAM);
    }

    private static final class TargetList
    implements Future<List<String>> {
        private static final RequestProcessor RP = new RequestProcessor(TargetList.class);
        final PhingExecutable phing;
        private final Future<Integer> task;
        private final PhingTargetsLineProcessor processor;
        private volatile Integer result;
        private List<String> phingTargets = null;

        TargetList(PhingExecutable phing, Future<Integer> task, PhingTargetsLineProcessor processor) {
            assert (phing != null);
            assert (task != null);
            assert (processor != null);
            this.phing = phing;
            this.task = task;
            this.processor = processor;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.task.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.task.isDone();
        }

        @Override
        public List<String> get() throws InterruptedException, ExecutionException {
            try {
                this.result = this.task.get();
            }
            catch (CancellationException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            return this.getPhingTargets();
        }

        @Override
        public List<String> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                this.result = this.task.get(timeout, unit);
            }
            catch (CancellationException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            return this.getPhingTargets();
        }

        private synchronized List<String> getPhingTargets() {
            if (this.phingTargets != null) {
                return Collections.unmodifiableList(this.phingTargets);
            }
            if (this.result == null || this.result == 1) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        phing.run(PhingExecutable.getListTargetsParams().toArray(new String[0]));
                    }
                });
                StatusDisplayer.getDefault().setStatusText(Bundle.TargetList_error());
                this.phingTargets = Collections.emptyList();
                return Collections.unmodifiableList(this.phingTargets);
            }
            ArrayList<String> targets = new ArrayList<String>(this.processor.getTargets());
            Collections.sort(targets);
            this.phingTargets = new CopyOnWriteArrayList<String>(targets);
            return Collections.unmodifiableList(this.phingTargets);
        }
    }

    private static final class PhingTargetsLineProcessor
    implements LineProcessor {
        private static final String MAIN_TARGETS = "Main targets:";
        private static final String SUBTARGETS = "Subtargets:";
        final List<String> targets = new ArrayList<String>();
        private boolean collecting = false;

        private PhingTargetsLineProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processLine(String line) {
            String trimmed = line.trim();
            if (this.collecting) {
                if (!SUBTARGETS.equals(trimmed) && StringUtilities.hasText((String)trimmed.replace('-', ' '))) {
                    List<String> list = this.targets;
                    synchronized (list) {
                        this.targets.add((String)StringUtilities.explode((String)trimmed, (String)" ").get(0));
                    }
                }
            } else {
                this.collecting = MAIN_TARGETS.equals(trimmed) || SUBTARGETS.equals(trimmed);
            }
        }

        public void reset() {
        }

        public void close() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> getTargets() {
            List<String> list = this.targets;
            synchronized (list) {
                return new ArrayList<String>(this.targets);
            }
        }
    }
}

