/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.performance.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.NumberFormat;
import java.text.ParseException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.modules.performance.utilities.PerformanceTestCase;

public abstract class MemoryFootprintTestCase
extends PerformanceTestCase {
    private static String platform;
    private static String pid;
    private static final String UNIX = "unix";
    private static final String WINDOWS = "windows";
    private static final String MAC = "mac";
    private static final String UNKNOWN = "unknown";
    private static final String[][] SUPPORTED_PLATFORMS;
    protected String prefix;

    public MemoryFootprintTestCase(String testName) {
        super(testName);
    }

    public MemoryFootprintTestCase(String testName, String performanceDataName) {
        super(testName, performanceDataName);
    }

    @Override
    public void initialize() {
        JemmyProperties.setCurrentTimeout((String)"JMenuOperator.PushMenuTimeout", (long)60000L);
        JemmyProperties.setCurrentTimeout((String)"JTreeOperator.WaitNextNodeTimeout", (long)60000L);
        JemmyProperties.setCurrentTimeout((String)"JTreeOperator.WaitNodeVisibleTimeout", (long)60000L);
        JemmyProperties.setCurrentTimeout((String)"ComponentOperator.WaitComponentTimeout", (long)300000L);
        JemmyProperties.setCurrentTimeout((String)"Waiter.WaitingTime", (long)300000L);
    }

    private String getPlatform() {
        String platformString = (System.getProperty("os.name", "") + "," + System.getProperty("os.arch", "")).replace(' ', '_');
        for (String[] supPlatform : SUPPORTED_PLATFORMS) {
            if (!platformString.equalsIgnoreCase(supPlatform[0])) continue;
            return supPlatform[1];
        }
        this.log("Unknown platform: " + platformString);
        return UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMeasureMemoryFootprint() {
        Exception exceptionDuringMeasurement = null;
        MeasuredMemoryValue[] measuredValues = new MeasuredMemoryValue[repeat_memory + 1];
        this.useTwoOrderTypes = false;
        this.checkScanFinished();
        this.initialize();
        this.log("Repeat = " + repeat_memory);
        for (int i = 1; i <= repeat_memory && exceptionDuringMeasurement == null; ++i) {
            try {
                this.testedComponentOperator = null;
                this.prepare();
                this.testedComponentOperator = this.open();
                this.runGC(5);
                measuredValues[i] = this.measureFootprint();
                measuredValues[i].reportPerformanceData(this.prefix, i);
                continue;
            }
            catch (Exception exc) {
                exc.printStackTrace(this.getLog());
                exceptionDuringMeasurement = exc;
                this.getScreenshot("exception_during_open");
                continue;
            }
            finally {
                try {
                    this.close();
                    MemoryFootprintTestCase.closeAllModal();
                }
                catch (Exception e) {
                    e.printStackTrace(this.getLog());
                    this.getScreenshot("measure");
                    if (exceptionDuringMeasurement == null) {
                        exceptionDuringMeasurement = e;
                    }
                }
            }
        }
        try {
            this.shutdown();
            MemoryFootprintTestCase.closeAllDialogs();
        }
        catch (Exception e) {
            e.printStackTrace(this.getLog());
            this.getScreenshot("shutdown");
            if (exceptionDuringMeasurement == null) {
                exceptionDuringMeasurement = e;
            }
        }
        if (exceptionDuringMeasurement != null) {
            throw new Error("Exception rises during measurement:" + exceptionDuringMeasurement, exceptionDuringMeasurement);
        }
    }

    private MeasuredMemoryValue measureFootprint() {
        MeasuredMemoryValue mv = new MeasuredMemoryValue();
        platform = this.getPlatform();
        pid = this.getPID();
        this.log("Platform=" + platform);
        if (platform.equals(UNIX)) {
            this.getRssVszOnUnix(mv);
        } else if (platform.equals(WINDOWS)) {
            this.getRssVszOnWindows(mv);
        } else {
            MemoryFootprintTestCase.fail((String)"Unsupported platform!");
        }
        this.getHeapAndPermGen(mv);
        this.getLoadedUnloadedClasses(mv);
        return mv;
    }

    private String getPID() {
        File ideRunning;
        String xtestWorkdir = System.getProperty("xtest.workdir");
        if (xtestWorkdir == null) {
            MemoryFootprintTestCase.fail((String)"xtest.workdir property is not specified");
        }
        if (!(ideRunning = new File(xtestWorkdir, "ide.pid")).exists()) {
            MemoryFootprintTestCase.fail((String)("Cannot find file containing PID of running IDE (" + ideRunning.getAbsolutePath()));
        }
        try {
            LineNumberReader reader = new LineNumberReader(new FileReader(ideRunning));
            String pid = reader.readLine().trim();
            this.log("PID = " + pid);
            return pid;
        }
        catch (Exception exc) {
            exc.printStackTrace(this.getLog());
            MemoryFootprintTestCase.fail((String)"Exception rises when reading PID from ide.pid file");
            return "";
        }
    }

    private void getRssVszOnWindows(MeasuredMemoryValue mv) {
        String pslist;
        String xtestHome = System.getProperty("xtest.tmpdir");
        String platformString = (System.getProperty("os.name", "") + "," + System.getProperty("os.arch", "")).replace(' ', '_');
        if (platformString.equalsIgnoreCase(SUPPORTED_PLATFORMS[8][0])) {
            this.log("Windows platform = " + platformString);
            this.log("Execiting ps_vista...");
            pslist = this.executeNativeCommand(xtestHome + "/ps_vista.exe -m " + pid);
        } else {
            this.log("Windows platform = " + platformString);
            this.log("Execiting pslist...");
            pslist = this.executeNativeCommand(xtestHome + "/pslist.exe -m " + pid);
        }
        String pslist_line = this.getLine(pslist);
        mv.rss = this.getItem(pslist_line, 3);
        mv.vsz = this.getItem(pslist_line, 5);
    }

    private void getRssVszOnUnix(MeasuredMemoryValue mv) {
        String ps_rss = this.executeNativeCommand("ps -o rss -p " + pid);
        String ps_vsz = this.executeNativeCommand("ps -o vsz -p " + pid);
        mv.rss = this.getLine(ps_rss).trim();
        mv.vsz = this.getLine(ps_vsz).trim();
    }

    private void getHeapAndPermGen(MeasuredMemoryValue mv) {
        String jstat = this.executeNativeCommand(this.getJavaBinDirectory() + "jstat -gc " + pid);
        String jstat_line = this.getLine(jstat);
        int heapU = (int)Math.floor(this.getItemFloat(jstat_line, 2) + this.getItemFloat(jstat_line, 3) + this.getItemFloat(jstat_line, 5) + this.getItemFloat(jstat_line, 7));
        int heapC = (int)Math.floor(this.getItemFloat(jstat_line, 0) + this.getItemFloat(jstat_line, 1) + this.getItemFloat(jstat_line, 4) + this.getItemFloat(jstat_line, 6));
        mv.heap_used = Integer.toString(heapU);
        mv.heap_commited = Integer.toString(heapC);
        mv.permGen_used = Integer.toString((int)Math.floor(this.getItemFloat(jstat_line, 9)));
        mv.permGen_commited = Integer.toString((int)Math.floor(this.getItemFloat(jstat_line, 8)));
    }

    private float getItemFloat(String line, int item) {
        try {
            NumberFormat nf = NumberFormat.getInstance();
            return nf.parse(this.getItem(line, item)).floatValue();
        }
        catch (ParseException exc) {
            exc.printStackTrace(this.getLog());
            return -1.0f;
        }
    }

    private void getLoadedUnloadedClasses(MeasuredMemoryValue mv) {
        String jstat = this.executeNativeCommand(this.getJavaBinDirectory() + "jstat -class " + pid);
        String jstat_line = this.getLine(jstat);
        mv.classes_loaded = this.getItem(jstat_line, 0);
        mv.classes_unloaded = this.getItem(jstat_line, 2);
    }

    private String getLine(String string) {
        this.log("Parsed output ==========\n" + string + "\n======");
        int line = (string.length() < 1 ? 0 : string.split("\n").length) - 1;
        return string.split("\n")[line];
    }

    private String getItem(String line, int item) {
        String[] lineitems = line.split(" ");
        int j = 0;
        for (int i = 0; i < lineitems.length; ++i) {
            if (lineitems[i].trim().length() <= 0) continue;
            if (item == j) {
                return lineitems[i];
            }
            ++j;
        }
        return "N/A";
    }

    private String getJavaBinDirectory() {
        String separator = System.getProperty("file.separator");
        String javaDir = System.getProperty("java.home");
        if (javaDir.endsWith(separator + "jre")) {
            javaDir = javaDir.substring(0, javaDir.length() - 4);
        }
        return javaDir + separator + "bin" + separator;
    }

    private String executeNativeCommand(String commandLine) {
        this.log("Execute command: [" + commandLine + "].");
        try {
            String line;
            Process proc = Runtime.getRuntime().exec(commandLine);
            proc.waitFor();
            StringBuilder buffer = new StringBuilder();
            BufferedReader dataInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = dataInput.readLine()) != null) {
                buffer.append(line);
                buffer.append('\n');
            }
            return buffer.toString();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace(this.getLog());
            this.log("InterruptedException: " + ie.toString());
        }
        catch (IOException ioe) {
            ioe.printStackTrace(this.getLog());
            this.log("None output from command, exception arise " + ioe.toString());
        }
        return null;
    }

    static {
        SUPPORTED_PLATFORMS = new String[][]{{"Linux,i386", UNIX}, {"SunOS,sparc", UNIX}, {"SunOS,x86", UNIX}, {"Windows_NT,x86", WINDOWS}, {"Windows_2000,x86", WINDOWS}, {"Windows_XP,x86", WINDOWS}, {"Windows_95,x86", WINDOWS}, {"Windows_98,x86", WINDOWS}, {"Windows_Me,x86", WINDOWS}, {"Windows_Vista,x86", WINDOWS}, {"Mac_OS_X,ppc", MAC}};
    }

    public final class MeasuredMemoryValue {
        String rss;
        String vsz;
        String heap_used;
        String heap_commited;
        String permGen_used;
        String permGen_commited;
        String classes_loaded;
        String classes_unloaded;

        public void reportPerformanceData(String prefix, int runOrder) {
            MemoryFootprintTestCase.this.reportPerformance(prefix + " Footprint-RSS", Long.valueOf(this.rss), "kB", runOrder);
            MemoryFootprintTestCase.this.reportPerformance(prefix + " Footprint-VSZ", Long.valueOf(this.vsz), "kB", runOrder);
            MemoryFootprintTestCase.this.reportPerformance(prefix + " Heap-Used", Long.valueOf(this.heap_used), "kB", runOrder);
            MemoryFootprintTestCase.this.reportPerformance(prefix + " Heap-Commited", Long.valueOf(this.heap_commited), "kB", runOrder);
            MemoryFootprintTestCase.this.reportPerformance(prefix + " PermGen-Used", Long.valueOf(this.permGen_used), "kB", runOrder);
            MemoryFootprintTestCase.this.reportPerformance(prefix + " PermGen-Commited", Long.valueOf(this.permGen_commited), "kB", runOrder);
            MemoryFootprintTestCase.this.reportPerformance(prefix + " Classes-Loaded", Long.valueOf(this.classes_loaded), "", runOrder);
            MemoryFootprintTestCase.this.reportPerformance(prefix + " Classes-Unloaded", Long.valueOf(this.classes_unloaded), "", runOrder);
        }
    }
}

