/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.util;

import com.sun.tools.ws.processor.model.java.JavaMethod;
import com.sun.tools.ws.processor.model.java.JavaParameter;
import com.sun.tools.ws.processor.model.java.JavaType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.api.WebProjectLibrariesModifier2;
import org.netbeans.modules.websvc.manager.spi.WebServiceManagerExt;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ManagerUtil {
    public static final int BUFFER_SIZE = 4096;
    public static final String xsdNamespace = "xsd";
    public static final String WSDL_FILE_EXTENSION = "wsdl";
    public static final String LOCALIZING_BUNDLE = "SystemFileSystem.localizingBundle";
    private static final String[] PRIMITIVE_WRAPPER_CLASSES = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.Character", "java.lang.String"};
    private static final String[] PRIMITIVE_TYPES = new String[]{"boolean", "byte", "double", "float", "int", "long", "short", "char"};
    public static final String PATH_LIBRARIES = "lib";
    public static final String PATH_IN_WAR_LIB = "WEB-INF/lib";
    private static Lookup.Result<WebServiceManagerExt> extensionsResult = null;

    public static boolean isJAXRPCAvailable() {
        return ManagerUtil.getWebServiceSupportLibDef(false) != null;
    }

    public static Library getWebServiceSupportLibDef(boolean isJ2EE_15) {
        String libraryName = isJ2EE_15 ? "jaxws21" : "jaxrpc16";
        Library libDef = LibraryManager.getDefault().getLibrary(libraryName);
        return libDef;
    }

    public static Method getPropertyGetter(String type, String propName, ClassLoader loader) {
        try {
            Class<?> typeClass = Class.forName(type, true, loader);
            char[] name = propName.toCharArray();
            String propCaps = null;
            Method method = null;
            for (int i = 0; i < propName.length() && method == null; ++i) {
                name[i] = Character.toUpperCase(name[i]);
                propCaps = new String(name);
                try {
                    method = typeClass.getMethod("get" + propCaps, new Class[0]);
                    continue;
                }
                catch (NoSuchMethodException ex) {
                    try {
                        method = typeClass.getMethod("is" + propCaps, new Class[0]);
                        continue;
                    }
                    catch (NoSuchMethodException nsme) {
                        // empty catch block
                    }
                }
            }
            return method;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean isPrimitiveType(String typeName) {
        for (int i = 0; i < PRIMITIVE_WRAPPER_CLASSES.length; ++i) {
            if (!PRIMITIVE_WRAPPER_CLASSES[i].equals(typeName)) continue;
            return true;
        }
        return ManagerUtil.isJavaPrimitive(typeName);
    }

    public static boolean isJavaPrimitive(String typeName) {
        for (int i = 0; i < PRIMITIVE_TYPES.length; ++i) {
            if (!PRIMITIVE_TYPES[i].equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public static String getWrapperForPrimitive(String javaPrimitive) {
        for (int i = 0; i < PRIMITIVE_TYPES.length; ++i) {
            if (!PRIMITIVE_TYPES[i].equals(javaPrimitive)) continue;
            return PRIMITIVE_WRAPPER_CLASSES[i];
        }
        return null;
    }

    public static boolean hasOutput(JavaMethod m) {
        JavaType type = m.getReturnType();
        if (!"void".equals(type.getRealName())) {
            return true;
        }
        return ManagerUtil.getOutputHolderIndex(m) >= 0;
    }

    public static int getOutputHolderIndex(JavaMethod m) {
        List params = m.getParametersList();
        if (params == null) {
            return -1;
        }
        for (int i = 0; i < params.size(); ++i) {
            JavaParameter nextParam = (JavaParameter)params.get(i);
            if (!nextParam.isHolder() || !nextParam.getParameter().isOUT() && !nextParam.getParameter().isINOUT()) continue;
            return i;
        }
        return -1;
    }

    public static String typeToString(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            if (paramType.getOwnerType() != null) {
                return null;
            }
            Type rawType = paramType.getRawType();
            if (!(rawType instanceof Class)) {
                return null;
            }
            Class rawClass = (Class)rawType;
            Type[] argTypes = paramType.getActualTypeArguments();
            if (argTypes == null || argTypes.length == 0) {
                return null;
            }
            StringBuffer arguments = new StringBuffer();
            for (int i = 0; i < argTypes.length; ++i) {
                String argument = ManagerUtil.typeToString(argTypes[0]);
                if (argument == null) {
                    return null;
                }
                arguments.append(argument);
                if (i == argTypes.length - 1) continue;
                arguments.append(',');
            }
            return rawClass.getCanonicalName() + "<" + arguments.toString() + ">";
        }
        if (type instanceof GenericArrayType) {
            String component = ManagerUtil.typeToString(((GenericArrayType)type).getGenericComponentType());
            if (component != null) {
                return component + "[]";
            }
        } else if (type instanceof Class) {
            return ((Class)type).getCanonicalName();
        }
        return null;
    }

    public static String removeNamespace(String tagName) {
        int pos = tagName.indexOf(58);
        if (pos < 0) {
            return tagName;
        }
        return tagName.substring(pos + 1);
    }

    public static String makeValidJavaBeanName(String name) {
        char[] chars = name.toCharArray();
        if (!(name.length() <= 1 || Character.isUpperCase(chars[0]) && Character.isUpperCase(chars[1]))) {
            chars[0] = Character.toLowerCase(chars[0]);
            chars[1] = Character.toLowerCase(chars[1]);
        } else if (name.length() == 1 && Character.isUpperCase(chars[0])) {
            chars[0] = Character.toLowerCase(chars[0]);
        }
        return new String(chars);
    }

    public static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static boolean isAcronyn(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        char[] chars = name.toCharArray();
        return Character.isUpperCase(chars[0]) && Character.isUpperCase(chars[1]);
    }

    public static String changeString(String inString, String oldSubString, String newSubString) {
        if (oldSubString.trim().equals("")) {
            return inString;
        }
        int start = 0;
        int end = 0;
        StringBuffer changedString = new StringBuffer("");
        end = inString.indexOf(oldSubString, start);
        while (end != -1) {
            changedString.append(inString.substring(start, end) + newSubString);
            start = end + oldSubString.length();
            end = inString.indexOf(oldSubString, start);
        }
        changedString.append(inString.substring(start));
        return changedString.toString();
    }

    public static String upperCaseFirstChar(String inString) {
        if (null == inString) {
            throw new IllegalArgumentException("Null string passed!");
        }
        String returnString = inString;
        String firstCharacter = returnString.substring(0, 1);
        returnString = firstCharacter.toUpperCase() + returnString.substring(1);
        return returnString;
    }

    public static String getProperPortName(String inPortName) {
        if (inPortName.indexOf(".") == -1) {
            return ManagerUtil.upperCaseFirstChar(inPortName);
        }
        StringTokenizer tokenizer = new StringTokenizer(inPortName, ".");
        StringBuilder builder = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String currentToken = tokenizer.nextToken();
            builder.append(ManagerUtil.upperCaseFirstChar(currentToken));
        }
        return builder.toString();
    }

    public static boolean isValidPackageName(String inPackageName) {
        if (null == inPackageName || inPackageName.length() == 0) {
            return false;
        }
        if (inPackageName.indexOf("$") != -1) {
            return false;
        }
        if (inPackageName.charAt(0) == '.') {
            return false;
        }
        if (inPackageName.charAt(inPackageName.length() - 1) == '.') {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(inPackageName, ".");
        if (tokenizer.hasMoreTokens()) {
            String currentLevel = null;
            while (tokenizer.hasMoreTokens()) {
                currentLevel = tokenizer.nextToken();
                if (!Character.isJavaIdentifierStart(currentLevel.charAt(0))) {
                    return false;
                }
                for (int ii = 0; ii < currentLevel.length(); ++ii) {
                    if (Character.isJavaIdentifierPart(currentLevel.charAt(ii))) continue;
                    return false;
                }
            }
        } else {
            if (!Character.isJavaIdentifierStart(inPackageName.charAt(0))) {
                return false;
            }
            for (int ii = 0; ii < inPackageName.length(); ++ii) {
                if (Character.isJavaIdentifierPart(inPackageName.charAt(ii))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isValidIdentifier(String inIdentifier) {
        if (null == inIdentifier || inIdentifier.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(inIdentifier.charAt(0))) {
            return false;
        }
        for (int ii = 0; ii < inIdentifier.length(); ++ii) {
            if (Character.isJavaIdentifierPart(inIdentifier.charAt(ii))) continue;
            return false;
        }
        return true;
    }

    public static String getParameterType(JavaParameter inParameter) {
        String parameterType = null;
        parameterType = inParameter.isHolder() ? inParameter.getHolderName() : inParameter.getType().getName();
        return parameterType;
    }

    public static String getFileName(String path) {
        return new File(path).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<URL> buildClasspath(File srcPath, boolean isJaxWS) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Properties properties = new Properties();
        FileInputStream is = new FileInputStream(System.getProperty("netbeans.user") + "/build.properties");
        try {
            properties.load(is);
        }
        finally {
            is.close();
        }
        if (srcPath != null) {
            urls.add(srcPath.toURI().toURL());
        }
        File toolsJar = new File(System.getProperty("java.home")).getParentFile();
        toolsJar = new File(toolsJar, PATH_LIBRARIES + File.separator + "tools.jar");
        urls.add(toolsJar.toURI().toURL());
        String pathSeparator = System.getProperty("path.separator");
        String longCP = properties.getProperty("libs.jsf12-support.classpath");
        String libProperty = isJaxWS ? "libs.jaxws21.classpath" : "libs.jaxrpc16.classpath";
        longCP = properties.getProperty(libProperty) + pathSeparator + longCP;
        StringTokenizer st = new StringTokenizer(longCP, pathSeparator);
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            File nextFile = new File(next);
            urls.add(nextFile.toURI().toURL());
        }
        return urls;
    }

    public static FileObject getProjectLibraryDirectory(Project project) throws IOException {
        FileObject projRoot = project.getProjectDirectory();
        FileObject libRoot = projRoot.getFileObject(PATH_LIBRARIES);
        if (libRoot == null) {
            libRoot = FileUtil.createFolder((FileObject)projRoot, (String)PATH_LIBRARIES);
        }
        return libRoot;
    }

    public static boolean hasLibraryReference(Project project, Library library, String type) {
        List lst = library.getContent("classpath");
        if (lst.isEmpty()) {
            return false;
        }
        URL url = (URL)lst.get(0);
        FileObject obj = URLMapper.findFileObject((URL)url);
        if (obj == null) {
            return false;
        }
        type = "classpath/compile";
        ClassPath cp = ClassPath.getClassPath((FileObject)ManagerUtil.getSourceRoot(project), (String)type);
        if (cp == null) {
            return false;
        }
        return cp.contains(obj);
    }

    public static FileObject getSourceRoot(Project project) {
        if (project == null) {
            return null;
        }
        Sources src = ProjectUtils.getSources((Project)project);
        SourceGroup[] grp = src.getSourceGroups("java");
        for (int i = 0; i < grp.length; ++i) {
            if (!"${src.dir}".equals(grp[i].getName())) continue;
            return grp[i].getRootFolder();
        }
        if (grp.length != 0) {
            return grp[0].getRootFolder();
        }
        return null;
    }

    public static boolean addLibraryReferences(Project project, Library[] libraries) throws IOException {
        try {
            return ProjectClassPathModifier.addLibraries((Library[])libraries, (FileObject)ManagerUtil.getSourceRoot(project), (String)"classpath/compile");
        }
        catch (IOException e) {
            Logger.getLogger(ManagerUtil.class.getName()).log(Level.INFO, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public static boolean addLibraryReferences(Project project, Library[] libraries, String type) throws IOException {
        WebProjectLibrariesModifier2 wplm = (WebProjectLibrariesModifier2)project.getLookup().lookup(WebProjectLibrariesModifier2.class);
        if (wplm == null || type.equals("classpath/compile")) {
            return ProjectClassPathModifier.addLibraries((Library[])libraries, (FileObject)ManagerUtil.getSourceRoot(project), (String)"classpath/compile_only");
        }
        if (type.equals("classpath/execute")) {
            return wplm.addPackageLibraries(libraries, PATH_IN_WAR_LIB);
        }
        return false;
    }

    public static boolean removeLibraryReferences(Project project, Library[] libraries) throws IOException {
        try {
            return ProjectClassPathModifier.removeLibraries((Library[])libraries, (FileObject)ManagerUtil.getSourceRoot(project), (String)"classpath/compile");
        }
        catch (IOException e) {
            Logger.getLogger(ManagerUtil.class.getName()).log(Level.INFO, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public static boolean hasRootReference(Project project, URL rootFile) {
        return ManagerUtil.hasRootReference(project, rootFile, "classpath/compile");
    }

    public static boolean hasRootReference(Project project, URL rootFile, String type) {
        FileObject obj = URLMapper.findFileObject((URL)rootFile);
        if (obj == null) {
            return false;
        }
        type = "classpath/compile";
        ClassPath cp = ClassPath.getClassPath((FileObject)ManagerUtil.getSourceRoot(project), (String)type);
        if (cp == null) {
            return false;
        }
        return cp.contains(obj);
    }

    public static boolean addRootReferences(Project project, URL[] rootFiles) throws IOException {
        try {
            return ProjectClassPathModifier.addRoots((URL[])rootFiles, (FileObject)ManagerUtil.getSourceRoot(project), (String)"classpath/compile");
        }
        catch (IOException e) {
            Logger.getLogger(ManagerUtil.class.getName()).log(Level.INFO, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public static boolean isJavaEE5Project(Project project) {
        if (project == null) {
            return false;
        }
        return "1.5".equals(ManagerUtil.getJ2eePlatformVersion(project));
    }

    public static String getJ2eePlatformVersion(Project project) {
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (wm == null) {
            return "";
        }
        return wm.getJ2eePlatformVersion();
    }

    public static Collection<? extends WebServiceManagerExt> getExtensions() {
        if (extensionsResult == null) {
            extensionsResult = Lookup.getDefault().lookupResult(WebServiceManagerExt.class);
        }
        return extensionsResult.allInstances();
    }

    public static String getLocalizedName(FileObject fo) {
        String name = fo.getNameExt();
        String bundleName = (String)fo.getAttribute(LOCALIZING_BUNDLE);
        if (bundleName != null) {
            try {
                bundleName = Utilities.translate((String)bundleName);
                ResourceBundle b = NbBundle.getBundle((String)bundleName);
                String localizedName = b.getString(fo.getPath());
                if (localizedName != null) {
                    name = localizedName;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return name;
    }
}

