/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

import com.oracle.js.parser.AbstractParser;
import com.oracle.js.parser.ErrorManager;
import com.oracle.js.parser.JSErrorType;
import com.oracle.js.parser.Lexer;
import com.oracle.js.parser.Namespace;
import com.oracle.js.parser.Options;
import com.oracle.js.parser.ParserContext;
import com.oracle.js.parser.ParserContextBaseNode;
import com.oracle.js.parser.ParserContextBlockNode;
import com.oracle.js.parser.ParserContextBreakableNode;
import com.oracle.js.parser.ParserContextFunctionNode;
import com.oracle.js.parser.ParserContextLabelNode;
import com.oracle.js.parser.ParserContextLoopNode;
import com.oracle.js.parser.ParserContextModuleNode;
import com.oracle.js.parser.ParserContextSwitchNode;
import com.oracle.js.parser.ParserException;
import com.oracle.js.parser.RecompilableScriptFunctionData;
import com.oracle.js.parser.ScriptEnvironment;
import com.oracle.js.parser.Source;
import com.oracle.js.parser.Token;
import com.oracle.js.parser.TokenKind;
import com.oracle.js.parser.TokenLookup;
import com.oracle.js.parser.TokenStream;
import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.AccessNode;
import com.oracle.js.parser.ir.BaseNode;
import com.oracle.js.parser.ir.BinaryNode;
import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.BlockStatement;
import com.oracle.js.parser.ir.BreakNode;
import com.oracle.js.parser.ir.CallNode;
import com.oracle.js.parser.ir.CaseNode;
import com.oracle.js.parser.ir.CatchNode;
import com.oracle.js.parser.ir.ClassNode;
import com.oracle.js.parser.ir.ContinueNode;
import com.oracle.js.parser.ir.DebuggerNode;
import com.oracle.js.parser.ir.EmptyNode;
import com.oracle.js.parser.ir.ErrorNode;
import com.oracle.js.parser.ir.ExportClauseNode;
import com.oracle.js.parser.ir.ExportNode;
import com.oracle.js.parser.ir.ExportSpecifierNode;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.ExpressionList;
import com.oracle.js.parser.ir.ExpressionStatement;
import com.oracle.js.parser.ir.ForNode;
import com.oracle.js.parser.ir.FromNode;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.IfNode;
import com.oracle.js.parser.ir.ImportClauseNode;
import com.oracle.js.parser.ir.ImportNode;
import com.oracle.js.parser.ir.ImportSpecifierNode;
import com.oracle.js.parser.ir.IndexNode;
import com.oracle.js.parser.ir.JoinPredecessorExpression;
import com.oracle.js.parser.ir.JsxAttributeNode;
import com.oracle.js.parser.ir.JsxElementNode;
import com.oracle.js.parser.ir.LabelNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LiteralNode;
import com.oracle.js.parser.ir.Module;
import com.oracle.js.parser.ir.NameSpaceImportNode;
import com.oracle.js.parser.ir.NamedImportsNode;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.ObjectNode;
import com.oracle.js.parser.ir.PropertyKey;
import com.oracle.js.parser.ir.PropertyNode;
import com.oracle.js.parser.ir.ReturnNode;
import com.oracle.js.parser.ir.RuntimeNode;
import com.oracle.js.parser.ir.Statement;
import com.oracle.js.parser.ir.SwitchNode;
import com.oracle.js.parser.ir.TernaryNode;
import com.oracle.js.parser.ir.ThrowNode;
import com.oracle.js.parser.ir.TryNode;
import com.oracle.js.parser.ir.UnaryNode;
import com.oracle.js.parser.ir.VarNode;
import com.oracle.js.parser.ir.WhileNode;
import com.oracle.js.parser.ir.WithNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class Parser
extends AbstractParser {
    private static final String ARGUMENTS_NAME = "arguments";
    private static final String EVAL_NAME = "eval";
    private static final String EXEC_NAME = "$EXEC";
    private static final String ANON_FUNCTION_PREFIX = "L:";
    private static final String PROGRAM_NAME = ":program";
    private static final String ARROW_FUNCTION_PREFIX = "=>:";
    private static final char NESTED_FUNCTION_SEPARATOR = '#';
    private static final String ASYNC_IDENT = "async";
    private static final boolean ES6_FOR_OF = Options.getBooleanProperty("parser.for.of", true);
    private static final boolean ES6_CLASS = Options.getBooleanProperty("parser.class", true);
    private static final boolean ES6_ARROW_FUNCTION = Options.getBooleanProperty("parser.arrow.function", true);
    private static final boolean ES6_REST_PARAMETER = Options.getBooleanProperty("parser.rest.parameter", true);
    private static final boolean ES6_SPREAD_ARGUMENT = Options.getBooleanProperty("parser.spread.argument", true);
    private static final boolean ES6_GENERATOR_FUNCTION = Options.getBooleanProperty("parser.generator.function", true);
    private static final boolean ES6_DESTRUCTURING = Options.getBooleanProperty("parser.destructuring", true);
    private static final boolean ES6_SPREAD_ARRAY = Options.getBooleanProperty("parser.spread.array", true);
    private static final boolean ES6_COMPUTED_PROPERTY_NAME = Options.getBooleanProperty("parser.computed.property.name", true);
    private static final boolean ES6_DEFAULT_PARAMETER = Options.getBooleanProperty("parser.default.parameter", true);
    private static final boolean ES6_NEW_TARGET = Options.getBooleanProperty("parser.new.target", true);
    private static final boolean ES7_CLASS_FIELD = Options.getBooleanProperty("parser.class.field", true);
    private static final boolean ES7_DECORATOR = Options.getBooleanProperty("parser.decorator", true);
    private static final boolean ES7_ASYNC_FUNCTION = Options.getBooleanProperty("parser.async.function", true);
    private static final boolean ES7_REST_SPREAD_PROPERTY = Options.getBooleanProperty("parser.rest.spread.property", true);
    private static final boolean ES7_TRAILING_COMMA = Options.getBooleanProperty("parser.trailing.comma", true);
    private final ScriptEnvironment env;
    private final boolean scripting;
    private final boolean shebang;
    private List<Statement> functionDeclarations;
    private final ParserContext lc = new ParserContext();
    private final Deque<Object> defaultNames = new ArrayDeque<Object>();
    private final Namespace namespace;
    protected final Lexer.LineInfoReceiver lineInfoReceiver;
    private RecompilableScriptFunctionData reparsedFunction;

    public Parser(ScriptEnvironment scriptEnvironment, Source source, ErrorManager errorManager) {
        this(scriptEnvironment, source, errorManager, scriptEnvironment.strict);
    }

    public Parser(ScriptEnvironment scriptEnvironment, Source source, ErrorManager errorManager, boolean bl) {
        this(scriptEnvironment, source, errorManager, bl, 0);
    }

    public Parser(ScriptEnvironment scriptEnvironment, Source source, ErrorManager errorManager, boolean bl, int n) {
        super(source, errorManager, bl, n);
        this.env = scriptEnvironment;
        this.namespace = new Namespace(scriptEnvironment.getNamespace());
        this.scripting = scriptEnvironment.scripting;
        this.shebang = scriptEnvironment.shebang;
        this.lineInfoReceiver = this.scripting ? new Lexer.LineInfoReceiver(){

            @Override
            public void lineInfo(int n, int n2) {
                Parser.this.line = n;
                Parser.this.linePosition = n2;
            }
        } : null;
    }

    public void setFunctionName(String string) {
        this.defaultNames.push(this.createIdentNode(0L, 0, string));
    }

    public FunctionNode parse() {
        return this.parse(PROGRAM_NAME, 0, this.source.getLength(), false);
    }

    public void setReparsedFunction(RecompilableScriptFunctionData recompilableScriptFunctionData) {
        this.reparsedFunction = recompilableScriptFunctionData;
    }

    private void scanFirstToken() {
        this.k = -1;
        this.next();
    }

    public FunctionNode parse(String string, int n, int n2, boolean bl) {
        try {
            this.stream = new TokenStream();
            this.lexer = new Lexer(this.source, n, n2, this.stream, this.scripting && this.env.syntaxExtensions, this.env.es6, this.shebang && this.env.syntaxExtensions, this.reparsedFunction != null, this.env.jsx);
            this.lexer.line = this.lexer.pendingLine = this.lineOffset + 1;
            this.line = this.lineOffset;
            this.scanFirstToken();
            return this.program(string, bl);
        }
        catch (Exception exception) {
            this.handleParseException(exception);
            return null;
        }
    }

    public FunctionNode parseModule(String string, int n, int n2) {
        try {
            this.stream = new TokenStream();
            this.lexer = new Lexer(this.source, n, n2, this.stream, this.scripting && this.env.syntaxExtensions, this.env.es6, this.shebang && this.env.syntaxExtensions, this.reparsedFunction != null, this.env.jsx);
            this.lexer.line = this.lexer.pendingLine = this.lineOffset + 1;
            this.line = this.lineOffset;
            this.scanFirstToken();
            return this.module(string);
        }
        catch (Exception exception) {
            this.handleParseException(exception);
            return null;
        }
    }

    public FunctionNode parseModule(String string) {
        return this.parseModule(string, 0, this.source.getLength());
    }

    public List<IdentNode> parseFormalParameterList() {
        try {
            this.stream = new TokenStream();
            this.lexer = new Lexer(this.source, this.stream, this.scripting && this.env.syntaxExtensions, this.env.es6, this.shebang && this.env.syntaxExtensions, this.env.jsx);
            this.scanFirstToken();
            return this.formalParameterList(TokenType.EOF, false, false);
        }
        catch (Exception exception) {
            this.handleParseException(exception);
            return null;
        }
    }

    public FunctionNode parseFunctionBody() {
        try {
            this.stream = new TokenStream();
            this.lexer = new Lexer(this.source, this.stream, this.scripting && this.env.syntaxExtensions, this.env.es6, this.shebang && this.env.syntaxExtensions, this.env.jsx);
            int n = this.line;
            this.scanFirstToken();
            long l = Token.toDesc(TokenType.FUNCTION, 0, this.source.getLength());
            IdentNode identNode = new IdentNode(l, Token.descPosition(l), PROGRAM_NAME);
            ParserContextFunctionNode parserContextFunctionNode = this.createParserContextFunctionNode(identNode, l, FunctionNode.Kind.NORMAL, n, Collections.emptyList());
            this.lc.push(parserContextFunctionNode);
            ParserContextBlockNode parserContextBlockNode = this.newBlock();
            this.functionDeclarations = new ArrayList<Statement>();
            this.sourceElements(false);
            this.addFunctionDeclarations(parserContextFunctionNode);
            this.functionDeclarations = null;
            this.restoreBlock(parserContextBlockNode);
            parserContextBlockNode.setFlag(1);
            Block block = new Block(l, this.finish, parserContextBlockNode.getFlags() | 0x10 | 0x20, parserContextBlockNode.getStatements());
            this.lc.pop(parserContextFunctionNode);
            this.expect(TokenType.EOF);
            FunctionNode functionNode = this.createFunctionNode(parserContextFunctionNode, l, identNode, Collections.emptyList(), FunctionNode.Kind.NORMAL, n, block);
            return functionNode;
        }
        catch (Exception exception) {
            this.handleParseException(exception);
            return null;
        }
    }

    private void handleParseException(Exception exception) {
        String string = exception.getMessage();
        if (string == null) {
            string = exception.toString();
        }
        if (exception instanceof ParserException) {
            this.errors.error((ParserException)exception);
        } else {
            this.errors.error(string);
        }
        if (this.env.dumpOnError) {
            exception.printStackTrace(this.env.getErr());
        }
    }

    private void recover(Exception exception) {
        if (exception != null) {
            String string = exception.getMessage();
            if (string == null) {
                string = exception.toString();
            }
            if (exception instanceof ParserException) {
                this.errors.error((ParserException)exception);
            } else {
                this.errors.error(string);
            }
            if (this.env.dumpOnError) {
                exception.printStackTrace(this.env.getErr());
            }
        }
        block4: while (true) {
            switch (this.type) {
                case EOF: {
                    break block4;
                }
                case EOL: 
                case SEMICOLON: 
                case RBRACE: {
                    this.next();
                    break block4;
                }
                default: {
                    this.nextOrEOL();
                    continue block4;
                }
            }
            break;
        }
    }

    private ParserContextBlockNode newBlock() {
        return this.lc.push(new ParserContextBlockNode(this.token));
    }

    private ParserContextFunctionNode createParserContextFunctionNode(IdentNode identNode, long l, FunctionNode.Kind kind, int n, List<IdentNode> list) {
        StringBuilder stringBuilder = new StringBuilder();
        ParserContextFunctionNode parserContextFunctionNode = this.lc.getCurrentFunction();
        if (parserContextFunctionNode != null && !parserContextFunctionNode.isProgram()) {
            stringBuilder.append(parserContextFunctionNode.getName()).append('#');
        }
        assert (identNode.getName() != null);
        stringBuilder.append(identNode.getName());
        String string = this.namespace.uniqueName(stringBuilder.toString());
        int n2 = 0;
        if (this.isStrictMode) {
            n2 |= 4;
        }
        if (parserContextFunctionNode == null) {
            n2 |= 0x2000;
        }
        ParserContextFunctionNode parserContextFunctionNode2 = new ParserContextFunctionNode(l, identNode, string, this.namespace, n, kind, list);
        parserContextFunctionNode2.setFlag(n2);
        return parserContextFunctionNode2;
    }

    private FunctionNode createFunctionNode(ParserContextFunctionNode parserContextFunctionNode, long l, IdentNode identNode, List<IdentNode> list, FunctionNode.Kind kind, int n, Block block) {
        assert (block.isFunctionBody() || block.getFlag(64) && ((BlockStatement)block.getLastStatement()).getBlock().isFunctionBody());
        FunctionNode functionNode = new FunctionNode(this.source, n, block.getToken(), Token.descPosition(block.getToken()), l, parserContextFunctionNode.getLastToken(), this.namespace, identNode, parserContextFunctionNode.getName(), list, kind, parserContextFunctionNode.getFlags(), block, parserContextFunctionNode.getEndParserState(), parserContextFunctionNode.getModule());
        return functionNode;
    }

    private ParserContextBlockNode restoreBlock(ParserContextBlockNode parserContextBlockNode) {
        return this.lc.pop(parserContextBlockNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block getBlock(boolean bl) {
        int n;
        long l = this.token;
        ParserContextBlockNode parserContextBlockNode = this.newBlock();
        try {
            if (bl) {
                this.expect(TokenType.LBRACE);
            }
            this.statementList();
        }
        finally {
            this.restoreBlock(parserContextBlockNode);
        }
        if (bl) {
            this.expectDontAdvance(TokenType.RBRACE);
            n = Token.descPosition(this.token) + Token.descLength(this.token);
            this.expect(TokenType.RBRACE);
        } else {
            n = this.finish;
        }
        int n2 = parserContextBlockNode.getFlags() | (bl ? 0 : 16);
        return new Block(l, Math.max(n, Token.descPosition(l)), n2, parserContextBlockNode.getStatements());
    }

    private List<Statement> caseStatementList() {
        ParserContextBlockNode parserContextBlockNode = this.newBlock();
        try {
            this.statementList();
        }
        finally {
            this.restoreBlock(parserContextBlockNode);
        }
        return parserContextBlockNode.getStatements();
    }

    private Block getStatement() {
        return this.getStatement(false);
    }

    private Block getStatement(boolean bl) {
        if (this.type == TokenType.LBRACE) {
            return this.getBlock(true);
        }
        ParserContextBlockNode parserContextBlockNode = this.newBlock();
        try {
            this.statement(false, false, true, bl, Collections.emptyList());
        }
        finally {
            this.restoreBlock(parserContextBlockNode);
        }
        return new Block(parserContextBlockNode.getToken(), this.finish, parserContextBlockNode.getFlags() | 0x10, parserContextBlockNode.getStatements());
    }

    private void detectSpecialFunction(IdentNode identNode) {
        String string = identNode.getName();
        if (EVAL_NAME.equals(string)) {
            Parser.markEval(this.lc);
        } else if (TokenType.SUPER.getName().equals(string)) {
            assert (identNode.isDirectSuper());
            Parser.markSuperCall(this.lc);
        }
    }

    private void detectSpecialProperty(IdentNode identNode) {
        if (Parser.isArguments(identNode)) {
            this.getCurrentNonArrowFunction().setFlag(8);
        }
    }

    private boolean useBlockScope() {
        return this.env.es6;
    }

    private boolean isES6() {
        return this.env.es6;
    }

    private boolean isES7() {
        return this.env.es7;
    }

    private static boolean isArguments(String string) {
        return ARGUMENTS_NAME.equals(string);
    }

    static boolean isArguments(IdentNode identNode) {
        return Parser.isArguments(identNode.getName());
    }

    private static boolean checkIdentLValue(IdentNode identNode) {
        return identNode.tokenType().getKind() != TokenKind.KEYWORD;
    }

    private Expression verifyAssignment(long l, Expression expression, Expression expression2) {
        TokenType tokenType = Token.descType(l);
        switch (tokenType) {
            case ASSIGN: 
            case ASSIGN_ADD: 
            case ASSIGN_BIT_AND: 
            case ASSIGN_BIT_OR: 
            case ASSIGN_BIT_XOR: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_MUL: 
            case ASSIGN_EXP: 
            case ASSIGN_SAR: 
            case ASSIGN_SHL: 
            case ASSIGN_SHR: 
            case ASSIGN_SUB: {
                if (expression instanceof IdentNode) {
                    if (!Parser.checkIdentLValue((IdentNode)expression)) {
                        return this.referenceError(expression, expression2, false);
                    }
                    this.verifyIdent((IdentNode)expression, "assignment");
                    break;
                }
                if (expression instanceof AccessNode || expression instanceof IndexNode) break;
                if (tokenType == TokenType.ASSIGN && this.isDestructuringLhs(expression)) {
                    this.verifyDestructuringAssignmentPattern(expression, "assignment");
                    break;
                }
                return this.referenceError(expression, expression2, this.env.earlyLvalueError);
            }
        }
        assert (!BinaryNode.isLogical(tokenType));
        return new BinaryNode(l, expression, expression2);
    }

    private boolean isDestructuringLhs(Expression expression) {
        if (expression instanceof ObjectNode || expression instanceof LiteralNode.ArrayLiteralNode) {
            return ES6_DESTRUCTURING && this.isES6();
        }
        return false;
    }

    private void verifyDestructuringAssignmentPattern(Expression expression, final String string) {
        assert (expression instanceof ObjectNode || expression instanceof LiteralNode.ArrayLiteralNode);
        expression.accept(new VerifyDestructuringPatternNodeVisitor(new LexicalContext()){

            @Override
            protected void verifySpreadElement(Expression expression) {
                if (!Parser.this.checkValidLValue(expression, string)) {
                    throw Parser.this.error(AbstractParser.message("invalid.lvalue", new String[0]), expression.getToken());
                }
            }

            @Override
            public boolean enterIdentNode(IdentNode identNode) {
                Parser.this.verifyIdent(identNode, string);
                if (!Parser.checkIdentLValue(identNode)) {
                    Parser.this.referenceError(identNode, null, true);
                    return false;
                }
                return false;
            }

            @Override
            public boolean enterAccessNode(AccessNode accessNode) {
                return false;
            }

            @Override
            public boolean enterIndexNode(IndexNode indexNode) {
                return false;
            }

            @Override
            protected boolean enterDefault(Node node) {
                throw Parser.this.error(String.format("unexpected node in AssignmentPattern: %s", node));
            }
        });
    }

    private static Expression newBinaryExpression(long l, Expression expression, Expression expression2) {
        TokenType tokenType = Token.descType(l);
        if (BinaryNode.isLogical(tokenType)) {
            return new BinaryNode(l, (Expression)new JoinPredecessorExpression(expression), (Expression)new JoinPredecessorExpression(expression2));
        }
        return new BinaryNode(l, expression, expression2);
    }

    private static UnaryNode incDecExpression(long l, TokenType tokenType, Expression expression, boolean bl) {
        if (bl) {
            return new UnaryNode(Token.recast(l, tokenType == TokenType.DECPREFIX ? TokenType.DECPOSTFIX : TokenType.INCPOSTFIX), expression.getStart(), Token.descPosition(l) + Token.descLength(l), expression);
        }
        return new UnaryNode(l, expression);
    }

    private FunctionNode program(String string, boolean bl) {
        int n = Math.min(Token.descPosition(Token.withDelimiter(this.token)), this.finish);
        long l = Token.toDesc(TokenType.FUNCTION, n, this.source.getLength() - n);
        int n2 = this.line;
        IdentNode identNode = new IdentNode(l, Token.descPosition(l), string);
        ParserContextFunctionNode parserContextFunctionNode = this.createParserContextFunctionNode(identNode, l, FunctionNode.Kind.SCRIPT, n2, Collections.emptyList());
        this.lc.push(parserContextFunctionNode);
        ParserContextBlockNode parserContextBlockNode = this.newBlock();
        this.functionDeclarations = new ArrayList<Statement>();
        this.sourceElements(bl);
        this.addFunctionDeclarations(parserContextFunctionNode);
        this.functionDeclarations = null;
        this.restoreBlock(parserContextBlockNode);
        parserContextBlockNode.setFlag(1);
        Block block = new Block(l, this.finish, parserContextBlockNode.getFlags() | 0x10 | 0x20, parserContextBlockNode.getStatements());
        this.lc.pop(parserContextFunctionNode);
        parserContextFunctionNode.setLastToken(this.token);
        this.expect(TokenType.EOF);
        return this.createFunctionNode(parserContextFunctionNode, l, identNode, Collections.emptyList(), FunctionNode.Kind.SCRIPT, n2, block);
    }

    private String getDirective(Node node) {
        LiteralNode literalNode;
        long l;
        TokenType tokenType;
        Expression expression;
        if (node instanceof ExpressionStatement && (expression = ((ExpressionStatement)node).getExpression()) instanceof LiteralNode && ((tokenType = Token.descType(l = (literalNode = (LiteralNode)expression).getToken())) == TokenType.STRING || tokenType == TokenType.ESCSTRING)) {
            return this.source.getString(literalNode.getStart(), Token.descLength(l));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sourceElements(boolean bl) {
        ArrayList<Statement> arrayList = null;
        boolean bl2 = true;
        boolean bl3 = bl;
        boolean bl4 = this.isStrictMode;
        try {
            while (this.type != TokenType.EOF) {
                if (this.type == TokenType.RBRACE) {
                    break;
                }
                try {
                    this.statement(true, bl3, false, false, Collections.emptyList());
                    bl3 = false;
                    if (bl2) {
                        Statement statement = this.lc.getLastStatement();
                        String string = this.getDirective(statement);
                        boolean bl5 = bl2 = string != null;
                        if (bl2) {
                            if (!bl4) {
                                if (arrayList == null) {
                                    arrayList = new ArrayList<Statement>();
                                }
                                arrayList.add(statement);
                            }
                            if ("use strict".equals(string)) {
                                this.isStrictMode = true;
                                ParserContextFunctionNode parserContextFunctionNode = this.lc.getCurrentFunction();
                                parserContextFunctionNode.setFlag(4);
                                if (!bl4 && arrayList != null) {
                                    for (Node node : arrayList) {
                                        this.getValue(node.getToken());
                                    }
                                    this.verifyIdent(parserContextFunctionNode.getIdent(), "function name");
                                    for (IdentNode identNode : parserContextFunctionNode.getParameters()) {
                                        this.verifyIdent(identNode, "function parameter");
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    int n = this.line;
                    long l = this.token;
                    this.recover(exception);
                    ErrorNode errorNode = new ErrorNode(l, this.finish);
                    ExpressionStatement expressionStatement = new ExpressionStatement(n, l, this.finish, errorNode);
                    this.appendStatement(expressionStatement);
                }
                this.stream.commit(this.k);
            }
        }
        finally {
            this.isStrictMode = bl4;
        }
    }

    private void statement() {
        this.statement(false, false, false, false, Collections.emptyList());
    }

    private void statement(boolean bl, boolean bl2, boolean bl3, boolean bl4, List<Expression> list) {
        if (!list.isEmpty() && this.type != TokenType.CLASS) {
            throw this.error(this.expectMessage(TokenType.CLASS));
        }
        switch (this.type) {
            case LBRACE: {
                this.block();
                break;
            }
            case VAR: {
                this.variableStatement(this.type);
                break;
            }
            case SEMICOLON: {
                this.emptyStatement();
                break;
            }
            case IF: {
                this.ifStatement();
                break;
            }
            case FOR: {
                this.forStatement();
                break;
            }
            case WHILE: {
                this.whileStatement();
                break;
            }
            case DO: {
                this.doStatement();
                break;
            }
            case CONTINUE: {
                this.continueStatement();
                break;
            }
            case BREAK: {
                this.breakStatement();
                break;
            }
            case RETURN: {
                this.returnStatement();
                break;
            }
            case WITH: {
                this.withStatement();
                break;
            }
            case SWITCH: {
                this.switchStatement();
                break;
            }
            case THROW: {
                this.throwStatement();
                break;
            }
            case TRY: {
                this.tryStatement();
                break;
            }
            case DEBUGGER: {
                this.debuggerStatement();
                break;
            }
            case EOF: 
            case RPAREN: 
            case RBRACKET: {
                this.expect(TokenType.SEMICOLON);
                break;
            }
            case FUNCTION: {
                if (bl3 && (!bl4 || this.isStrictMode)) {
                    throw this.error(AbstractParser.message("expected.stmt", "function declaration"), this.token);
                }
                this.functionExpression(true, bl || bl4, false);
                return;
            }
            default: {
                if (this.useBlockScope() && (this.type == TokenType.LET && this.lookaheadIsLetDeclaration(false) || this.type == TokenType.CONST)) {
                    if (bl3) {
                        throw this.error(AbstractParser.message("expected.stmt", this.type.getName() + " declaration"), this.token);
                    }
                    this.variableStatement(this.type);
                    break;
                }
                if (ES6_CLASS && this.isES6() && (this.type == TokenType.CLASS || ES7_DECORATOR && this.isES7() && this.type == TokenType.AT)) {
                    if (bl3) {
                        throw this.error(AbstractParser.message("expected.stmt", "class declaration"), this.token);
                    }
                    this.classDeclaration(false, list);
                    break;
                }
                if (ES7_ASYNC_FUNCTION && this.isES7() && this.type == TokenType.IDENT && ASYNC_IDENT.equals((String)this.getValue(this.token)) && this.lookaheadIsAsyncFunction(false)) {
                    this.nextOrEOL();
                    this.functionExpression(true, bl || bl4, true);
                    break;
                }
                if (this.env.constAsVar && this.type == TokenType.CONST) {
                    this.variableStatement(TokenType.VAR);
                    break;
                }
                if (this.isBindingIdentifier()) {
                    if (!(this.T(this.k + 1) != TokenType.COLON || this.type == TokenType.YIELD && this.inGeneratorFunction() || this.isAwait(this.token) && this.inAsyncFunction())) {
                        this.labelStatement();
                        return;
                    }
                    if (bl2) {
                        String string = (String)this.getValue();
                        long l = this.token;
                        int n = this.line;
                        if ("get".equals(string)) {
                            this.next();
                            this.addPropertyFunctionStatement(this.propertyGetterFunction(l, n));
                            return;
                        }
                        if ("set".equals(string)) {
                            this.next();
                            this.addPropertyFunctionStatement(this.propertySetterFunction(l, n));
                            return;
                        }
                    }
                }
                this.expressionStatement();
            }
        }
    }

    private void addPropertyFunctionStatement(PropertyFunction propertyFunction) {
        FunctionNode functionNode = propertyFunction.functionNode;
        this.functionDeclarations.add(new ExpressionStatement(functionNode.getLineNumber(), functionNode.getToken(), this.finish, functionNode));
    }

    private ClassNode classDeclaration(boolean bl, List<Expression> list) {
        int n = this.line;
        ClassNode classNode = this.classExpression(!bl, list);
        if (!bl) {
            VarNode varNode = new VarNode(n, classNode.getToken(), classNode.getIdent().getFinish(), classNode.getIdent(), classNode, 2);
            this.appendStatement(varNode);
        }
        return classNode;
    }

    private ClassNode classExpression(boolean bl, List<Expression> list) {
        assert (this.type == TokenType.CLASS || this.type == TokenType.AT);
        int n = this.line;
        long l = this.token;
        ArrayList<Expression> arrayList = new ArrayList<Expression>(list);
        arrayList.addAll(this.decoratorList());
        this.expect(TokenType.CLASS);
        IdentNode identNode = null;
        if (bl || this.type == TokenType.IDENT) {
            identNode = this.getIdent();
        }
        return this.classTail(n, l, identNode, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassNode classTail(int n, long l, IdentNode identNode, List<Expression> list) {
        boolean bl = this.isStrictMode;
        this.isStrictMode = true;
        try {
            Expression expression = null;
            if (this.type == TokenType.EXTENDS) {
                this.next();
                expression = this.leftHandSideExpression();
            }
            this.expect(TokenType.LBRACE);
            PropertyNode propertyNode = null;
            ArrayList<PropertyNode> arrayList = new ArrayList<PropertyNode>();
            HashMap<ClassElementKey, Integer> hashMap = new HashMap<ClassElementKey, Integer>();
            while (true) {
                PropertyNode propertyNode2;
                if (this.type == TokenType.SEMICOLON) {
                    this.next();
                    continue;
                }
                if (this.type == TokenType.RBRACE) break;
                List<Expression> list2 = this.type == TokenType.AT ? this.decoratorList() : Collections.emptyList();
                long l2 = this.token;
                boolean bl2 = false;
                if (this.type == TokenType.STATIC) {
                    bl2 = true;
                    this.next();
                }
                boolean bl3 = false;
                if (ES7_ASYNC_FUNCTION && this.isES7() && this.type == TokenType.IDENT && ASYNC_IDENT.equals((String)this.getValue(this.token)) && this.lookaheadIsAsyncFunction(true)) {
                    bl3 = true;
                    this.next();
                }
                boolean bl4 = false;
                if (!bl3 && ES6_GENERATOR_FUNCTION && this.type == TokenType.MUL) {
                    bl4 = true;
                    this.next();
                }
                if ((propertyNode2 = this.classElement(bl2, expression != null, bl4, bl3, list2)).isComputed()) {
                    arrayList.add(propertyNode2);
                    continue;
                }
                if (!propertyNode2.isStatic() && propertyNode2.getKeyName().equals("constructor")) {
                    if (propertyNode == null) {
                        propertyNode = propertyNode2;
                        continue;
                    }
                    throw this.error(AbstractParser.message("multiple.constructors", new String[0]), l2);
                }
                ClassElementKey classElementKey = new ClassElementKey(propertyNode2.isStatic(), propertyNode2.getKeyName());
                Integer n2 = (Integer)hashMap.get(classElementKey);
                if (n2 == null) {
                    hashMap.put(classElementKey, arrayList.size());
                    arrayList.add(propertyNode2);
                    continue;
                }
                PropertyNode propertyNode3 = arrayList.get(n2);
                Expression expression2 = propertyNode2.getValue();
                FunctionNode functionNode = propertyNode2.getGetter();
                FunctionNode functionNode2 = propertyNode2.getSetter();
                if (expression2 != null || propertyNode3.getValue() != null) {
                    hashMap.put(classElementKey, arrayList.size());
                    arrayList.add(propertyNode2);
                    continue;
                }
                if (functionNode != null) {
                    assert (propertyNode3.getGetter() != null || propertyNode3.getSetter() != null);
                    arrayList.set(n2, propertyNode3.setGetter(functionNode));
                    continue;
                }
                if (functionNode2 == null) continue;
                assert (propertyNode3.getGetter() != null || propertyNode3.getSetter() != null);
                arrayList.set(n2, propertyNode3.setSetter(functionNode2));
            }
            long l3 = this.token;
            this.expect(TokenType.RBRACE);
            if (propertyNode == null) {
                propertyNode = this.createDefaultClassConstructor(n, l, l3, identNode, expression != null);
            }
            arrayList.trimToSize();
            ClassNode classNode = new ClassNode(n, l, this.finish, identNode, expression, propertyNode, arrayList, list);
            return classNode;
        }
        finally {
            this.isStrictMode = bl;
        }
    }

    private PropertyNode createDefaultClassConstructor(int n, long l, long l2, IdentNode identNode, boolean bl) {
        List<IdentNode> list;
        List<Statement> list2;
        Node node;
        Object object;
        IdentNode identNode2;
        Node node2;
        int n2 = this.finish;
        long l3 = Token.recast(l, TokenType.IDENT);
        if (bl) {
            node2 = this.createIdentNode(l3, n2, TokenType.SUPER.getName()).setIsDirectSuper();
            identNode2 = this.createIdentNode(l3, n2, "args").setIsRestParameter();
            object = new UnaryNode(Token.recast(l, TokenType.SPREAD_ARGUMENT), (Expression)identNode2);
            node = new CallNode(n, l, n2, (Expression)node2, (List<Expression>)Collections.singletonList(object), false);
            list2 = Collections.singletonList(new ExpressionStatement(n, l, n2, (Expression)node));
            list = Collections.singletonList(identNode2);
        } else {
            list2 = Collections.emptyList();
            list = Collections.emptyList();
        }
        node2 = new Block(l, n2, 32, list2);
        identNode2 = identNode != null ? identNode : this.createIdentNode(l3, n2, "constructor");
        object = this.createParserContextFunctionNode(identNode2, l, FunctionNode.Kind.NORMAL, n, list);
        ((ParserContextFunctionNode)object).setLastToken(l2);
        ((ParserContextBaseNode)object).setFlag(0x100000);
        ((ParserContextBaseNode)object).setFlag(0x200000);
        if (bl) {
            ((ParserContextBaseNode)object).setFlag(0x400000);
            ((ParserContextBaseNode)object).setFlag(262144);
        }
        if (identNode == null) {
            ((ParserContextBaseNode)object).setFlag(1);
        }
        node = new PropertyNode(l, n2, identNode2, this.createFunctionNode((ParserContextFunctionNode)object, l, identNode2, list, FunctionNode.Kind.NORMAL, n, (Block)node2), null, null, false, false, Collections.emptyList());
        return node;
    }

    private PropertyNode classElement(boolean bl, boolean bl2, boolean bl3, boolean bl4, List<Expression> list) {
        Object object;
        long l = this.token;
        int n = this.line;
        boolean bl5 = this.type == TokenType.LBRACKET;
        boolean bl6 = this.type == TokenType.IDENT;
        Expression expression = this.propertyName();
        int n2 = 0x100000;
        if (!bl5) {
            object = ((PropertyKey)((Object)expression)).getPropertyName();
            if (!bl3 && bl6 && this.type != TokenType.LPAREN && ((String)object).equals("get") && (!ES7_CLASS_FIELD || !this.isES7() || this.isPropertyName(this.token))) {
                PropertyFunction propertyFunction = this.propertyGetterFunction(l, n, n2);
                this.verifyAllowedMethodName(propertyFunction.key, bl, propertyFunction.computed, bl3, bl4, true);
                return new PropertyNode(l, this.finish, propertyFunction.key, null, propertyFunction.functionNode, null, bl, propertyFunction.computed, list);
            }
            if (!bl3 && bl6 && this.type != TokenType.LPAREN && ((String)object).equals("set") && (!ES7_CLASS_FIELD || !this.isES7() || this.isPropertyName(this.token))) {
                PropertyFunction propertyFunction = this.propertySetterFunction(l, n, n2);
                this.verifyAllowedMethodName(propertyFunction.key, bl, propertyFunction.computed, bl3, bl4, true);
                return new PropertyNode(l, this.finish, propertyFunction.key, null, null, propertyFunction.functionNode, bl, propertyFunction.computed, list);
            }
            if (!bl && !bl3 && ((String)object).equals("constructor")) {
                n2 |= 0x200000;
                if (bl2) {
                    n2 |= 0x400000;
                }
            }
            if (bl4) {
                n2 = 0x2000000;
            }
            this.verifyAllowedMethodName(expression, bl, bl5, bl3, bl4, false);
        }
        if (ES7_CLASS_FIELD && this.isES7() && this.type != TokenType.LPAREN && !bl4) {
            object = null;
            if (this.type == TokenType.ASSIGN) {
                this.next();
                object = this.assignmentExpression(false);
            }
            this.endOfLine();
            return new PropertyNode(l, this.finish, expression, (Expression)object, null, null, bl, bl5, list);
        }
        object = this.propertyMethodFunction(expression, l, n, bl3, false, n2, bl5);
        return new PropertyNode(l, this.finish, ((PropertyFunction)object).key, ((PropertyFunction)object).functionNode, null, null, bl, bl5, list);
    }

    private List<Expression> decoratorList() {
        if (!this.isES7() || !ES7_DECORATOR || this.type != TokenType.AT) {
            return Collections.emptyList();
        }
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        do {
            this.next();
            Expression expression = this.leftHandSideExpression();
            if (expression == null) {
                throw this.error(AbstractParser.message("expected.lvalue", this.type.getNameOrType()));
            }
            arrayList.add(expression);
        } while (this.type == TokenType.AT);
        return arrayList;
    }

    private void verifyAllowedMethodName(Expression expression, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (!bl2) {
            if (!bl && bl3 && ((PropertyKey)((Object)expression)).getPropertyName().equals("constructor")) {
                throw this.error(AbstractParser.message("generator.constructor", new String[0]), expression.getToken());
            }
            if (!bl && bl5 && ((PropertyKey)((Object)expression)).getPropertyName().equals("constructor")) {
                throw this.error(AbstractParser.message("accessor.constructor", new String[0]), expression.getToken());
            }
            if (bl && ((PropertyKey)((Object)expression)).getPropertyName().equals("prototype")) {
                throw this.error(AbstractParser.message("static.prototype.method", new String[0]), expression.getToken());
            }
        }
    }

    private boolean isPropertyName(long l) {
        TokenType tokenType = Token.descType(l);
        if (ES6_COMPUTED_PROPERTY_NAME && tokenType == TokenType.LBRACKET && this.isES6()) {
            return true;
        }
        switch (tokenType) {
            case IDENT: {
                return true;
            }
            case OCTAL_LEGACY: {
                if (this.isStrictMode) {
                    return false;
                }
            }
            case STRING: 
            case ESCSTRING: 
            case DECIMAL: 
            case HEXADECIMAL: 
            case OCTAL: 
            case BINARY_NUMBER: 
            case FLOATING: {
                return true;
            }
        }
        return this.isIdentifierName(l);
    }

    private void block() {
        this.appendStatement(new BlockStatement(this.line, this.getBlock(true)));
    }

    private void statementList() {
        block3: while (this.type != TokenType.EOF) {
            switch (this.type) {
                case EOF: 
                case RBRACE: 
                case CASE: 
                case DEFAULT: {
                    break block3;
                }
                default: {
                    this.statement();
                    continue block3;
                }
            }
        }
    }

    private void verifyIdent(IdentNode identNode, String string) {
        this.verifyStrictIdent(identNode, string);
        if (this.isES6()) {
            TokenType tokenType = TokenLookup.lookupKeyword(identNode.getName(), 0, identNode.getName().length());
            if (tokenType != TokenType.IDENT && tokenType.getKind() != TokenKind.FUTURESTRICT) {
                throw this.error(this.expectMessage(TokenType.IDENT));
            }
            if (this.isModule && "await".equals(identNode.getName())) {
                throw this.error(AbstractParser.message("strict.name", identNode.getName(), string), identNode.getToken());
            }
        }
    }

    private void verifyStrictIdent(IdentNode identNode, String string) {
        if (this.isStrictMode) {
            switch (identNode.getName()) {
                case "eval": 
                case "arguments": {
                    throw this.error(AbstractParser.message("strict.name", identNode.getName(), string), identNode.getToken());
                }
            }
            if (identNode.isFutureStrictName()) {
                throw this.error(AbstractParser.message("strict.name", identNode.getName(), string), identNode.getToken());
            }
        }
    }

    private void variableStatement(TokenType tokenType) {
        this.variableDeclarationList(tokenType, true, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ForVariableDeclarationListResult variableDeclarationList(TokenType tokenType, boolean bl, final int n) {
        assert (tokenType == TokenType.VAR || tokenType == TokenType.LET || tokenType == TokenType.CONST);
        this.next();
        int n2 = 0;
        if (tokenType == TokenType.LET) {
            n2 |= 1;
        } else if (tokenType == TokenType.CONST) {
            n2 |= 2;
        }
        ForVariableDeclarationListResult forVariableDeclarationListResult = bl ? null : new ForVariableDeclarationListResult();
        while (true) {
            Expression expression;
            Expression expression2;
            boolean bl2;
            final int n3 = this.line;
            final long l = Token.recast(this.token, tokenType);
            if (this.type == TokenType.YIELD && this.inGeneratorFunction()) {
                this.expect(TokenType.IDENT);
            }
            boolean bl3 = bl2 = !((expression2 = this.bindingIdentifierOrPattern("variable name")) instanceof IdentNode);
            if (bl2) {
                final int n4 = n2 | 0x10;
                this.verifyDestructuringBindingPattern(expression2, new Consumer<IdentNode>(){

                    @Override
                    public void accept(IdentNode identNode) {
                        Parser.this.verifyIdent(identNode, "variable name");
                        VarNode varNode = new VarNode(n3, l, n, identNode.getFinish(), identNode.setIsDeclaredHere(), null, n4);
                        Parser.this.appendStatement(varNode);
                    }
                });
            }
            Expression expression3 = null;
            if (this.type == TokenType.ASSIGN) {
                if (!bl) {
                    forVariableDeclarationListResult.recordDeclarationWithInitializer(l);
                }
                this.next();
                if (!bl2) {
                    this.defaultNames.push(expression2);
                }
                try {
                    expression3 = this.assignmentExpression(!bl);
                }
                finally {
                    if (!bl2) {
                        this.defaultNames.pop();
                    }
                }
            } else if (bl) {
                if (bl2) {
                    throw this.error(AbstractParser.message("missing.destructuring.assignment", new String[0]), this.token);
                }
                if (tokenType == TokenType.CONST) {
                    throw this.error(AbstractParser.message("missing.const.assignment", ((IdentNode)expression2).getName()));
                }
            }
            if (!bl2) {
                assert (expression3 != null || tokenType != TokenType.CONST || !bl);
                expression = (IdentNode)expression2;
                if (!bl) {
                    if (((IdentNode)expression).getName().equals("let")) {
                        throw this.error("let is not a valid binding name in a for loop");
                    }
                    if (expression3 == null && tokenType == TokenType.CONST) {
                        forVariableDeclarationListResult.recordMissingAssignment(expression2);
                    }
                    forVariableDeclarationListResult.addBinding(expression2);
                }
                VarNode varNode = new VarNode(n3, l, n, this.finish, ((IdentNode)expression).setIsDeclaredHere(), expression3, n2);
                this.appendStatement(varNode);
            } else {
                assert (expression3 != null || !bl);
                if (expression3 != null) {
                    expression = this.verifyAssignment(Token.recast(l, TokenType.ASSIGN), expression2, expression3);
                    if (bl) {
                        this.appendStatement(new ExpressionStatement(n3, expression.getToken(), this.finish, expression));
                    } else {
                        forVariableDeclarationListResult.addAssignment(expression);
                        forVariableDeclarationListResult.addBinding(expression);
                    }
                } else if (!bl) {
                    forVariableDeclarationListResult.recordMissingAssignment(expression2);
                    forVariableDeclarationListResult.addBinding(expression2);
                }
            }
            if (this.type != TokenType.COMMARIGHT) break;
            this.next();
        }
        if (bl) {
            this.endOfLine();
        }
        return forVariableDeclarationListResult;
    }

    private boolean isBindingIdentifier() {
        return this.type == TokenType.IDENT || this.isNonStrictModeIdent();
    }

    private IdentNode bindingIdentifier(String string) {
        IdentNode identNode = this.getIdent();
        this.verifyIdent(identNode, string);
        return identNode;
    }

    private Expression bindingPattern() {
        if (this.type == TokenType.LBRACKET) {
            return this.arrayLiteral();
        }
        if (this.type == TokenType.LBRACE) {
            return this.objectLiteral();
        }
        throw this.error(AbstractParser.message("expected.binding", new String[0]));
    }

    private Expression bindingIdentifierOrPattern(String string) {
        if (this.isBindingIdentifier() || !ES6_DESTRUCTURING || !this.isES6()) {
            return this.bindingIdentifier(string);
        }
        return this.bindingPattern();
    }

    private void verifyDestructuringBindingPattern(Expression expression, final Consumer<IdentNode> consumer) {
        assert (expression instanceof ObjectNode || expression instanceof LiteralNode.ArrayLiteralNode);
        expression.accept(new VerifyDestructuringPatternNodeVisitor(new LexicalContext()){

            @Override
            protected void verifySpreadElement(Expression expression) {
                if (!(expression instanceof IdentNode)) {
                    if (Parser.this.isDestructuringLhs(expression)) {
                        Parser.this.verifyDestructuringBindingPattern(expression, consumer);
                    } else {
                        throw Parser.this.error("Expected a valid binding identifier", expression.getToken());
                    }
                }
            }

            @Override
            public boolean enterIdentNode(IdentNode identNode) {
                consumer.accept(identNode);
                return false;
            }

            @Override
            protected boolean enterDefault(Node node) {
                throw Parser.this.error(String.format("unexpected node in BindingPattern: %s", node));
            }
        });
    }

    private void emptyStatement() {
        if (this.env.emptyStatements) {
            this.appendStatement(new EmptyNode(this.line, this.token, Token.descPosition(this.token) + Token.descLength(this.token)));
        }
        this.next();
    }

    private void expressionStatement() {
        int n = this.line;
        long l = this.token;
        Expression expression = this.expression();
        ExpressionStatement expressionStatement = null;
        if (expression != null) {
            this.endOfLine();
            expressionStatement = new ExpressionStatement(n, l, this.finish, expression);
            this.appendStatement(expressionStatement);
        } else {
            this.expect(null);
            this.endOfLine();
        }
    }

    private void ifStatement() {
        int n = this.line;
        long l = this.token;
        this.next();
        this.expect(TokenType.LPAREN);
        Expression expression = this.expression();
        this.expect(TokenType.RPAREN);
        Block block = this.getStatement();
        Block block2 = null;
        if (this.type == TokenType.ELSE) {
            this.next();
            block2 = this.getStatement();
        }
        this.appendStatement(new IfNode(n, l, block2 != null ? block2.getFinish() : block.getFinish(), expression, block, block2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forStatement() {
        long l = this.token;
        int n = this.line;
        int n2 = Token.descPosition(l);
        ParserContextBlockNode parserContextBlockNode = this.useBlockScope() ? this.newBlock() : null;
        ParserContextLoopNode parserContextLoopNode = new ParserContextLoopNode();
        this.lc.push(parserContextLoopNode);
        Node node = null;
        Expression expression = null;
        JoinPredecessorExpression joinPredecessorExpression = null;
        JoinPredecessorExpression joinPredecessorExpression2 = null;
        ForVariableDeclarationListResult forVariableDeclarationListResult = null;
        int n3 = 0;
        boolean bl = false;
        try {
            this.next();
            if (this.env.syntaxExtensions && this.type == TokenType.IDENT && "each".equals(this.getValue())) {
                n3 |= 2;
                this.next();
            }
            this.expect(TokenType.LPAREN);
            Object object = null;
            switch (this.type) {
                case VAR: {
                    object = this.type;
                    forVariableDeclarationListResult = this.variableDeclarationList((TokenType)((Object)object), false, n2);
                    break;
                }
                case SEMICOLON: {
                    break;
                }
                default: {
                    if (this.useBlockScope() && (this.type == TokenType.LET && this.lookaheadIsLetDeclaration(true) || this.type == TokenType.CONST)) {
                        if (this.type == TokenType.LET) {
                            n3 |= 4;
                        }
                        object = this.type;
                        forVariableDeclarationListResult = this.variableDeclarationList((TokenType)((Object)object), false, n2);
                        break;
                    }
                    if (this.env.constAsVar && this.type == TokenType.CONST) {
                        object = TokenType.VAR;
                        forVariableDeclarationListResult = this.variableDeclarationList((TokenType)((Object)object), false, n2);
                        break;
                    }
                    expression = this.expression(true, false);
                }
            }
            switch (this.type) {
                case SEMICOLON: {
                    if (forVariableDeclarationListResult != null) {
                        assert (expression == null);
                        expression = forVariableDeclarationListResult.init;
                        if (forVariableDeclarationListResult.missingAssignment != null) {
                            if (forVariableDeclarationListResult.missingAssignment instanceof IdentNode) {
                                throw this.error(AbstractParser.message("missing.const.assignment", ((IdentNode)forVariableDeclarationListResult.missingAssignment).getName()));
                            }
                            throw this.error(AbstractParser.message("missing.destructuring.assignment", new String[0]), forVariableDeclarationListResult.missingAssignment.getToken());
                        }
                    }
                    if ((n3 & 2) != 0) {
                        throw this.error(AbstractParser.message("for.each.without.in", new String[0]), this.token);
                    }
                    this.expect(TokenType.SEMICOLON);
                    if (this.type != TokenType.SEMICOLON) {
                        joinPredecessorExpression = this.joinPredecessorExpression();
                    }
                    this.expect(TokenType.SEMICOLON);
                    if (this.type == TokenType.RPAREN) break;
                    joinPredecessorExpression2 = this.joinPredecessorExpression();
                    break;
                }
                case IDENT: {
                    if (ES6_FOR_OF && "of".equals(this.getValue())) {
                        bl = true;
                    } else {
                        this.expect(TokenType.SEMICOLON);
                        break;
                    }
                }
                case IN: {
                    n3 |= bl ? 8 : 1;
                    joinPredecessorExpression = new JoinPredecessorExpression();
                    if (forVariableDeclarationListResult != null) {
                        if (forVariableDeclarationListResult.secondBinding != null) {
                            throw this.error(AbstractParser.message("many.vars.in.for.in.loop", bl ? "of" : "in"), forVariableDeclarationListResult.secondBinding.getToken());
                        }
                        if (forVariableDeclarationListResult.declarationWithInitializerToken != 0L && (this.isStrictMode || this.type != TokenType.IN || object != TokenType.VAR || forVariableDeclarationListResult.init != null)) {
                            throw this.error(AbstractParser.message("for.in.loop.initializer", bl ? "of" : "in"), forVariableDeclarationListResult.declarationWithInitializerToken);
                        }
                        expression = forVariableDeclarationListResult.firstBinding;
                        assert (expression instanceof IdentNode || this.isDestructuringLhs(expression));
                        if (object == TokenType.CONST) {
                            n3 |= 4;
                        }
                    } else {
                        assert (expression != null) : "for..in/of init expression can not be null here";
                        if (!this.checkValidLValue(expression, bl ? "for-of iterator" : "for-in iterator")) {
                            throw this.error(AbstractParser.message("not.lvalue.for.in.loop", bl ? "of" : "in"), expression.getToken());
                        }
                    }
                    this.next();
                    joinPredecessorExpression2 = bl ? new JoinPredecessorExpression(this.assignmentExpression(false)) : this.joinPredecessorExpression();
                    break;
                }
                default: {
                    this.expect(TokenType.SEMICOLON);
                }
            }
            this.expect(TokenType.RPAREN);
            node = this.getStatement();
            this.lc.pop(parserContextLoopNode);
        }
        catch (Throwable throwable) {
            this.lc.pop(parserContextLoopNode);
            for (Statement statement : parserContextLoopNode.getStatements()) {
                assert (statement instanceof VarNode);
                this.appendStatement(statement);
            }
            if (node != null) {
                this.appendStatement(new ForNode(n, l, node.getFinish(), (Block)node, parserContextLoopNode.getFlags() | n3, expression, joinPredecessorExpression, joinPredecessorExpression2));
            }
            if (parserContextBlockNode != null) {
                this.restoreBlock(parserContextBlockNode);
                if (node != null) {
                    this.appendStatement(new BlockStatement(n, new Block(parserContextBlockNode.getToken(), node.getFinish(), parserContextBlockNode.getStatements())));
                }
            }
            throw throwable;
        }
        for (Statement statement : parserContextLoopNode.getStatements()) {
            assert (statement instanceof VarNode);
            this.appendStatement(statement);
        }
        if (node != null) {
            this.appendStatement(new ForNode(n, l, node.getFinish(), (Block)node, parserContextLoopNode.getFlags() | n3, expression, joinPredecessorExpression, joinPredecessorExpression2));
        }
        if (parserContextBlockNode != null) {
            this.restoreBlock(parserContextBlockNode);
            if (node != null) {
                this.appendStatement(new BlockStatement(n, new Block(parserContextBlockNode.getToken(), node.getFinish(), parserContextBlockNode.getStatements())));
            }
        }
    }

    private boolean checkValidLValue(Expression expression, String string) {
        if (expression instanceof IdentNode) {
            if (!Parser.checkIdentLValue((IdentNode)expression)) {
                return false;
            }
            this.verifyIdent((IdentNode)expression, string);
            return true;
        }
        if (expression instanceof AccessNode || expression instanceof IndexNode) {
            return true;
        }
        if (this.isDestructuringLhs(expression)) {
            this.verifyDestructuringAssignmentPattern(expression, string);
            return true;
        }
        return false;
    }

    private boolean lookaheadIsLetDeclaration(boolean bl) {
        assert (this.type == TokenType.LET);
        int n = 1;
        while (true) {
            TokenType tokenType = this.T(this.k + n);
            switch (tokenType) {
                case EOL: 
                case COMMENT: {
                    break;
                }
                case IDENT: {
                    if (bl && ES6_FOR_OF && "of".equals(this.getValue(this.getToken(this.k + n)))) {
                        return false;
                    }
                }
                case LBRACE: 
                case LBRACKET: {
                    return true;
                }
                default: {
                    return !this.isStrictMode && tokenType.getKind() == TokenKind.FUTURESTRICT;
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void whileStatement() {
        long l = this.token;
        int n = this.line;
        this.next();
        ParserContextLoopNode parserContextLoopNode = new ParserContextLoopNode();
        this.lc.push(parserContextLoopNode);
        JoinPredecessorExpression joinPredecessorExpression = null;
        Block block = null;
        try {
            this.expect(TokenType.LPAREN);
            joinPredecessorExpression = this.joinPredecessorExpression();
            this.expect(TokenType.RPAREN);
            block = this.getStatement();
        }
        finally {
            this.lc.pop(parserContextLoopNode);
        }
        if (block != null) {
            this.appendStatement(new WhileNode(n, l, block.getFinish(), false, joinPredecessorExpression, block));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStatement() {
        long l = this.token;
        int n = 0;
        this.next();
        ParserContextLoopNode parserContextLoopNode = new ParserContextLoopNode();
        this.lc.push(parserContextLoopNode);
        Block block = null;
        JoinPredecessorExpression joinPredecessorExpression = null;
        try {
            block = this.getStatement();
            this.expect(TokenType.WHILE);
            this.expect(TokenType.LPAREN);
            n = this.line;
            joinPredecessorExpression = this.joinPredecessorExpression();
            this.expect(TokenType.RPAREN);
            if (this.type == TokenType.SEMICOLON) {
                this.endOfLine();
            }
        }
        finally {
            this.lc.pop(parserContextLoopNode);
        }
        this.appendStatement(new WhileNode(n, l, this.finish, true, joinPredecessorExpression, block));
    }

    private void continueStatement() {
        Object object;
        int n = this.line;
        long l = this.token;
        this.nextOrEOL();
        ParserContextLabelNode parserContextLabelNode = null;
        switch (this.type) {
            case EOF: 
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                object = this.getIdent();
                parserContextLabelNode = this.lc.findLabel(((IdentNode)object).getName());
                if (parserContextLabelNode != null) break;
                throw this.error(AbstractParser.message("undefined.label", ((IdentNode)object).getName()), ((Node)object).getToken());
            }
        }
        object = parserContextLabelNode == null ? null : parserContextLabelNode.getLabelName();
        ParserContextLoopNode parserContextLoopNode = this.lc.getContinueTo((String)object);
        if (parserContextLoopNode == null) {
            throw this.error(AbstractParser.message("illegal.continue.stmt", new String[0]), l);
        }
        this.endOfLine();
        this.appendStatement(new ContinueNode(n, l, this.finish, (String)object));
    }

    private void breakStatement() {
        Object object;
        int n = this.line;
        long l = this.token;
        this.nextOrEOL();
        ParserContextLabelNode parserContextLabelNode = null;
        switch (this.type) {
            case EOF: 
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                object = this.getIdent();
                parserContextLabelNode = this.lc.findLabel(((IdentNode)object).getName());
                if (parserContextLabelNode != null) break;
                throw this.error(AbstractParser.message("undefined.label", ((IdentNode)object).getName()), ((Node)object).getToken());
            }
        }
        object = parserContextLabelNode == null ? null : parserContextLabelNode.getLabelName();
        ParserContextBreakableNode parserContextBreakableNode = this.lc.getBreakable((String)object);
        if (parserContextBreakableNode == null) {
            throw this.error(AbstractParser.message("illegal.break.stmt", new String[0]), l);
        }
        this.endOfLine();
        this.appendStatement(new BreakNode(n, l, this.finish, (String)object));
    }

    private void returnStatement() {
        if (this.lc.getCurrentFunction().getKind() == FunctionNode.Kind.SCRIPT || this.lc.getCurrentFunction().getKind() == FunctionNode.Kind.MODULE) {
            throw this.error(AbstractParser.message("invalid.return", new String[0]));
        }
        int n = this.line;
        long l = this.token;
        this.nextOrEOL();
        Expression expression = null;
        switch (this.type) {
            case EOF: 
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                expression = this.expression();
            }
        }
        this.endOfLine();
        this.appendStatement(new ReturnNode(n, l, this.finish, expression));
    }

    private Expression yieldExpression(boolean bl) {
        assert (this.inGeneratorFunction());
        long l = this.token;
        assert (this.type == TokenType.YIELD);
        this.nextOrEOL();
        Expression expression = null;
        boolean bl2 = false;
        if (this.type == TokenType.MUL) {
            bl2 = true;
            l = Token.recast(l, TokenType.YIELD_STAR);
            this.next();
        }
        switch (this.type) {
            case EOF: 
            case EOL: 
            case SEMICOLON: 
            case RBRACE: 
            case RPAREN: 
            case RBRACKET: 
            case COMMARIGHT: 
            case COLON: {
                if (!bl2) {
                    expression = Parser.newUndefinedLiteral(l, this.finish);
                    if (this.type != TokenType.EOL) break;
                    this.next();
                    break;
                }
            }
            default: {
                expression = this.assignmentExpression(bl);
            }
        }
        return new UnaryNode(l, expression);
    }

    private Expression awaitExpression() {
        assert (this.inAsyncFunction());
        long l = this.token;
        this.nextOrEOL();
        Expression expression = this.unaryExpression();
        return new UnaryNode(Token.recast(l, TokenType.AWAIT), expression);
    }

    private static UnaryNode newUndefinedLiteral(long l, int n) {
        return new UnaryNode(Token.recast(l, TokenType.VOID), LiteralNode.newInstance(l, n, 0));
    }

    private void withStatement() {
        int n = this.line;
        long l = this.token;
        this.next();
        if (this.isStrictMode) {
            throw this.error(AbstractParser.message("strict.no.with", new String[0]), l);
        }
        this.expect(TokenType.LPAREN);
        Expression expression = this.expression();
        this.expect(TokenType.RPAREN);
        Block block = this.getStatement();
        this.appendStatement(new WithNode(n, l, this.finish, expression, block));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchStatement() {
        Node node;
        int n = this.line;
        long l = this.token;
        ParserContextBlockNode parserContextBlockNode = this.newBlock();
        this.next();
        ParserContextSwitchNode parserContextSwitchNode = new ParserContextSwitchNode();
        this.lc.push(parserContextSwitchNode);
        CaseNode caseNode = null;
        ArrayList<CaseNode> arrayList = new ArrayList<CaseNode>();
        Expression expression = null;
        try {
            this.expect(TokenType.LPAREN);
            expression = this.expression();
            this.expect(TokenType.RPAREN);
            this.expect(TokenType.LBRACE);
            while (this.type != TokenType.RBRACE) {
                node = null;
                long l2 = this.token;
                switch (this.type) {
                    case CASE: {
                        this.next();
                        node = this.expression();
                        break;
                    }
                    case DEFAULT: {
                        if (caseNode != null) {
                            throw this.error(AbstractParser.message("duplicate.default.in.switch", new String[0]));
                        }
                        this.next();
                        break;
                    }
                    default: {
                        this.expect(TokenType.CASE);
                    }
                }
                this.expect(TokenType.COLON);
                List<Statement> list = this.caseStatementList();
                CaseNode caseNode2 = new CaseNode(l2, this.finish, (Expression)node, list);
                if (node == null) {
                    caseNode = caseNode2;
                }
                arrayList.add(caseNode2);
            }
            this.next();
        }
        finally {
            this.lc.pop(parserContextSwitchNode);
            this.restoreBlock(parserContextBlockNode);
        }
        node = new SwitchNode(n, l, this.finish, expression, arrayList, caseNode);
        this.appendStatement(new BlockStatement(n, new Block(l, this.finish, parserContextBlockNode.getFlags() | 0x10 | 0x80, new Statement[]{node})));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void labelStatement() {
        long l = this.token;
        IdentNode identNode = this.getIdent();
        this.expect(TokenType.COLON);
        if (this.lc.findLabel(identNode.getName()) != null) {
            throw this.error(AbstractParser.message("duplicate.label", identNode.getName()), l);
        }
        ParserContextLabelNode parserContextLabelNode = new ParserContextLabelNode(identNode.getName());
        Block block = null;
        try {
            this.lc.push(parserContextLabelNode);
            block = this.getStatement(true);
        }
        finally {
            this.lc.pop(parserContextLabelNode);
        }
        this.appendStatement(new LabelNode(this.line, l, this.finish, identNode.getName(), block));
    }

    private void throwStatement() {
        int n = this.line;
        long l = this.token;
        this.nextOrEOL();
        Expression expression = null;
        switch (this.type) {
            case EOL: 
            case SEMICOLON: 
            case RBRACE: {
                break;
            }
            default: {
                expression = this.expression();
            }
        }
        if (expression == null) {
            throw this.error(AbstractParser.message("expected.operand", this.type.getNameOrType()));
        }
        this.endOfLine();
        this.appendStatement(new ThrowNode(n, l, this.finish, expression, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryStatement() {
        int n = this.line;
        long l = this.token;
        this.next();
        int n2 = this.line;
        ParserContextBlockNode parserContextBlockNode = this.newBlock();
        try {
            Block block = this.getBlock(true);
            ArrayList<Block> arrayList = new ArrayList<Block>();
            while (this.type == TokenType.CATCH) {
                Expression expression;
                int n3 = this.line;
                long l2 = this.token;
                this.next();
                this.expect(TokenType.LPAREN);
                IdentNode identNode = this.getIdent();
                this.verifyIdent(identNode, "catch argument");
                if (this.env.syntaxExtensions && this.type == TokenType.IF) {
                    this.next();
                    expression = this.expression();
                } else {
                    expression = null;
                }
                this.expect(TokenType.RPAREN);
                ParserContextBlockNode parserContextBlockNode2 = this.newBlock();
                try {
                    Block block2 = this.getBlock(true);
                    CatchNode catchNode = new CatchNode(n3, l2, this.finish, identNode, expression, block2, false);
                    this.appendStatement(catchNode);
                }
                finally {
                    this.restoreBlock(parserContextBlockNode2);
                    arrayList.add(new Block(parserContextBlockNode2.getToken(), Math.max(this.finish, Token.descPosition(parserContextBlockNode2.getToken())), parserContextBlockNode2.getFlags() | 0x10, parserContextBlockNode2.getStatements()));
                }
                if (expression != null) continue;
                break;
            }
            Block block3 = null;
            if (this.type == TokenType.FINALLY) {
                this.next();
                block3 = this.getBlock(true);
            }
            if (arrayList.isEmpty() && block3 == null) {
                throw this.error(AbstractParser.message("missing.catch.or.finally", new String[0]), l);
            }
            TryNode tryNode = new TryNode(n, l, this.finish, block, arrayList, block3);
            assert (this.lc.peek() == parserContextBlockNode);
            this.appendStatement(tryNode);
        }
        finally {
            this.restoreBlock(parserContextBlockNode);
        }
        this.appendStatement(new BlockStatement(n2, new Block(l, this.finish, parserContextBlockNode.getFlags() | 0x10, parserContextBlockNode.getStatements())));
    }

    private void debuggerStatement() {
        int n = this.line;
        long l = this.token;
        this.next();
        this.endOfLine();
        this.appendStatement(new DebuggerNode(n, l, this.finish));
    }

    private Expression primaryExpression() {
        int n = this.line;
        long l = this.token;
        switch (this.type) {
            case THIS: {
                String string = this.type.getName();
                this.next();
                Parser.markThis(this.lc);
                return new IdentNode(l, this.finish, string);
            }
            case IDENT: {
                IdentNode identNode = this.getIdent();
                if (identNode == null) break;
                this.detectSpecialProperty(identNode);
                return identNode;
            }
            case OCTAL_LEGACY: {
                if (this.isStrictMode) {
                    throw this.error(AbstractParser.message("strict.no.octal", new String[0]), this.token);
                }
            }
            case STRING: 
            case ESCSTRING: 
            case DECIMAL: 
            case HEXADECIMAL: 
            case OCTAL: 
            case BINARY_NUMBER: 
            case FLOATING: 
            case REGEX: 
            case XML: {
                return this.getLiteral();
            }
            case EXECSTRING: {
                return this.execString(n, l);
            }
            case FALSE: {
                this.next();
                return LiteralNode.newInstance(l, this.finish, false);
            }
            case TRUE: {
                this.next();
                return LiteralNode.newInstance(l, this.finish, true);
            }
            case NULL: {
                this.next();
                return LiteralNode.newInstance(l, this.finish);
            }
            case LBRACKET: {
                return this.arrayLiteral();
            }
            case LBRACE: {
                return this.objectLiteral();
            }
            case LPAREN: {
                this.next();
                if (ES6_ARROW_FUNCTION && this.isES6()) {
                    if (this.type == TokenType.RPAREN) {
                        this.nextOrEOL();
                        this.expectDontAdvance(TokenType.ARROW);
                        return new ExpressionList(l, this.finish, Collections.emptyList());
                    }
                    if (ES6_REST_PARAMETER && this.type == TokenType.ELLIPSIS) {
                        IdentNode identNode = this.formalParameterList(false, false).get(0);
                        this.expectDontAdvance(TokenType.RPAREN);
                        this.nextOrEOL();
                        this.expectDontAdvance(TokenType.ARROW);
                        return new ExpressionList(l, this.finish, Collections.singletonList(identNode));
                    }
                }
                Expression expression = this.expression(false, true);
                this.expect(TokenType.RPAREN);
                return expression;
            }
            case TEMPLATE: 
            case TEMPLATE_HEAD: {
                return this.templateLiteral();
            }
            default: {
                if (this.env.jsx && this.lexer.scanJsx(l, this.type)) {
                    return this.jsxElement(l);
                }
                if (this.lexer.scanLiteral(l, this.type, this.lineInfoReceiver)) {
                    this.next();
                    return this.getLiteral();
                }
                if (!this.isNonStrictModeIdent()) break;
                return this.getIdent();
            }
        }
        return null;
    }

    CallNode execString(int n, long l) {
        IdentNode identNode = new IdentNode(l, this.finish, EXEC_NAME);
        this.next();
        this.expect(TokenType.LBRACE);
        List<Expression> list = Collections.singletonList(this.expression());
        this.expect(TokenType.RBRACE);
        return new CallNode(n, l, this.finish, identNode, list, false);
    }

    private LiteralNode<Expression[]> arrayLiteral() {
        long l = this.token;
        this.next();
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        boolean bl = true;
        boolean bl2 = false;
        block5: while (true) {
            long l2 = 0L;
            switch (this.type) {
                case RBRACKET: {
                    this.next();
                    break block5;
                }
                case COMMARIGHT: {
                    this.next();
                    if (bl) {
                        arrayList.add(null);
                    }
                    bl = true;
                    continue block5;
                }
                case ELLIPSIS: {
                    if (ES6_SPREAD_ARRAY) {
                        bl2 = true;
                        l2 = this.token;
                        this.next();
                    }
                }
                default: {
                    if (!bl) {
                        throw this.error(AbstractParser.message("expected.comma", this.type.getNameOrType()));
                    }
                    Expression expression = this.assignmentExpression(false);
                    if (expression != null) {
                        if (l2 != 0L) {
                            expression = new UnaryNode(Token.recast(l2, TokenType.SPREAD_ARRAY), expression);
                        }
                        arrayList.add(expression);
                    } else {
                        this.expect(TokenType.RBRACKET);
                    }
                    bl = false;
                    continue block5;
                }
            }
            break;
        }
        return LiteralNode.newInstance(l, this.finish, arrayList, bl2, bl);
    }

    private ObjectNode objectLiteral() {
        long l = this.token;
        this.next();
        ArrayList<PropertyNode> arrayList = new ArrayList<PropertyNode>();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        boolean bl = true;
        block4: while (true) {
            switch (this.type) {
                case RBRACE: {
                    this.next();
                    break block4;
                }
                case COMMARIGHT: {
                    if (bl) {
                        throw this.error(AbstractParser.message("expected.property.id", this.type.getNameOrType()));
                    }
                    this.next();
                    bl = true;
                    continue block4;
                }
                default: {
                    if (!bl) {
                        throw this.error(AbstractParser.message("expected.comma", this.type.getNameOrType()));
                    }
                    bl = false;
                    PropertyNode propertyNode = this.propertyAssignment();
                    if (propertyNode.isComputed() || propertyNode.getKey().isTokenType(TokenType.SPREAD_OBJECT)) {
                        arrayList.add(propertyNode);
                        continue block4;
                    }
                    String string = propertyNode.getKeyName();
                    Integer n = (Integer)hashMap.get(string);
                    if (n == null) {
                        hashMap.put(string, arrayList.size());
                        arrayList.add(propertyNode);
                        continue block4;
                    }
                    PropertyNode propertyNode2 = (PropertyNode)arrayList.get(n);
                    Expression expression = propertyNode.getValue();
                    FunctionNode functionNode = propertyNode.getGetter();
                    FunctionNode functionNode2 = propertyNode.getSetter();
                    Expression expression2 = propertyNode2.getValue();
                    FunctionNode functionNode3 = propertyNode2.getGetter();
                    FunctionNode functionNode4 = propertyNode2.getSetter();
                    if (!this.isES6()) {
                        this.checkPropertyRedefinition(propertyNode, expression, functionNode, functionNode2, expression2, functionNode3, functionNode4);
                    } else if (propertyNode.getKey() instanceof IdentNode && ((IdentNode)propertyNode.getKey()).isProtoPropertyName() && propertyNode2.getKey() instanceof IdentNode && ((IdentNode)propertyNode2.getKey()).isProtoPropertyName()) {
                        throw this.error(AbstractParser.message("multiple.proto.key", new String[0]), propertyNode.getToken());
                    }
                    if (expression != null || expression2 != null) {
                        hashMap.put(string, arrayList.size());
                        arrayList.add(propertyNode);
                        continue block4;
                    }
                    if (functionNode != null) {
                        assert (functionNode3 != null || functionNode4 != null);
                        arrayList.set(n, propertyNode2.setGetter(functionNode));
                        continue block4;
                    }
                    if (functionNode2 == null) continue block4;
                    assert (functionNode3 != null || functionNode4 != null);
                    arrayList.set(n, propertyNode2.setSetter(functionNode2));
                    continue block4;
                }
            }
            break;
        }
        return new ObjectNode(l, this.finish, arrayList);
    }

    private void checkPropertyRedefinition(PropertyNode propertyNode, Expression expression, FunctionNode functionNode, FunctionNode functionNode2, Expression expression2, FunctionNode functionNode3, FunctionNode functionNode4) {
        boolean bl;
        if (this.isStrictMode && expression != null && expression2 != null) {
            throw this.error(AbstractParser.message("property.redefinition", propertyNode.getKeyName()), propertyNode.getToken());
        }
        boolean bl2 = functionNode3 != null || functionNode4 != null;
        boolean bl3 = bl = functionNode != null || functionNode2 != null;
        if (expression2 != null && bl) {
            throw this.error(AbstractParser.message("property.redefinition", propertyNode.getKeyName()), propertyNode.getToken());
        }
        if (bl2 && expression != null) {
            throw this.error(AbstractParser.message("property.redefinition", propertyNode.getKeyName()), propertyNode.getToken());
        }
        if (bl && bl2 && (functionNode != null && functionNode3 != null || functionNode2 != null && functionNode4 != null)) {
            throw this.error(AbstractParser.message("property.redefinition", propertyNode.getKeyName()), propertyNode.getToken());
        }
    }

    private PropertyKey literalPropertyName() {
        switch (this.type) {
            case IDENT: {
                return this.getIdent().setIsPropertyName();
            }
            case OCTAL_LEGACY: {
                if (this.isStrictMode) {
                    throw this.error(AbstractParser.message("strict.no.octal", new String[0]), this.token);
                }
            }
            case STRING: 
            case ESCSTRING: 
            case DECIMAL: 
            case HEXADECIMAL: 
            case OCTAL: 
            case BINARY_NUMBER: 
            case FLOATING: {
                return this.getLiteral();
            }
        }
        return this.getIdentifierName().setIsPropertyName();
    }

    private Expression computedPropertyName() {
        this.expect(TokenType.LBRACKET);
        Expression expression = this.assignmentExpression(false);
        this.expect(TokenType.RBRACKET);
        return expression;
    }

    private Expression propertyName() {
        if (ES6_COMPUTED_PROPERTY_NAME && this.type == TokenType.LBRACKET && this.isES6()) {
            return this.computedPropertyName();
        }
        return (Expression)((Object)this.literalPropertyName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyNode propertyAssignment() {
        Expression expression;
        boolean bl;
        Object object;
        boolean bl2;
        List<Expression> list = this.decoratorList();
        boolean bl3 = ES7_DECORATOR && this.isES7() && !list.isEmpty();
        boolean bl4 = false;
        if (ES7_ASYNC_FUNCTION && this.isES7() && this.type == TokenType.IDENT && ASYNC_IDENT.equals((String)this.getValue(this.token)) && this.lookaheadIsAsyncFunction(true)) {
            bl4 = true;
            this.next();
        }
        boolean bl5 = false;
        if (!bl4 && ES6_GENERATOR_FUNCTION && this.type == TokenType.MUL && this.isES6()) {
            bl5 = true;
            this.next();
        }
        long l = this.token;
        int n = this.line;
        boolean bl6 = bl2 = this.type == TokenType.LBRACKET;
        if (this.type == TokenType.IDENT) {
            object = (String)this.expectValue(TokenType.IDENT);
            if (!(this.type == TokenType.COLON || this.type == TokenType.LPAREN && this.isES6())) {
                long l2 = l;
                switch (object) {
                    case "get": {
                        PropertyFunction propertyFunction = this.propertyGetterFunction(l2, n);
                        return new PropertyNode(l, this.finish, propertyFunction.key, null, propertyFunction.functionNode, null, false, propertyFunction.computed, list);
                    }
                    case "set": {
                        PropertyFunction propertyFunction = this.propertySetterFunction(l2, n);
                        return new PropertyNode(l, this.finish, propertyFunction.key, null, null, propertyFunction.functionNode, false, propertyFunction.computed, list);
                    }
                }
            }
            bl = true;
            IdentNode identNode = this.createIdentNode(l, this.finish, (String)object).setIsPropertyName();
            if (this.type == TokenType.COLON && ((String)object).equals("__proto__")) {
                identNode = identNode.setIsProtoPropertyName();
            }
            expression = identNode;
        } else {
            if (this.type == TokenType.ELLIPSIS && ES7_REST_SPREAD_PROPERTY && this.isES7()) {
                if (bl3) {
                    throw this.error(AbstractParser.message("decorator.method.only", new String[0]));
                }
                long l3 = Token.recast(l, TokenType.SPREAD_OBJECT);
                this.next();
                UnaryNode unaryNode = new UnaryNode(l3, this.assignmentExpression(false));
                return new PropertyNode(l, this.finish, unaryNode, unaryNode, null, null, false, false, list);
            }
            bl = this.isNonStrictModeIdent();
            expression = this.propertyName();
        }
        if (bl5 || bl3 || bl4) {
            this.expectDontAdvance(TokenType.LPAREN);
        }
        if (this.type == TokenType.LPAREN && this.isES6()) {
            object = this.propertyMethodFunction((Expression)expression, (long)l, (int)n, (boolean)bl5, (boolean)bl4, (int)0x100000, (boolean)bl2).functionNode;
        } else if (bl && (this.type == TokenType.COMMARIGHT || this.type == TokenType.RBRACE || this.type == TokenType.ASSIGN) && this.isES6()) {
            object = this.createIdentNode(l, this.finish, ((IdentNode)expression).getPropertyName());
            if (this.type == TokenType.ASSIGN && ES6_DESTRUCTURING) {
                long l4 = this.token;
                this.next();
                Object object2 = this.assignmentExpression(false);
                object = this.verifyAssignment(l4, (Expression)object, (Expression)object2);
            }
        } else {
            this.expect(TokenType.COLON);
            this.defaultNames.push(expression);
            try {
                object = this.assignmentExpression(false);
            }
            finally {
                this.defaultNames.pop();
            }
        }
        return new PropertyNode(l, this.finish, expression, (Expression)object, null, null, false, bl2, list);
    }

    private PropertyFunction propertyGetterFunction(long l, int n) {
        return this.propertyGetterFunction(l, n, 0x100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyFunction propertyGetterFunction(long l, int n, int n2) {
        Block block;
        boolean bl = this.type == TokenType.LBRACKET;
        Expression expression = this.propertyName();
        String string = expression instanceof PropertyKey ? ((PropertyKey)((Object)expression)).getPropertyName() : this.getDefaultValidFunctionName(n, false);
        IdentNode identNode = this.createIdentNode(expression.getToken(), this.finish, "get " + string);
        this.expect(TokenType.LPAREN);
        this.expect(TokenType.RPAREN);
        ParserContextFunctionNode parserContextFunctionNode = this.createParserContextFunctionNode(identNode, l, FunctionNode.Kind.GETTER, n, Collections.emptyList());
        parserContextFunctionNode.setFlag(n2);
        if (bl) {
            parserContextFunctionNode.setFlag(1);
        }
        this.lc.push(parserContextFunctionNode);
        try {
            block = this.functionBody(parserContextFunctionNode);
        }
        finally {
            this.lc.pop(parserContextFunctionNode);
        }
        FunctionNode functionNode = this.createFunctionNode(parserContextFunctionNode, l, identNode, Collections.emptyList(), FunctionNode.Kind.GETTER, n, block);
        return new PropertyFunction(expression, functionNode, bl);
    }

    private PropertyFunction propertySetterFunction(long l, int n) {
        return this.propertySetterFunction(l, n, 0x100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyFunction propertySetterFunction(long l, int n, int n2) {
        Block block;
        IdentNode identNode;
        boolean bl = this.type == TokenType.LBRACKET;
        Expression expression = this.propertyName();
        String string = expression instanceof PropertyKey ? ((PropertyKey)((Object)expression)).getPropertyName() : this.getDefaultValidFunctionName(n, false);
        IdentNode identNode2 = this.createIdentNode(expression.getToken(), this.finish, "set " + string);
        this.expect(TokenType.LPAREN);
        if (this.isBindingIdentifier()) {
            identNode = this.getIdent();
            this.verifyIdent(identNode, "setter argument");
        } else {
            identNode = null;
        }
        this.expect(TokenType.RPAREN);
        ArrayList<IdentNode> arrayList = new ArrayList<IdentNode>();
        if (identNode != null) {
            arrayList.add(identNode);
        }
        ParserContextFunctionNode parserContextFunctionNode = this.createParserContextFunctionNode(identNode2, l, FunctionNode.Kind.SETTER, n, arrayList);
        parserContextFunctionNode.setFlag(n2);
        if (bl) {
            parserContextFunctionNode.setFlag(1);
        }
        this.lc.push(parserContextFunctionNode);
        try {
            block = this.functionBody(parserContextFunctionNode);
        }
        finally {
            this.lc.pop(parserContextFunctionNode);
        }
        FunctionNode functionNode = this.createFunctionNode(parserContextFunctionNode, l, identNode2, arrayList, FunctionNode.Kind.SETTER, n, block);
        return new PropertyFunction(expression, functionNode, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyFunction propertyMethodFunction(Expression expression, long l, int n, boolean bl, boolean bl2, int n2, boolean bl3) {
        String string = expression instanceof PropertyKey ? ((PropertyKey)((Object)expression)).getPropertyName() : this.getDefaultValidFunctionName(n, false);
        IdentNode identNode = this.createIdentNode(expression.getToken(), this.finish, string);
        FunctionNode.Kind kind = bl ? FunctionNode.Kind.GENERATOR : FunctionNode.Kind.NORMAL;
        ParserContextFunctionNode parserContextFunctionNode = this.createParserContextFunctionNode(identNode, l, kind, n, null);
        parserContextFunctionNode.setFlag(n2);
        if (bl3) {
            parserContextFunctionNode.setFlag(1);
        }
        if (bl2) {
            parserContextFunctionNode.setFlag(0x2000000);
        }
        this.lc.push(parserContextFunctionNode);
        try {
            List<IdentNode> list;
            ParserContextBlockNode parserContextBlockNode = this.newBlock();
            try {
                this.expect(TokenType.LPAREN);
                list = this.formalParameterList(bl, bl2);
                parserContextFunctionNode.setParameters(list);
                this.expect(TokenType.RPAREN);
            }
            finally {
                this.restoreBlock(parserContextBlockNode);
            }
            Block block = this.functionBody(parserContextFunctionNode);
            block = Parser.maybeWrapBodyInParameterBlock(block, parserContextBlockNode);
            FunctionNode functionNode = this.createFunctionNode(parserContextFunctionNode, l, identNode, list, kind, n, block);
            PropertyFunction propertyFunction = new PropertyFunction(expression, functionNode, bl3);
            return propertyFunction;
        }
        finally {
            this.lc.pop(parserContextFunctionNode);
        }
    }

    private Expression leftHandSideExpression() {
        Object object;
        int n = this.line;
        long l = this.token;
        Expression expression = this.memberExpression();
        if (this.type == TokenType.LPAREN) {
            object = Parser.optimizeList(this.argumentList());
            if (expression instanceof IdentNode) {
                this.detectSpecialFunction((IdentNode)expression);
            }
            expression = new CallNode(n, l, this.finish, expression, (List<Expression>)object, false);
        }
        block6: while (true) {
            n = this.line;
            l = this.token;
            switch (this.type) {
                case LPAREN: {
                    object = Parser.optimizeList(this.argumentList());
                    expression = new CallNode(n, l, this.finish, expression, (List<Expression>)object, false);
                    continue block6;
                }
                case LBRACKET: {
                    this.next();
                    object = this.expression();
                    this.expect(TokenType.RBRACKET);
                    expression = new IndexNode(l, this.finish, expression, (Expression)object);
                    continue block6;
                }
                case PERIOD: {
                    this.next();
                    object = this.getIdentifierName();
                    expression = new AccessNode(l, this.finish, expression, ((IdentNode)object).getName());
                    continue block6;
                }
                case TEMPLATE: 
                case TEMPLATE_HEAD: {
                    object = this.templateLiteralArgumentList();
                    expression = new CallNode(n, l, this.finish, expression, (List<Expression>)object, false);
                    continue block6;
                }
            }
            break;
        }
        return expression;
    }

    private Expression newExpression() {
        long l = this.token;
        this.next();
        if (ES6_NEW_TARGET && this.type == TokenType.PERIOD && this.isES6()) {
            this.next();
            if (this.type == TokenType.IDENT && "target".equals(this.getValue())) {
                if (this.lc.getCurrentFunction().isProgram()) {
                    throw this.error(AbstractParser.message("new.target.in.function", new String[0]), this.token);
                }
                this.next();
                Parser.markNewTarget(this.lc);
                return new IdentNode(l, this.finish, "new.target");
            }
            throw this.error(AbstractParser.message("expected.target", new String[0]), this.token);
        }
        int n = this.line;
        Expression expression = this.memberExpression();
        if (expression == null) {
            return null;
        }
        ArrayList<Expression> arrayList = this.type == TokenType.LPAREN ? this.argumentList() : new ArrayList();
        if (this.env.syntaxExtensions && this.type == TokenType.LBRACE) {
            arrayList.add(this.objectLiteral());
        }
        CallNode callNode = new CallNode(n, expression.getToken(), this.finish, expression, Parser.optimizeList(arrayList), true);
        return new UnaryNode(l, (Expression)callNode);
    }

    private Expression memberExpression() {
        Expression expression;
        boolean bl = false;
        block0 : switch (this.type) {
            case NEW: {
                expression = this.newExpression();
                break;
            }
            case FUNCTION: {
                expression = this.functionExpression(false, false, false);
                break;
            }
            case CLASS: 
            case AT: {
                if (ES6_CLASS && this.isES6() && (this.type == TokenType.CLASS || ES7_DECORATOR && this.isES7() && this.type == TokenType.AT)) {
                    expression = this.classExpression(false, Collections.emptyList());
                    break;
                }
            }
            case SUPER: {
                ParserContextFunctionNode parserContextFunctionNode;
                if (ES6_CLASS && this.isES6() && (parserContextFunctionNode = this.getCurrentNonArrowFunction()).isMethod()) {
                    long l = Token.recast(this.token, TokenType.IDENT);
                    this.next();
                    expression = this.createIdentNode(l, this.finish, TokenType.SUPER.getName());
                    switch (this.type) {
                        case LBRACKET: 
                        case PERIOD: {
                            this.getCurrentNonArrowFunction().setFlag(524288);
                            bl = true;
                            break block0;
                        }
                        case LPAREN: {
                            if (!parserContextFunctionNode.isSubclassConstructor()) break;
                            expression = ((IdentNode)expression).setIsDirectSuper();
                            break block0;
                        }
                    }
                    throw this.error(AbstractParser.message("invalid.super", new String[0]), l);
                }
            }
            default: {
                if (ES7_ASYNC_FUNCTION && this.isES7() && this.type == TokenType.IDENT && ASYNC_IDENT.equals((String)this.getValue(this.token)) && this.lookaheadIsAsyncFunction(false)) {
                    this.nextOrEOL();
                    expression = this.functionExpression(false, false, true);
                    break;
                }
                expression = this.primaryExpression();
            }
        }
        block15: while (true) {
            long l = this.token;
            switch (this.type) {
                case LBRACKET: {
                    this.next();
                    Expression expression2 = this.expression();
                    this.expect(TokenType.RBRACKET);
                    expression = new IndexNode(l, this.finish, expression, expression2);
                    if (!bl) continue block15;
                    bl = false;
                    expression = ((BaseNode)expression).setIsSuper();
                    continue block15;
                }
                case PERIOD: {
                    if (expression == null) {
                        throw this.error(AbstractParser.message("expected.operand", this.type.getNameOrType()));
                    }
                    this.next();
                    IdentNode identNode = this.getIdentifierName();
                    expression = new AccessNode(l, this.finish, expression, identNode.getName());
                    if (!bl) continue block15;
                    bl = false;
                    expression = ((BaseNode)expression).setIsSuper();
                    continue block15;
                }
                case TEMPLATE: 
                case TEMPLATE_HEAD: {
                    int n = this.line;
                    List<Expression> list = this.templateLiteralArgumentList();
                    expression = new CallNode(n, l, this.finish, expression, list, false);
                    continue block15;
                }
            }
            break;
        }
        return expression;
    }

    private ArrayList<Expression> argumentList() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        this.next();
        boolean bl = true;
        while (this.type != TokenType.RPAREN) {
            if (!bl) {
                this.expect(TokenType.COMMARIGHT);
                if (ES7_TRAILING_COMMA && this.isES7() && this.type == TokenType.RPAREN) {
                    break;
                }
            } else {
                bl = false;
            }
            long l = 0L;
            if (ES6_SPREAD_ARGUMENT && this.type == TokenType.ELLIPSIS && this.isES6()) {
                l = this.token;
                this.next();
            }
            Expression expression = this.assignmentExpression(false);
            if (l != 0L) {
                expression = new UnaryNode(Token.recast(l, TokenType.SPREAD_ARGUMENT), expression);
            }
            arrayList.add(expression);
        }
        this.expect(TokenType.RPAREN);
        return arrayList;
    }

    private static <T> List<T> optimizeList(ArrayList<T> arrayList) {
        switch (arrayList.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(arrayList.get(0));
            }
        }
        arrayList.trimToSize();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression functionExpression(boolean bl, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        long l = this.token;
        int n = this.line;
        assert (this.type == TokenType.FUNCTION);
        this.next();
        boolean bl4 = false;
        if (ES6_GENERATOR_FUNCTION && this.type == TokenType.MUL && this.isES6()) {
            bl4 = true;
            this.next();
        }
        IdentNode identNode = null;
        if (this.isBindingIdentifier()) {
            if (this.type == TokenType.YIELD && (!bl && bl4 || bl && this.inGeneratorFunction())) {
                this.expect(TokenType.IDENT);
            }
            if (this.isAwait(this.token) && (!bl && bl3 || bl && this.inAsyncFunction())) {
                this.expect(TokenType.IDENT);
            }
            identNode = this.getIdent();
            this.verifyIdent(identNode, "function name");
        } else if (bl && !this.env.syntaxExtensions && this.reparsedFunction == null) {
            this.expect(TokenType.IDENT);
        }
        boolean bl5 = false;
        if (identNode == null) {
            object2 = this.getDefaultValidFunctionName(n, bl);
            identNode = new IdentNode(l, Token.descPosition(l), (String)object2);
            bl5 = true;
        }
        object2 = bl4 ? FunctionNode.Kind.GENERATOR : FunctionNode.Kind.NORMAL;
        List<IdentNode> list = Collections.emptyList();
        ParserContextFunctionNode parserContextFunctionNode = this.createParserContextFunctionNode(identNode, l, (FunctionNode.Kind)((Object)object2), n, list);
        if (bl3) {
            parserContextFunctionNode.setFlag(0x2000000);
        }
        this.lc.push(parserContextFunctionNode);
        Block block = null;
        this.hideDefaultName();
        try {
            object = this.newBlock();
            try {
                this.expect(TokenType.LPAREN);
                list = this.formalParameterList(bl4, bl3);
                parserContextFunctionNode.setParameters(list);
                this.expect(TokenType.RPAREN);
            }
            finally {
                this.restoreBlock((ParserContextBlockNode)object);
            }
            block = this.functionBody(parserContextFunctionNode);
            block = Parser.maybeWrapBodyInParameterBlock(block, (ParserContextBlockNode)object);
        }
        finally {
            this.defaultNames.pop();
            this.lc.pop(parserContextFunctionNode);
        }
        if (bl) {
            parserContextFunctionNode.setFlag(0x1000000);
            if (bl2 || this.useBlockScope() || !this.isStrictMode && this.env.functionDeclarationHoisting && this.env.functionStatement == ScriptEnvironment.FunctionStatementBehavior.ACCEPT) {
                parserContextFunctionNode.setFlag(2);
            } else {
                if (this.isStrictMode) {
                    throw this.error(JSErrorType.SyntaxError, AbstractParser.message("strict.no.func.decl.here", new String[0]), l);
                }
                if (this.env.functionStatement == ScriptEnvironment.FunctionStatementBehavior.ERROR) {
                    throw this.error(JSErrorType.SyntaxError, AbstractParser.message("no.func.decl.here", new String[0]), l);
                }
                if (this.env.functionStatement == ScriptEnvironment.FunctionStatementBehavior.WARNING) {
                    this.warning(JSErrorType.SyntaxError, AbstractParser.message("no.func.decl.here.warn", new String[0]), l);
                }
            }
            if (Parser.isArguments(identNode)) {
                this.lc.getCurrentFunction().setFlag(256);
            }
        }
        if (bl5) {
            parserContextFunctionNode.setFlag(1);
        }
        this.verifyParameterList(list, parserContextFunctionNode);
        object = this.createFunctionNode(parserContextFunctionNode, l, identNode, list, (FunctionNode.Kind)((Object)object2), n, block);
        if (bl) {
            if (bl5) {
                this.appendStatement(new ExpressionStatement(n, l, this.finish, (Expression)object));
                return object;
            }
            int n2 = bl2 || !this.useBlockScope() ? 0 : 1;
            VarNode varNode = new VarNode(n, l, this.finish, identNode, (Expression)object, n2);
            if (bl2) {
                this.functionDeclarations.add(varNode);
            } else if (this.useBlockScope()) {
                this.prependStatement(varNode);
            } else {
                this.appendStatement(varNode);
            }
        }
        return object;
    }

    private void verifyParameterList(List<IdentNode> list, ParserContextFunctionNode parserContextFunctionNode) {
        IdentNode identNode = parserContextFunctionNode.getDuplicateParameterBinding();
        if (identNode != null) {
            if (parserContextFunctionNode.isStrict() || parserContextFunctionNode.getKind() == FunctionNode.Kind.ARROW || !parserContextFunctionNode.isSimpleParameterList()) {
                throw this.error(AbstractParser.message("strict.param.redefinition", identNode.getName()), identNode.getToken());
            }
            int n = list.size();
            HashSet<String> hashSet = new HashSet<String>(n);
            for (int i = n - 1; i >= 0; --i) {
                IdentNode identNode2 = list.get(i);
                String string = identNode2.getName();
                if (hashSet.contains(string)) {
                    string = parserContextFunctionNode.uniqueName(string);
                    long l = identNode2.getToken();
                    list.set(i, new IdentNode(l, Token.descPosition(l), parserContextFunctionNode.uniqueName(string)));
                }
                hashSet.add(string);
            }
        }
    }

    private static Block maybeWrapBodyInParameterBlock(Block block, ParserContextBlockNode parserContextBlockNode) {
        assert (block.isFunctionBody());
        if (!parserContextBlockNode.getStatements().isEmpty()) {
            parserContextBlockNode.appendStatement(new BlockStatement(block));
            return new Block(parserContextBlockNode.getToken(), block.getFinish(), (block.getFlags() | 0x40) & 0xFFFFFFDF, parserContextBlockNode.getStatements());
        }
        return block;
    }

    private String getDefaultValidFunctionName(int n, boolean bl) {
        String string = this.getDefaultFunctionName();
        if (Parser.isValidIdentifier(string)) {
            if (bl) {
                return ANON_FUNCTION_PREFIX + string;
            }
            return string;
        }
        return ANON_FUNCTION_PREFIX + n;
    }

    private static boolean isValidIdentifier(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private String getDefaultFunctionName() {
        if (!this.defaultNames.isEmpty()) {
            Object object = this.defaultNames.peek();
            if (object instanceof PropertyKey) {
                this.markDefaultNameUsed();
                return ((PropertyKey)object).getPropertyName();
            }
            if (object instanceof AccessNode) {
                this.markDefaultNameUsed();
                return ((AccessNode)object).getProperty();
            }
        }
        return null;
    }

    private void markDefaultNameUsed() {
        this.defaultNames.pop();
        this.hideDefaultName();
    }

    private void hideDefaultName() {
        this.defaultNames.push("");
    }

    private List<IdentNode> formalParameterList(boolean bl, boolean bl2) {
        return this.formalParameterList(TokenType.RPAREN, bl, bl2);
    }

    private List<IdentNode> formalParameterList(TokenType tokenType, boolean bl, boolean bl2) {
        assert (tokenType != TokenType.COMMARIGHT);
        ArrayList<IdentNode> arrayList = new ArrayList<IdentNode>();
        boolean bl3 = true;
        while (this.type != tokenType) {
            Expression expression;
            Object object;
            Object object2;
            Object object3;
            IdentNode identNode;
            if (!bl3) {
                this.expect(TokenType.COMMARIGHT);
                if (ES7_TRAILING_COMMA && this.isES7() && this.type == tokenType) {
                    break;
                }
            } else {
                bl3 = false;
            }
            boolean bl4 = false;
            if (ES6_REST_PARAMETER && this.type == TokenType.ELLIPSIS && this.isES6()) {
                this.next();
                bl4 = true;
            }
            if (this.type == TokenType.YIELD && bl || this.isAwait(this.token) && bl2) {
                this.expect(TokenType.IDENT);
            }
            long l = this.token;
            int n = this.line;
            if (this.isBindingIdentifier() || bl4 || !ES6_DESTRUCTURING || !this.isES6()) {
                identNode = this.bindingIdentifier("function parameter");
                if (bl4) {
                    identNode = identNode.setIsRestParameter();
                    this.expectDontAdvance(tokenType);
                    arrayList.add(identNode);
                    break;
                }
                if (this.type == TokenType.ASSIGN && ES6_DEFAULT_PARAMETER && this.isES6()) {
                    this.next();
                    identNode = identNode.setIsDefaultParameter();
                    if (this.type == TokenType.YIELD && bl || this.isAwait(this.token) && bl2) {
                        this.expect(TokenType.IDENT);
                    }
                    object3 = this.assignmentExpression(false);
                    object2 = this.lc.getCurrentFunction();
                    if (object2 != null) {
                        object = new BinaryNode(Token.recast(l, TokenType.EQ_STRICT), (Expression)identNode, (Expression)Parser.newUndefinedLiteral(l, this.finish));
                        expression = new TernaryNode(Token.recast(l, TokenType.TERNARY), (Expression)object, new JoinPredecessorExpression((Expression)object3), new JoinPredecessorExpression(identNode));
                        BinaryNode binaryNode = new BinaryNode(Token.recast(l, TokenType.ASSIGN), (Expression)identNode, expression);
                        this.lc.getFunctionBody((ParserContextFunctionNode)object2).appendStatement(new ExpressionStatement(n, binaryNode.getToken(), binaryNode.getFinish(), binaryNode));
                    }
                }
                if ((object3 = this.lc.getCurrentFunction()) != null) {
                    ((ParserContextFunctionNode)object3).addParameterBinding(identNode);
                    if (identNode.isRestParameter() || identNode.isDefaultParameter()) {
                        ((ParserContextFunctionNode)object3).setSimpleParameterList(false);
                    }
                }
            } else {
                object3 = this.bindingPattern();
                identNode = this.createIdentNode(l, ((Node)object3).getFinish(), String.format("arguments[%d]", arrayList.size())).setIsDestructuredParameter();
                this.verifyDestructuringParameterBindingPattern((Expression)object3, l, n, "function parameter");
                object2 = identNode;
                if (this.type == TokenType.ASSIGN) {
                    this.next();
                    identNode = identNode.setIsDefaultParameter();
                    object = this.assignmentExpression(false);
                    expression = new BinaryNode(Token.recast(l, TokenType.EQ_STRICT), (Expression)identNode, (Expression)Parser.newUndefinedLiteral(l, this.finish));
                    object2 = new TernaryNode(Token.recast(l, TokenType.TERNARY), expression, new JoinPredecessorExpression((Expression)object), new JoinPredecessorExpression(identNode));
                }
                if ((object = this.lc.getCurrentFunction()) != null) {
                    expression = new BinaryNode(Token.recast(l, TokenType.ASSIGN), (Expression)object3, (Expression)object2);
                    this.lc.getFunctionBody((ParserContextFunctionNode)object).appendStatement(new ExpressionStatement(n, expression.getToken(), expression.getFinish(), expression));
                }
            }
            arrayList.add(identNode);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    private void verifyDestructuringParameterBindingPattern(final Expression expression, final long l, final int n, final String string) {
        this.verifyDestructuringBindingPattern(expression, new Consumer<IdentNode>(){

            @Override
            public void accept(IdentNode identNode) {
                Parser.this.verifyIdent(identNode, string);
                ParserContextFunctionNode parserContextFunctionNode = Parser.this.lc.getCurrentFunction();
                if (parserContextFunctionNode != null) {
                    Parser.this.lc.getFunctionBody(parserContextFunctionNode).appendStatement(new VarNode(n, Token.recast(l, TokenType.VAR), expression.getFinish(), identNode, null).setFlag(16));
                    parserContextFunctionNode.addParameterBinding(identNode);
                    parserContextFunctionNode.setSimpleParameterList(false);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Block functionBody(ParserContextFunctionNode parserContextFunctionNode) {
        RecompilableScriptFunctionData recompilableScriptFunctionData;
        boolean bl;
        ParserState parserState;
        int n;
        long l;
        ParserContextBlockNode parserContextBlockNode;
        block18: {
            long l2 = 0L;
            parserContextBlockNode = null;
            l = this.token;
            n = 0;
            parserState = null;
            try {
                parserContextBlockNode = this.newBlock();
                assert (parserContextFunctionNode != null);
                int n2 = parserContextFunctionNode.getId();
                boolean bl2 = bl = this.reparsedFunction == null || n2 <= this.reparsedFunction.getFunctionNodeId();
                if ((this.env.syntaxExtensions || parserContextFunctionNode.getKind() == FunctionNode.Kind.ARROW) && this.type != TokenType.LBRACE) {
                    Expression expression = this.assignmentExpression(false);
                    l2 = this.previousToken;
                    parserContextFunctionNode.setLastToken(this.previousToken);
                    assert (this.lc.getCurrentBlock() == this.lc.getFunctionBody(parserContextFunctionNode));
                    int n3 = Token.descPosition(l2) + (Token.descType(l2) == TokenType.EOL ? 0 : Token.descLength(l2));
                    if (bl) {
                        ReturnNode returnNode = new ReturnNode(parserContextFunctionNode.getLineNumber(), expression.getToken(), n3, expression);
                        this.appendStatement(returnNode);
                    }
                    n = this.finish;
                    break block18;
                }
                this.expectDontAdvance(TokenType.LBRACE);
                if (bl || !this.skipFunctionBody(parserContextFunctionNode)) {
                    this.next();
                    List<Statement> list = this.functionDeclarations;
                    this.functionDeclarations = new ArrayList<Statement>();
                    try {
                        this.sourceElements(false);
                        this.addFunctionDeclarations(parserContextFunctionNode);
                    }
                    finally {
                        this.functionDeclarations = list;
                    }
                    l2 = this.token;
                    if (bl) {
                        parserState = new ParserState(Token.descPosition(this.token), this.line, this.linePosition);
                    }
                }
                n = this.finish;
                parserContextFunctionNode.setLastToken(this.token);
                this.expect(TokenType.RBRACE);
            }
            finally {
                this.restoreBlock(parserContextBlockNode);
            }
        }
        if (bl) {
            parserContextFunctionNode.setEndParserState(parserState);
        } else if (!parserContextBlockNode.getStatements().isEmpty()) {
            parserContextBlockNode.setStatements(Collections.emptyList());
        }
        if (this.reparsedFunction != null && (recompilableScriptFunctionData = this.reparsedFunction.getScriptFunctionData(parserContextFunctionNode.getId())) != null) {
            parserContextFunctionNode.setFlag(recompilableScriptFunctionData.getFunctionFlags());
            if (parserContextFunctionNode.hasNestedEval()) {
                assert (parserContextFunctionNode.hasScopeBlock());
                parserContextBlockNode.setFlag(1);
            }
        }
        Block block = new Block(l, n, parserContextBlockNode.getFlags() | 0x20, parserContextBlockNode.getStatements());
        return block;
    }

    private boolean skipFunctionBody(ParserContextFunctionNode parserContextFunctionNode) {
        if (this.reparsedFunction == null) {
            return false;
        }
        RecompilableScriptFunctionData recompilableScriptFunctionData = this.reparsedFunction.getScriptFunctionData(parserContextFunctionNode.getId());
        if (recompilableScriptFunctionData == null) {
            return false;
        }
        ParserState parserState = (ParserState)recompilableScriptFunctionData.getEndParserState();
        assert (parserState != null);
        if (this.k < this.stream.last() && this.start < parserState.position && parserState.position <= Token.descPosition(this.stream.get(this.stream.last()))) {
            while (this.k < this.stream.last()) {
                long l = this.stream.get(this.k + 1);
                if (Token.descPosition(l) == parserState.position && Token.descType(l) == TokenType.RBRACE) {
                    this.token = this.stream.get(this.k);
                    this.type = Token.descType(this.token);
                    this.next();
                    assert (this.type == TokenType.RBRACE && this.start == parserState.position);
                    return true;
                }
                ++this.k;
            }
        }
        this.stream.reset();
        this.lexer = parserState.createLexer(this.source, this.lexer, this.stream, this.scripting && this.env.syntaxExtensions, this.env.es6, this.shebang, this.env.jsx);
        this.line = parserState.line;
        this.linePosition = parserState.linePosition;
        this.type = TokenType.SEMICOLON;
        this.scanFirstToken();
        return true;
    }

    private void addFunctionDeclarations(ParserContextFunctionNode parserContextFunctionNode) {
        VarNode varNode = null;
        for (int i = this.functionDeclarations.size() - 1; i >= 0; --i) {
            Statement statement = this.functionDeclarations.get(i);
            if (varNode == null && statement instanceof VarNode) {
                varNode = ((VarNode)statement).setFlag(4);
                statement = varNode;
                parserContextFunctionNode.setFlag(1024);
            }
            this.prependStatement(statement);
        }
    }

    private RuntimeNode referenceError(Expression expression, Expression expression2, boolean bl) {
        if (bl) {
            throw this.error(JSErrorType.ReferenceError, AbstractParser.message("invalid.lvalue", new String[0]), expression.getToken());
        }
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        arrayList.add(expression);
        if (expression2 == null) {
            arrayList.add(LiteralNode.newInstance(expression.getToken(), expression.getFinish()));
        } else {
            arrayList.add(expression2);
        }
        arrayList.add(LiteralNode.newInstance(expression.getToken(), expression.getFinish(), expression.toString()));
        return new RuntimeNode(expression.getToken(), expression.getFinish(), RuntimeNode.Request.REFERENCE_ERROR, arrayList);
    }

    private Expression unaryExpression() {
        int n = this.line;
        long l = this.token;
        switch (this.type) {
            case DELETE: {
                this.next();
                Expression expression = this.unaryExpression();
                if (this.type == TokenType.EXP) {
                    throw this.error(AbstractParser.message("unexpected.token", this.type.getNameOrType()));
                }
                if (expression instanceof BaseNode || expression instanceof IdentNode) {
                    return new UnaryNode(l, expression);
                }
                this.appendStatement(new ExpressionStatement(n, l, this.finish, expression));
                return LiteralNode.newInstance(l, this.finish, true);
            }
            case VOID: 
            case TYPEOF: 
            case ADD: 
            case SUB: 
            case BIT_NOT: 
            case NOT: {
                this.next();
                Expression expression = this.unaryExpression();
                if (this.type == TokenType.EXP) {
                    throw this.error(AbstractParser.message("unexpected.token", this.type.getNameOrType()));
                }
                return new UnaryNode(l, expression);
            }
            case INCPREFIX: 
            case DECPREFIX: {
                TokenType tokenType = this.type;
                this.next();
                Expression expression = this.unaryExpression();
                if (expression == null) {
                    throw this.error(AbstractParser.message("expected.lvalue", this.type.getNameOrType()));
                }
                return this.verifyIncDecExpression(l, tokenType, expression, false);
            }
        }
        if (this.isAwait(this.token) && ES7_ASYNC_FUNCTION && this.inAsyncFunction() && this.isES7()) {
            return this.awaitExpression();
        }
        Expression expression = this.leftHandSideExpression();
        if (this.last != TokenType.EOL) {
            switch (this.type) {
                case INCPREFIX: 
                case DECPREFIX: {
                    long l2 = this.token;
                    TokenType tokenType = this.type;
                    Expression expression2 = expression;
                    if (expression2 == null) {
                        throw this.error(AbstractParser.message("expected.lvalue", this.type.getNameOrType()));
                    }
                    this.next();
                    return this.verifyIncDecExpression(l2, tokenType, expression2, true);
                }
            }
        }
        if (expression == null) {
            throw this.error(AbstractParser.message("expected.operand", this.type.getNameOrType()));
        }
        return expression;
    }

    private Expression verifyIncDecExpression(long l, TokenType tokenType, Expression expression, boolean bl) {
        assert (expression != null);
        if (!(expression instanceof AccessNode || expression instanceof IndexNode || expression instanceof IdentNode)) {
            return this.referenceError(expression, null, this.env.earlyLvalueError);
        }
        if (expression instanceof IdentNode) {
            if (!Parser.checkIdentLValue((IdentNode)expression)) {
                return this.referenceError(expression, null, false);
            }
            assert (tokenType == TokenType.INCPREFIX || tokenType == TokenType.DECPREFIX);
            String string = tokenType == TokenType.INCPREFIX ? "operand for ++ operator" : "operand for -- operator";
            this.verifyIdent((IdentNode)expression, string);
        }
        return Parser.incDecExpression(l, tokenType, expression, bl);
    }

    protected Expression expression() {
        return this.expression(false, false);
    }

    private Expression expression(boolean bl, boolean bl2) {
        Expression expression = this.assignmentExpression(bl);
        while (this.type == TokenType.COMMARIGHT) {
            long l = this.token;
            this.next();
            if (ES7_TRAILING_COMMA && this.isES7() && bl2 && this.type == TokenType.RPAREN) break;
            boolean bl3 = false;
            if (ES6_ARROW_FUNCTION && ES6_REST_PARAMETER && this.type == TokenType.ELLIPSIS && this.isES6() && this.isRestParameterEndOfArrowFunctionParameterList()) {
                this.next();
                bl3 = true;
            }
            Expression expression2 = this.assignmentExpression(bl);
            if (bl3) {
                expression2 = ((IdentNode)expression2).setIsRestParameter();
                assert (this.type == TokenType.RPAREN);
            }
            expression = new BinaryNode(l, expression, expression2);
        }
        return expression;
    }

    private Expression expression(int n, boolean bl) {
        return this.expression(this.unaryExpression(), n, bl);
    }

    private JoinPredecessorExpression joinPredecessorExpression() {
        return new JoinPredecessorExpression(this.expression());
    }

    private Expression expression(Expression expression, int n, boolean bl) {
        int n2 = this.type.getPrecedence();
        Expression expression2 = expression;
        while (this.checkOperator(bl) && n2 >= n) {
            Expression expression3;
            long l = this.token;
            if (this.type == TokenType.TERNARY) {
                this.next();
                expression3 = this.assignmentExpression(false);
                this.expect(TokenType.COLON);
                Expression expression4 = this.assignmentExpression(bl);
                expression2 = new TernaryNode(l, expression2, new JoinPredecessorExpression(expression3), new JoinPredecessorExpression(expression4));
            } else {
                this.next();
                assert (!Token.descType(l).isAssignment());
                expression3 = this.unaryExpression();
                int n3 = this.type.getPrecedence();
                while (this.checkOperator(bl) && (n3 > n2 || n3 == n2 && !this.type.isLeftAssociative())) {
                    expression3 = this.expression(expression3, n3, bl);
                    n3 = this.type.getPrecedence();
                }
                expression2 = Parser.newBinaryExpression(l, expression2, expression3);
            }
            n2 = this.type.getPrecedence();
        }
        return expression2;
    }

    private boolean checkOperator(boolean bl) {
        return this.type.isOperator(bl) && (this.type != TokenType.EXP || this.isES6());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression assignmentExpression(boolean bl) {
        if (this.type == TokenType.YIELD && ES6_GENERATOR_FUNCTION && this.inGeneratorFunction() && this.isES6()) {
            return this.yieldExpression(bl);
        }
        long l = this.token;
        int n = this.line;
        int n2 = this.k;
        Expression expression = this.conditionalExpression(bl);
        boolean bl2 = false;
        if (ES7_ASYNC_FUNCTION && this.isES7()) {
            Expression expression2;
            if (expression instanceof IdentNode && ASYNC_IDENT.equals(((IdentNode)expression).getName()) && (this.isNonStrictModeIdent() || this.type == TokenType.IDENT)) {
                boolean bl3 = false;
                for (int i = n2 + 1; i < this.k; ++i) {
                    TokenType tokenType = this.T(i);
                    if (tokenType == TokenType.COMMENT) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    bl2 = true;
                    expression = this.conditionalExpression(bl);
                }
            }
            if (!bl2 && expression instanceof CallNode && this.type == TokenType.ARROW && (expression2 = ((CallNode)expression).getFunction()) instanceof IdentNode && ASYNC_IDENT.equals(((IdentNode)expression2).getName())) {
                bl2 = true;
            }
        }
        if (ES6_ARROW_FUNCTION && this.type == TokenType.ARROW && this.isES6() && this.checkNoLineTerminator()) {
            Expression expression3 = expression instanceof ExpressionList ? (((ExpressionList)expression).getExpressions().isEmpty() ? null : ((ExpressionList)expression).getExpressions().get(0)) : expression;
            return this.arrowFunction(l, n, expression3, bl2);
        }
        assert (!(expression instanceof ExpressionList));
        if (this.type.isAssignment()) {
            boolean bl4;
            boolean bl5 = bl4 = this.type == TokenType.ASSIGN;
            if (bl4) {
                this.defaultNames.push(expression);
            }
            try {
                long l2 = this.token;
                this.next();
                Expression expression4 = this.assignmentExpression(bl);
                Expression expression5 = this.verifyAssignment(l2, expression, expression4);
                return expression5;
            }
            finally {
                if (bl4) {
                    this.defaultNames.pop();
                }
            }
        }
        return expression;
    }

    private Expression conditionalExpression(boolean bl) {
        return this.expression(TokenType.TERNARY.getPrecedence(), bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression arrowFunction(long l, int n, Expression expression, boolean bl) {
        assert (this.type != TokenType.ARROW || this.checkNoLineTerminator());
        this.expect(TokenType.ARROW);
        long l2 = Token.recast(l, TokenType.ARROW);
        IdentNode identNode = new IdentNode(l2, Token.descPosition(l2), ARROW_FUNCTION_PREFIX + n);
        ParserContextFunctionNode parserContextFunctionNode = this.createParserContextFunctionNode(identNode, l2, FunctionNode.Kind.ARROW, n, null);
        parserContextFunctionNode.setFlag(1);
        if (bl) {
            parserContextFunctionNode.setFlag(0x2000000);
        }
        this.lc.push(parserContextFunctionNode);
        try {
            FunctionNode functionNode;
            List<IdentNode> list;
            ParserContextBlockNode parserContextBlockNode = this.newBlock();
            try {
                list = this.convertArrowFunctionParameterList(expression, n, bl);
                parserContextFunctionNode.setParameters(list);
                if (!parserContextFunctionNode.isSimpleParameterList()) {
                    this.markEvalInArrowParameterList(parserContextBlockNode);
                }
            }
            finally {
                this.restoreBlock(parserContextBlockNode);
            }
            Block block = this.functionBody(parserContextFunctionNode);
            block = Parser.maybeWrapBodyInParameterBlock(block, parserContextBlockNode);
            this.verifyParameterList(list, parserContextFunctionNode);
            FunctionNode functionNode2 = functionNode = this.createFunctionNode(parserContextFunctionNode, l2, identNode, list, FunctionNode.Kind.ARROW, n, block);
            return functionNode2;
        }
        finally {
            this.lc.pop(parserContextFunctionNode);
        }
    }

    private void markEvalInArrowParameterList(ParserContextBlockNode parserContextBlockNode) {
        Iterator<ParserContextFunctionNode> iterator = this.lc.getFunctions();
        final ParserContextFunctionNode parserContextFunctionNode = iterator.next();
        ParserContextFunctionNode parserContextFunctionNode2 = iterator.next();
        if (parserContextFunctionNode2.getFlag(32) != 0) {
            for (Statement statement : parserContextBlockNode.getStatements()) {
                statement.accept((NodeVisitor<? extends LexicalContext>)new NodeVisitor<LexicalContext>(new LexicalContext()){

                    @Override
                    public boolean enterCallNode(CallNode callNode) {
                        if (callNode.getFunction() instanceof IdentNode && ((IdentNode)callNode.getFunction()).getName().equals(Parser.EVAL_NAME)) {
                            parserContextFunctionNode.setFlag(32);
                        }
                        return true;
                    }
                });
            }
        }
    }

    private List<IdentNode> convertArrowFunctionParameterList(Expression expression, int n, boolean bl) {
        List<IdentNode> list;
        if (expression == null) {
            list = Collections.emptyList();
        } else if (expression instanceof IdentNode || expression.isTokenType(TokenType.ASSIGN) || this.isDestructuringLhs(expression)) {
            list = Collections.singletonList(this.verifyArrowParameter(expression, 0, n));
        } else if (expression instanceof BinaryNode && Token.descType(expression.getToken()) == TokenType.COMMARIGHT) {
            list = new ArrayList<IdentNode>();
            Expression expression2 = expression;
            do {
                Expression expression3 = ((BinaryNode)expression2).rhs();
                list.add(0, this.verifyArrowParameter(expression3, list.size(), n));
            } while ((expression2 = ((BinaryNode)expression2).lhs()) instanceof BinaryNode && Token.descType(expression2.getToken()) == TokenType.COMMARIGHT);
            list.add(0, this.verifyArrowParameter(expression2, list.size(), n));
        } else if (expression instanceof CallNode && bl) {
            list = new ArrayList<IdentNode>();
            for (Expression expression4 : ((CallNode)expression).getArgs()) {
                list.add(this.verifyArrowParameter(expression4, list.size(), n));
            }
        } else {
            throw this.error(AbstractParser.message("expected.arrow.parameter", new String[0]), expression.getToken());
        }
        return list;
    }

    private IdentNode verifyArrowParameter(Expression expression, int n, int n2) {
        if (expression instanceof IdentNode) {
            IdentNode identNode = (IdentNode)expression;
            this.verifyStrictIdent(identNode, "function parameter");
            ParserContextFunctionNode parserContextFunctionNode = this.lc.getCurrentFunction();
            if (parserContextFunctionNode != null) {
                parserContextFunctionNode.addParameterBinding(identNode);
            }
            return identNode;
        }
        if (expression.isTokenType(TokenType.ASSIGN)) {
            Expression expression2 = ((BinaryNode)expression).lhs();
            long l = expression2.getToken();
            Expression expression3 = ((BinaryNode)expression).rhs();
            if (expression2 instanceof IdentNode) {
                IdentNode identNode = (IdentNode)expression2;
                ParserContextFunctionNode parserContextFunctionNode = this.lc.getCurrentFunction();
                if (parserContextFunctionNode != null) {
                    BinaryNode binaryNode = new BinaryNode(Token.recast(l, TokenType.EQ_STRICT), (Expression)identNode, (Expression)Parser.newUndefinedLiteral(l, this.finish));
                    TernaryNode ternaryNode = new TernaryNode(Token.recast(l, TokenType.TERNARY), (Expression)binaryNode, new JoinPredecessorExpression(expression3), new JoinPredecessorExpression(identNode));
                    BinaryNode binaryNode2 = new BinaryNode(Token.recast(l, TokenType.ASSIGN), (Expression)identNode, (Expression)ternaryNode);
                    this.lc.getFunctionBody(parserContextFunctionNode).appendStatement(new ExpressionStatement(n2, binaryNode2.getToken(), binaryNode2.getFinish(), binaryNode2));
                    parserContextFunctionNode.addParameterBinding(identNode);
                    parserContextFunctionNode.setSimpleParameterList(false);
                }
                return identNode;
            }
            if (this.isDestructuringLhs(expression2)) {
                IdentNode identNode = this.createIdentNode(l, expression.getFinish(), String.format("arguments[%d]", n)).setIsDestructuredParameter().setIsDefaultParameter();
                this.verifyDestructuringParameterBindingPattern(expression, l, n2, "function parameter");
                ParserContextFunctionNode parserContextFunctionNode = this.lc.getCurrentFunction();
                if (parserContextFunctionNode != null) {
                    BinaryNode binaryNode = new BinaryNode(Token.recast(l, TokenType.EQ_STRICT), (Expression)identNode, (Expression)Parser.newUndefinedLiteral(l, this.finish));
                    TernaryNode ternaryNode = new TernaryNode(Token.recast(l, TokenType.TERNARY), (Expression)binaryNode, new JoinPredecessorExpression(expression3), new JoinPredecessorExpression(identNode));
                    BinaryNode binaryNode3 = new BinaryNode(Token.recast(l, TokenType.ASSIGN), expression, (Expression)ternaryNode);
                    this.lc.getFunctionBody(parserContextFunctionNode).appendStatement(new ExpressionStatement(n2, binaryNode3.getToken(), binaryNode3.getFinish(), binaryNode3));
                }
                return identNode;
            }
        } else if (this.isDestructuringLhs(expression)) {
            long l = expression.getToken();
            IdentNode identNode = this.createIdentNode(l, expression.getFinish(), String.format("arguments[%d]", n)).setIsDestructuredParameter();
            this.verifyDestructuringParameterBindingPattern(expression, l, n2, "function parameter");
            ParserContextFunctionNode parserContextFunctionNode = this.lc.getCurrentFunction();
            if (parserContextFunctionNode != null) {
                BinaryNode binaryNode = new BinaryNode(Token.recast(l, TokenType.ASSIGN), expression, (Expression)identNode);
                this.lc.getFunctionBody(parserContextFunctionNode).appendStatement(new ExpressionStatement(n2, binaryNode.getToken(), binaryNode.getFinish(), binaryNode));
            }
            return identNode;
        }
        throw this.error(AbstractParser.message("invalid.arrow.parameter", new String[0]), expression.getToken());
    }

    private boolean checkNoLineTerminator() {
        assert (this.type == TokenType.ARROW);
        if (this.last == TokenType.RPAREN) {
            return true;
        }
        if (this.last == TokenType.IDENT) {
            return true;
        }
        block5: for (int i = this.k - 1; i >= 0; --i) {
            TokenType tokenType = this.T(i);
            switch (tokenType) {
                case RPAREN: 
                case IDENT: {
                    return true;
                }
                case EOL: {
                    return false;
                }
                case COMMENT: {
                    continue block5;
                }
                default: {
                    return tokenType.getKind() == TokenKind.FUTURESTRICT;
                }
            }
        }
        return false;
    }

    private boolean isRestParameterEndOfArrowFunctionParameterList() {
        TokenType tokenType;
        assert (this.type == TokenType.ELLIPSIS);
        int n = 1;
        while ((tokenType = this.T(this.k + n++)) != TokenType.IDENT) {
            if (tokenType == TokenType.EOL || tokenType == TokenType.COMMENT) continue;
            return false;
        }
        while ((tokenType = this.T(this.k + n++)) != TokenType.RPAREN) {
            if (tokenType == TokenType.EOL || tokenType == TokenType.COMMENT) continue;
            return false;
        }
        while ((tokenType = this.T(this.k + n++)) != TokenType.ARROW) {
            if (tokenType == TokenType.COMMENT) continue;
            return false;
        }
        return true;
    }

    private void endOfLine() {
        switch (this.type) {
            case EOL: 
            case SEMICOLON: {
                this.next();
                break;
            }
            case EOF: 
            case RBRACE: 
            case RPAREN: 
            case RBRACKET: {
                break;
            }
            default: {
                if (this.last == TokenType.EOL) break;
                this.expect(TokenType.SEMICOLON);
            }
        }
    }

    private Expression templateLiteral() {
        TokenType tokenType;
        assert (this.type == TokenType.TEMPLATE || this.type == TokenType.TEMPLATE_HEAD);
        boolean bl = this.type == TokenType.TEMPLATE;
        long l = this.token;
        LiteralNode<?> literalNode = this.getLiteral();
        if (bl) {
            return literalNode;
        }
        Expression expression = literalNode;
        do {
            Expression expression2 = this.expression();
            if (this.type != TokenType.TEMPLATE_MIDDLE && this.type != TokenType.TEMPLATE_TAIL) {
                throw this.error(AbstractParser.message("unterminated.template.expression", new String[0]), this.token);
            }
            expression2 = new RuntimeNode(Token.recast(expression2.getToken(), TokenType.VOID), expression2.getFinish(), RuntimeNode.Request.TO_STRING, expression2);
            expression = new BinaryNode(Token.recast(l, TokenType.ADD), expression, expression2);
            tokenType = this.type;
            l = this.token;
            literalNode = this.getLiteral();
            expression = new BinaryNode(Token.recast(l, TokenType.ADD), expression, literalNode);
        } while (tokenType == TokenType.TEMPLATE_MIDDLE);
        return expression;
    }

    private List<Expression> templateLiteralArgumentList() {
        LiteralNode<Expression[]> literalNode;
        Object object;
        assert (this.type == TokenType.TEMPLATE || this.type == TokenType.TEMPLATE_HEAD);
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        ArrayList<Expression> arrayList3 = new ArrayList<Expression>();
        arrayList.add(null);
        long l = this.token;
        boolean bl = this.type == TokenType.TEMPLATE_HEAD;
        this.addTemplateLiteralString(arrayList2, arrayList3);
        if (bl) {
            do {
                literalNode = this.expression();
                if (this.type != TokenType.TEMPLATE_MIDDLE && this.type != TokenType.TEMPLATE_TAIL) {
                    throw this.error(AbstractParser.message("unterminated.template.expression", new String[0]), this.token);
                }
                arrayList.add(literalNode);
                object = this.type;
                this.addTemplateLiteralString(arrayList2, arrayList3);
            } while (object == TokenType.TEMPLATE_MIDDLE);
        }
        object = LiteralNode.newInstance(l, this.finish, arrayList2);
        literalNode = LiteralNode.newInstance(l, this.finish, arrayList3);
        RuntimeNode runtimeNode = new RuntimeNode(l, this.finish, RuntimeNode.Request.GET_TEMPLATE_OBJECT, new Expression[]{object, literalNode});
        arrayList.set(0, runtimeNode);
        return Parser.optimizeList(arrayList);
    }

    private void addTemplateLiteralString(ArrayList<Expression> arrayList, ArrayList<Expression> arrayList2) {
        long l = this.token;
        String string = this.lexer.valueOfRawString(l);
        String string2 = (String)this.getValue();
        this.next();
        arrayList.add(LiteralNode.newInstance(l, this.finish, string));
        arrayList2.add(LiteralNode.newInstance(l, this.finish, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FunctionNode module(String string) {
        boolean bl = this.isStrictMode;
        boolean bl2 = this.isModule;
        try {
            this.isStrictMode = true;
            this.isModule = true;
            int n = Math.min(Token.descPosition(Token.withDelimiter(this.token)), this.finish);
            long l = Token.toDesc(TokenType.FUNCTION, n, this.source.getLength() - n);
            int n2 = this.line;
            IdentNode identNode = new IdentNode(l, Token.descPosition(l), string);
            ParserContextFunctionNode parserContextFunctionNode = this.createParserContextFunctionNode(identNode, l, FunctionNode.Kind.MODULE, n2, Collections.emptyList());
            this.lc.push(parserContextFunctionNode);
            ParserContextModuleNode parserContextModuleNode = new ParserContextModuleNode(string);
            this.lc.push(parserContextModuleNode);
            ParserContextBlockNode parserContextBlockNode = this.newBlock();
            this.functionDeclarations = new ArrayList<Statement>();
            this.moduleBody();
            this.addFunctionDeclarations(parserContextFunctionNode);
            this.functionDeclarations = null;
            this.restoreBlock(parserContextBlockNode);
            parserContextBlockNode.setFlag(1);
            Block block = new Block(l, this.finish, parserContextBlockNode.getFlags() | 0x10 | 0x20, parserContextBlockNode.getStatements());
            this.lc.pop(parserContextModuleNode);
            this.lc.pop(parserContextFunctionNode);
            parserContextFunctionNode.setLastToken(this.token);
            this.expect(TokenType.EOF);
            parserContextFunctionNode.setModule(parserContextModuleNode.createModule());
            FunctionNode functionNode = this.createFunctionNode(parserContextFunctionNode, l, identNode, Collections.emptyList(), FunctionNode.Kind.MODULE, n2, block);
            return functionNode;
        }
        finally {
            this.isModule = bl2;
            this.isStrictMode = bl;
        }
    }

    private void moduleBody() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        block6: while (this.type != TokenType.EOF) {
            switch (this.type) {
                case EOF: {
                    break block6;
                }
                case IMPORT: {
                    this.importDeclaration();
                    arrayList.clear();
                    continue block6;
                }
                case EXPORT: {
                    this.exportDeclaration(arrayList);
                    arrayList.clear();
                    continue block6;
                }
                case AT: {
                    if (ES7_DECORATOR && this.isES7()) {
                        arrayList.addAll(this.decoratorList());
                        continue block6;
                    }
                }
                default: {
                    this.statement(true, false, false, false, arrayList);
                    arrayList.clear();
                    continue block6;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void importDeclaration() {
        long l = this.token;
        this.expect(TokenType.IMPORT);
        ParserContextModuleNode parserContextModuleNode = this.lc.getCurrentModule();
        if (this.type == TokenType.STRING || this.type == TokenType.ESCSTRING) {
            String string = (String)this.getValue();
            LiteralNode<String> literalNode = LiteralNode.newInstance(this.token, this.finish, string);
            this.next();
            parserContextModuleNode.addModuleRequest(string);
            parserContextModuleNode.addImport(new ImportNode(l, Token.descPosition(l), this.finish, literalNode));
        } else {
            Object object;
            List<Module.ImportEntry> list;
            ImportClauseNode importClauseNode;
            Node node;
            long l2 = this.token;
            if (this.type == TokenType.MUL) {
                node = this.nameSpaceImport();
                importClauseNode = new ImportClauseNode(l2, Token.descPosition(l2), this.finish, (NameSpaceImportNode)node);
                list = Collections.singletonList(Module.ImportEntry.importStarAsNameSpaceFrom(((NameSpaceImportNode)node).getBindingIdentifier().getName()));
            } else if (this.type == TokenType.LBRACE) {
                node = this.namedImports();
                importClauseNode = new ImportClauseNode(l2, Token.descPosition(l2), this.finish, (NamedImportsNode)node);
                list = Parser.convert((NamedImportsNode)node);
            } else {
                if (!this.isBindingIdentifier()) throw this.error(AbstractParser.message("expected.import", new String[0]));
                node = this.bindingIdentifier("ImportedBinding");
                object = Module.ImportEntry.importDefault(((IdentNode)node).getName());
                if (this.type == TokenType.COMMARIGHT) {
                    Node node2;
                    this.next();
                    if (this.type == TokenType.MUL) {
                        node2 = this.nameSpaceImport();
                        importClauseNode = new ImportClauseNode(l2, Token.descPosition(l2), this.finish, (IdentNode)node, (NameSpaceImportNode)node2);
                        list = new ArrayList<Module.ImportEntry>(2);
                        list.add((Module.ImportEntry)object);
                        list.add(Module.ImportEntry.importStarAsNameSpaceFrom(((NameSpaceImportNode)node2).getBindingIdentifier().getName()));
                    } else {
                        if (this.type != TokenType.LBRACE) throw this.error(AbstractParser.message("expected.named.import", new String[0]));
                        node2 = this.namedImports();
                        importClauseNode = new ImportClauseNode(l2, Token.descPosition(l2), this.finish, (IdentNode)node, (NamedImportsNode)node2);
                        list = Parser.convert((NamedImportsNode)node2);
                        list.add(0, (Module.ImportEntry)object);
                    }
                } else {
                    importClauseNode = new ImportClauseNode(l2, Token.descPosition(l2), this.finish, (IdentNode)node);
                    list = Collections.singletonList(object);
                }
            }
            node = this.fromClause();
            parserContextModuleNode.addImport(new ImportNode(l, Token.descPosition(l), this.finish, importClauseNode, (FromNode)node));
            object = ((FromNode)node).getModuleSpecifier().getValue();
            parserContextModuleNode.addModuleRequest((String)object);
            for (int i = 0; i < list.size(); ++i) {
                parserContextModuleNode.addImportEntry(list.get(i).withFrom((String)object));
            }
        }
        this.endOfLine();
    }

    private NameSpaceImportNode nameSpaceImport() {
        long l = this.token;
        assert (this.type == TokenType.MUL);
        this.next();
        long l2 = this.token;
        String string = (String)this.expectValue(TokenType.IDENT);
        if (!"as".equals(string)) {
            throw this.error(AbstractParser.message("expected.as", new String[0]), l2);
        }
        IdentNode identNode = this.bindingIdentifier("ImportedBinding");
        return new NameSpaceImportNode(l, Token.descPosition(l), this.finish, identNode);
    }

    private NamedImportsNode namedImports() {
        long l = this.token;
        assert (this.type == TokenType.LBRACE);
        this.next();
        ArrayList<ImportSpecifierNode> arrayList = new ArrayList<ImportSpecifierNode>();
        while (this.type != TokenType.RBRACE) {
            boolean bl = this.isBindingIdentifier();
            long l2 = this.token;
            IdentNode identNode = this.getIdentifierName();
            if (this.type == TokenType.IDENT && "as".equals(this.getValue())) {
                this.next();
                IdentNode identNode2 = this.bindingIdentifier("ImportedBinding");
                arrayList.add(new ImportSpecifierNode(l2, Token.descPosition(l2), this.finish, identNode2, identNode));
            } else {
                if (!bl) {
                    throw this.error(AbstractParser.message("expected.binding.identifier", new String[0]), l2);
                }
                arrayList.add(new ImportSpecifierNode(l2, Token.descPosition(l2), this.finish, identNode, null));
            }
            if (this.type != TokenType.COMMARIGHT) break;
            this.next();
        }
        this.expect(TokenType.RBRACE);
        return new NamedImportsNode(l, Token.descPosition(l), this.finish, arrayList);
    }

    private FromNode fromClause() {
        int n = this.start;
        long l = this.token;
        String string = (String)this.expectValue(TokenType.IDENT);
        if (!"from".equals(string)) {
            throw this.error(AbstractParser.message("expected.from", new String[0]), l);
        }
        if (this.type == TokenType.STRING || this.type == TokenType.ESCSTRING) {
            String string2 = (String)this.getValue();
            LiteralNode<String> literalNode = LiteralNode.newInstance(this.token, this.finish, string2);
            this.next();
            return new FromNode(l, n, this.finish, literalNode);
        }
        throw this.error(this.expectMessage(TokenType.STRING));
    }

    private void exportDeclaration(List<Expression> list) {
        long l = this.token;
        this.expect(TokenType.EXPORT);
        ParserContextModuleNode parserContextModuleNode = this.lc.getCurrentModule();
        if (!list.isEmpty() && this.type != TokenType.DEFAULT && this.type != TokenType.CLASS && this.type != TokenType.AT) {
            throw this.error(this.expectMessage(TokenType.CLASS));
        }
        switch (this.type) {
            case MUL: {
                this.next();
                FromNode fromNode = this.fromClause();
                String string = fromNode.getModuleSpecifier().getValue();
                parserContextModuleNode.addModuleRequest(string);
                parserContextModuleNode.addStarExportEntry(Module.ExportEntry.exportStarFrom(string));
                parserContextModuleNode.addExport(new ExportNode(l, Token.descPosition(l), this.finish, fromNode));
                this.endOfLine();
                break;
            }
            case LBRACE: {
                ExportClauseNode exportClauseNode = this.exportClause();
                if (this.type == TokenType.IDENT && "from".equals(this.getValue())) {
                    FromNode fromNode = this.fromClause();
                    parserContextModuleNode.addExport(new ExportNode(l, Token.descPosition(l), this.finish, exportClauseNode, fromNode));
                    String string = fromNode.getModuleSpecifier().getValue();
                    parserContextModuleNode.addModuleRequest(string);
                    List<Module.ExportEntry> list2 = Parser.convert(exportClauseNode);
                    for (int i = 0; i < list2.size(); ++i) {
                        parserContextModuleNode.addIndirectExportEntry(list2.get(i).withFrom(string));
                    }
                } else {
                    for (ExportSpecifierNode exportSpecifierNode : exportClauseNode.getExportSpecifiers()) {
                        this.verifyIdent(exportSpecifierNode.getIdentifier(), "ExportedBinding");
                    }
                    parserContextModuleNode.addExport(new ExportNode(l, Token.descPosition(l), this.finish, exportClauseNode));
                    List<Module.ExportEntry> list3 = Parser.convert(exportClauseNode);
                    for (int i = 0; i < list3.size(); ++i) {
                        parserContextModuleNode.addLocalExportEntry((Module.ExportEntry)list3.get(i));
                    }
                }
                this.endOfLine();
                break;
            }
            case DEFAULT: {
                boolean bl;
                IdentNode identNode;
                Expression expression;
                this.next();
                if (!list.isEmpty() && this.type != TokenType.AT && this.type != TokenType.CLASS) {
                    throw this.error(this.expectMessage(TokenType.CLASS));
                }
                int n = this.line;
                long l2 = this.token;
                switch (this.type) {
                    case FUNCTION: {
                        expression = this.functionExpression(false, true, false);
                        identNode = ((FunctionNode)expression).getIdent();
                        bl = true;
                        break;
                    }
                    case CLASS: 
                    case AT: {
                        expression = this.classDeclaration(true, list);
                        identNode = expression.getIdent();
                        bl = true;
                        break;
                    }
                    default: {
                        if (ES7_ASYNC_FUNCTION && this.isES7() && this.type == TokenType.IDENT && ASYNC_IDENT.equals((String)this.getValue(this.token)) && this.lookaheadIsAsyncFunction(false)) {
                            this.nextOrEOL();
                            expression = this.functionExpression(false, true, true);
                            identNode = ((FunctionNode)expression).getIdent();
                            bl = true;
                            break;
                        }
                        expression = this.assignmentExpression(false);
                        identNode = null;
                        bl = false;
                    }
                }
                parserContextModuleNode.addExport(new ExportNode(l, Token.descPosition(l), this.finish, expression, true));
                if (identNode != null) {
                    parserContextModuleNode.addLocalExportEntry(Module.ExportEntry.exportDefault(identNode.getName()));
                    break;
                }
                identNode = this.createIdentNode(Token.recast(l2, TokenType.IDENT), this.finish, "*default*");
                this.lc.appendStatementToCurrentNode(new VarNode(n, Token.recast(l2, TokenType.LET), this.finish, identNode, expression).setFlag(8));
                if (!bl) {
                    this.endOfLine();
                }
                parserContextModuleNode.addLocalExportEntry(Module.ExportEntry.exportDefault());
                break;
            }
            case VAR: 
            case LET: 
            case CONST: {
                List<Statement> list4 = this.lc.getCurrentBlock().getStatements();
                int n = list4.size();
                this.variableStatement(this.type);
                for (Statement statement : list4.subList(n, list4.size())) {
                    if (!(statement instanceof VarNode)) continue;
                    parserContextModuleNode.addExport(new ExportNode(l, Token.descPosition(l), this.finish, (VarNode)statement));
                    parserContextModuleNode.addLocalExportEntry(Module.ExportEntry.exportSpecifier(((VarNode)statement).getName().getName()));
                }
                break;
            }
            case CLASS: 
            case AT: {
                ClassNode classNode = this.classDeclaration(false, list);
                parserContextModuleNode.addExport(new ExportNode(l, Token.descPosition(l), this.finish, classNode, false));
                parserContextModuleNode.addLocalExportEntry(Module.ExportEntry.exportSpecifier(classNode.getIdent().getName()));
                break;
            }
            case FUNCTION: {
                FunctionNode functionNode = (FunctionNode)this.functionExpression(true, true, false);
                parserContextModuleNode.addExport(new ExportNode(l, Token.descPosition(l), this.finish, functionNode, false));
                parserContextModuleNode.addLocalExportEntry(Module.ExportEntry.exportSpecifier(functionNode.getIdent().getName()));
                break;
            }
            default: {
                if (ES7_ASYNC_FUNCTION && this.isES7() && this.type == TokenType.IDENT && ASYNC_IDENT.equals((String)this.getValue(this.token)) && this.lookaheadIsAsyncFunction(false)) {
                    this.nextOrEOL();
                    FunctionNode functionNode = (FunctionNode)this.functionExpression(true, true, true);
                    parserContextModuleNode.addExport(new ExportNode(l, Token.descPosition(l), this.finish, functionNode, false));
                    parserContextModuleNode.addLocalExportEntry(Module.ExportEntry.exportSpecifier(functionNode.getIdent().getName()));
                    break;
                }
                throw this.error(AbstractParser.message("invalid.export", new String[0]), this.token);
            }
        }
    }

    private ExportClauseNode exportClause() {
        long l = this.token;
        assert (this.type == TokenType.LBRACE);
        this.next();
        ArrayList<ExportSpecifierNode> arrayList = new ArrayList<ExportSpecifierNode>();
        while (this.type != TokenType.RBRACE) {
            long l2 = this.token;
            IdentNode identNode = this.getIdentifierName();
            if (this.type == TokenType.IDENT && "as".equals(this.getValue())) {
                this.next();
                IdentNode identNode2 = this.getIdentifierName();
                arrayList.add(new ExportSpecifierNode(l2, Token.descPosition(l2), this.finish, identNode, identNode2));
            } else {
                arrayList.add(new ExportSpecifierNode(l2, Token.descPosition(l2), this.finish, identNode, null));
            }
            if (this.type != TokenType.COMMARIGHT) break;
            this.next();
        }
        this.expect(TokenType.RBRACE);
        return new ExportClauseNode(l, Token.descPosition(l), this.finish, arrayList);
    }

    private Expression jsxElement(long l) {
        Expression expression;
        long l2 = l;
        if (Token.descType(l2) == TokenType.LT) {
            l2 = Token.recast(l2, TokenType.JSX_ELEM_START);
        }
        assert (Token.descType(l2) == TokenType.JSX_ELEM_START);
        this.next();
        String string = this.jsxElementName();
        if (this.type == TokenType.JSX_ELEM_CLOSE) {
            this.next();
            this.expect(TokenType.JSX_ELEM_END);
            return new JsxElementNode(string, Collections.emptyList(), Collections.emptyList(), l2, this.finish);
        }
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        while ((expression = this.jsxAttribute()) != null) {
            arrayList.add(expression);
        }
        boolean bl = false;
        if (this.type == TokenType.JSX_ELEM_CLOSE) {
            this.next();
            bl = true;
        }
        this.expect(TokenType.JSX_ELEM_END);
        if (bl) {
            return new JsxElementNode(string, arrayList, Collections.emptyList(), l2, this.finish);
        }
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        block6: while (true) {
            switch (this.type) {
                case JSX_TEXT: {
                    long l3 = this.token;
                    String string2 = (String)this.getValue(this.token);
                    arrayList2.add(LiteralNode.newInstance(l3, this.finish, string2));
                    this.next();
                    continue block6;
                }
                case JSX_ELEM_START: {
                    if (this.T(this.k + 1) == TokenType.JSX_ELEM_CLOSE) {
                        this.next();
                        this.next();
                        String string3 = this.jsxElementName();
                        if (!string3.equals(string)) {
                            throw this.error(AbstractParser.message("expected.jsx.name.mismatch", string, string3));
                        }
                        this.expect(TokenType.JSX_ELEM_END);
                        break block6;
                    }
                    arrayList2.add(this.jsxElement(this.token));
                    continue block6;
                }
                case LBRACE: {
                    if (this.T(this.k + 1) == TokenType.RBRACE) {
                        this.next();
                        this.next();
                        continue block6;
                    }
                    this.next();
                    arrayList2.add(this.assignmentExpression(false));
                    this.expect(TokenType.RBRACE);
                    continue block6;
                }
                default: {
                    throw this.error(AbstractParser.message("expected.jsx.child", this.type.getNameOrType()));
                }
            }
            break;
        }
        return new JsxElementNode(string, arrayList, arrayList2, l2, this.finish);
    }

    private Expression jsxAttribute() {
        Expression expression = null;
        if (this.type == TokenType.LBRACE) {
            this.next();
            this.expect(TokenType.ELLIPSIS);
            expression = new UnaryNode(Token.recast(this.token, TokenType.SPREAD_OBJECT), this.assignmentExpression(false));
            this.expect(TokenType.RBRACE);
        } else if (this.type == TokenType.JSX_IDENTIFIER) {
            long l = this.token;
            StringBuilder stringBuilder = new StringBuilder((String)this.getValue(this.token));
            this.next();
            if (this.type == TokenType.COLON) {
                this.expectDontAdvance(TokenType.JSX_IDENTIFIER);
                stringBuilder.append(":").append((String)this.getValue(this.token));
                this.next();
            }
            LiteralNode<String> literalNode = null;
            if (this.type == TokenType.ASSIGN) {
                this.next();
                switch (this.type) {
                    case JSX_STRING: {
                        long l2 = this.token;
                        String string = (String)this.getValue(this.token);
                        literalNode = LiteralNode.newInstance(l2, this.finish, string);
                        this.next();
                        break;
                    }
                    case LBRACE: {
                        this.next();
                        literalNode = this.assignmentExpression(false);
                        this.expect(TokenType.RBRACE);
                        break;
                    }
                    case JSX_ELEM_START: {
                        literalNode = this.jsxElement(this.token);
                        break;
                    }
                    default: {
                        throw this.error(AbstractParser.message("expected.jsx.attribute", this.type.getNameOrType()));
                    }
                }
            }
            expression = new JsxAttributeNode(stringBuilder.toString(), literalNode, l, this.finish);
        }
        return expression;
    }

    private String jsxElementName() {
        StringBuilder stringBuilder;
        block2: {
            block1: {
                this.expectDontAdvance(TokenType.JSX_IDENTIFIER);
                stringBuilder = new StringBuilder((String)this.getValue(this.token));
                this.next();
                if (this.type != TokenType.COLON) break block1;
                this.next();
                this.expectDontAdvance(TokenType.JSX_IDENTIFIER);
                stringBuilder.append(":").append((String)this.getValue(this.token));
                this.next();
                break block2;
            }
            if (this.type != TokenType.PERIOD) break block2;
            do {
                this.next();
                this.expectDontAdvance(TokenType.JSX_IDENTIFIER);
                stringBuilder.append(".").append((String)this.getValue(this.token));
                this.next();
            } while (this.type == TokenType.PERIOD);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return "'JavaScript Parsing'";
    }

    private static void markEval(ParserContext parserContext) {
        Iterator<ParserContextFunctionNode> iterator = parserContext.getFunctions();
        boolean bl = false;
        while (iterator.hasNext()) {
            ParserContextFunctionNode parserContextFunctionNode = iterator.next();
            if (!bl) {
                parserContextFunctionNode.setFlag(32);
                bl = true;
                if (parserContextFunctionNode.getKind() == FunctionNode.Kind.ARROW) {
                    Parser.markThis(parserContext);
                    Parser.markNewTarget(parserContext);
                }
            } else {
                parserContextFunctionNode.setFlag(64);
            }
            ParserContextBlockNode parserContextBlockNode = parserContext.getFunctionBody(parserContextFunctionNode);
            parserContextBlockNode.setFlag(1);
            parserContextFunctionNode.setFlag(128);
        }
    }

    private void prependStatement(Statement statement) {
        this.lc.prependStatementToCurrentNode(statement);
    }

    private void appendStatement(Statement statement) {
        this.lc.appendStatementToCurrentNode(statement);
    }

    private static void markSuperCall(ParserContext parserContext) {
        Iterator<ParserContextFunctionNode> iterator = parserContext.getFunctions();
        while (iterator.hasNext()) {
            ParserContextFunctionNode parserContextFunctionNode = iterator.next();
            if (parserContextFunctionNode.getKind() == FunctionNode.Kind.ARROW) continue;
            assert (parserContextFunctionNode.isSubclassConstructor());
            parserContextFunctionNode.setFlag(262144);
            break;
        }
    }

    private ParserContextFunctionNode getCurrentNonArrowFunction() {
        Iterator<ParserContextFunctionNode> iterator = this.lc.getFunctions();
        while (iterator.hasNext()) {
            ParserContextFunctionNode parserContextFunctionNode = iterator.next();
            if (parserContextFunctionNode.getKind() == FunctionNode.Kind.ARROW) continue;
            return parserContextFunctionNode;
        }
        return null;
    }

    private static void markThis(ParserContext parserContext) {
        Iterator<ParserContextFunctionNode> iterator = parserContext.getFunctions();
        while (iterator.hasNext()) {
            ParserContextFunctionNode parserContextFunctionNode = iterator.next();
            parserContextFunctionNode.setFlag(32768);
            if (parserContextFunctionNode.getKind() == FunctionNode.Kind.ARROW) continue;
            break;
        }
    }

    private static void markNewTarget(ParserContext parserContext) {
        Iterator<ParserContextFunctionNode> iterator = parserContext.getFunctions();
        while (iterator.hasNext()) {
            ParserContextFunctionNode parserContextFunctionNode = iterator.next();
            if (parserContextFunctionNode.getKind() == FunctionNode.Kind.ARROW) continue;
            if (parserContextFunctionNode.isProgram()) break;
            parserContextFunctionNode.setFlag(0x800000);
            break;
        }
    }

    private boolean inGeneratorFunction() {
        return this.lc.getCurrentFunction().getKind() == FunctionNode.Kind.GENERATOR;
    }

    private boolean inAsyncFunction() {
        return this.lc.getCurrentFunction().isAsync();
    }

    private boolean isAwait(long l) {
        return Token.descType(l) == TokenType.IDENT && "await".equals((String)this.getValue(l));
    }

    private boolean lookaheadIsAsyncFunction(boolean bl) {
        assert (this.type == TokenType.IDENT && ASYNC_IDENT.equals((String)this.getValue(this.token)));
        int n = 1;
        while (true) {
            long l = this.getToken(this.k + n);
            TokenType tokenType = Token.descType(l);
            switch (tokenType) {
                case COMMENT: {
                    break;
                }
                case FUNCTION: {
                    return !bl;
                }
                case EOL: {
                    return false;
                }
                default: {
                    return bl && this.isPropertyName(l);
                }
            }
            ++n;
        }
    }

    private static List<Module.ImportEntry> convert(NamedImportsNode namedImportsNode) {
        ArrayList<Module.ImportEntry> arrayList = new ArrayList<Module.ImportEntry>(namedImportsNode.getImportSpecifiers().size());
        for (ImportSpecifierNode importSpecifierNode : namedImportsNode.getImportSpecifiers()) {
            if (importSpecifierNode.getIdentifier() != null) {
                arrayList.add(Module.ImportEntry.importSpecifier(importSpecifierNode.getIdentifier().getName(), importSpecifierNode.getBindingIdentifier().getName()));
                continue;
            }
            arrayList.add(Module.ImportEntry.importSpecifier(importSpecifierNode.getBindingIdentifier().getName()));
        }
        return arrayList;
    }

    private static List<Module.ExportEntry> convert(ExportClauseNode exportClauseNode) {
        ArrayList<Module.ExportEntry> arrayList = new ArrayList<Module.ExportEntry>(exportClauseNode.getExportSpecifiers().size());
        for (ExportSpecifierNode exportSpecifierNode : exportClauseNode.getExportSpecifiers()) {
            if (exportSpecifierNode.getExportIdentifier() != null) {
                arrayList.add(Module.ExportEntry.exportSpecifier(exportSpecifierNode.getExportIdentifier().getName(), exportSpecifierNode.getIdentifier().getName()));
                continue;
            }
            arrayList.add(Module.ExportEntry.exportSpecifier(exportSpecifierNode.getIdentifier().getName()));
        }
        return arrayList;
    }

    private static class ParserState {
        private final int position;
        private final int line;
        private final int linePosition;

        ParserState(int n, int n2, int n3) {
            this.position = n;
            this.line = n2;
            this.linePosition = n3;
        }

        Lexer createLexer(Source source, Lexer lexer, TokenStream tokenStream, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            Lexer lexer2 = new Lexer(source, this.position, lexer.limit - this.position, tokenStream, bl, bl2, bl3, true, bl4);
            lexer2.restoreState(new Lexer.State(this.position, Integer.MAX_VALUE, this.line, -1, this.linePosition, TokenType.SEMICOLON));
            return lexer2;
        }
    }

    private static class PropertyFunction {
        final Expression key;
        final FunctionNode functionNode;
        final boolean computed;

        PropertyFunction(Expression expression, FunctionNode functionNode, boolean bl) {
            this.key = expression;
            this.functionNode = functionNode;
            this.computed = bl;
        }
    }

    private abstract class VerifyDestructuringPatternNodeVisitor
    extends NodeVisitor<LexicalContext> {
        VerifyDestructuringPatternNodeVisitor(LexicalContext lexicalContext) {
            super(lexicalContext);
        }

        @Override
        public boolean enterLiteralNode(LiteralNode<?> literalNode) {
            if (literalNode.isArray()) {
                if (((LiteralNode.ArrayLiteralNode)literalNode).hasSpread() && ((LiteralNode.ArrayLiteralNode)literalNode).hasTrailingComma()) {
                    throw Parser.this.error("Rest element must be last", literalNode.getElementExpressions().get(literalNode.getElementExpressions().size() - 1).getToken());
                }
                boolean bl = false;
                for (Expression expression : literalNode.getElementExpressions()) {
                    if (expression == null) continue;
                    if (bl) {
                        throw Parser.this.error("Unexpected element after rest element", expression.getToken());
                    }
                    if (expression.isTokenType(TokenType.SPREAD_ARRAY)) {
                        bl = true;
                        Expression expression2 = ((UnaryNode)expression).getExpression();
                        this.verifySpreadElement(expression2);
                    }
                    expression.accept(this);
                }
                return false;
            }
            return this.enterDefault(literalNode);
        }

        protected abstract void verifySpreadElement(Expression var1);

        @Override
        public boolean enterObjectNode(ObjectNode objectNode) {
            boolean bl = false;
            for (PropertyNode propertyNode : objectNode.getElements()) {
                if (propertyNode == null) continue;
                if (bl) {
                    throw Parser.this.error("Unexpected element after rest element", propertyNode.getToken());
                }
                Expression expression = propertyNode.getValue();
                if (expression.isTokenType(TokenType.SPREAD_OBJECT)) {
                    bl = true;
                    Expression expression2 = ((UnaryNode)expression).getExpression();
                    this.verifySpreadElement(expression2);
                }
                propertyNode.accept(this);
            }
            return false;
        }

        @Override
        public boolean enterPropertyNode(PropertyNode propertyNode) {
            if (propertyNode.getValue() != null) {
                propertyNode.getValue().accept(this);
                return false;
            }
            return this.enterDefault(propertyNode);
        }

        @Override
        public boolean enterBinaryNode(BinaryNode binaryNode) {
            if (binaryNode.isTokenType(TokenType.ASSIGN)) {
                binaryNode.lhs().accept(this);
                return false;
            }
            return this.enterDefault(binaryNode);
        }

        @Override
        public boolean enterUnaryNode(UnaryNode unaryNode) {
            if (unaryNode.isTokenType(TokenType.SPREAD_ARRAY) || unaryNode.isTokenType(TokenType.SPREAD_OBJECT)) {
                return true;
            }
            return this.enterDefault(unaryNode);
        }
    }

    private static final class ForVariableDeclarationListResult {
        Expression missingAssignment;
        long declarationWithInitializerToken;
        Expression init;
        Expression firstBinding;
        Expression secondBinding;

        private ForVariableDeclarationListResult() {
        }

        void recordMissingAssignment(Expression expression) {
            if (this.missingAssignment == null) {
                this.missingAssignment = expression;
            }
        }

        void recordDeclarationWithInitializer(long l) {
            if (this.declarationWithInitializerToken == 0L) {
                this.declarationWithInitializerToken = l;
            }
        }

        void addBinding(Expression expression) {
            if (this.firstBinding == null) {
                this.firstBinding = expression;
            } else if (this.secondBinding == null) {
                this.secondBinding = expression;
            }
        }

        void addAssignment(Expression expression) {
            this.init = this.init == null ? expression : new BinaryNode(Token.recast(this.init.getToken(), TokenType.COMMARIGHT), this.init, expression);
        }
    }

    private static final class ClassElementKey {
        private final boolean isStatic;
        private final String propertyName;

        private ClassElementKey(boolean bl, String string) {
            this.isStatic = bl;
            this.propertyName = string;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.isStatic ? 1231 : 1237);
            n = 31 * n + (this.propertyName == null ? 0 : this.propertyName.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof ClassElementKey) {
                ClassElementKey classElementKey = (ClassElementKey)object;
                return this.isStatic == classElementKey.isStatic && Objects.equals(this.propertyName, classElementKey.propertyName);
            }
            return false;
        }
    }
}

